/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import org.archive.io.ArchiveRecordHeader;
import org.archive.util.Base32;

public abstract class ArchiveRecord
extends InputStream {
    protected static final long MIN_HTTP_HEADER_LENGTH = Math.min("HTTP/1.1 200 OK\r\n".length(), "GET / HTTP/1.0\n\r".length());
    protected ArchiveRecordHeader header = null;
    protected InputStream in = null;
    protected long position = 0L;
    protected boolean eor = false;
    protected MessageDigest digest = null;
    private String digestStr = null;
    protected boolean strict = false;

    public ArchiveRecord(InputStream in) throws IOException {
        this(in, null, 0, true, false);
    }

    public ArchiveRecord(InputStream in, ArchiveRecordHeader header) throws IOException {
        this(in, header, 0, true, false);
    }

    public ArchiveRecord(InputStream in, ArchiveRecordHeader header, int bodyOffset, boolean digest, boolean strict) throws IOException {
        this.in = in;
        this.header = header;
        this.position = bodyOffset;
        if (digest) {
            try {
                this.digest = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage());
            }
        }
        this.strict = strict;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public ArchiveRecordHeader getHeader() {
        return this.header;
    }

    protected void setHeader(ArchiveRecordHeader header) {
        this.header = header;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.skip();
            this.in = null;
            if (this.digest != null) {
                this.digestStr = Base32.encode(this.digest.digest());
            }
        }
    }

    @Override
    public int read() throws IOException {
        int c = -1;
        if (this.available() > 0) {
            c = this.in.read();
            if (c == -1) {
                throw new IOException("Premature EOF before end-of-record.");
            }
            if (this.digest != null) {
                this.digest.update((byte)c);
            }
            this.incrementPosition();
        }
        return c;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int read = Math.min(length, this.available());
        if (read == -1 || read == 0) {
            read = -1;
        } else {
            if ((read = this.in.read(b, offset, read)) == -1) {
                String msg = "Premature EOF before end-of-record: " + this.getHeader().getHeaderFields();
                if (this.isStrict()) {
                    throw new IOException(msg);
                }
                this.setEor(true);
                System.err.println(Level.WARNING.toString() + " " + msg);
            }
            if (this.digest != null && read >= 0) {
                this.digest.update(b, offset, read);
            }
            this.incrementPosition(read);
        }
        return read;
    }

    @Override
    public int available() {
        long amount = this.getHeader().getLength() - this.getPosition();
        return amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount;
    }

    protected void skip() throws IOException {
        if (this.eor) {
            return;
        }
        int r = this.available();
        while (r > 0 && !this.eor) {
            this.skip(r);
            r = this.available();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        int SKIP_BUFFERSIZE = 4096;
        byte[] b = new byte[4096];
        long total = 0L;
        int read = 0;
        while (total < n && read != -1) {
            read = Math.min(4096, (int)(n - total));
            if ((read = this.read(b, 0, read)) <= 0) {
                read = -1;
                continue;
            }
            total += (long)read;
        }
        return total;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    protected InputStream getIn() {
        return this.in;
    }

    public String getDigestStr() {
        return this.digestStr;
    }

    protected void incrementPosition() {
        ++this.position;
    }

    protected void incrementPosition(long incr) {
        this.position += incr;
    }

    public long getPosition() {
        return this.position;
    }

    protected boolean isEor() {
        return this.eor;
    }

    protected void setEor(boolean eor) {
        this.eor = eor;
    }

    protected String getStatusCode4Cdx(ArchiveRecordHeader h) {
        return "-";
    }

    protected String getIp4Cdx(ArchiveRecordHeader h) {
        return "-";
    }

    protected String getDigest4Cdx(ArchiveRecordHeader h) {
        return this.getDigestStr() == null ? "-" : this.getDigestStr();
    }

    protected String getMimetype4Cdx(ArchiveRecordHeader h) {
        return h.getMimetype();
    }

    protected String outputCdx(String strippedFileName) throws IOException {
        this.close();
        ArchiveRecordHeader h = this.getHeader();
        StringBuilder buffer = new StringBuilder(1224);
        buffer.append(h.getDate());
        buffer.append(' ');
        buffer.append(this.getIp4Cdx(h));
        buffer.append(' ');
        buffer.append(h.getUrl());
        buffer.append(' ');
        buffer.append(this.getMimetype4Cdx(h));
        buffer.append(' ');
        buffer.append(this.getStatusCode4Cdx(h));
        buffer.append(' ');
        buffer.append(this.getDigest4Cdx(h));
        buffer.append(' ');
        buffer.append(h.getOffset());
        buffer.append(' ');
        buffer.append(h.getLength());
        buffer.append(' ');
        buffer.append(strippedFileName != null ? strippedFileName : Character.valueOf('-'));
        return buffer.toString();
    }

    public void dump() throws IOException {
        this.dump(System.out);
    }

    public void dump(OutputStream os) throws IOException {
        byte[] outputBuffer = new byte[16384];
        int read = outputBuffer.length;
        while ((read = this.read(outputBuffer, 0, outputBuffer.length)) != -1) {
            os.write(outputBuffer, 0, read);
        }
        os.flush();
    }

    public boolean hasContentHeaders() {
        String url = this.getHeader().getUrl();
        if (url == null) {
            return false;
        }
        if (!url.toLowerCase().startsWith("http")) {
            return false;
        }
        return this.getHeader().getLength() > MIN_HTTP_HEADER_LENGTH;
    }

    protected void setBodyOffset(int bodyOffset) {
        this.position = bodyOffset;
    }
}

