/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

public class StringFieldExtractor {
    private char delim;
    private int field;

    public StringFieldExtractor(char delim, int field) {
        this.delim = delim;
        this.field = field;
    }

    public String extract(String text) {
        if (text == null) {
            return null;
        }
        int start = 0;
        for (int i = 0; i < this.field; ++i) {
            if (start > text.length()) {
                return null;
            }
            int newStart = text.indexOf(this.delim, start);
            if (newStart == -1) {
                return null;
            }
            start = newStart + 1;
        }
        if (start == text.length()) {
            return "";
        }
        int end = text.indexOf(this.delim, start);
        if (end == -1) {
            return text.substring(start);
        }
        return text.substring(start, end);
    }

    public StringTuple split(String s) {
        int keyEnd = 0;
        for (int i = 0; i < this.field; ++i) {
            int dIdx = s.indexOf(this.delim, keyEnd);
            if (dIdx == -1) {
                return new StringTuple(s, null);
            }
            keyEnd = dIdx + 1;
        }
        return new StringTuple(s.substring(0, keyEnd - 1), s.substring(keyEnd));
    }

    public int getField() {
        return this.field;
    }

    public void setField(int field) {
        this.field = field;
    }

    public char getDelim() {
        return this.delim;
    }

    public void setDelim(char delim) {
        this.delim = delim;
    }

    public class StringTuple {
        public String first;
        public String second;

        public StringTuple(String first, String second) {
            this.first = first;
            this.second = second;
        }
    }
}

