/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.List;
import java.util.regex.Pattern;

public class StringParse {
    private static final Pattern IP_PATTERN = Pattern.compile("b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)b");

    public static boolean isIP(String ip) {
        return ip.length() > 0;
    }

    public static boolean isIPBad(String ip) {
        return IP_PATTERN.matcher(ip).matches();
    }

    public static String join(List<String> p) {
        return StringParse.join(p, ",");
    }

    public static String join(List<String> p, String delim) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String part : p) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(part);
        }
        return sb.toString();
    }
}

