/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.parser.neko;

import com.gargoylesoftware.htmlunit.ObjectInstantiationException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DefaultElementFactory;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.ElementFactory;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.UnknownElementFactory;
import com.gargoylesoftware.htmlunit.html.parser.HTMLParser;
import com.gargoylesoftware.htmlunit.html.parser.neko.HtmlUnitNekoDOMBuilder;
import com.gargoylesoftware.htmlunit.svg.SvgElementFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.SAXException;

public final class HtmlUnitNekoHtmlParser
implements HTMLParser {
    public static final SvgElementFactory SVG_FACTORY = new SvgElementFactory();
    private static final Map<String, ElementFactory> ELEMENT_FACTORIES = new HashMap<String, ElementFactory>();

    @Override
    public void parseFragment(DomNode parent, String source) throws SAXException, IOException {
        this.parseFragment(parent, parent, source, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFragment(DomNode parent, DomNode context, String source, boolean createdByJavascript) throws SAXException, IOException {
        SgmlPage page = parent.getPage();
        if (!(page instanceof HtmlPage)) {
            return;
        }
        HtmlPage htmlPage = (HtmlPage)page;
        URL url = htmlPage.getUrl();
        HtmlUnitNekoDOMBuilder domBuilder = new HtmlUnitNekoDOMBuilder(this, parent, url, source, createdByJavascript);
        domBuilder.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        ArrayList<QName> ancestors = new ArrayList<QName>();
        for (DomNode node = context; node != null && node.getNodeType() != 9; node = node.getParentNode()) {
            ancestors.add(0, new QName(null, node.getNodeName(), null, null));
        }
        if (ancestors.isEmpty() || !"html".equals(((QName)ancestors.get((int)0)).localpart)) {
            ancestors.add(0, new QName(null, "html", null, null));
        }
        if (ancestors.size() == 1 || !"body".equals(((QName)ancestors.get((int)1)).localpart)) {
            ancestors.add(1, new QName(null, "body", null, null));
        }
        domBuilder.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-tags", true);
        domBuilder.setProperty("http://cyberneko.org/html/properties/balance-tags/fragment-context-stack", ancestors.toArray(new QName[0]));
        XMLInputSource in = new XMLInputSource(null, url.toString(), null, (Reader)new StringReader(source), null);
        htmlPage.registerParsingStart();
        htmlPage.registerSnippetParsingStart();
        try {
            domBuilder.parse(in);
        }
        finally {
            htmlPage.registerParsingEnd();
            htmlPage.registerSnippetParsingEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(WebResponse webResponse, HtmlPage page, boolean xhtml, boolean createdByJavascript) throws IOException {
        URL url = webResponse.getWebRequest().getUrl();
        HtmlUnitNekoDOMBuilder domBuilder = new HtmlUnitNekoDOMBuilder(this, page, url, null, createdByJavascript);
        Charset charset = webResponse.getContentCharsetOrNull();
        try {
            if (charset == null) {
                charset = StandardCharsets.ISO_8859_1;
            } else {
                domBuilder.setFeature("http://cyberneko.org/html/features/scanner/ignore-specified-charset", true);
            }
            if (xhtml) {
                domBuilder.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-tags", true);
                domBuilder.setFeature("http://cyberneko.org/html/features/scanner/script/strip-cdata-delims", true);
                domBuilder.setFeature("http://cyberneko.org/html/features/scanner/style/strip-cdata-delims", true);
            }
        }
        catch (Exception e) {
            throw new ObjectInstantiationException("Error setting HTML parser feature", e);
        }
        try (InputStream content = webResponse.getContentAsStream();){
            String encoding = charset.name();
            XMLInputSource in = new XMLInputSource(null, url.toString(), null, content, encoding);
            page.registerParsingStart();
            try {
                domBuilder.parse(in);
            }
            catch (XNIException e) {
                Throwable origin = HtmlUnitNekoHtmlParser.extractNestedException(e);
                throw new RuntimeException("Failed parsing content from " + url, origin);
            }
        }
        finally {
            page.registerParsingEnd();
        }
    }

    static Throwable extractNestedException(Throwable e) {
        Throwable originalException = e;
        Throwable cause = ((XNIException)e).getException();
        while (cause != null) {
            originalException = cause;
            if (cause instanceof XNIException) {
                cause = ((XNIException)cause).getException();
                continue;
            }
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
                continue;
            }
            cause = null;
        }
        return originalException;
    }

    @Override
    public ElementFactory getSvgFactory() {
        return SVG_FACTORY;
    }

    @Override
    public ElementFactory getFactory(String tagName) {
        ElementFactory result = ELEMENT_FACTORIES.get(tagName);
        if (result != null) {
            return result;
        }
        return UnknownElementFactory.instance;
    }

    @Override
    public ElementFactory getElementFactory(SgmlPage page, String namespaceURI, String qualifiedName, boolean insideSvg, boolean svgSupport) {
        if (insideSvg) {
            return SVG_FACTORY;
        }
        if (namespaceURI == null || namespaceURI.isEmpty() || "http://www.w3.org/1999/xhtml".equals(namespaceURI) || "http://www.w3.org/2000/svg".equals(namespaceURI) || !qualifiedName.contains(":")) {
            String tagName = qualifiedName;
            int index = tagName.indexOf(58);
            tagName = index == -1 ? tagName.toLowerCase(Locale.ROOT) : tagName.substring(index + 1);
            ElementFactory factory = svgSupport && !"svg".equals(tagName) && "http://www.w3.org/2000/svg".equals(namespaceURI) ? SVG_FACTORY : ELEMENT_FACTORIES.get(tagName);
            if (factory != null) {
                return factory;
            }
        }
        return UnknownElementFactory.instance;
    }

    static {
        DefaultElementFactory defaultElementFactory = new DefaultElementFactory();
        for (String tagName : DefaultElementFactory.SUPPORTED_TAGS_) {
            ELEMENT_FACTORIES.put(tagName, defaultElementFactory);
        }
    }
}

