/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.axes;

import java.util.ArrayList;
import net.sourceforge.htmlunit.xpath.xml.dtm.DTMIterator;
import net.sourceforge.htmlunit.xpath.xml.utils.WrappedRuntimeException;

public final class IteratorPool {
    private final DTMIterator m_orig;
    private final ArrayList<DTMIterator> m_freeStack;

    public IteratorPool(DTMIterator original) {
        this.m_orig = original;
        this.m_freeStack = new ArrayList();
    }

    public synchronized DTMIterator getInstanceOrThrow() throws CloneNotSupportedException {
        if (this.m_freeStack.isEmpty()) {
            return (DTMIterator)this.m_orig.clone();
        }
        return this.m_freeStack.remove(this.m_freeStack.size() - 1);
    }

    public synchronized DTMIterator getInstance() {
        if (this.m_freeStack.isEmpty()) {
            try {
                return (DTMIterator)this.m_orig.clone();
            }
            catch (Exception ex) {
                throw new WrappedRuntimeException(ex);
            }
        }
        return this.m_freeStack.remove(this.m_freeStack.size() - 1);
    }

    public synchronized void freeInstance(DTMIterator obj) {
        this.m_freeStack.add(obj);
    }
}

