/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.coin;

import de.vandermeer.skb.interfaces.coin.HeadsSuccess;
import de.vandermeer.skb.interfaces.messagesets.IsWarningSet;
import de.vandermeer.skb.interfaces.render.DoesRender;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.text.StrBuilder;

public interface HeadsSuccessWithWarnings<R, M>
extends HeadsSuccess<R>,
IsWarningSet<M> {
    @Override
    default public boolean reportsWarnings() {
        return true;
    }

    @Override
    default public boolean hasWarningReports() {
        return this.hasWarnings();
    }

    @Override
    default public String render() {
        StrBuilder ret = new StrBuilder(100);
        for (Object m : this.getWarningMessages()) {
            ret.append("warning: ");
            if (m instanceof DoesRender) {
                ret.append(((DoesRender)m).render());
            } else {
                ret.append(m);
            }
            ret.appendNewLine();
        }
        return ret.toString();
    }

    public static <R, M> HeadsSuccessWithWarnings<R, M> create(final R value) {
        return new HeadsSuccessWithWarnings<R, M>(){
            final Set<M> warningSet = new LinkedHashSet();

            @Override
            public R getReturn() {
                return value;
            }

            @Override
            public Set<M> getWarningMessages() {
                return this.warningSet;
            }
        };
    }
}

