/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.tools.AbstractCommonCrawlFormat;
import org.apache.nutch.tools.CommonCrawlConfig;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CommonCrawlFormatJettinson
extends AbstractCommonCrawlFormat {
    private Deque<JSONObject> stackObjects = new ArrayDeque<JSONObject>();
    private Deque<JSONArray> stackArrays = new ArrayDeque<JSONArray>();

    public CommonCrawlFormatJettinson(String url, Content content, Metadata metadata, Configuration nutchConf, CommonCrawlConfig config) throws IOException {
        super(url, content, metadata, nutchConf, config);
    }

    @Override
    protected void writeKeyValue(String key, String value) throws IOException {
        try {
            this.stackObjects.getFirst().put(key, (Object)value);
        }
        catch (JSONException jsone) {
            throw new IOException(jsone.getMessage());
        }
    }

    @Override
    protected void writeKeyNull(String key) throws IOException {
        try {
            this.stackObjects.getFirst().put(key, JSONObject.NULL);
        }
        catch (JSONException jsone) {
            throw new IOException(jsone.getMessage());
        }
    }

    @Override
    protected void startArray(String key, boolean nested, boolean newline) throws IOException {
        JSONArray array = new JSONArray();
        this.stackArrays.push(array);
    }

    @Override
    protected void closeArray(String key, boolean nested, boolean newline) throws IOException {
        try {
            if (this.stackArrays.size() > 1) {
                JSONArray array = this.stackArrays.pop();
                if (nested) {
                    this.stackArrays.getFirst().put((Object)array);
                } else {
                    this.stackObjects.getFirst().put(key, (Object)array);
                }
            }
        }
        catch (JSONException jsone) {
            throw new IOException(jsone.getMessage());
        }
    }

    @Override
    protected void writeArrayValue(String value) throws IOException {
        if (this.stackArrays.size() > 1) {
            this.stackArrays.getFirst().put((Object)value);
        }
    }

    @Override
    protected void startObject(String key) throws IOException {
        JSONObject object = new JSONObject();
        this.stackObjects.push(object);
    }

    @Override
    protected void closeObject(String key) throws IOException {
        try {
            if (this.stackObjects.size() > 1) {
                JSONObject object = this.stackObjects.pop();
                this.stackObjects.getFirst().put(key, (Object)object);
            }
        }
        catch (JSONException jsone) {
            throw new IOException(jsone.getMessage());
        }
    }

    @Override
    protected String generateJson() throws IOException {
        try {
            return this.stackObjects.getFirst().toString(2);
        }
        catch (JSONException jsone) {
            throw new IOException(jsone.getMessage());
        }
    }
}

