/****************************************************************************
 * drivers/video/nxlogo160.c
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/* Script-generated framebuffer splashscreen bitmap file.
 * Generated from drivers/video/nxlogo160.png
 * by splashscreen_converter.py
 */

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/video/fb.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/****************************************************************************
 * Private Data
 ****************************************************************************/

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32
static const fb_pixel_t palette[] =
{
  MKRGB(0, 0, 0, 0),
  MKRGB(255, 60, 52, 227),
  MKRGB(255, 255, 255, 255),
  MKRGB(255, 206, 227, 241),
  MKRGB(255, 43, 39, 131),
  MKRGB(255, 90, 150, 189),
  MKRGB(255, 202, 225, 240),
  MKRGB(255, 254, 254, 254),
  MKRGB(255, 59, 51, 226),
  MKRGB(255, 230, 241, 248),
  MKRGB(255, 201, 224, 239),
  MKRGB(255, 205, 226, 240),
  MKRGB(255, 61, 52, 233),
  MKRGB(45, 60, 52, 227),
  MKRGB(255, 57, 43, 227),
  MKRGB(255, 222, 246, 252),
  MKRGB(255, 124, 133, 186),
  MKRGB(255, 26, 19, 119),
  MKRGB(255, 44, 40, 141),
  MKRGB(255, 57, 49, 210),
  MKRGB(255, 216, 238, 247),
  MKRGB(255, 215, 237, 241),
  MKRGB(255, 50, 61, 141),
  MKRGB(255, 57, 50, 210),
  MKRGB(255, 91, 161, 231),
  MKRGB(255, 32, 27, 124),
  MKRGB(255, 50, 41, 226),
  MKRGB(255, 41, 37, 121),
  MKRGB(255, 61, 53, 236),
  MKRGB(255, 51, 45, 179),
  MKRGB(255, 220, 244, 242),
  MKRGB(255, 41, 38, 125),
  MKRGB(255, 133, 139, 234),
  MKRGB(255, 45, 34, 225),
  MKRGB(255, 88, 153, 225),
  MKRGB(45, 93, 171, 225),
  MKRGB(254, 90, 150, 189),
  MKRGB(127, 90, 150, 189),
  MKRGB(255, 217, 234, 246),
  MKRGB(255, 148, 188, 215),
  MKRGB(255, 78, 142, 183),
  MKRGB(255, 213, 231, 244),
  MKRGB(254, 206, 227, 241),
  MKRGB(255, 82, 145, 185),
  MKRGB(127, 206, 227, 241),
  MKRGB(255, 60, 52, 226),
  MKRGB(255, 42, 32, 142),
  MKRGB(255, 87, 157, 208),
  MKRGB(255, 89, 149, 188),
  MKRGB(255, 39, 31, 127),
  MKRGB(255, 81, 130, 178),
  MKRGB(255, 65, 73, 226),
  MKRGB(255, 61, 53, 233),
  MKRGB(255, 216, 233, 244),
  MKRGB(45, 206, 227, 241),
  MKRGB(255, 50, 40, 226),
  MKRGB(46, 60, 52, 227),
  MKRGB(255, 216, 239, 248),
  MKRGB(255, 214, 232, 243),
  MKRGB(255, 82, 144, 185),
  MKRGB(255, 232, 241, 248),
  MKRGB(255, 211, 233, 244),
  MKRGB(255, 227, 239, 247),
  MKRGB(255, 114, 121, 179),
  MKRGB(45, 90, 150, 189),
  MKRGB(255, 42, 38, 125),
  MKRGB(255, 213, 232, 244),
  MKRGB(255, 203, 225, 240),
  MKRGB(255, 197, 222, 238),
  MKRGB(255, 152, 191, 216),
  MKRGB(255, 79, 143, 184),
  MKRGB(255, 134, 140, 240),
  MKRGB(255, 46, 41, 148),
  MKRGB(255, 41, 38, 124),
  MKRGB(255, 33, 27, 124),
  MKRGB(255, 16, 8, 112),
  MKRGB(55, 90, 150, 189),
  MKRGB(255, 46, 35, 231),
  MKRGB(255, 221, 245, 248),
  MKRGB(255, 216, 238, 248),
  MKRGB(255, 179, 195, 238),
  MKRGB(255, 60, 52, 230),
  MKRGB(255, 42, 38, 128),
  MKRGB(255, 26, 19, 120),
  MKRGB(255, 244, 248, 251),
  MKRGB(255, 228, 240, 247),
  MKRGB(255, 215, 238, 241),
  MKRGB(255, 199, 223, 239),
  MKRGB(255, 151, 196, 219),
  MKRGB(46, 93, 171, 225),
  MKRGB(255, 87, 152, 225),
  MKRGB(255, 127, 133, 233),
  MKRGB(255, 123, 132, 179),
  MKRGB(255, 86, 83, 229),
  MKRGB(255, 56, 49, 209),
  MKRGB(255, 58, 48, 227),
  MKRGB(255, 47, 42, 155),
  MKRGB(255, 51, 41, 229),
  MKRGB(255, 46, 35, 235),
  MKRGB(255, 32, 26, 123),
  MKRGB(255, 23, 12, 115),
  MKRGB(255, 46, 41, 152),
  MKRGB(255, 246, 249, 252),
  MKRGB(255, 217, 240, 248),
  MKRGB(255, 209, 229, 242),
  MKRGB(255, 204, 226, 240),
  MKRGB(255, 92, 165, 234),
  MKRGB(255, 110, 163, 198),
  MKRGB(136, 90, 150, 189),
  MKRGB(255, 90, 149, 188),
  MKRGB(255, 56, 49, 206),
  MKRGB(255, 52, 46, 186),
  MKRGB(255, 51, 41, 226),
  MKRGB(255, 50, 41, 225),
  MKRGB(255, 242, 247, 251),
  MKRGB(255, 221, 245, 245),
  MKRGB(255, 220, 244, 241),
  MKRGB(255, 220, 240, 245),
  MKRGB(255, 216, 239, 245),
  MKRGB(255, 79, 142, 224),
  MKRGB(255, 220, 236, 247),
  MKRGB(199, 206, 227, 241),
  MKRGB(255, 214, 234, 241),
  MKRGB(255, 210, 232, 241),
  MKRGB(255, 212, 229, 241),
  MKRGB(255, 209, 229, 243),
  MKRGB(255, 209, 228, 241),
  MKRGB(128, 205, 226, 240),
  MKRGB(255, 44, 40, 131),
  MKRGB(54, 206, 227, 241),
  MKRGB(255, 153, 213, 235),
  MKRGB(255, 180, 210, 229),
  MKRGB(209, 206, 227, 241),
  MKRGB(191, 167, 201, 223),
  MKRGB(208, 206, 227, 241),
  MKRGB(255, 176, 193, 221),
  MKRGB(255, 174, 188, 237),
  MKRGB(190, 117, 168, 201),
  MKRGB(46, 55, 155, 219),
  MKRGB(255, 79, 150, 207),
  MKRGB(255, 89, 149, 189),
  MKRGB(255, 86, 147, 187),
  MKRGB(255, 80, 143, 185),
  MKRGB(127, 89, 149, 188),
  MKRGB(255, 82, 133, 177),
  MKRGB(255, 80, 125, 225),
  MKRGB(255, 74, 125, 175),
  MKRGB(255, 77, 123, 211),
  MKRGB(255, 73, 119, 185),
  MKRGB(118, 90, 150, 189),
  MKRGB(255, 221, 245, 251),
  MKRGB(255, 66, 83, 209),
  MKRGB(255, 65, 73, 225),
  MKRGB(255, 56, 66, 171),
  MKRGB(255, 56, 62, 225),
  MKRGB(255, 51, 62, 141),
  MKRGB(255, 62, 54, 243),
  MKRGB(255, 62, 53, 239),
  MKRGB(255, 59, 49, 231),
  MKRGB(255, 58, 47, 227),
  MKRGB(255, 52, 42, 235),
  MKRGB(255, 50, 41, 179),
  MKRGB(54, 90, 150, 189),
  MKRGB(128, 90, 150, 189),
  MKRGB(255, 50, 40, 229),
  MKRGB(255, 42, 39, 127),
  MKRGB(255, 47, 38, 209),
  MKRGB(255, 44, 37, 145),
  MKRGB(255, 40, 37, 117),
  MKRGB(255, 43, 36, 141),
  MKRGB(255, 41, 35, 129),
  MKRGB(255, 41, 34, 127),
  MKRGB(255, 39, 33, 119),
  MKRGB(255, 40, 32, 127),
  MKRGB(255, 41, 31, 201),
  MKRGB(255, 38, 30, 121),
  MKRGB(255, 38, 29, 121),
  MKRGB(255, 37, 28, 115),
  MKRGB(255, 37, 27, 111),
  MKRGB(255, 42, 26, 225),
  MKRGB(255, 29, 22, 137),
  MKRGB(37, 25, 9, 73),
  MKRGB(29, 44, 0, 247),
  MKRGB(255, 221, 242, 250),
  MKRGB(55, 203, 223, 240),
  MKRGB(255, 196, 221, 238),
  MKRGB(255, 147, 188, 214),
  MKRGB(46, 93, 170, 224),
  MKRGB(191, 157, 168, 236),
  MKRGB(255, 115, 166, 200),
  MKRGB(255, 114, 166, 200),
  MKRGB(182, 154, 165, 236),
  MKRGB(255, 111, 164, 198),
  MKRGB(255, 91, 160, 234),
  MKRGB(255, 90, 158, 232),
  MKRGB(255, 138, 145, 234),
  MKRGB(255, 79, 142, 184),
  MKRGB(255, 82, 130, 178),
  MKRGB(254, 81, 129, 178),
  MKRGB(254, 80, 129, 172),
  MKRGB(255, 32, 26, 124),
  MKRGB(255, 78, 121, 172),
  MKRGB(255, 113, 120, 178),
  MKRGB(1, 75, 101, 208),
  MKRGB(109, 72, 92, 210),
  MKRGB(255, 71, 71, 144),
  MKRGB(255, 58, 51, 216),
  MKRGB(255, 58, 47, 226),
  MKRGB(255, 55, 46, 226),
  MKRGB(255, 52, 45, 182),
  MKRGB(255, 55, 44, 206),
  MKRGB(255, 50, 44, 172),
  MKRGB(255, 57, 43, 226),
  MKRGB(255, 42, 34, 178),
  MKRGB(255, 41, 33, 172),
  MKRGB(255, 48, 32, 226),
  MKRGB(255, 35, 29, 138),
  MKRGB(255, 32, 26, 120),
  MKRGB(255, 31, 25, 114),
  MKRGB(255, 34, 24, 138),
  MKRGB(255, 31, 23, 122),
  MKRGB(255, 27, 20, 120),
  MKRGB(136, 206, 227, 241),
  MKRGB(255, 24, 16, 118),
  MKRGB(255, 21, 14, 116),
  MKRGB(254, 255, 255, 255),
  MKRGB(46, 10, 0, 222),
  MKRGB(255, 9, 0, 108),
};
#endif

#if defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP24) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP16) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP8)
static const fb_pixel_t palette[] =
{
  MKRGB(0, 0, 0),
  MKRGB(60, 52, 227),
  MKRGB(255, 255, 255),
  MKRGB(206, 227, 241),
  MKRGB(43, 39, 131),
  MKRGB(90, 150, 189),
  MKRGB(202, 225, 240),
  MKRGB(254, 254, 254),
  MKRGB(59, 51, 226),
  MKRGB(230, 241, 248),
  MKRGB(201, 224, 239),
  MKRGB(205, 226, 240),
  MKRGB(61, 52, 233),
  MKRGB(57, 43, 227),
  MKRGB(222, 246, 252),
  MKRGB(124, 133, 186),
  MKRGB(26, 19, 119),
  MKRGB(44, 40, 141),
  MKRGB(57, 49, 210),
  MKRGB(216, 238, 247),
  MKRGB(215, 237, 241),
  MKRGB(50, 61, 141),
  MKRGB(57, 50, 210),
  MKRGB(91, 161, 231),
  MKRGB(32, 27, 124),
  MKRGB(50, 41, 226),
  MKRGB(41, 37, 121),
  MKRGB(61, 53, 236),
  MKRGB(51, 45, 179),
  MKRGB(220, 244, 242),
  MKRGB(41, 38, 125),
  MKRGB(133, 139, 234),
  MKRGB(93, 171, 225),
  MKRGB(45, 34, 225),
  MKRGB(88, 153, 225),
  MKRGB(217, 234, 246),
  MKRGB(148, 188, 215),
  MKRGB(78, 142, 183),
  MKRGB(213, 231, 244),
  MKRGB(82, 145, 185),
  MKRGB(60, 52, 226),
  MKRGB(89, 149, 188),
  MKRGB(42, 32, 142),
  MKRGB(87, 157, 208),
  MKRGB(39, 31, 127),
  MKRGB(81, 130, 178),
  MKRGB(65, 73, 226),
  MKRGB(61, 53, 233),
  MKRGB(216, 233, 244),
  MKRGB(50, 40, 226),
  MKRGB(216, 239, 248),
  MKRGB(214, 232, 243),
  MKRGB(82, 144, 185),
  MKRGB(232, 241, 248),
  MKRGB(211, 233, 244),
  MKRGB(227, 239, 247),
  MKRGB(114, 121, 179),
  MKRGB(42, 38, 125),
  MKRGB(213, 232, 244),
  MKRGB(203, 225, 240),
  MKRGB(197, 222, 238),
  MKRGB(152, 191, 216),
  MKRGB(79, 143, 184),
  MKRGB(134, 140, 240),
  MKRGB(46, 41, 148),
  MKRGB(41, 38, 124),
  MKRGB(33, 27, 124),
  MKRGB(16, 8, 112),
  MKRGB(46, 35, 231),
  MKRGB(221, 245, 248),
  MKRGB(216, 238, 248),
  MKRGB(179, 195, 238),
  MKRGB(60, 52, 230),
  MKRGB(42, 38, 128),
  MKRGB(26, 19, 120),
  MKRGB(244, 248, 251),
  MKRGB(228, 240, 247),
  MKRGB(215, 238, 241),
  MKRGB(199, 223, 239),
  MKRGB(151, 196, 219),
  MKRGB(87, 152, 225),
  MKRGB(127, 133, 233),
  MKRGB(123, 132, 179),
  MKRGB(86, 83, 229),
  MKRGB(56, 49, 209),
  MKRGB(58, 48, 227),
  MKRGB(47, 42, 155),
  MKRGB(51, 41, 229),
  MKRGB(46, 35, 235),
  MKRGB(32, 26, 123),
  MKRGB(23, 12, 115),
  MKRGB(46, 41, 152),
  MKRGB(246, 249, 252),
  MKRGB(217, 240, 248),
  MKRGB(209, 229, 242),
  MKRGB(204, 226, 240),
  MKRGB(92, 165, 234),
  MKRGB(110, 163, 198),
  MKRGB(90, 149, 188),
  MKRGB(56, 49, 206),
  MKRGB(52, 46, 186),
  MKRGB(51, 41, 226),
  MKRGB(50, 41, 225),
  MKRGB(242, 247, 251),
  MKRGB(221, 245, 245),
  MKRGB(220, 244, 241),
  MKRGB(220, 240, 245),
  MKRGB(216, 239, 245),
  MKRGB(79, 142, 224),
  MKRGB(220, 236, 247),
  MKRGB(214, 234, 241),
  MKRGB(210, 232, 241),
  MKRGB(212, 229, 241),
  MKRGB(209, 229, 243),
  MKRGB(209, 228, 241),
  MKRGB(44, 40, 131),
  MKRGB(153, 213, 235),
  MKRGB(180, 210, 229),
  MKRGB(167, 201, 223),
  MKRGB(176, 193, 221),
  MKRGB(174, 188, 237),
  MKRGB(117, 168, 201),
  MKRGB(55, 155, 219),
  MKRGB(79, 150, 207),
  MKRGB(89, 149, 189),
  MKRGB(86, 147, 187),
  MKRGB(80, 143, 185),
  MKRGB(82, 133, 177),
  MKRGB(80, 125, 225),
  MKRGB(74, 125, 175),
  MKRGB(77, 123, 211),
  MKRGB(73, 119, 185),
  MKRGB(221, 245, 251),
  MKRGB(66, 83, 209),
  MKRGB(65, 73, 225),
  MKRGB(56, 66, 171),
  MKRGB(56, 62, 225),
  MKRGB(51, 62, 141),
  MKRGB(62, 54, 243),
  MKRGB(62, 53, 239),
  MKRGB(59, 49, 231),
  MKRGB(58, 47, 227),
  MKRGB(52, 42, 235),
  MKRGB(50, 41, 179),
  MKRGB(50, 40, 229),
  MKRGB(42, 39, 127),
  MKRGB(47, 38, 209),
  MKRGB(44, 37, 145),
  MKRGB(40, 37, 117),
  MKRGB(43, 36, 141),
  MKRGB(41, 35, 129),
  MKRGB(41, 34, 127),
  MKRGB(39, 33, 119),
  MKRGB(40, 32, 127),
  MKRGB(41, 31, 201),
  MKRGB(38, 30, 121),
  MKRGB(38, 29, 121),
  MKRGB(37, 28, 115),
  MKRGB(37, 27, 111),
  MKRGB(42, 26, 225),
  MKRGB(29, 22, 137),
  MKRGB(25, 9, 73),
  MKRGB(44, 0, 247),
  MKRGB(221, 242, 250),
  MKRGB(203, 223, 240),
  MKRGB(196, 221, 238),
  MKRGB(147, 188, 214),
  MKRGB(93, 170, 224),
  MKRGB(157, 168, 236),
  MKRGB(115, 166, 200),
  MKRGB(114, 166, 200),
  MKRGB(154, 165, 236),
  MKRGB(111, 164, 198),
  MKRGB(91, 160, 234),
  MKRGB(90, 158, 232),
  MKRGB(138, 145, 234),
  MKRGB(79, 142, 184),
  MKRGB(82, 130, 178),
  MKRGB(81, 129, 178),
  MKRGB(80, 129, 172),
  MKRGB(32, 26, 124),
  MKRGB(78, 121, 172),
  MKRGB(113, 120, 178),
  MKRGB(75, 101, 208),
  MKRGB(72, 92, 210),
  MKRGB(71, 71, 144),
  MKRGB(58, 51, 216),
  MKRGB(58, 47, 226),
  MKRGB(55, 46, 226),
  MKRGB(52, 45, 182),
  MKRGB(55, 44, 206),
  MKRGB(50, 44, 172),
  MKRGB(57, 43, 226),
  MKRGB(42, 34, 178),
  MKRGB(41, 33, 172),
  MKRGB(48, 32, 226),
  MKRGB(35, 29, 138),
  MKRGB(32, 26, 120),
  MKRGB(31, 25, 114),
  MKRGB(34, 24, 138),
  MKRGB(31, 23, 122),
  MKRGB(27, 20, 120),
  MKRGB(24, 16, 118),
  MKRGB(21, 14, 116),
  MKRGB(10, 0, 222),
  MKRGB(9, 0, 108),
};
#endif

#if defined(CONFIG_VIDEO_FB_SPLASHSCREEN_GREY) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_MONO)
static const fb_pixel_t palette[] =
{
};
#endif

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32
static const struct splscr_bitmap_s bitmap[] =
{
  {76, 0},
  {1, 89},
  {1, 90},
  {1, 95},
  {4, 1},
  {1, 56},
  {76, 0},                                                /* End of row   1 */
  {75, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 12},
  {1, 81},
  {3, 1},
  {1, 13},
  {75, 0},                                                /* End of row   2 */
  {74, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 177},
  {1, 167},
  {1, 12},
  {3, 1},
  {1, 13},
  {74, 0},                                                /* End of row   3 */
  {73, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 193},
  {1, 151},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {73, 0},                                                /* End of row   4 */
  {72, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {72, 0},                                                /* End of row   5 */
  {71, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {2, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {71, 0},                                                /* End of row   6 */
  {70, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {4, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {70, 0},                                                /* End of row   7 */
  {69, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {6, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {69, 0},                                                /* End of row   8 */
  {68, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {8, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {68, 0},                                                /* End of row   9 */
  {67, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {10, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {67, 0},                                                /* End of row  10 */
  {66, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {12, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {66, 0},                                                /* End of row  11 */
  {65, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {14, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {65, 0},                                                /* End of row  12 */
  {64, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {16, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {64, 0},                                                /* End of row  13 */
  {63, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {18, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {63, 0},                                                /* End of row  14 */
  {62, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {20, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {62, 0},                                                /* End of row  15 */
  {61, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {22, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {61, 0},                                                /* End of row  16 */
  {60, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {24, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {60, 0},                                                /* End of row  17 */
  {59, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {26, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {59, 0},                                                /* End of row  18 */
  {58, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {28, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {26, 0},
  {1, 44},
  {5, 3},
  {1, 44},
  {25, 0},                                                /* End of row  19 */
  {57, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {10, 1},
  {1, 55},
  {3, 26},
  {1, 55},
  {15, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {23, 0},
  {1, 54},
  {1, 3},
  {1, 42},
  {5, 3},
  {1, 42},
  {1, 3},
  {1, 54},
  {23, 0},                                                /* End of row  20 */
  {56, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {9, 1},
  {1, 55},
  {1, 32},
  {1, 30},
  {3, 21},
  {1, 30},
  {1, 32},
  {1, 33},
  {14, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {22, 0},
  {11, 3},
  {1, 54},
  {22, 0},                                                /* End of row  21 */
  {23, 0},
  {1, 44},
  {5, 3},
  {1, 134},
  {25, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {9, 1},
  {1, 55},
  {1, 80},
  {1, 11},
  {5, 3},
  {1, 11},
  {1, 30},
  {1, 93},
  {14, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {20, 0},
  {1, 44},
  {1, 42},
  {11, 3},
  {1, 54},
  {21, 0},                                                /* End of row  22 */
  {21, 0},
  {1, 54},
  {1, 3},
  {1, 42},
  {5, 3},
  {1, 42},
  {1, 3},
  {1, 54},
  {22, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {9, 1},
  {1, 55},
  {1, 80},
  {1, 11},
  {8, 3},
  {1, 86},
  {1, 93},
  {1, 52},
  {3, 12},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {19, 0},
  {14, 3},
  {21, 0},                                                /* End of row  23 */
  {21, 0},
  {11, 3},
  {1, 54},
  {20, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {10, 1},
  {1, 32},
  {1, 11},
  {10, 3},
  {1, 118},
  {1, 205},
  {1, 65},
  {1, 31},
  {1, 27},
  {1, 29},
  {1, 12},
  {9, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {17, 0},
  {1, 44},
  {1, 42},
  {4, 3},
  {1, 6},
  {2, 53},
  {1, 6},
  {4, 3},
  {1, 42},
  {1, 127},
  {20, 0},                                                /* End of row  24 */
  {20, 0},
  {1, 132},
  {1, 42},
  {11, 3},
  {1, 137},
  {4, 5},
  {1, 37},
  {13, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {10, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {3, 6},
  {5, 3},
  {1, 15},
  {1, 17},
  {3, 4},
  {1, 72},
  {1, 12},
  {9, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {16, 0},
  {5, 3},
  {1, 58},
  {4, 2},
  {1, 58},
  {4, 3},
  {1, 66},
  {1, 196},
  {1, 64},
  {18, 0},                                                /* End of row  25 */
  {19, 0},
  {1, 44},
  {1, 42},
  {12, 3},
  {1, 38},
  {1, 40},
  {3, 5},
  {1, 36},
  {1, 5},
  {11, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {11, 1},
  {1, 195},
  {1, 11},
  {3, 3},
  {1, 53},
  {3, 2},
  {1, 58},
  {4, 3},
  {1, 11},
  {1, 16},
  {4, 4},
  {1, 72},
  {1, 12},
  {9, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {14, 0},
  {1, 44},
  {1, 42},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 69},
  {1, 5},
  {1, 64},
  {17, 0},                                                /* End of row  26 */
  {19, 0},
  {5, 3},
  {1, 10},
  {1, 60},
  {1, 9},
  {1, 53},
  {5, 3},
  {1, 11},
  {1, 39},
  {4, 5},
  {1, 36},
  {1, 37},
  {9, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {11, 1},
  {1, 208},
  {1, 136},
  {3, 3},
  {1, 105},
  {1, 84},
  {4, 2},
  {1, 58},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 72},
  {1, 12},
  {9, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {13, 0},
  {5, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 60},
  {4, 3},
  {1, 39},
  {2, 5},
  {1, 64},
  {16, 0},                                                /* End of row  27 */
  {18, 0},
  {1, 44},
  {1, 42},
  {3, 3},
  {1, 58},
  {1, 2},
  {1, 7},
  {2, 2},
  {1, 53},
  {5, 3},
  {1, 38},
  {1, 40},
  {5, 5},
  {8, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {12, 1},
  {1, 26},
  {1, 21},
  {3, 3},
  {1, 53},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {11, 0},
  {1, 44},
  {1, 42},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 60},
  {4, 3},
  {1, 39},
  {3, 5},
  {16, 0},                                                /* End of row  28 */
  {18, 0},
  {4, 3},
  {1, 10},
  {5, 2},
  {1, 84},
  {1, 6},
  {4, 3},
  {1, 11},
  {1, 39},
  {4, 5},
  {1, 36},
  {1, 37},
  {6, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {13, 1},
  {1, 26},
  {1, 21},
  {3, 3},
  {1, 85},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {10, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {10, 0},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 69},
  {2, 5},
  {1, 36},
  {1, 37},
  {15, 0},                                                /* End of row  29 */
  {18, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 38},
  {1, 40},
  {5, 5},
  {5, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {14, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {10, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {8, 0},
  {1, 44},
  {1, 42},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {4, 5},
  {15, 0},                                                /* End of row  30 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 39},
  {4, 5},
  {1, 36},
  {1, 37},
  {3, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {15, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {11, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {7, 0},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 76},
  {14, 0},                                                /* End of row  31 */
  {18, 0},
  {3, 3},
  {1, 6},
  {7, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 38},
  {1, 40},
  {5, 5},
  {2, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {16, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {9, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {11, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {5, 0},
  {1, 44},
  {1, 42},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {5, 5},
  {1, 37},
  {14, 0},                                                /* End of row  32 */
  {18, 0},
  {3, 3},
  {1, 6},
  {9, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 39},
  {4, 5},
  {1, 36},
  {1, 163},
  {1, 187},
  {1, 34},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {17, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {12, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {4, 0},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {6, 5},
  {1, 76},
  {14, 0},                                                /* End of row  33 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 38},
  {1, 40},
  {3, 5},
  {1, 48},
  {1, 201},
  {1, 194},
  {1, 14},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {18, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {10, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {12, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {2, 0},
  {1, 44},
  {1, 42},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {15, 0},                                                /* End of row  34 */
  {18, 0},
  {3, 3},
  {1, 6},
  {10, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 39},
  {2, 5},
  {1, 48},
  {1, 50},
  {1, 173},
  {1, 161},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {19, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {9, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {13, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 13},
  {1, 0},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 104},
  {1, 192},
  {5, 5},
  {1, 36},
  {1, 37},
  {15, 0},                                                /* End of row  35 */
  {18, 0},
  {3, 3},
  {1, 6},
  {9, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 38},
  {1, 40},
  {1, 48},
  {1, 50},
  {1, 49},
  {1, 4},
  {1, 27},
  {1, 206},
  {1, 22},
  {1, 24},
  {1, 14},
  {20, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {11, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {13, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {3, 1},
  {1, 188},
  {1, 42},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 59},
  {6, 5},
  {16, 0},                                                /* End of row  36 */
  {18, 0},
  {3, 3},
  {1, 6},
  {11, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 186},
  {1, 197},
  {1, 49},
  {3, 4},
  {1, 176},
  {1, 106},
  {1, 14},
  {21, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {10, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {14, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {1, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {16, 0},                                                /* End of row  37 */
  {18, 0},
  {3, 3},
  {1, 6},
  {10, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 183},
  {1, 223},
  {4, 4},
  {1, 165},
  {1, 210},
  {22, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {12, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {14, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 52},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {17, 0},                                                /* End of row  38 */
  {18, 0},
  {3, 3},
  {1, 6},
  {12, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 209},
  {1, 8},
  {21, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {11, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {15, 1},
  {1, 8},
  {1, 19},
  {1, 180},
  {1, 115},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {17, 0},                                                /* End of row  39 */
  {18, 0},
  {3, 3},
  {1, 6},
  {11, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {21, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {13, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {15, 1},
  {1, 45},
  {1, 71},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {18, 0},                                                /* End of row  40 */
  {18, 0},
  {3, 3},
  {1, 6},
  {13, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {20, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {12, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {15, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {18, 0},                                                /* End of row  41 */
  {18, 0},
  {3, 3},
  {1, 6},
  {12, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {20, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {14, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {14, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {19, 0},                                                /* End of row  42 */
  {18, 0},
  {3, 3},
  {1, 6},
  {14, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {19, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {6, 2},
  {1, 7},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {13, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {19, 0},                                                /* End of row  43 */
  {18, 0},
  {3, 3},
  {1, 6},
  {13, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {19, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 62},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {12, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {20, 0},                                                /* End of row  44 */
  {18, 0},
  {3, 3},
  {1, 6},
  {7, 2},
  {1, 7},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {18, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 68},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {11, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {20, 0},                                                /* End of row  45 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 62},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {18, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 67},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {10, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {21, 0},                                                /* End of row  46 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 68},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {17, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {9, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {21, 0},                                                /* End of row  47 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 67},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {17, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {8, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {22, 0},                                                /* End of row  48 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {16, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {7, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 88},
  {1, 109},
  {4, 5},
  {1, 36},
  {1, 37},
  {22, 0},                                                /* End of row  49 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {1, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {16, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {6, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 100},
  {1, 50},
  {1, 48},
  {4, 5},
  {23, 0},                                                /* End of row  50 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {1, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {15, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {5, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {1, 4},
  {1, 49},
  {1, 50},
  {1, 48},
  {1, 5},
  {1, 36},
  {1, 37},
  {23, 0},                                                /* End of row  51 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {15, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {4, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {2, 4},
  {1, 49},
  {1, 50},
  {1, 48},
  {1, 5},
  {24, 0},                                                /* End of row  52 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {14, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {3, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {4, 4},
  {1, 49},
  {1, 198},
  {1, 143},
  {24, 0},                                                /* End of row  53 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {3, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {14, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {2, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 170},
  {1, 181},
  {24, 0},                                                /* End of row  54 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {13, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {4, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {1, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 168},
  {1, 28},
  {1, 13},
  {23, 0},                                                /* End of row  55 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {13, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 45},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 73},
  {1, 156},
  {1, 8},
  {1, 1},
  {1, 13},
  {22, 0},                                                /* End of row  56 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {4, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {12, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {5, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 98},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 96},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {21, 0},                                                /* End of row  57 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {5, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {12, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {6, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 92},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {20, 0},                                                /* End of row  58 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {5, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {11, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {6, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {3, 4},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {2, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {19, 0},                                                /* End of row  59 */
  {17, 0},
  {1, 138},
  {1, 126},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {6, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {11, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {7, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {3, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {2, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {18, 0},                                                /* End of row  60 */
  {16, 0},
  {1, 35},
  {1, 119},
  {1, 122},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {6, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {10, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 11},
  {1, 61},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {1, 4},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {3, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {17, 0},                                                /* End of row  61 */
  {15, 0},
  {1, 35},
  {1, 34},
  {1, 215},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {7, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {10, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 57},
  {1, 63},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {1, 128},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {5, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {16, 0},                                                /* End of row  62 */
  {14, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 97},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {7, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {9, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 75},
  {1, 15},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 227},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {6, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {15, 0},                                                /* End of row  63 */
  {13, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 219},
  {1, 57},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 11},
  {1, 61},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {9, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 74},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 103},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {8, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {14, 0},                                                /* End of row  64 */
  {12, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 139},
  {1, 124},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 57},
  {1, 63},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {8, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {1, 17},
  {1, 15},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {9, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {13, 0},                                                /* End of row  65 */
  {11, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 154},
  {1, 86},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 75},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {8, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {1, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {7, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {11, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {12, 0},                                                /* End of row  66 */
  {10, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 112},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 74},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {7, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {1, 4},
  {1, 17},
  {1, 15},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {7, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {12, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {11, 0},                                                /* End of row  67 */
  {9, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {7, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {2, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {5, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {14, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {10, 0},                                                /* End of row  68 */
  {8, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {1, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {1, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {6, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {2, 4},
  {1, 17},
  {1, 15},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {15, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {9, 0},                                                 /* End of row  69 */
  {7, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {2, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {1, 4},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {6, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {3, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {17, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {8, 0},                                                 /* End of row  70 */
  {6, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {3, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {2, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {5, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {3, 4},
  {1, 17},
  {1, 15},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {18, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {7, 0},                                                 /* End of row  71 */
  {5, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {4, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {2, 4},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {5, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {4, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {1, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {20, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {6, 0},                                                 /* End of row  72 */
  {4, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {5, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {3, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {4, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {4, 4},
  {1, 17},
  {1, 15},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {21, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {5, 0},                                                 /* End of row  73 */
  {3, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {6, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {3, 4},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {4, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 185},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {23, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {4, 0},                                                 /* End of row  74 */
  {2, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {7, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {4, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {3, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 83},
  {1, 78},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 2},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {24, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {3, 0},                                                 /* End of row  75 */
  {1, 0},
  {1, 35},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {8, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {4, 4},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {3, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 65},
  {1, 71},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {11, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {26, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {2, 0},                                                 /* End of row  76 */
  {1, 89},
  {1, 34},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {9, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {2, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 77},
  {1, 30},
  {3, 3},
  {1, 10},
  {13, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {27, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 13},
  {1, 0},                                                 /* End of row  77 */
  {1, 90},
  {1, 14},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {10, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 83},
  {1, 78},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {2, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 52},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {9, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {29, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},
  {1, 56},                                                /* End of row  78 */
  {1, 95},
  {1, 12},
  {1, 46},
  {1, 47},
  {1, 51},
  {1, 45},
  {11, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 65},
  {1, 71},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {1, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {1, 33},
  {1, 30},
  {3, 3},
  {1, 10},
  {11, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {30, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 12},
  {2, 1},                                                 /* End of row  79 */
  {1, 1},
  {1, 211},
  {1, 148},
  {1, 152},
  {1, 45},
  {12, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 77},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {1, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {1, 1},
  {1, 91},
  {4, 3},
  {1, 9},
  {1, 7},
  {8, 2},
  {1, 85},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 27},
  {1, 28},
  {32, 1},
  {1, 8},
  {1, 19},
  {1, 18},
  {1, 28},
  {1, 8},                                                 /* End of row  80 */
  {1, 1},
  {1, 12},
  {1, 169},
  {1, 23},
  {1, 8},
  {12, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 52},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 8},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {1, 1},
  {1, 91},
  {4, 3},
  {1, 87},
  {9, 2},
  {1, 53},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 29},
  {1, 8},
  {33, 1},
  {1, 8},
  {1, 111},
  {1, 178},
  {1, 52},                                                /* End of row  81 */
  {2, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {11, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 28},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {7, 2},
  {1, 114},
  {1, 105},
  {3, 3},
  {1, 103},
  {1, 224},
  {5, 4},
  {1, 73},
  {1, 28},
  {33, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 106},
  {1, 207},                                               /* End of row  82 */
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {10, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {1, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 29},
  {1, 113},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 52},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {10, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 73},
  {1, 28},
  {32, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},                                                 /* End of row  83 */
  {1, 56},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {9, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {1, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 27},
  {1, 160},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 77},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {8, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {1, 8},
  {30, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 56},                                                /* End of row  84 */
  {1, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {8, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {2, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 213},
  {1, 21},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 65},
  {1, 71},
  {1, 11},
  {3, 3},
  {1, 10},
  {12, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {29, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {1, 0},                                                 /* End of row  85 */
  {2, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {7, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {2, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 217},
  {1, 79},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 83},
  {1, 78},
  {4, 3},
  {1, 9},
  {1, 7},
  {10, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {1, 8},
  {27, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {2, 0},                                                 /* End of row  86 */
  {3, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {6, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {3, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {4, 4},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {14, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {26, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {3, 0},                                                 /* End of row  87 */
  {4, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {5, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {3, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {3, 4},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {4, 4},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {12, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {1, 8},
  {24, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {4, 0},                                                 /* End of row  88 */
  {5, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {4, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {4, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {3, 4},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {4, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {9, 2},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {23, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {5, 0},                                                 /* End of row  89 */
  {6, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {3, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {4, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {2, 4},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {3, 4},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {1, 87},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {1, 8},
  {21, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {6, 0},                                                 /* End of row  90 */
  {7, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {2, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {5, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {2, 4},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {3, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {1, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {20, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {7, 0},                                                 /* End of row  91 */
  {8, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {1, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {5, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {1, 4},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {2, 4},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {1, 8},
  {18, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {8, 0},                                                 /* End of row  92 */
  {9, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {6, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {1, 4},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {2, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {17, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {9, 0},                                                 /* End of row  93 */
  {10, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 113},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {6, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 17},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {1, 4},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {1, 8},
  {15, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {10, 0},                                                /* End of row  94 */
  {11, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 166},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {7, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 16},
  {1, 74},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {1, 4},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {14, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {11, 0},                                                /* End of row  95 */
  {12, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 216},
  {1, 79},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {7, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 15},
  {1, 75},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {1, 17},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {6, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {1, 8},
  {12, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {12, 0},                                                /* End of row  96 */
  {13, 0},
  {1, 13},
  {3, 1},
  {1, 97},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {8, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 63},
  {1, 57},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 74},
  {1, 16},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {7, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {11, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {13, 0},                                                /* End of row  97 */
  {14, 0},
  {1, 13},
  {2, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {8, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 61},
  {1, 11},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 75},
  {1, 15},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 61},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {14, 0},                                                /* End of row  98 */
  {15, 0},
  {1, 13},
  {1, 1},
  {1, 26},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {9, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {8, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 57},
  {1, 63},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 202},
  {1, 15},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {8, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {15, 0},                                                /* End of row  99 */
  {16, 0},
  {1, 13},
  {1, 112},
  {1, 21},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {9, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {8, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 11},
  {1, 61},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 221},
  {1, 16},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {1, 8},
  {6, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {16, 0},                                                /* End of row 100 */
  {17, 0},
  {1, 226},
  {1, 123},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {10, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {7, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {7, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {1, 4},
  {1, 17},
  {1, 15},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {5, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {17, 0},                                                /* End of row 101 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {10, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {7, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {7, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {2, 4},
  {1, 16},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {1, 8},
  {3, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {18, 0},                                                /* End of row 102 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {11, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {6, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {6, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {3, 4},
  {1, 17},
  {1, 15},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {2, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {19, 0},                                                /* End of row 103 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {11, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {6, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {6, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {4, 4},
  {1, 16},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 29},
  {2, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {20, 0},                                                /* End of row 104 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {12, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {5, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {5, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 17},
  {1, 15},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 27},
  {1, 28},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {21, 0},                                                /* End of row 105 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {12, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {5, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 92},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 96},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {22, 0},                                                /* End of row 106 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {13, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {4, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 98},
  {1, 30},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {5, 4},
  {1, 171},
  {1, 147},
  {1, 212},
  {1, 1},
  {1, 13},
  {23, 0},                                                /* End of row 107 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {13, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 45},
  {1, 32},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {5, 4},
  {1, 172},
  {1, 52},
  {1, 13},
  {24, 0},                                                /* End of row 108 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {14, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {3, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {1, 1},
  {1, 33},
  {1, 30},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {4, 4},
  {1, 49},
  {1, 144},
  {1, 204},
  {1, 203},
  {24, 0},                                                /* End of row 109 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {14, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {3, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {3, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {2, 1},
  {1, 32},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {2, 4},
  {1, 49},
  {1, 50},
  {1, 48},
  {1, 5},
  {25, 0},                                                /* End of row 110 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {15, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {3, 1},
  {1, 33},
  {1, 30},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {1, 4},
  {1, 49},
  {1, 50},
  {1, 48},
  {1, 5},
  {1, 36},
  {1, 37},
  {24, 0},                                                /* End of row 111 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {15, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {4, 1},
  {1, 32},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 100},
  {1, 50},
  {1, 48},
  {4, 5},
  {24, 0},                                                /* End of row 112 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {16, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {1, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {5, 1},
  {1, 33},
  {1, 30},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 88},
  {1, 109},
  {4, 5},
  {1, 36},
  {1, 37},
  {23, 0},                                                /* End of row 113 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {16, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {1, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {6, 1},
  {1, 32},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {23, 0},                                                /* End of row 114 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {17, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {7, 1},
  {1, 33},
  {1, 30},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {22, 0},                                                /* End of row 115 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 20},
  {1, 25},
  {5, 4},
  {1, 31},
  {1, 12},
  {17, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {1, 67},
  {7, 2},
  {1, 67},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {8, 1},
  {1, 32},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {22, 0},                                                /* End of row 116 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 57},
  {1, 220},
  {5, 4},
  {1, 31},
  {1, 12},
  {18, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 68},
  {7, 2},
  {1, 68},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {9, 1},
  {1, 33},
  {1, 30},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {21, 0},                                                /* End of row 117 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 146},
  {1, 49},
  {4, 4},
  {1, 31},
  {1, 12},
  {18, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 62},
  {7, 2},
  {1, 62},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {10, 1},
  {1, 32},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {21, 0},                                                /* End of row 118 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 59},
  {1, 50},
  {1, 49},
  {3, 4},
  {1, 82},
  {1, 94},
  {1, 8},
  {18, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 7},
  {5, 2},
  {1, 7},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {11, 1},
  {1, 33},
  {1, 30},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {20, 0},                                                /* End of row 119 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {1, 48},
  {1, 50},
  {1, 49},
  {2, 4},
  {1, 82},
  {1, 72},
  {1, 19},
  {1, 8},
  {17, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {18, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {12, 1},
  {1, 32},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {20, 0},                                                /* End of row 120 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {1, 5},
  {1, 48},
  {1, 50},
  {1, 49},
  {1, 4},
  {1, 31},
  {1, 157},
  {1, 18},
  {1, 19},
  {1, 8},
  {17, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {20, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {12, 1},
  {1, 8},
  {1, 174},
  {1, 117},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {19, 0},                                                /* End of row 121 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {2, 5},
  {1, 48},
  {1, 50},
  {1, 49},
  {1, 31},
  {2, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {16, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {16, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {11, 1},
  {1, 8},
  {1, 23},
  {1, 155},
  {1, 130},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {19, 0},                                                /* End of row 122 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {3, 5},
  {1, 48},
  {1, 50},
  {1, 175},
  {1, 12},
  {1, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {16, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {18, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {11, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 179},
  {1, 30},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {18, 0},                                                /* End of row 123 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {4, 5},
  {1, 48},
  {1, 199},
  {1, 158},
  {2, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {15, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {14, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {10, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 191},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {18, 0},                                                /* End of row 124 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {5, 5},
  {1, 140},
  {1, 182},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {15, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {16, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {10, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {1, 184},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {17, 0},                                                /* End of row 125 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {1, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {14, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {12, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {2, 0},
  {1, 44},
  {1, 42},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {17, 0},                                                /* End of row 126 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {2, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {14, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {14, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {9, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {4, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {16, 0},                                                /* End of row 127 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {3, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {13, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {10, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {8, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {5, 0},
  {1, 44},
  {1, 42},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {16, 0},                                                /* End of row 128 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {4, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {13, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {12, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {8, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {7, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {5, 5},
  {1, 36},
  {1, 37},
  {15, 0},                                                /* End of row 129 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {5, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {12, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {8, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {7, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {8, 0},
  {1, 44},
  {1, 42},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 38},
  {1, 40},
  {6, 5},
  {15, 0},                                                /* End of row 130 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {6, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {12, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {10, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {7, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {10, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 69},
  {5, 5},
  {1, 36},
  {1, 108},
  {14, 0},                                                /* End of row 131 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {7, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {11, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {6, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {11, 0},
  {1, 44},
  {1, 42},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 60},
  {4, 3},
  {1, 39},
  {6, 5},
  {1, 149},
  {14, 0},                                                /* End of row 132 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {8, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {11, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {6, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {13, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 9},
  {4, 3},
  {1, 39},
  {7, 5},
  {14, 0},                                                /* End of row 133 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {9, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {10, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {5, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {14, 0},
  {1, 44},
  {1, 42},
  {2, 3},
  {1, 10},
  {5, 2},
  {1, 7},
  {1, 60},
  {3, 3},
  {1, 104},
  {1, 189},
  {6, 5},
  {1, 36},
  {1, 108},
  {13, 0},                                                /* End of row 134 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {10, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {10, 1},
  {1, 32},
  {1, 11},
  {3, 3},
  {1, 6},
  {1, 102},
  {1, 7},
  {2, 2},
  {1, 7},
  {1, 102},
  {1, 6},
  {3, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {5, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {16, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {2, 2},
  {1, 7},
  {1, 2},
  {1, 10},
  {3, 3},
  {1, 38},
  {1, 59},
  {7, 5},
  {1, 37},
  {13, 0},                                                /* End of row 135 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {11, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {9, 1},
  {1, 33},
  {1, 30},
  {4, 3},
  {1, 6},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 6},
  {4, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {4, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {17, 0},
  {1, 44},
  {1, 42},
  {2, 3},
  {1, 6},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 39},
  {8, 5},
  {1, 37},
  {13, 0},                                                /* End of row 136 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {12, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {9, 1},
  {1, 32},
  {1, 11},
  {5, 3},
  {2, 6},
  {5, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {4, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {19, 0},
  {5, 3},
  {2, 6},
  {5, 3},
  {1, 38},
  {1, 40},
  {8, 5},
  {1, 76},
  {13, 0},                                                /* End of row 137 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {13, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {8, 1},
  {1, 33},
  {1, 30},
  {12, 3},
  {1, 15},
  {1, 17},
  {6, 4},
  {1, 29},
  {1, 8},
  {3, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {20, 0},
  {1, 44},
  {1, 42},
  {9, 3},
  {1, 66},
  {1, 107},
  {9, 5},
  {14, 0},                                                /* End of row 138 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 41},
  {1, 43},
  {6, 5},
  {14, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {8, 1},
  {1, 32},
  {1, 11},
  {10, 3},
  {1, 11},
  {1, 16},
  {6, 4},
  {1, 27},
  {1, 28},
  {3, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {22, 0},
  {9, 3},
  {1, 66},
  {1, 107},
  {8, 5},
  {1, 36},
  {1, 37},
  {14, 0},                                                /* End of row 139 */
  {18, 0},
  {3, 3},
  {1, 6},
  {2, 2},
  {1, 7},
  {1, 225},
  {4, 2},
  {1, 125},
  {2, 41},
  {1, 120},
  {1, 59},
  {6, 5},
  {15, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {7, 1},
  {1, 55},
  {1, 80},
  {1, 11},
  {8, 3},
  {1, 11},
  {1, 135},
  {1, 99},
  {6, 4},
  {1, 29},
  {1, 8},
  {2, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {23, 0},
  {1, 129},
  {1, 121},
  {1, 3},
  {1, 42},
  {2, 3},
  {1, 11},
  {1, 66},
  {1, 131},
  {1, 190},
  {10, 5},
  {15, 0},                                                /* End of row 140 */
  {25, 0},
  {1, 142},
  {4, 70},
  {3, 43},
  {1, 59},
  {7, 5},
  {16, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {7, 1},
  {1, 55},
  {1, 32},
  {1, 30},
  {1, 11},
  {4, 3},
  {1, 11},
  {1, 15},
  {1, 16},
  {1, 99},
  {6, 4},
  {1, 27},
  {1, 28},
  {2, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {27, 0},
  {1, 222},
  {1, 44},
  {1, 133},
  {1, 69},
  {1, 40},
  {1, 141},
  {9, 5},
  {1, 36},
  {1, 37},
  {15, 0},                                                /* End of row 141 */
  {25, 0},
  {16, 5},
  {17, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {8, 1},
  {1, 33},
  {1, 32},
  {1, 116},
  {1, 79},
  {1, 20},
  {1, 150},
  {1, 16},
  {1, 17},
  {7, 4},
  {1, 73},
  {1, 94},
  {1, 8},
  {1, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {30, 0},
  {1, 162},
  {11, 5},
  {1, 36},
  {1, 5},
  {16, 0},                                                /* End of row 142 */
  {25, 0},
  {16, 5},
  {18, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {9, 1},
  {1, 164},
  {1, 214},
  {1, 218},
  {1, 200},
  {7, 4},
  {1, 82},
  {1, 101},
  {1, 110},
  {1, 8},
  {1, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {32, 0},
  {1, 37},
  {1, 36},
  {8, 5},
  {1, 36},
  {1, 5},
  {17, 0},                                                /* End of row 143 */
  {25, 0},
  {16, 5},
  {19, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 28},
  {1, 29},
  {1, 27},
  {5, 31},
  {1, 101},
  {1, 110},
  {1, 81},
  {2, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {34, 0},
  {8, 5},
  {1, 36},
  {1, 5},
  {18, 0},                                                /* End of row 144 */
  {25, 0},
  {16, 5},
  {20, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {10, 1},
  {1, 8},
  {6, 12},
  {1, 81},
  {3, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {35, 0},
  {1, 64},
  {7, 5},
  {1, 37},
  {19, 0},                                                /* End of row 145 */
  {25, 0},
  {16, 5},
  {21, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {19, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {64, 0},                                                /* End of row 146 */
  {25, 0},
  {16, 5},
  {22, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {17, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {65, 0},                                                /* End of row 147 */
  {64, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {15, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {66, 0},                                                /* End of row 148 */
  {65, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {13, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {67, 0},                                                /* End of row 149 */
  {66, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {11, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {68, 0},                                                /* End of row 150 */
  {67, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {69, 0},                                                /* End of row 151 */
  {68, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {7, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {70, 0},                                                /* End of row 152 */
  {69, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {5, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {71, 0},                                                /* End of row 153 */
  {70, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {3, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {72, 0},                                                /* End of row 154 */
  {71, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {1, 1},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {73, 0},                                                /* End of row 155 */
  {72, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 19},
  {1, 8},
  {1, 23},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {74, 0},                                                /* End of row 156 */
  {73, 0},
  {1, 13},
  {3, 1},
  {1, 12},
  {1, 18},
  {1, 111},
  {1, 22},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {75, 0},                                                /* End of row 157 */
  {74, 0},
  {1, 13},
  {3, 1},
  {1, 52},
  {1, 153},
  {1, 24},
  {1, 14},
  {1, 1},
  {1, 13},
  {76, 0},                                                /* End of row 158 */
  {75, 0},
  {1, 13},
  {2, 1},
  {1, 159},
  {1, 145},
  {1, 14},
  {1, 1},
  {1, 13},
  {77, 0},                                                /* End of row 159 */
  {76, 0},
  {1, 56},
  {4, 1},
  {1, 56},
  {78, 0},                                                /* End of row 160 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32 */

#if defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP24) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP16)
static const struct splscr_bitmap_s bitmap[] =
{
  {76, 0},
  {1, 32},
  {1, 80},
  {1, 85},
  {5, 1},
  {76, 0},                                                /* End of row   1 */
  {75, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 12},
  {1, 72},
  {4, 1},
  {75, 0},                                                /* End of row   2 */
  {74, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 157},
  {1, 147},
  {1, 12},
  {4, 1},
  {74, 0},                                                /* End of row   3 */
  {73, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 173},
  {1, 133},
  {1, 17},
  {1, 12},
  {4, 1},
  {73, 0},                                                /* End of row   4 */
  {72, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {72, 0},                                                /* End of row   5 */
  {71, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {71, 0},                                                /* End of row   6 */
  {70, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {4, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {70, 0},                                                /* End of row   7 */
  {69, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {6, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {69, 0},                                                /* End of row   8 */
  {68, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {8, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {68, 0},                                                /* End of row   9 */
  {67, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {10, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {67, 0},                                                /* End of row  10 */
  {66, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {12, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {66, 0},                                                /* End of row  11 */
  {65, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {14, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {65, 0},                                                /* End of row  12 */
  {64, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {16, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {64, 0},                                                /* End of row  13 */
  {63, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {18, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {63, 0},                                                /* End of row  14 */
  {62, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {20, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {62, 0},                                                /* End of row  15 */
  {61, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {22, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {61, 0},                                                /* End of row  16 */
  {60, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {24, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {60, 0},                                                /* End of row  17 */
  {59, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {26, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {59, 0},                                                /* End of row  18 */
  {58, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {28, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {26, 0},
  {7, 3},
  {25, 0},                                                /* End of row  19 */
  {57, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {10, 1},
  {1, 49},
  {3, 25},
  {1, 49},
  {15, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {23, 0},
  {11, 3},
  {23, 0},                                                /* End of row  20 */
  {56, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {9, 1},
  {1, 49},
  {1, 31},
  {1, 29},
  {3, 20},
  {1, 29},
  {1, 31},
  {1, 33},
  {14, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {22, 0},
  {12, 3},
  {22, 0},                                                /* End of row  21 */
  {23, 0},
  {7, 3},
  {25, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {9, 1},
  {1, 49},
  {1, 71},
  {1, 11},
  {5, 3},
  {1, 11},
  {1, 29},
  {1, 83},
  {14, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {20, 0},
  {14, 3},
  {21, 0},                                                /* End of row  22 */
  {21, 0},
  {11, 3},
  {22, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {9, 1},
  {1, 49},
  {1, 71},
  {1, 11},
  {8, 3},
  {1, 77},
  {1, 83},
  {1, 47},
  {3, 12},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {19, 0},
  {14, 3},
  {21, 0},                                                /* End of row  23 */
  {21, 0},
  {12, 3},
  {20, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {10, 1},
  {1, 31},
  {1, 11},
  {10, 3},
  {1, 107},
  {1, 185},
  {1, 57},
  {1, 30},
  {1, 26},
  {1, 28},
  {1, 12},
  {9, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {17, 0},
  {6, 3},
  {1, 6},
  {2, 48},
  {1, 6},
  {5, 3},
  {1, 11},
  {20, 0},                                                /* End of row  24 */
  {20, 0},
  {13, 3},
  {1, 121},
  {5, 5},
  {13, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {10, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {3, 6},
  {5, 3},
  {1, 14},
  {1, 16},
  {3, 4},
  {1, 64},
  {1, 12},
  {9, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {16, 0},
  {5, 3},
  {1, 51},
  {4, 2},
  {1, 51},
  {4, 3},
  {1, 58},
  {1, 176},
  {1, 5},
  {18, 0},                                                /* End of row  25 */
  {19, 0},
  {14, 3},
  {1, 35},
  {1, 37},
  {5, 5},
  {11, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {11, 1},
  {1, 175},
  {1, 11},
  {3, 3},
  {1, 48},
  {3, 2},
  {1, 51},
  {4, 3},
  {1, 11},
  {1, 15},
  {4, 4},
  {1, 64},
  {1, 12},
  {9, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {14, 0},
  {5, 3},
  {1, 10},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 61},
  {2, 5},
  {17, 0},                                                /* End of row  26 */
  {19, 0},
  {5, 3},
  {1, 10},
  {1, 53},
  {1, 9},
  {1, 48},
  {5, 3},
  {1, 11},
  {1, 36},
  {6, 5},
  {9, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {11, 1},
  {1, 188},
  {1, 120},
  {3, 3},
  {1, 95},
  {1, 75},
  {4, 2},
  {1, 51},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 64},
  {1, 12},
  {9, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {13, 0},
  {5, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 53},
  {4, 3},
  {1, 36},
  {3, 5},
  {16, 0},                                                /* End of row  27 */
  {18, 0},
  {5, 3},
  {1, 51},
  {1, 2},
  {1, 7},
  {2, 2},
  {1, 48},
  {5, 3},
  {1, 35},
  {1, 37},
  {5, 5},
  {8, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {12, 1},
  {1, 25},
  {1, 20},
  {3, 3},
  {1, 48},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {11, 0},
  {5, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 53},
  {4, 3},
  {1, 36},
  {3, 5},
  {16, 0},                                                /* End of row  28 */
  {18, 0},
  {4, 3},
  {1, 10},
  {5, 2},
  {1, 75},
  {1, 6},
  {4, 3},
  {1, 11},
  {1, 36},
  {6, 5},
  {6, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {13, 1},
  {1, 25},
  {1, 20},
  {3, 3},
  {1, 76},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {10, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {10, 0},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 61},
  {4, 5},
  {15, 0},                                                /* End of row  29 */
  {18, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 35},
  {1, 37},
  {5, 5},
  {5, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {14, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {10, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {8, 0},
  {5, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {4, 5},
  {15, 0},                                                /* End of row  30 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 36},
  {6, 5},
  {3, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {15, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {11, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {7, 0},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {6, 5},
  {14, 0},                                                /* End of row  31 */
  {18, 0},
  {3, 3},
  {1, 6},
  {7, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 35},
  {1, 37},
  {5, 5},
  {2, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {16, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {9, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {11, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {5, 0},
  {5, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {14, 0},                                                /* End of row  32 */
  {18, 0},
  {3, 3},
  {1, 6},
  {9, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 36},
  {6, 5},
  {1, 167},
  {1, 34},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {17, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {12, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {4, 0},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {14, 0},                                                /* End of row  33 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 35},
  {1, 37},
  {3, 5},
  {1, 41},
  {1, 181},
  {1, 174},
  {1, 13},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {18, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {10, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {12, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {2, 0},
  {5, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {15, 0},                                                /* End of row  34 */
  {18, 0},
  {3, 3},
  {1, 6},
  {10, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 36},
  {2, 5},
  {1, 41},
  {1, 45},
  {1, 153},
  {1, 143},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {19, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {9, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {13, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {4, 1},
  {1, 0},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 94},
  {1, 172},
  {7, 5},
  {15, 0},                                                /* End of row  35 */
  {18, 0},
  {3, 3},
  {1, 6},
  {9, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 35},
  {1, 37},
  {1, 41},
  {1, 45},
  {1, 44},
  {1, 4},
  {1, 26},
  {1, 186},
  {1, 21},
  {1, 23},
  {1, 13},
  {20, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {11, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {13, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {1, 168},
  {4, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 52},
  {6, 5},
  {16, 0},                                                /* End of row  36 */
  {18, 0},
  {3, 3},
  {1, 6},
  {11, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 166},
  {1, 177},
  {1, 44},
  {3, 4},
  {1, 156},
  {1, 96},
  {1, 13},
  {21, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {10, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {14, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {1, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {16, 0},                                                /* End of row  37 */
  {18, 0},
  {3, 3},
  {1, 6},
  {10, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 163},
  {1, 202},
  {4, 4},
  {1, 145},
  {1, 190},
  {22, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {12, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {14, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 47},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {17, 0},                                                /* End of row  38 */
  {18, 0},
  {3, 3},
  {1, 6},
  {12, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 189},
  {1, 8},
  {21, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {11, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {15, 1},
  {1, 8},
  {1, 18},
  {1, 160},
  {1, 104},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {17, 0},                                                /* End of row  39 */
  {18, 0},
  {3, 3},
  {1, 6},
  {11, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {21, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {13, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {15, 1},
  {1, 40},
  {1, 63},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {18, 0},                                                /* End of row  40 */
  {18, 0},
  {3, 3},
  {1, 6},
  {13, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {20, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {12, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {15, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {18, 0},                                                /* End of row  41 */
  {18, 0},
  {3, 3},
  {1, 6},
  {12, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {20, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {14, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {14, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {19, 0},                                                /* End of row  42 */
  {18, 0},
  {3, 3},
  {1, 6},
  {14, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {19, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {6, 2},
  {1, 7},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {13, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {19, 0},                                                /* End of row  43 */
  {18, 0},
  {3, 3},
  {1, 6},
  {13, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {19, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 55},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {12, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {20, 0},                                                /* End of row  44 */
  {18, 0},
  {3, 3},
  {1, 6},
  {7, 2},
  {1, 7},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {18, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 60},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {11, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {20, 0},                                                /* End of row  45 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 55},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {18, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 59},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {10, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {21, 0},                                                /* End of row  46 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 60},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {17, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {9, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {21, 0},                                                /* End of row  47 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 59},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {17, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {8, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {22, 0},                                                /* End of row  48 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {16, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {7, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 79},
  {1, 98},
  {6, 5},
  {22, 0},                                                /* End of row  49 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {1, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {16, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {6, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 90},
  {1, 45},
  {1, 41},
  {4, 5},
  {23, 0},                                                /* End of row  50 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {1, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {15, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {5, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {1, 4},
  {1, 44},
  {1, 45},
  {1, 41},
  {3, 5},
  {23, 0},                                                /* End of row  51 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {15, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {4, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {2, 4},
  {1, 44},
  {1, 45},
  {1, 41},
  {1, 5},
  {24, 0},                                                /* End of row  52 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {14, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {3, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {4, 4},
  {1, 44},
  {1, 178},
  {1, 41},
  {24, 0},                                                /* End of row  53 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {3, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {14, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {2, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 150},
  {1, 161},
  {24, 0},                                                /* End of row  54 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {13, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {4, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {1, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 148},
  {1, 27},
  {1, 1},
  {23, 0},                                                /* End of row  55 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {13, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 40},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 65},
  {1, 138},
  {1, 8},
  {2, 1},
  {22, 0},                                                /* End of row  56 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {4, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {12, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {5, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 88},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 86},
  {1, 17},
  {1, 12},
  {3, 1},
  {21, 0},                                                /* End of row  57 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {5, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {12, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {6, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 82},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {20, 0},                                                /* End of row  58 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {5, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {11, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {6, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {3, 4},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {2, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {19, 0},                                                /* End of row  59 */
  {17, 0},
  {1, 122},
  {1, 114},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {6, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {11, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {7, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {3, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {2, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {18, 0},                                                /* End of row  60 */
  {16, 0},
  {1, 32},
  {1, 108},
  {1, 110},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {6, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {10, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 11},
  {1, 54},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {1, 4},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {3, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {17, 0},                                                /* End of row  61 */
  {15, 0},
  {1, 32},
  {1, 34},
  {1, 195},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {7, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {10, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 50},
  {1, 56},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {1, 115},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {5, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {16, 0},                                                /* End of row  62 */
  {14, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 87},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {7, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {9, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 67},
  {1, 14},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 205},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {6, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {15, 0},                                                /* End of row  63 */
  {13, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 199},
  {1, 50},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 11},
  {1, 54},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {9, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 66},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 93},
  {1, 11},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {8, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {14, 0},                                                /* End of row  64 */
  {12, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 123},
  {1, 112},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 50},
  {1, 56},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {8, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {1, 16},
  {1, 14},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {9, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {13, 0},                                                /* End of row  65 */
  {11, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 136},
  {1, 77},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 67},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {8, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {1, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {7, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {11, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {12, 0},                                                /* End of row  66 */
  {10, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 101},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 66},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {7, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {1, 4},
  {1, 16},
  {1, 14},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {7, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {12, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {11, 0},                                                /* End of row  67 */
  {9, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {7, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {2, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {5, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {14, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {10, 0},                                                /* End of row  68 */
  {8, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {1, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {1, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {6, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {2, 4},
  {1, 16},
  {1, 14},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {15, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {9, 0},                                                 /* End of row  69 */
  {7, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {2, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {1, 4},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {6, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {3, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {17, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {8, 0},                                                 /* End of row  70 */
  {6, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {3, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {2, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {5, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {3, 4},
  {1, 16},
  {1, 14},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {18, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {7, 0},                                                 /* End of row  71 */
  {5, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {4, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {2, 4},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {5, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {4, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {1, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {20, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {6, 0},                                                 /* End of row  72 */
  {4, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {5, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {3, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {4, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {4, 4},
  {1, 16},
  {1, 14},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {21, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {5, 0},                                                 /* End of row  73 */
  {3, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {6, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {3, 4},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {4, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 165},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {23, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {4, 0},                                                 /* End of row  74 */
  {2, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {7, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {4, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {3, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 74},
  {1, 69},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 2},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {24, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {3, 0},                                                 /* End of row  75 */
  {1, 0},
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {8, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {4, 4},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {3, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 57},
  {1, 63},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {11, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {26, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {2, 0},                                                 /* End of row  76 */
  {1, 32},
  {1, 34},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {9, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {2, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 68},
  {1, 29},
  {3, 3},
  {1, 10},
  {13, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {27, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},
  {1, 0},                                                 /* End of row  77 */
  {1, 80},
  {1, 13},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {10, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 74},
  {1, 69},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {2, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 47},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 9},
  {1, 7},
  {9, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {29, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {3, 1},                                                 /* End of row  78 */
  {1, 85},
  {1, 12},
  {1, 42},
  {1, 43},
  {1, 46},
  {1, 40},
  {11, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 57},
  {1, 63},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {1, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {1, 33},
  {1, 29},
  {3, 3},
  {1, 10},
  {11, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {30, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 12},
  {2, 1},                                                 /* End of row  79 */
  {1, 1},
  {1, 191},
  {1, 131},
  {1, 134},
  {1, 40},
  {12, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 68},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {1, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {1, 1},
  {1, 81},
  {4, 3},
  {1, 9},
  {1, 7},
  {8, 2},
  {1, 76},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 26},
  {1, 27},
  {32, 1},
  {1, 8},
  {1, 18},
  {1, 17},
  {1, 27},
  {1, 8},                                                 /* End of row  80 */
  {1, 1},
  {1, 12},
  {1, 149},
  {1, 22},
  {1, 8},
  {12, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 47},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 8},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {1, 1},
  {1, 81},
  {4, 3},
  {1, 78},
  {9, 2},
  {1, 48},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 28},
  {1, 8},
  {33, 1},
  {1, 8},
  {1, 100},
  {1, 158},
  {1, 47},                                                /* End of row  81 */
  {2, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {11, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 27},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {7, 2},
  {1, 103},
  {1, 95},
  {3, 3},
  {1, 93},
  {1, 203},
  {5, 4},
  {1, 65},
  {1, 27},
  {33, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 96},
  {1, 187},                                               /* End of row  82 */
  {3, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {10, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {1, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 28},
  {1, 102},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 47},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {10, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 65},
  {1, 27},
  {32, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {1, 1},                                                 /* End of row  83 */
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {9, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {1, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 26},
  {1, 142},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 68},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {8, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {1, 8},
  {30, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},                                                 /* End of row  84 */
  {1, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {8, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {2, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 193},
  {1, 20},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 57},
  {1, 63},
  {1, 11},
  {3, 3},
  {1, 10},
  {12, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {29, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {1, 0},                                                 /* End of row  85 */
  {2, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {7, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {2, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 197},
  {1, 70},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 74},
  {1, 69},
  {4, 3},
  {1, 9},
  {1, 7},
  {10, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {1, 8},
  {27, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {2, 0},                                                 /* End of row  86 */
  {3, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {6, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {3, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {4, 4},
  {1, 24},
  {1, 19},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {14, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {26, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {3, 0},                                                 /* End of row  87 */
  {4, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {5, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {3, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {3, 4},
  {1, 24},
  {1, 19},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {4, 4},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {12, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {1, 8},
  {24, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {4, 0},                                                 /* End of row  88 */
  {5, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {4, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {4, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {3, 4},
  {1, 24},
  {1, 19},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {4, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {9, 2},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {23, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {5, 0},                                                 /* End of row  89 */
  {6, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {3, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {4, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {2, 4},
  {1, 24},
  {1, 19},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {3, 4},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {1, 78},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {1, 8},
  {21, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {6, 0},                                                 /* End of row  90 */
  {7, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {2, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {5, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {2, 4},
  {1, 24},
  {1, 19},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {3, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {1, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {20, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {7, 0},                                                 /* End of row  91 */
  {8, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {1, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {5, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {1, 4},
  {1, 24},
  {1, 19},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {2, 4},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {1, 8},
  {18, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {8, 0},                                                 /* End of row  92 */
  {9, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {6, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {1, 4},
  {1, 24},
  {1, 19},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {2, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {17, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {9, 0},                                                 /* End of row  93 */
  {10, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 102},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {6, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 16},
  {1, 24},
  {1, 19},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {1, 4},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {1, 8},
  {15, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {10, 0},                                                /* End of row  94 */
  {11, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 146},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {7, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 15},
  {1, 66},
  {1, 19},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {1, 4},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {5, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {14, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {11, 0},                                                /* End of row  95 */
  {12, 0},
  {4, 1},
  {1, 12},
  {1, 196},
  {1, 70},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {7, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 14},
  {1, 67},
  {1, 19},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {1, 16},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {6, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {1, 8},
  {12, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {12, 0},                                                /* End of row  96 */
  {13, 0},
  {4, 1},
  {1, 87},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {8, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 11},
  {1, 56},
  {1, 50},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 66},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {7, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {11, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {13, 0},                                                /* End of row  97 */
  {14, 0},
  {3, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {8, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 54},
  {1, 11},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 67},
  {1, 14},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 54},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {14, 0},                                                /* End of row  98 */
  {15, 0},
  {2, 1},
  {1, 25},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {9, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {8, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 50},
  {1, 56},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 182},
  {1, 14},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {8, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {15, 0},                                                /* End of row  99 */
  {16, 0},
  {1, 1},
  {1, 101},
  {1, 20},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {9, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {8, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 11},
  {1, 54},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 201},
  {1, 15},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {1, 8},
  {6, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {16, 0},                                                /* End of row 100 */
  {17, 0},
  {1, 204},
  {1, 111},
  {2, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {10, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {7, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {7, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {1, 4},
  {1, 16},
  {1, 14},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {5, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {17, 0},                                                /* End of row 101 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {10, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {7, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {7, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {2, 4},
  {1, 15},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {1, 8},
  {3, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {18, 0},                                                /* End of row 102 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {11, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {6, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {6, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {3, 4},
  {1, 16},
  {1, 14},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {2, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {19, 0},                                                /* End of row 103 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {11, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {6, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {6, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {4, 4},
  {1, 15},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 28},
  {2, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {20, 0},                                                /* End of row 104 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {12, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {5, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {5, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 16},
  {1, 14},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 26},
  {1, 27},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {21, 0},                                                /* End of row 105 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {12, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {5, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {5, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 82},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 86},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {22, 0},                                                /* End of row 106 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {13, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {4, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {4, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 88},
  {1, 29},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {5, 4},
  {1, 151},
  {1, 130},
  {1, 192},
  {2, 1},
  {23, 0},                                                /* End of row 107 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {13, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 40},
  {1, 31},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {5, 4},
  {1, 152},
  {1, 47},
  {1, 1},
  {24, 0},                                                /* End of row 108 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {14, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {3, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {1, 1},
  {1, 33},
  {1, 29},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {4, 4},
  {1, 44},
  {1, 127},
  {1, 184},
  {1, 183},
  {24, 0},                                                /* End of row 109 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {14, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {3, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {3, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {2, 1},
  {1, 31},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {2, 4},
  {1, 44},
  {1, 45},
  {1, 41},
  {1, 5},
  {25, 0},                                                /* End of row 110 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {15, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {3, 1},
  {1, 33},
  {1, 29},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {1, 4},
  {1, 44},
  {1, 45},
  {1, 41},
  {3, 5},
  {24, 0},                                                /* End of row 111 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {15, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {2, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {4, 1},
  {1, 31},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 90},
  {1, 45},
  {1, 41},
  {4, 5},
  {24, 0},                                                /* End of row 112 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {16, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {1, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {5, 1},
  {1, 33},
  {1, 29},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 79},
  {1, 98},
  {6, 5},
  {23, 0},                                                /* End of row 113 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {16, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {1, 3},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {6, 1},
  {1, 31},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {23, 0},                                                /* End of row 114 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {17, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 10},
  {1, 6},
  {7, 2},
  {1, 6},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {7, 1},
  {1, 33},
  {1, 29},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {22, 0},                                                /* End of row 115 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 19},
  {1, 24},
  {5, 4},
  {1, 30},
  {1, 12},
  {17, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {1, 59},
  {7, 2},
  {1, 59},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {8, 1},
  {1, 31},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {22, 0},                                                /* End of row 116 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 50},
  {1, 200},
  {5, 4},
  {1, 30},
  {1, 12},
  {18, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 60},
  {7, 2},
  {1, 60},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {9, 1},
  {1, 33},
  {1, 29},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {21, 0},                                                /* End of row 117 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 129},
  {1, 44},
  {4, 4},
  {1, 30},
  {1, 12},
  {18, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 55},
  {7, 2},
  {1, 55},
  {1, 7},
  {5, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {10, 1},
  {1, 31},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {21, 0},                                                /* End of row 118 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 52},
  {1, 45},
  {1, 44},
  {3, 4},
  {1, 73},
  {1, 84},
  {1, 8},
  {18, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {7, 2},
  {1, 7},
  {5, 2},
  {1, 7},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {11, 1},
  {1, 33},
  {1, 29},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {20, 0},                                                /* End of row 119 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {1, 41},
  {1, 45},
  {1, 44},
  {2, 4},
  {1, 73},
  {1, 64},
  {1, 18},
  {1, 8},
  {17, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {18, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {12, 1},
  {1, 31},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {20, 0},                                                /* End of row 120 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {1, 5},
  {1, 41},
  {1, 45},
  {1, 44},
  {1, 4},
  {1, 30},
  {1, 139},
  {1, 17},
  {1, 18},
  {1, 8},
  {17, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {20, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {12, 1},
  {1, 8},
  {1, 154},
  {1, 106},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {19, 0},                                                /* End of row 121 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {2, 5},
  {1, 41},
  {1, 45},
  {1, 44},
  {1, 30},
  {2, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {16, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {16, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {11, 1},
  {1, 8},
  {1, 22},
  {1, 137},
  {1, 116},
  {1, 11},
  {2, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {19, 0},                                                /* End of row 122 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {3, 5},
  {1, 41},
  {1, 45},
  {1, 155},
  {1, 12},
  {1, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {16, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {18, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {11, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 159},
  {1, 29},
  {3, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {18, 0},                                                /* End of row 123 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {4, 5},
  {1, 41},
  {1, 179},
  {1, 140},
  {2, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {15, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {14, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {10, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {1, 1},
  {1, 171},
  {3, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {18, 0},                                                /* End of row 124 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {5, 5},
  {1, 124},
  {1, 162},
  {3, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {15, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {16, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {10, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {1, 164},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {17, 0},                                                /* End of row 125 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {1, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {14, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {12, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {2, 0},
  {4, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {17, 0},                                                /* End of row 126 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {2, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {14, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {14, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {9, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {4, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {16, 0},                                                /* End of row 127 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {3, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {13, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {10, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {8, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {5, 0},
  {4, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {16, 0},                                                /* End of row 128 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {4, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {13, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {12, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {8, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {7, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {7, 5},
  {15, 0},                                                /* End of row 129 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {5, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {12, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {8, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {7, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {8, 0},
  {4, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 35},
  {1, 37},
  {6, 5},
  {15, 0},                                                /* End of row 130 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {6, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {12, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {10, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {7, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {10, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 61},
  {7, 5},
  {14, 0},                                                /* End of row 131 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {7, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {11, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {6, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {6, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {11, 0},
  {4, 3},
  {1, 10},
  {6, 2},
  {1, 7},
  {1, 53},
  {4, 3},
  {1, 36},
  {7, 5},
  {14, 0},                                                /* End of row 132 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {8, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {11, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {6, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {13, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {5, 2},
  {1, 9},
  {4, 3},
  {1, 36},
  {7, 5},
  {14, 0},                                                /* End of row 133 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {9, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {10, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 9},
  {1, 7},
  {4, 2},
  {1, 7},
  {1, 9},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {5, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {14, 0},
  {4, 3},
  {1, 10},
  {5, 2},
  {1, 7},
  {1, 53},
  {3, 3},
  {1, 94},
  {1, 169},
  {8, 5},
  {13, 0},                                                /* End of row 134 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {10, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {10, 1},
  {1, 31},
  {1, 11},
  {3, 3},
  {1, 6},
  {1, 92},
  {1, 7},
  {2, 2},
  {1, 7},
  {1, 92},
  {1, 6},
  {3, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {5, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {16, 0},
  {4, 3},
  {1, 9},
  {1, 7},
  {2, 2},
  {1, 7},
  {1, 2},
  {1, 10},
  {3, 3},
  {1, 35},
  {1, 52},
  {8, 5},
  {13, 0},                                                /* End of row 135 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {11, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {9, 1},
  {1, 33},
  {1, 29},
  {4, 3},
  {1, 6},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 6},
  {4, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {4, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {17, 0},
  {4, 3},
  {1, 6},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 10},
  {3, 3},
  {1, 11},
  {1, 36},
  {9, 5},
  {13, 0},                                                /* End of row 136 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {12, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {9, 1},
  {1, 31},
  {1, 11},
  {5, 3},
  {2, 6},
  {5, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {4, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {19, 0},
  {5, 3},
  {2, 6},
  {5, 3},
  {1, 35},
  {1, 37},
  {9, 5},
  {13, 0},                                                /* End of row 137 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {13, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {8, 1},
  {1, 33},
  {1, 29},
  {12, 3},
  {1, 14},
  {1, 16},
  {6, 4},
  {1, 28},
  {1, 8},
  {3, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {20, 0},
  {11, 3},
  {1, 58},
  {1, 97},
  {9, 5},
  {14, 0},                                                /* End of row 138 */
  {18, 0},
  {3, 3},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 3},
  {1, 38},
  {1, 39},
  {6, 5},
  {14, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {8, 1},
  {1, 31},
  {1, 11},
  {10, 3},
  {1, 11},
  {1, 15},
  {6, 4},
  {1, 26},
  {1, 27},
  {3, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {22, 0},
  {9, 3},
  {1, 58},
  {1, 97},
  {10, 5},
  {14, 0},                                                /* End of row 139 */
  {18, 0},
  {3, 3},
  {1, 6},
  {2, 2},
  {1, 7},
  {5, 2},
  {1, 113},
  {2, 38},
  {1, 109},
  {1, 52},
  {6, 5},
  {15, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {7, 1},
  {1, 49},
  {1, 71},
  {1, 11},
  {8, 3},
  {1, 11},
  {1, 119},
  {1, 89},
  {6, 4},
  {1, 28},
  {1, 8},
  {2, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {23, 0},
  {6, 3},
  {1, 11},
  {1, 58},
  {1, 117},
  {1, 170},
  {10, 5},
  {15, 0},                                                /* End of row 140 */
  {25, 0},
  {1, 126},
  {4, 62},
  {3, 39},
  {1, 52},
  {7, 5},
  {16, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {7, 1},
  {1, 49},
  {1, 31},
  {1, 29},
  {1, 11},
  {4, 3},
  {1, 11},
  {1, 14},
  {1, 15},
  {1, 89},
  {6, 4},
  {1, 26},
  {1, 27},
  {2, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {27, 0},
  {2, 3},
  {1, 118},
  {1, 61},
  {1, 37},
  {1, 125},
  {11, 5},
  {15, 0},                                                /* End of row 141 */
  {25, 0},
  {16, 5},
  {17, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {8, 1},
  {1, 33},
  {1, 31},
  {1, 105},
  {1, 70},
  {1, 19},
  {1, 132},
  {1, 15},
  {1, 16},
  {7, 4},
  {1, 65},
  {1, 84},
  {1, 8},
  {1, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {30, 0},
  {14, 5},
  {16, 0},                                                /* End of row 142 */
  {25, 0},
  {16, 5},
  {18, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {9, 1},
  {1, 144},
  {1, 194},
  {1, 198},
  {1, 180},
  {7, 4},
  {1, 73},
  {1, 91},
  {1, 99},
  {1, 8},
  {1, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {32, 0},
  {12, 5},
  {17, 0},                                                /* End of row 143 */
  {25, 0},
  {16, 5},
  {19, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 27},
  {1, 28},
  {1, 26},
  {5, 30},
  {1, 91},
  {1, 99},
  {1, 72},
  {2, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {34, 0},
  {10, 5},
  {18, 0},                                                /* End of row 144 */
  {25, 0},
  {16, 5},
  {20, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {10, 1},
  {1, 8},
  {6, 12},
  {1, 72},
  {3, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {35, 0},
  {9, 5},
  {19, 0},                                                /* End of row 145 */
  {25, 0},
  {16, 5},
  {21, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {19, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {64, 0},                                                /* End of row 146 */
  {25, 0},
  {16, 5},
  {22, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {17, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {65, 0},                                                /* End of row 147 */
  {64, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {15, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {66, 0},                                                /* End of row 148 */
  {65, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {13, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {67, 0},                                                /* End of row 149 */
  {66, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {11, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {68, 0},                                                /* End of row 150 */
  {67, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {9, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {69, 0},                                                /* End of row 151 */
  {68, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {7, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {70, 0},                                                /* End of row 152 */
  {69, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {5, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {71, 0},                                                /* End of row 153 */
  {70, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {3, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {72, 0},                                                /* End of row 154 */
  {71, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {1, 1},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {73, 0},                                                /* End of row 155 */
  {72, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 18},
  {1, 8},
  {1, 22},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {74, 0},                                                /* End of row 156 */
  {73, 0},
  {4, 1},
  {1, 12},
  {1, 17},
  {1, 100},
  {1, 21},
  {1, 23},
  {1, 13},
  {2, 1},
  {75, 0},                                                /* End of row 157 */
  {74, 0},
  {4, 1},
  {1, 47},
  {1, 135},
  {1, 23},
  {1, 13},
  {2, 1},
  {76, 0},                                                /* End of row 158 */
  {75, 0},
  {3, 1},
  {1, 141},
  {1, 128},
  {1, 13},
  {2, 1},
  {77, 0},                                                /* End of row 159 */
  {76, 0},
  {6, 1},
  {78, 0},                                                /* End of row 160 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_BPP24 */

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_GREY
static const struct splscr_bitmap_s bitmap[] =
{
  {76, 0},
  {1, 154},
  {1, 141},
  {1, 71},
  {5, 74},
  {76, 0},                                                /* End of row   1 */
  {75, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {2, 75},
  {4, 74},
  {75, 0},                                                /* End of row   2 */
  {74, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 41},
  {1, 51},
  {1, 75},
  {4, 74},
  {74, 0},                                                /* End of row   3 */
  {73, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 92},
  {1, 53},
  {1, 75},
  {4, 74},
  {73, 0},                                                /* End of row   4 */
  {72, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {72, 0},                                                /* End of row   5 */
  {71, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {71, 0},                                                /* End of row   6 */
  {70, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {4, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {70, 0},                                                /* End of row   7 */
  {69, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {6, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {69, 0},                                                /* End of row   8 */
  {68, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {8, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {68, 0},                                                /* End of row   9 */
  {67, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {10, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {67, 0},                                                /* End of row  10 */
  {66, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {12, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {66, 0},                                                /* End of row  11 */
  {65, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {14, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {65, 0},                                                /* End of row  12 */
  {64, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {16, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {64, 0},                                                /* End of row  13 */
  {63, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {18, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {63, 0},                                                /* End of row  14 */
  {62, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {20, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {62, 0},                                                /* End of row  15 */
  {61, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {22, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {61, 0},                                                /* End of row  16 */
  {60, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {24, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {60, 0},                                                /* End of row  17 */
  {59, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {26, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {59, 0},                                                /* End of row  18 */
  {58, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {28, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {26, 0},
  {7, 222},
  {25, 0},                                                /* End of row  19 */
  {57, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {10, 74},
  {1, 64},
  {3, 65},
  {1, 64},
  {15, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {23, 0},
  {11, 222},
  {23, 0},                                                /* End of row  20 */
  {56, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {9, 74},
  {1, 64},
  {1, 148},
  {1, 237},
  {3, 231},
  {1, 237},
  {1, 148},
  {1, 59},
  {14, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {22, 0},
  {12, 222},
  {22, 0},                                                /* End of row  21 */
  {23, 0},
  {7, 222},
  {25, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {9, 74},
  {1, 64},
  {1, 195},
  {1, 221},
  {5, 222},
  {1, 221},
  {1, 237},
  {1, 101},
  {14, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {20, 0},
  {14, 222},
  {21, 0},                                                /* End of row  22 */
  {21, 0},
  {11, 222},
  {22, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {9, 74},
  {1, 64},
  {1, 195},
  {1, 221},
  {8, 222},
  {1, 231},
  {1, 101},
  {1, 76},
  {3, 75},
  {1, 73},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {19, 0},
  {14, 222},
  {21, 0},                                                /* End of row  23 */
  {21, 0},
  {12, 222},
  {20, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {10, 74},
  {1, 148},
  {1, 221},
  {10, 222},
  {1, 233},
  {1, 79},
  {2, 49},
  {1, 48},
  {1, 62},
  {1, 75},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {17, 0},
  {6, 222},
  {1, 220},
  {2, 229},
  {1, 220},
  {5, 222},
  {1, 221},
  {20, 0},                                                /* End of row  24 */
  {20, 0},
  {13, 222},
  {1, 157},
  {5, 137},
  {13, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {10, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {3, 220},
  {5, 222},
  {1, 240},
  {1, 32},
  {3, 51},
  {1, 55},
  {1, 75},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {16, 0},
  {5, 222},
  {1, 228},
  {4, 255},
  {1, 228},
  {4, 222},
  {1, 228},
  {1, 128},
  {1, 137},
  {18, 0},                                                /* End of row  25 */
  {19, 0},
  {14, 222},
  {1, 230},
  {1, 128},
  {5, 137},
  {11, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {11, 74},
  {1, 153},
  {1, 221},
  {3, 222},
  {1, 229},
  {3, 255},
  {1, 228},
  {4, 222},
  {1, 221},
  {1, 136},
  {4, 51},
  {1, 55},
  {1, 75},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {14, 0},
  {5, 222},
  {1, 219},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 182},
  {2, 137},
  {17, 0},                                                /* End of row  26 */
  {19, 0},
  {5, 222},
  {1, 219},
  {2, 239},
  {1, 229},
  {5, 222},
  {1, 221},
  {1, 179},
  {6, 137},
  {9, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {11, 74},
  {1, 69},
  {1, 189},
  {3, 222},
  {1, 221},
  {1, 247},
  {4, 255},
  {1, 228},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 55},
  {1, 75},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {13, 0},
  {5, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 179},
  {3, 137},
  {16, 0},                                                /* End of row  27 */
  {18, 0},
  {5, 222},
  {1, 228},
  {1, 255},
  {1, 254},
  {2, 255},
  {1, 229},
  {5, 222},
  {1, 230},
  {1, 128},
  {5, 137},
  {8, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {12, 74},
  {1, 65},
  {1, 231},
  {3, 222},
  {1, 229},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {11, 0},
  {5, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 179},
  {3, 137},
  {16, 0},                                                /* End of row  28 */
  {18, 0},
  {4, 222},
  {1, 219},
  {5, 255},
  {1, 247},
  {1, 220},
  {4, 222},
  {1, 221},
  {1, 179},
  {6, 137},
  {6, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {13, 74},
  {1, 65},
  {1, 231},
  {3, 222},
  {1, 237},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {10, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {10, 0},
  {5, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 182},
  {4, 137},
  {15, 0},                                                /* End of row  29 */
  {18, 0},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 230},
  {1, 128},
  {5, 137},
  {5, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {14, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {10, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {8, 0},
  {5, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {4, 137},
  {15, 0},                                                /* End of row  30 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 179},
  {6, 137},
  {3, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {15, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {11, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {7, 0},
  {5, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {6, 137},
  {14, 0},                                                /* End of row  31 */
  {18, 0},
  {3, 222},
  {1, 220},
  {7, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 230},
  {1, 128},
  {5, 137},
  {2, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {16, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {9, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {11, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {5, 0},
  {5, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {14, 0},                                                /* End of row  32 */
  {18, 0},
  {3, 222},
  {1, 220},
  {9, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 179},
  {6, 137},
  {1, 153},
  {1, 142},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {17, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {12, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {4, 0},
  {5, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {14, 0},                                                /* End of row  33 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 230},
  {1, 128},
  {3, 137},
  {1, 136},
  {1, 114},
  {1, 146},
  {1, 68},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {18, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {10, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {12, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {2, 0},
  {5, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {15, 0},                                                /* End of row  34 */
  {18, 0},
  {3, 222},
  {1, 220},
  {10, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 179},
  {2, 137},
  {1, 136},
  {1, 121},
  {1, 45},
  {1, 59},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {19, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {9, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {13, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {4, 74},
  {1, 0},
  {5, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 225},
  {1, 152},
  {7, 137},
  {15, 0},                                                /* End of row  35 */
  {18, 0},
  {3, 222},
  {1, 220},
  {9, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 230},
  {1, 128},
  {1, 136},
  {1, 121},
  {1, 44},
  {1, 51},
  {1, 48},
  {1, 72},
  {1, 67},
  {1, 148},
  {1, 68},
  {20, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {11, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {13, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {1, 172},
  {4, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 130},
  {6, 137},
  {16, 0},                                                /* End of row  36 */
  {18, 0},
  {3, 222},
  {1, 220},
  {11, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 179},
  {1, 121},
  {1, 44},
  {3, 51},
  {1, 42},
  {1, 151},
  {1, 68},
  {21, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {10, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {14, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {1, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {16, 0},                                                /* End of row  37 */
  {18, 0},
  {3, 222},
  {1, 220},
  {10, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 237},
  {1, 30},
  {4, 51},
  {1, 50},
  {1, 66},
  {22, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {12, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {14, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 76},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {17, 0},                                                /* End of row  38 */
  {18, 0},
  {3, 222},
  {1, 220},
  {12, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 63},
  {1, 73},
  {21, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {11, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {15, 74},
  {1, 73},
  {1, 70},
  {1, 37},
  {1, 238},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {17, 0},                                                /* End of row  39 */
  {18, 0},
  {3, 222},
  {1, 220},
  {11, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {21, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {13, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {16, 74},
  {1, 150},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {18, 0},                                                /* End of row  40 */
  {18, 0},
  {3, 222},
  {1, 220},
  {13, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {20, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {12, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {15, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {18, 0},                                                /* End of row  41 */
  {18, 0},
  {3, 222},
  {1, 220},
  {12, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {20, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {14, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {14, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {19, 0},                                                /* End of row  42 */
  {18, 0},
  {3, 222},
  {1, 220},
  {14, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {19, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {6, 255},
  {1, 254},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {13, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {19, 0},                                                /* End of row  43 */
  {18, 0},
  {3, 222},
  {1, 220},
  {13, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {19, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 236},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {12, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {20, 0},                                                /* End of row  44 */
  {18, 0},
  {3, 222},
  {1, 220},
  {7, 255},
  {1, 254},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {18, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 216},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {11, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {20, 0},                                                /* End of row  45 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 236},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {18, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {10, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {21, 0},                                                /* End of row  46 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 216},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {17, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {9, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {21, 0},                                                /* End of row  47 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {17, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {1, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {8, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {22, 0},                                                /* End of row  48 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {16, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {1, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {7, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 185},
  {1, 136},
  {6, 137},
  {22, 0},                                                /* End of row  49 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {1, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {16, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {6, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 27},
  {1, 121},
  {1, 136},
  {4, 137},
  {23, 0},                                                /* End of row  50 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {1, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {15, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {5, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {1, 51},
  {1, 44},
  {1, 121},
  {1, 136},
  {3, 137},
  {23, 0},                                                /* End of row  51 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {15, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {4, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {2, 51},
  {1, 44},
  {1, 121},
  {1, 136},
  {1, 137},
  {24, 0},                                                /* End of row  52 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {14, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {3, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {4, 51},
  {1, 44},
  {1, 120},
  {1, 136},
  {24, 0},                                                /* End of row  53 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {3, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {14, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {2, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 21},
  {24, 0},                                                /* End of row  54 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {13, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {4, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {1, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 47},
  {1, 76},
  {1, 74},
  {23, 0},                                                /* End of row  55 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {13, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {5, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 49},
  {1, 78},
  {1, 73},
  {2, 74},
  {22, 0},                                                /* End of row  56 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {4, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {12, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {5, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 61},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 56},
  {1, 53},
  {1, 75},
  {3, 74},
  {21, 0},                                                /* End of row  57 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {5, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {12, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {6, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 135},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {20, 0},                                                /* End of row  58 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {5, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {11, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {6, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {3, 51},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {2, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {19, 0},                                                /* End of row  59 */
  {17, 0},
  {1, 132},
  {1, 224},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {6, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {11, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {7, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {3, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {2, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {18, 0},                                                /* End of row  60 */
  {16, 0},
  {1, 154},
  {1, 133},
  {1, 229},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {6, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {10, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 221},
  {1, 228},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {1, 51},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {3, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {17, 0},                                                /* End of row  61 */
  {15, 0},
  {1, 154},
  {1, 142},
  {1, 59},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {7, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {10, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 233},
  {1, 126},
  {1, 221},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {1, 52},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {5, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {16, 0},                                                /* End of row  62 */
  {14, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {7, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {9, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 22},
  {1, 240},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 15},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {6, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {15, 0},                                                /* End of row  63 */
  {13, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 40},
  {1, 233},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 221},
  {1, 228},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {9, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 234},
  {1, 221},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {8, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {14, 0},                                                /* End of row  64 */
  {12, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 135},
  {1, 225},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 233},
  {1, 126},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {8, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 32},
  {1, 240},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {9, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {13, 0},                                                /* End of row  65 */
  {11, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 79},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 22},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {8, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {7, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {11, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {12, 0},                                                /* End of row  66 */
  {10, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {7, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 51},
  {1, 32},
  {1, 240},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {7, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {12, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {11, 0},                                                /* End of row  67 */
  {9, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {1, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {7, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {2, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {5, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {14, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {10, 0},                                                /* End of row  68 */
  {8, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {2, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {6, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {2, 51},
  {1, 32},
  {1, 240},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {15, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {9, 0},                                                 /* End of row  69 */
  {7, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {3, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 51},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {6, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {3, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {17, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {8, 0},                                                 /* End of row  70 */
  {6, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {4, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {2, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {5, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {3, 51},
  {1, 32},
  {1, 240},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {18, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {7, 0},                                                 /* End of row  71 */
  {5, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {5, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {2, 51},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {5, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {4, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {1, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {20, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {6, 0},                                                 /* End of row  72 */
  {4, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {6, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {3, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {4, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {4, 51},
  {1, 32},
  {1, 240},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {1, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {21, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {5, 0},                                                 /* End of row  73 */
  {3, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {7, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {3, 51},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {4, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 215},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {23, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {4, 0},                                                 /* End of row  74 */
  {2, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {8, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {4, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {3, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 33},
  {1, 238},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 255},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {24, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {3, 0},                                                 /* End of row  75 */
  {1, 0},
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {9, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {4, 51},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {3, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 150},
  {1, 221},
  {3, 222},
  {1, 239},
  {1, 254},
  {11, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {26, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {2, 0},                                                 /* End of row  76 */
  {1, 154},
  {1, 142},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {10, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {2, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 61},
  {1, 237},
  {3, 222},
  {1, 219},
  {13, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {27, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},
  {1, 0},                                                 /* End of row  77 */
  {1, 141},
  {1, 68},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {11, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 33},
  {1, 238},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {2, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 76},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 239},
  {1, 254},
  {9, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {29, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {3, 74},                                                /* End of row  78 */
  {1, 71},
  {1, 75},
  {1, 48},
  {1, 142},
  {1, 88},
  {12, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 150},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {1, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {1, 59},
  {1, 237},
  {3, 222},
  {1, 219},
  {11, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {30, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 75},
  {2, 74},                                                /* End of row  79 */
  {1, 74},
  {1, 60},
  {1, 113},
  {1, 88},
  {13, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 61},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {1, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {1, 74},
  {1, 143},
  {4, 222},
  {1, 239},
  {1, 254},
  {8, 255},
  {1, 237},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 48},
  {1, 76},
  {32, 74},
  {1, 73},
  {1, 70},
  {1, 53},
  {1, 76},
  {1, 73},                                                /* End of row  80 */
  {1, 74},
  {1, 75},
  {1, 50},
  {1, 70},
  {1, 73},
  {12, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 76},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 73},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {1, 74},
  {1, 143},
  {4, 222},
  {1, 218},
  {9, 255},
  {1, 229},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 62},
  {1, 73},
  {33, 74},
  {1, 73},
  {1, 64},
  {1, 40},
  {1, 76},                                                /* End of row  81 */
  {2, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {11, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 76},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {7, 255},
  {1, 246},
  {1, 221},
  {3, 222},
  {1, 234},
  {1, 28},
  {5, 51},
  {1, 49},
  {1, 76},
  {33, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 151},
  {1, 71},                                                /* End of row  82 */
  {3, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {10, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {1, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 62},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 76},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {10, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 49},
  {1, 76},
  {32, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {1, 74},                                                /* End of row  83 */
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {9, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {1, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 48},
  {1, 67},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 61},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {8, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {1, 73},
  {30, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},                                                /* End of row  84 */
  {1, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {8, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {2, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 53},
  {1, 231},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 150},
  {1, 221},
  {3, 222},
  {1, 219},
  {12, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {29, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {1, 0},                                                 /* End of row  85 */
  {2, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {7, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {2, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 39},
  {1, 233},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 33},
  {1, 238},
  {4, 222},
  {1, 239},
  {1, 254},
  {10, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {1, 73},
  {27, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {2, 0},                                                 /* End of row  86 */
  {3, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {6, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {3, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {4, 51},
  {1, 40},
  {1, 232},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {14, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {26, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {3, 0},                                                 /* End of row  87 */
  {4, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {5, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {3, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {3, 51},
  {1, 40},
  {1, 232},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {4, 51},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {12, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {1, 73},
  {24, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {4, 0},                                                 /* End of row  88 */
  {5, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {4, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {4, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {3, 51},
  {1, 40},
  {1, 232},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {4, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {9, 255},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {23, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {5, 0},                                                 /* End of row  89 */
  {6, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {3, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {4, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {2, 51},
  {1, 40},
  {1, 232},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {3, 51},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {1, 218},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {1, 73},
  {21, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {6, 0},                                                 /* End of row  90 */
  {7, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {2, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {5, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {2, 51},
  {1, 40},
  {1, 232},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {3, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {1, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {20, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {7, 0},                                                 /* End of row  91 */
  {8, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {1, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {5, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {1, 51},
  {1, 40},
  {1, 232},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {2, 51},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {1, 73},
  {18, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {8, 0},                                                 /* End of row  92 */
  {9, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {6, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {1, 51},
  {1, 40},
  {1, 232},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {2, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {17, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {9, 0},                                                 /* End of row  93 */
  {10, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {6, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 32},
  {1, 40},
  {1, 232},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 51},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {1, 73},
  {15, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {10, 0},                                                /* End of row  94 */
  {11, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 60},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {7, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 136},
  {1, 40},
  {1, 232},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 51},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {5, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {14, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {11, 0},                                                /* End of row  95 */
  {12, 0},
  {4, 74},
  {1, 75},
  {1, 43},
  {1, 233},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {7, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 240},
  {1, 22},
  {1, 232},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 32},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {6, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {1, 73},
  {12, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {12, 0},                                                /* End of row  96 */
  {13, 0},
  {4, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {8, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 221},
  {1, 126},
  {1, 233},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {1, 136},
  {1, 221},
  {3, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {7, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {11, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {13, 0},                                                /* End of row  97 */
  {14, 0},
  {3, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {8, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 228},
  {1, 221},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 22},
  {1, 240},
  {4, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 228},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {1, 73},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {14, 0},                                                /* End of row  98 */
  {15, 0},
  {2, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {9, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {8, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 233},
  {1, 126},
  {1, 221},
  {3, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 125},
  {1, 240},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {8, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {15, 0},                                                /* End of row  99 */
  {16, 0},
  {1, 74},
  {1, 65},
  {1, 231},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {9, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {8, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 221},
  {1, 228},
  {4, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 33},
  {1, 136},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {1, 73},
  {6, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {16, 0},                                                /* End of row 100 */
  {17, 0},
  {1, 28},
  {1, 226},
  {2, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {10, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {7, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {7, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {1, 51},
  {1, 32},
  {1, 240},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {5, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {17, 0},                                                /* End of row 101 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {10, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {7, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {7, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {2, 51},
  {1, 136},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {1, 73},
  {3, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {18, 0},                                                /* End of row 102 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {11, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {6, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {6, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {3, 51},
  {1, 32},
  {1, 240},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {2, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {19, 0},                                                /* End of row 103 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {11, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {6, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {6, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {4, 51},
  {1, 136},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 62},
  {2, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {20, 0},                                                /* End of row 104 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {12, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {5, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {5, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 32},
  {1, 240},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 48},
  {1, 76},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {21, 0},                                                /* End of row 105 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {12, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {5, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {5, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 135},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 56},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {22, 0},                                                /* End of row 106 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {13, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {4, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {4, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 61},
  {1, 237},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {5, 51},
  {1, 47},
  {1, 119},
  {1, 68},
  {2, 74},
  {23, 0},                                                /* End of row 107 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {13, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {4, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 74},
  {1, 148},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {5, 51},
  {1, 45},
  {1, 76},
  {1, 74},
  {24, 0},                                                /* End of row 108 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {14, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {3, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {3, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {1, 74},
  {1, 59},
  {1, 237},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {4, 51},
  {1, 44},
  {1, 123},
  {1, 99},
  {1, 105},
  {24, 0},                                                /* End of row 109 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {14, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {3, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {3, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {2, 74},
  {1, 148},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {2, 51},
  {1, 44},
  {1, 121},
  {1, 136},
  {1, 137},
  {25, 0},                                                /* End of row 110 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {15, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {3, 74},
  {1, 59},
  {1, 237},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {1, 51},
  {1, 44},
  {1, 121},
  {1, 136},
  {3, 137},
  {24, 0},                                                /* End of row 111 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {15, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {2, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {2, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {4, 74},
  {1, 148},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 27},
  {1, 121},
  {1, 136},
  {4, 137},
  {24, 0},                                                /* End of row 112 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {16, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {1, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {1, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {5, 74},
  {1, 59},
  {1, 237},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 185},
  {1, 136},
  {6, 137},
  {23, 0},                                                /* End of row 113 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {16, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {1, 222},
  {1, 220},
  {7, 255},
  {1, 220},
  {1, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {6, 74},
  {1, 148},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {23, 0},                                                /* End of row 114 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {17, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 219},
  {1, 220},
  {7, 255},
  {1, 220},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {7, 74},
  {1, 59},
  {1, 237},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {22, 0},                                                /* End of row 115 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 232},
  {1, 40},
  {5, 51},
  {1, 49},
  {1, 75},
  {17, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {1, 220},
  {7, 255},
  {1, 220},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {8, 74},
  {1, 148},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {22, 0},                                                /* End of row 116 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 233},
  {1, 37},
  {5, 51},
  {1, 49},
  {1, 75},
  {18, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 216},
  {7, 255},
  {1, 216},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {9, 74},
  {1, 59},
  {1, 237},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {21, 0},                                                /* End of row 117 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 115},
  {1, 44},
  {4, 51},
  {1, 49},
  {1, 75},
  {18, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 236},
  {7, 255},
  {1, 236},
  {1, 254},
  {5, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {10, 74},
  {1, 148},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {21, 0},                                                /* End of row 118 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 130},
  {1, 121},
  {1, 44},
  {3, 51},
  {1, 49},
  {1, 69},
  {1, 73},
  {18, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {7, 255},
  {1, 254},
  {5, 255},
  {1, 254},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {11, 74},
  {1, 59},
  {1, 237},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {20, 0},                                                /* End of row 119 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {1, 136},
  {1, 121},
  {1, 44},
  {2, 51},
  {1, 49},
  {1, 55},
  {1, 70},
  {1, 73},
  {17, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {18, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {12, 74},
  {1, 148},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {20, 0},                                                /* End of row 120 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {1, 137},
  {1, 136},
  {1, 121},
  {1, 44},
  {1, 51},
  {1, 49},
  {1, 77},
  {1, 53},
  {1, 70},
  {1, 73},
  {17, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {20, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {12, 74},
  {1, 73},
  {1, 53},
  {1, 235},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {19, 0},                                                /* End of row 121 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {2, 137},
  {1, 136},
  {1, 121},
  {1, 44},
  {1, 49},
  {2, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {16, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {16, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {11, 74},
  {1, 73},
  {1, 70},
  {1, 68},
  {1, 198},
  {1, 221},
  {2, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {19, 0},                                                /* End of row 122 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {3, 137},
  {1, 136},
  {1, 121},
  {1, 43},
  {1, 75},
  {1, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {16, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {18, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {11, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 53},
  {1, 237},
  {3, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {18, 0},                                                /* End of row 123 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {4, 137},
  {1, 136},
  {1, 119},
  {1, 73},
  {2, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {15, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {14, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {10, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {1, 74},
  {1, 170},
  {3, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {18, 0},                                                /* End of row 124 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {5, 137},
  {1, 136},
  {1, 41},
  {3, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {15, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {16, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {10, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {1, 219},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {17, 0},                                                /* End of row 125 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {1, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {14, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {12, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {2, 0},
  {4, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {17, 0},                                                /* End of row 126 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {2, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {14, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {14, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {4, 0},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {16, 0},                                                /* End of row 127 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {3, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {13, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {10, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {8, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {5, 0},
  {4, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {16, 0},                                                /* End of row 128 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {4, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {13, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {12, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {8, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {7, 0},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {7, 137},
  {15, 0},                                                /* End of row 129 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {5, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {12, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {8, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {7, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {8, 0},
  {4, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 230},
  {1, 128},
  {6, 137},
  {15, 0},                                                /* End of row 130 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {6, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {12, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {10, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {7, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {10, 0},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 182},
  {7, 137},
  {14, 0},                                                /* End of row 131 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {7, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {11, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {6, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {11, 0},
  {4, 222},
  {1, 219},
  {6, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 179},
  {7, 137},
  {14, 0},                                                /* End of row 132 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {8, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {11, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 219},
  {8, 255},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {6, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {13, 0},
  {4, 222},
  {1, 239},
  {1, 254},
  {5, 255},
  {1, 239},
  {4, 222},
  {1, 179},
  {7, 137},
  {14, 0},                                                /* End of row 133 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {9, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {10, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 239},
  {1, 254},
  {4, 255},
  {1, 254},
  {1, 239},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {5, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {14, 0},
  {4, 222},
  {1, 219},
  {5, 255},
  {1, 254},
  {1, 239},
  {3, 222},
  {1, 225},
  {1, 155},
  {8, 137},
  {13, 0},                                                /* End of row 134 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {10, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {10, 74},
  {1, 148},
  {1, 221},
  {3, 222},
  {1, 220},
  {1, 248},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 248},
  {1, 220},
  {3, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {5, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {16, 0},
  {4, 222},
  {1, 239},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 255},
  {1, 219},
  {3, 222},
  {1, 230},
  {1, 130},
  {8, 137},
  {13, 0},                                                /* End of row 135 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {11, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {9, 74},
  {1, 59},
  {1, 237},
  {4, 222},
  {1, 220},
  {1, 239},
  {2, 255},
  {1, 239},
  {1, 220},
  {4, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {4, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {17, 0},
  {4, 222},
  {1, 220},
  {1, 239},
  {2, 255},
  {1, 239},
  {1, 219},
  {3, 222},
  {1, 221},
  {1, 179},
  {9, 137},
  {13, 0},                                                /* End of row 136 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {12, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {9, 74},
  {1, 148},
  {1, 221},
  {5, 222},
  {2, 220},
  {5, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {4, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {19, 0},
  {5, 222},
  {2, 220},
  {5, 222},
  {1, 230},
  {1, 128},
  {9, 137},
  {13, 0},                                                /* End of row 137 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {13, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {8, 74},
  {1, 59},
  {1, 237},
  {12, 222},
  {1, 240},
  {1, 32},
  {6, 51},
  {1, 62},
  {1, 73},
  {3, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {20, 0},
  {11, 222},
  {1, 228},
  {1, 151},
  {9, 137},
  {14, 0},                                                /* End of row 138 */
  {18, 0},
  {3, 222},
  {1, 220},
  {8, 255},
  {1, 220},
  {2, 222},
  {1, 227},
  {1, 131},
  {6, 137},
  {14, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {8, 74},
  {1, 148},
  {1, 221},
  {10, 222},
  {1, 221},
  {1, 136},
  {6, 51},
  {1, 48},
  {1, 76},
  {3, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {22, 0},
  {9, 222},
  {1, 228},
  {1, 151},
  {10, 137},
  {14, 0},                                                /* End of row 139 */
  {18, 0},
  {3, 222},
  {1, 220},
  {2, 255},
  {1, 254},
  {5, 255},
  {1, 225},
  {2, 227},
  {1, 232},
  {1, 130},
  {6, 137},
  {15, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {7, 74},
  {1, 64},
  {1, 195},
  {1, 221},
  {8, 222},
  {1, 221},
  {1, 191},
  {1, 39},
  {6, 51},
  {1, 62},
  {1, 73},
  {2, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {23, 0},
  {6, 222},
  {1, 221},
  {1, 228},
  {1, 203},
  {1, 154},
  {10, 137},
  {15, 0},                                                /* End of row 140 */
  {25, 0},
  {5, 129},
  {3, 131},
  {1, 130},
  {7, 137},
  {16, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {7, 74},
  {1, 64},
  {1, 148},
  {1, 237},
  {1, 221},
  {4, 222},
  {1, 221},
  {1, 240},
  {1, 136},
  {1, 39},
  {6, 51},
  {1, 48},
  {1, 76},
  {2, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {27, 0},
  {2, 222},
  {1, 193},
  {1, 182},
  {1, 128},
  {1, 133},
  {11, 137},
  {15, 0},                                                /* End of row 141 */
  {25, 0},
  {16, 137},
  {17, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {8, 74},
  {1, 59},
  {1, 148},
  {1, 236},
  {1, 233},
  {1, 232},
  {1, 239},
  {1, 136},
  {1, 32},
  {7, 51},
  {1, 49},
  {1, 69},
  {1, 73},
  {1, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {30, 0},
  {14, 137},
  {16, 0},                                                /* End of row 142 */
  {25, 0},
  {16, 137},
  {18, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {9, 74},
  {1, 65},
  {1, 51},
  {1, 37},
  {1, 39},
  {7, 51},
  {1, 49},
  {1, 55},
  {1, 69},
  {1, 73},
  {1, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {32, 0},
  {12, 137},
  {17, 0},                                                /* End of row 143 */
  {25, 0},
  {16, 137},
  {19, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {9, 74},
  {1, 73},
  {1, 76},
  {1, 62},
  {1, 48},
  {5, 49},
  {1, 55},
  {1, 69},
  {1, 75},
  {2, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {34, 0},
  {10, 137},
  {18, 0},                                                /* End of row 144 */
  {25, 0},
  {16, 137},
  {20, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {10, 74},
  {1, 73},
  {7, 75},
  {3, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {35, 0},
  {9, 137},
  {19, 0},                                                /* End of row 145 */
  {25, 0},
  {16, 137},
  {21, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {19, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {64, 0},                                                /* End of row 146 */
  {25, 0},
  {16, 137},
  {22, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {17, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {65, 0},                                                /* End of row 147 */
  {64, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {15, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {66, 0},                                                /* End of row 148 */
  {65, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {13, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {67, 0},                                                /* End of row 149 */
  {66, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {11, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {68, 0},                                                /* End of row 150 */
  {67, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {9, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {69, 0},                                                /* End of row 151 */
  {68, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {7, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {70, 0},                                                /* End of row 152 */
  {69, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {5, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {71, 0},                                                /* End of row 153 */
  {70, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {3, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {72, 0},                                                /* End of row 154 */
  {71, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {1, 74},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {73, 0},                                                /* End of row 155 */
  {72, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 70},
  {1, 73},
  {1, 70},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {74, 0},                                                /* End of row 156 */
  {73, 0},
  {4, 74},
  {1, 75},
  {1, 53},
  {1, 64},
  {1, 67},
  {1, 148},
  {1, 68},
  {2, 74},
  {75, 0},                                                /* End of row 157 */
  {74, 0},
  {4, 74},
  {1, 76},
  {1, 75},
  {1, 148},
  {1, 68},
  {2, 74},
  {76, 0},                                                /* End of row 158 */
  {75, 0},
  {3, 74},
  {1, 71},
  {1, 123},
  {1, 68},
  {2, 74},
  {77, 0},                                                /* End of row 159 */
  {76, 0},
  {6, 74},
  {78, 0},                                                /* End of row 160 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_GREY */

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_MONO
static const struct splscr_bitmap_s bitmap[] =
{
  {76, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {78, 0},                                                /* End of row   1 */
  {75, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {76, 0},                                                /* End of row   2 */
  {74, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {74, 0},                                                /* End of row   3 */
  {73, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {75, 0},                                                /* End of row   4 */
  {72, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {73, 0},                                                /* End of row   5 */
  {71, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {71, 0},                                                /* End of row   6 */
  {70, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {74, 0},                                                /* End of row   7 */
  {69, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {69, 0},                                                /* End of row   8 */
  {68, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {77, 0},                                                /* End of row   9 */
  {67, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {67, 0},                                                /* End of row  10 */
  {66, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {70, 0},                                                /* End of row  11 */
  {65, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {66, 0},                                                /* End of row  12 */
  {64, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {65, 0},                                                /* End of row  13 */
  {63, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {66, 0},                                                /* End of row  14 */
  {62, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {62, 0},                                                /* End of row  15 */
  {61, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {66, 0},                                                /* End of row  16 */
  {60, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {60, 0},                                                /* End of row  17 */
  {59, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {65, 0},                                                /* End of row  18 */
  {58, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {27, 0},
  {7, 255},
  {25, 0},                                                /* End of row  19 */
  {57, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {23, 0},
  {11, 255},
  {23, 0},                                                /* End of row  20 */
  {56, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {7, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {24, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {22, 0},                                                /* End of row  21 */
  {23, 0},
  {7, 255},
  {25, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {21, 0},
  {9, 255},
  {1, 0},
  {4, 255},
  {21, 0},                                                /* End of row  22 */
  {21, 0},
  {11, 255},
  {22, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {19, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {21, 0},                                                /* End of row  23 */
  {21, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {20, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {20, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {20, 0},                                                /* End of row  24 */
  {20, 0},
  {9, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {13, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {14, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {17, 0},
  {4, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {1, 255},
  {18, 0},                                                /* End of row  25 */
  {19, 0},
  {3, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {15, 0},
  {2, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {17, 0},                                                /* End of row  26 */
  {19, 0},
  {6, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {1, 0},
  {5, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {14, 0},
  {17, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {16, 0},                                                /* End of row  27 */
  {18, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {17, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {5, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {17, 0},                                                /* End of row  28 */
  {18, 0},
  {14, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {2, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {16, 0},                                                /* End of row  29 */
  {18, 0},
  {4, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {18, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {10, 0},
  {19, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {16, 0},                                                /* End of row  30 */
  {18, 0},
  {2, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {8, 0},
  {4, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {14, 0},                                                /* End of row  31 */
  {18, 0},
  {16, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {15, 0},                                                /* End of row  32 */
  {18, 0},
  {20, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {20, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {18, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},                                                /* End of row  33 */
  {18, 0},
  {2, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {19, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {5, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {15, 0},                                                /* End of row  34 */
  {18, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {4, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {16, 0},                                                /* End of row  35 */
  {18, 0},
  {21, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {17, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {17, 0},                                                /* End of row  36 */
  {18, 0},
  {2, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {17, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {16, 0},                                                /* End of row  37 */
  {18, 0},
  {16, 255},
  {1, 0},
  {5, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {21, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {17, 0},                                                /* End of row  38 */
  {18, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {18, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {17, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {17, 0},                                                /* End of row  39 */
  {18, 0},
  {1, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},                                                /* End of row  40 */
  {18, 0},
  {24, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {19, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {19, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {18, 0},                                                /* End of row  41 */
  {18, 0},
  {19, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {24, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {20, 0},                                                /* End of row  42 */
  {18, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},                                                /* End of row  43 */
  {18, 0},
  {25, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {25, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {14, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {20, 0},                                                /* End of row  44 */
  {18, 0},
  {1, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {21, 0},                                                /* End of row  45 */
  {18, 0},
  {26, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {21, 0},                                                /* End of row  46 */
  {18, 0},
  {21, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {12, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {14, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {22, 0},                                                /* End of row  47 */
  {18, 0},
  {2, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {27, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {22, 0},                                                /* End of row  48 */
  {18, 0},
  {13, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {18, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {22, 0},                                                /* End of row  49 */
  {18, 0},
  {22, 255},
  {1, 0},
  {5, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {23, 0},                                                /* End of row  50 */
  {18, 0},
  {2, 255},
  {1, 0},
  {25, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {23, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {3, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {23, 0},                                                /* End of row  51 */
  {18, 0},
  {13, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {4, 255},
  {10, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {24, 0},                                                /* End of row  52 */
  {18, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {12, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {15, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {25, 0},                                                /* End of row  53 */
  {18, 0},
  {15, 255},
  {1, 0},
  {14, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {29, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {27, 0},                                                /* End of row  54 */
  {18, 0},
  {1, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {2, 255},
  {9, 0},
  {18, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {24, 0},                                                /* End of row  55 */
  {18, 0},
  {28, 255},
  {1, 0},
  {2, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {13, 255},
  {1, 0},
  {18, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {13, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {22, 0},                                                /* End of row  56 */
  {18, 0},
  {3, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {4, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {14, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {24, 0},                                                /* End of row  57 */
  {18, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {5, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {15, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {20, 0},                                                /* End of row  58 */
  {18, 0},
  {29, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {28, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {24, 0},                                                /* End of row  59 */
  {18, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {14, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {3, 255},
  {11, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},                                                /* End of row  60 */
  {16, 0},
  {15, 255},
  {1, 0},
  {20, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {15, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {18, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {18, 0},                                                /* End of row  61 */
  {15, 0},
  {1, 255},
  {2, 0},
  {28, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {15, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {3, 255},
  {6, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {16, 0},                                                /* End of row  62 */
  {14, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {14, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {14, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {18, 0},                                                /* End of row  63 */
  {13, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {21, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {16, 255},
  {2, 0},
  {31, 255},
  {1, 0},
  {4, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {15, 0},                                                /* End of row  64 */
  {12, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {15, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {14, 0},                                                /* End of row  65 */
  {11, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {16, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {17, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {12, 0},                                                /* End of row  66 */
  {10, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {15, 255},
  {3, 0},
  {14, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {13, 0},                                                /* End of row  67 */
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {16, 255},
  {2, 0},
  {13, 255},
  {1, 0},
  {5, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {19, 255},
  {1, 0},
  {13, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {11, 0},                                                /* End of row  68 */
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {14, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {9, 0},                                                 /* End of row  69 */
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {17, 255},
  {3, 0},
  {14, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {12, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {14, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {11, 0},                                                /* End of row  70 */
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {5, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  71 */
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {16, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {19, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {15, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {15, 0},                                                /* End of row  72 */
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {16, 255},
  {5, 0},
  {3, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {6, 0},
  {13, 255},
  {1, 0},
  {13, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},                                                 /* End of row  73 */
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {15, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},                                                /* End of row  74 */
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {5, 0},
  {2, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {7, 0},
  {25, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},                                                 /* End of row  75 */
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {16, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {5, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},                                                 /* End of row  76 */
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {15, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {15, 255},
  {8, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},                                                 /* End of row  77 */
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {16, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {19, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {18, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},                                                 /* End of row  78 */
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {16, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},                                                 /* End of row  79 */
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {19, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {15, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},                                                 /* End of row  80 */
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {17, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {3, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},                                                 /* End of row  81 */
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {14, 255},
  {9, 0},
  {3, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {17, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {2, 255},
  {1, 0},                                                 /* End of row  82 */
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {3, 255},
  {8, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},                                                 /* End of row  83 */
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {8, 0},
  {16, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {15, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {22, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {2, 0},
  {1, 255},                                               /* End of row  84 */
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {12, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {7, 0},
  {4, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},                                                 /* End of row  85 */
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {19, 255},
  {6, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},                                                 /* End of row  86 */
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {16, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {3, 255},
  {1, 0},
  {16, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {15, 255},
  {6, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {6, 0},                                                 /* End of row  87 */
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {13, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {14, 255},
  {1, 0},
  {4, 255},
  {5, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},                                                 /* End of row  88 */
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {5, 0},
  {5, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},                                                 /* End of row  89 */
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {16, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {14, 255},
  {1, 0},
  {4, 255},
  {4, 0},
  {15, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  90 */
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {15, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {10, 0},                                                /* End of row  91 */
  {11, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {16, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {26, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {8, 0},                                                 /* End of row  92 */
  {9, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {16, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {15, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {9, 0},                                                 /* End of row  93 */
  {11, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {17, 255},
  {2, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {15, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {13, 0},                                                /* End of row  94 */
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {15, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {2, 0},
  {29, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {11, 0},                                                /* End of row  95 */
  {12, 0},
  {1, 255},
  {5, 0},
  {16, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {15, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {18, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {15, 0},                                                /* End of row  96 */
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {13, 0},                                                /* End of row  97 */
  {18, 0},
  {16, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {4, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {13, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {17, 0},                                                /* End of row  98 */
  {15, 0},
  {1, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {16, 0},                                                /* End of row  99 */
  {18, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {12, 255},
  {1, 0},
  {4, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},                                                /* End of row 100 */
  {18, 0},
  {16, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {19, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {16, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {17, 0},                                                /* End of row 101 */
  {18, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {17, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {19, 0},                                                /* End of row 102 */
  {18, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {12, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {21, 0},                                                /* End of row 103 */
  {18, 0},
  {16, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {15, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {23, 0},                                                /* End of row 104 */
  {18, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {18, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {21, 0},                                                /* End of row 105 */
  {18, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {16, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {18, 255},
  {7, 0},
  {3, 255},
  {1, 0},
  {14, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {22, 0},                                                /* End of row 106 */
  {18, 0},
  {16, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {13, 255},
  {1, 0},
  {3, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {24, 0},                                                /* End of row 107 */
  {18, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {18, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {15, 255},
  {9, 0},
  {4, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {26, 0},                                                /* End of row 108 */
  {18, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {15, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {24, 0},                                                /* End of row 109 */
  {18, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {37, 255},
  {1, 0},
  {4, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {17, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {25, 0},                                                /* End of row 110 */
  {18, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {12, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {24, 0},                                                /* End of row 111 */
  {18, 0},
  {1, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {3, 255},
  {7, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {25, 0},                                                /* End of row 112 */
  {18, 0},
  {16, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {34, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {18, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {23, 0},                                                /* End of row 113 */
  {18, 0},
  {16, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {4, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {23, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {23, 0},                                                /* End of row 114 */
  {18, 0},
  {3, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {12, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {22, 0},                                                /* End of row 115 */
  {18, 0},
  {16, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {32, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {23, 0},                                                /* End of row 116 */
  {18, 0},
  {1, 255},
  {1, 0},
  {14, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {31, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {21, 0},                                                /* End of row 117 */
  {18, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {8, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {30, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {17, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {22, 0},                                                /* End of row 118 */
  {18, 0},
  {17, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {28, 255},
  {8, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {21, 0},                                                /* End of row 119 */
  {18, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {30, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {20, 0},                                                /* End of row 120 */
  {18, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {4, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {14, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {20, 0},                                                /* End of row 121 */
  {18, 0},
  {16, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {28, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {19, 0},                                                /* End of row 122 */
  {18, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {28, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {12, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},                                                /* End of row 123 */
  {18, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {18, 0},                                                /* End of row 124 */
  {18, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {26, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {19, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {18, 0},                                                /* End of row 125 */
  {18, 0},
  {16, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {17, 0},                                                /* End of row 126 */
  {18, 0},
  {1, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {7, 0},
  {12, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {17, 0},                                                /* End of row 127 */
  {18, 0},
  {17, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {19, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {4, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {17, 0},                                                /* End of row 128 */
  {18, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {10, 0},
  {18, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {15, 0},                                                /* End of row 129 */
  {18, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {15, 0},                                                /* End of row 130 */
  {18, 0},
  {17, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {17, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {10, 0},
  {18, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},                                                /* End of row 131 */
  {18, 0},
  {1, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {20, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {11, 0},
  {3, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},                                                /* End of row 132 */
  {18, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {13, 0},
  {13, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {15, 0},                                                /* End of row 133 */
  {18, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {13, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {14, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {13, 0},                                                /* End of row 134 */
  {18, 0},
  {16, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {11, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {8, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {17, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {14, 0},                                                /* End of row 135 */
  {18, 0},
  {2, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {13, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {18, 0},
  {10, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},                                                /* End of row 136 */
  {18, 0},
  {16, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {17, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {22, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {13, 0},                                                /* End of row 137 */
  {18, 0},
  {16, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {14, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {20, 0},
  {7, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},                                                /* End of row 138 */
  {18, 0},
  {2, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {17, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {22, 0},
  {4, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {15, 0},                                                /* End of row 139 */
  {18, 0},
  {17, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {26, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {16, 0},                                                /* End of row 140 */
  {26, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {16, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {8, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {27, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {15, 0},                                                /* End of row 141 */
  {25, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {20, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {13, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {31, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {17, 0},                                                /* End of row 142 */
  {26, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {18, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {32, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {17, 0},                                                /* End of row 143 */
  {25, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {23, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {13, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {37, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},                                                /* End of row 144 */
  {25, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {20, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {36, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {20, 0},                                                /* End of row 145 */
  {26, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {22, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {64, 0},                                                /* End of row 146 */
  {25, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {24, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {65, 0},                                                /* End of row 147 */
  {72, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {66, 0},                                                /* End of row 148 */
  {65, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {67, 0},                                                /* End of row 149 */
  {68, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {68, 0},                                                /* End of row 150 */
  {69, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {69, 0},                                                /* End of row 151 */
  {70, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {71, 0},                                                /* End of row 152 */
  {69, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {74, 0},                                                /* End of row 153 */
  {71, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {72, 0},                                                /* End of row 154 */
  {73, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {74, 0},                                                /* End of row 155 */
  {74, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {77, 0},                                                /* End of row 156 */
  {73, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {75, 0},                                                /* End of row 157 */
  {75, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {76, 0},                                                /* End of row 158 */
  {76, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {77, 0},                                                /* End of row 159 */
  {78, 0},
  {1, 255},
  {81, 0},                                                /* End of row 160 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_MONO */

const struct palette_bitmap_s g_splscr =
{
  160,                 /* width in pixels                                   */
  160,                 /* height in pixels                                  */
  palette,             /* Colour palette                                    */
  bitmap,              /* Pointer to the start of the RLE data              */
};

/****************************************************************************
 * Private Functions
 ****************************************************************************/
