/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.AssociationSetEnd;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationSetView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntitySetView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmNameBuilder;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;

public class JPAEdmAssociationSet
extends JPAEdmBaseViewImpl
implements JPAEdmAssociationSetView {
    private JPAEdmSchemaView schemaView;
    private AssociationSet currentAssociationSet;
    private List<AssociationSet> associationSetList;
    private Association currentAssociation;

    public JPAEdmAssociationSet(JPAEdmSchemaView view) {
        super((JPAEdmBaseView)view);
        this.schemaView = view;
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmAssociationSetBuilder();
        }
        return this.builder;
    }

    public List<AssociationSet> getConsistentEdmAssociationSetList() {
        return this.associationSetList;
    }

    public AssociationSet getEdmAssociationSet() {
        return this.currentAssociationSet;
    }

    public Association getEdmAssociation() {
        return this.currentAssociation;
    }

    private class JPAEdmAssociationSetBuilder
    implements JPAEdmBuilder {
        private JPAEdmAssociationSetBuilder() {
        }

        public void build() throws ODataJPAModelException {
            if (JPAEdmAssociationSet.this.associationSetList == null) {
                JPAEdmAssociationSet.this.associationSetList = new ArrayList<AssociationSet>();
            }
            JPAEdmAssociationView associationView = JPAEdmAssociationSet.this.schemaView.getJPAEdmAssociationView();
            JPAEdmEntitySetView entitySetView = JPAEdmAssociationSet.this.schemaView.getJPAEdmEntityContainerView().getJPAEdmEntitySetView();
            List entitySetList = entitySetView.getConsistentEdmEntitySetList();
            if (associationView.isConsistent()) {
                Iterator iterator = associationView.getConsistentEdmAssociationList().iterator();
                while (iterator.hasNext()) {
                    Association association;
                    JPAEdmAssociationSet.this.currentAssociation = association = (Association)iterator.next();
                    FullQualifiedName fQname = new FullQualifiedName(JPAEdmAssociationSet.this.schemaView.getEdmSchema().getNamespace(), association.getName());
                    JPAEdmAssociationSet.this.currentAssociationSet = new AssociationSet();
                    JPAEdmAssociationSet.this.currentAssociationSet.setAssociation(fQname);
                    int endCount = 0;
                    FullQualifiedName end1Type = association.getEnd1().getType();
                    FullQualifiedName end2Type = association.getEnd2().getType();
                    for (EntitySet entitySet : entitySetList) {
                        AssociationSetEnd end;
                        fQname = entitySet.getEntityType();
                        if (fQname.equals((Object)end1Type)) {
                            end = new AssociationSetEnd();
                            end.setEntitySet(entitySet.getName());
                            JPAEdmAssociationSet.this.currentAssociationSet.setEnd1(end);
                            end.setRole(association.getEnd1().getRole());
                            ++endCount;
                        }
                        if (fQname.equals((Object)end2Type)) {
                            end = new AssociationSetEnd();
                            end.setEntitySet(entitySet.getName());
                            JPAEdmAssociationSet.this.currentAssociationSet.setEnd2(end);
                            end.setRole(association.getEnd2().getRole());
                            ++endCount;
                        }
                        if (endCount != 2) continue;
                        break;
                    }
                    if (endCount != 2) continue;
                    JPAEdmNameBuilder.build(JPAEdmAssociationSet.this);
                    JPAEdmAssociationSet.this.associationSetList.add(JPAEdmAssociationSet.this.currentAssociationSet);
                }
            }
        }
    }
}

