/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.olingo.fit.metadata;

import java.util.LinkedHashMap;
import java.util.Map;

public class EntitySet extends AbstractMetadataElement {

  private final String name;
  private String type;
  private final boolean singleton;
  private final Map<String, String> binding;

  public EntitySet(final String name, final boolean singleton) {
    this.name = name;
    this.singleton = singleton;
    binding = new LinkedHashMap<String, String>();
  }

  public EntitySet(final String name) {
    this(name, false);
  }

  public String getName() {
    return name;
  }

  public String getType() {
    return type;
  }

  public void setType(final String type) {
    this.type = type;
  }

  public boolean isSingleton() {
    return singleton;
  }

  public EntitySet addBinding(final String path, final String target) {
    binding.put(path, target);
    return this;
  }

  public String getTarget(final String path) {
    return binding.get(path);
  }
}
