/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.data;

import java.util.List;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.geo.Geospatial;

public abstract class Valuable
extends Annotatable {
    private ValueType valueType = null;
    private Object value = null;
    private String type;

    public boolean isNull() {
        return this.value == null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPrimitive() {
        return this.valueType == ValueType.PRIMITIVE || this.valueType == ValueType.COLLECTION_PRIMITIVE;
    }

    public boolean isGeospatial() {
        return this.valueType == ValueType.GEOSPATIAL || this.valueType == ValueType.COLLECTION_GEOSPATIAL;
    }

    public boolean isEnum() {
        return this.valueType == ValueType.ENUM || this.valueType == ValueType.COLLECTION_ENUM;
    }

    public boolean isComplex() {
        return this.valueType == ValueType.COMPLEX || this.valueType == ValueType.COLLECTION_COMPLEX;
    }

    public boolean isCollection() {
        return this.valueType != null && this.valueType != this.valueType.getBaseType();
    }

    public Object asPrimitive() {
        return this.isPrimitive() && !this.isCollection() ? this.value : null;
    }

    public Geospatial asGeospatial() {
        return this.isGeospatial() && !this.isCollection() ? (Geospatial)this.value : null;
    }

    public Object asEnum() {
        return this.isEnum() && !this.isCollection() ? this.value : null;
    }

    public ComplexValue asComplex() {
        return this.isComplex() && !this.isCollection() ? (ComplexValue)this.value : null;
    }

    public List<?> asCollection() {
        return this.isCollection() ? (List)this.value : null;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(ValueType valueType, Object value) {
        this.valueType = valueType;
        this.value = value;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Valuable other = (Valuable)o;
        return this.getAnnotations().equals(other.getAnnotations()) && (this.valueType == null ? other.valueType == null : this.valueType.equals((Object)other.valueType)) && (this.value == null ? other.value == null : this.value.equals(other.value)) && (this.type == null ? other.type == null : this.type.equals(other.type));
    }

    public int hashCode() {
        int result = this.getAnnotations().hashCode();
        result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }
}

