/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ipc.PhoenixRpcScheduler;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixRpcSchedulerFactory
implements RpcSchedulerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixRpcSchedulerFactory.class);
    private static final String VERSION_TOO_OLD_FOR_INDEX_RPC = "Running an older version of HBase (less than 0.98.4), Phoenix index RPC handling cannot be enabled.";

    public RpcScheduler create(Configuration conf, PriorityFunction priorityFunction, Abortable abortable) {
        RpcScheduler delegate;
        try {
            delegate = new SimpleRpcSchedulerFactory().create(conf, priorityFunction, abortable);
        }
        catch (IllegalAccessError e) {
            LOGGER.error(VERSION_TOO_OLD_FOR_INDEX_RPC);
            throw e;
        }
        int indexPriority = PhoenixRpcSchedulerFactory.getIndexPriority(conf);
        this.validatePriority(indexPriority);
        int metadataPriority = PhoenixRpcSchedulerFactory.getMetadataPriority(conf);
        this.validatePriority(metadataPriority);
        Preconditions.checkArgument((indexPriority != metadataPriority ? 1 : 0) != 0, (Object)("Index and Metadata priority must not be same " + indexPriority));
        LOGGER.info("Using custom Phoenix Index RPC Handling with index rpc priority " + indexPriority + " and metadata rpc priority " + metadataPriority);
        PhoenixRpcScheduler scheduler = new PhoenixRpcScheduler(conf, delegate, indexPriority, metadataPriority);
        return scheduler;
    }

    public RpcScheduler create(Configuration configuration, PriorityFunction priorityFunction) {
        return this.create(configuration, priorityFunction, null);
    }

    private void validatePriority(int priority) {
        Preconditions.checkArgument((priority < 0 || priority > 200 ? 1 : 0) != 0, (Object)"priority cannot be within hbase priority range 0 to 200");
    }

    public static int getIndexPriority(Configuration conf) {
        return conf.getInt("phoenix.index.rpc.priority", 1000);
    }

    public static int getMetadataPriority(Configuration conf) {
        return conf.getInt("phoenix.metadata.rpc.priority", 2000);
    }
}

