/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.UndecodableByteException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.ByteUtil;

public class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final byte SPACE_UTF8 = 32;
    private static final int BYTES_1_MASK = 32640;
    private static final int BYTES_2_MASK = 8160;
    private static final int BYTES_3_MASK = 4080;
    private static final int BYTES_4_MASK = 2040;
    public static final byte INVERTED_SPACE_UTF8 = SortOrder.invert(new byte[]{32}, 0, new byte[1], 0, 1)[0];
    public static final char SINGLE_CHAR_WILDCARD = '?';
    public static final char SINGLE_CHAR_LIKE = '_';
    public static final char MULTI_CHAR_WILDCARD = '*';
    public static final char MULTI_CHAR_LIKE = '%';
    public static final String[] LIKE_ESCAPE_SEQS = new String[]{"\\_", "\\%"};
    public static final String[] LIKE_UNESCAPED_SEQS = new String[]{"_", "%"};

    private StringUtil() {
    }

    public static String replaceChar(String value, char ch, CharSequence replacement) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(ch);
        if (i == -1) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value.length() + 16);
        int j = 0;
        while (i != -1) {
            buf.append(value, j, i).append(replacement);
            j = i + 1;
            i = value.indexOf(ch, j);
        }
        if (j < value.length()) {
            buf.append(value, j, value.length());
        }
        return buf.toString();
    }

    public static String replace(String s, String[] src, String[] target) {
        assert (src != null && target != null && src.length > 0 && src.length == target.length);
        if (src.length == 1 && src[0].length() == 1) {
            return StringUtil.replaceChar(s, src[0].charAt(0), target[0]);
        }
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int pos = 0;
        int limit = s.length();
        int lastMatch = 0;
        while (pos < limit) {
            boolean matched = false;
            for (int i = 0; i < src.length; ++i) {
                if (!s.startsWith(src[i], pos) || src[i].length() <= 0) continue;
                sb.append(s.substring(lastMatch, pos)).append(target[i]);
                lastMatch = pos += src[i].length();
                matched = true;
                break;
            }
            if (matched) continue;
            ++pos;
        }
        if (lastMatch == 0) {
            return s;
        }
        sb.append(s.substring(lastMatch));
        return sb.toString();
    }

    public static int getBytesInChar(byte b, SortOrder sortOrder) {
        int ret = StringUtil.getBytesInCharNoException(b, sortOrder);
        if (ret == -1) {
            throw new UndecodableByteException(b);
        }
        return ret;
    }

    private static int getBytesInCharNoException(byte b, SortOrder sortOrder) {
        int c;
        Preconditions.checkNotNull((Object)((Object)sortOrder));
        if (sortOrder == SortOrder.DESC) {
            b = SortOrder.invert(b);
        }
        if (((c = b & 0xFF) & 0x7F80) == 0) {
            return 1;
        }
        if ((c & 0x1FE0) == 192) {
            return 2;
        }
        if ((c & 0xFF0) == 224) {
            return 3;
        }
        if ((c & 0x7F8) == 240) {
            return 4;
        }
        return -1;
    }

    public static int calculateUTF8Length(byte[] bytes, int offset, int length, SortOrder sortOrder) {
        int i = offset;
        int endOffset = offset + length;
        length = 0;
        while (i < endOffset) {
            int charLength = StringUtil.getBytesInChar(bytes[i], sortOrder);
            i += charLength;
            ++length;
        }
        return length;
    }

    private static int calculateNextCharOffset(byte[] bytes, int curPos, int range, SortOrder sortOrder) {
        int ret = StringUtil.getBytesInCharNoException(bytes[curPos], sortOrder);
        if (ret == -1) {
            return -1;
        }
        if ((ret += curPos) >= range) {
            return -1;
        }
        return ret;
    }

    private static int calculatePreCharOffset(byte[] bytes, int curPos, int offset, SortOrder sortOrder) {
        int i = 1;
        for (int pos = --curPos - i + 1; i <= 4 && offset <= pos; ++i, --pos) {
            int ret = StringUtil.getBytesInCharNoException(bytes[pos], sortOrder);
            if (ret != i) continue;
            return pos;
        }
        return -1;
    }

    public static int calculateUTF8Offset(byte[] bytes, int offset, int length, SortOrder sortOrder, int offsetInStr) {
        int ret;
        if (offsetInStr == 0) {
            return offset;
        }
        int range = offset + length;
        if (offsetInStr > 0) {
            ret = offset;
            while (offsetInStr > 0) {
                if ((ret = StringUtil.calculateNextCharOffset(bytes, ret, range, sortOrder)) == -1) {
                    return -1;
                }
                --offsetInStr;
            }
        } else {
            ret = offset + length;
            while (offsetInStr < 0) {
                if ((ret = StringUtil.calculatePreCharOffset(bytes, ret, offset, sortOrder)) < offset) {
                    return -1;
                }
                ++offsetInStr;
            }
        }
        return ret;
    }

    public static int getByteLengthForUtf8SubStr(byte[] bytes, int offset, int length, SortOrder sortOrder) {
        int byteLength = 0;
        while (length > 0 && offset + byteLength < bytes.length) {
            int charLength = StringUtil.getBytesInChar(bytes[offset + byteLength], sortOrder);
            byteLength += charLength;
            --length;
        }
        return byteLength;
    }

    public static boolean hasMultiByteChars(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public static int getFirstNonBlankCharIdxFromStart(byte[] string, int offset, int length, SortOrder sortOrder) {
        int i;
        byte space;
        byte by = space = sortOrder == SortOrder.ASC ? (byte)32 : (byte)INVERTED_SPACE_UTF8;
        for (i = offset; i < offset + length && string[i] == space; ++i) {
        }
        return i;
    }

    public static int getFirstNonBlankCharIdxFromEnd(byte[] string, int offset, int length, SortOrder sortOrder) {
        int i;
        byte space;
        byte by = space = sortOrder == SortOrder.ASC ? (byte)32 : (byte)INVERTED_SPACE_UTF8;
        for (i = offset + length - 1; i >= offset && string[i] == space; --i) {
        }
        return i;
    }

    public static byte[] toBytes(String input) {
        if (input == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        return Bytes.toBytes((String)input);
    }

    public static String escapeLike(String s) {
        return StringUtil.replace(s, LIKE_UNESCAPED_SEQS, LIKE_ESCAPE_SEQS);
    }

    public static int getUnpaddedCharLength(byte[] b, int offset, int length, SortOrder sortOrder) {
        return StringUtil.getFirstNonBlankCharIdxFromEnd(b, offset, length, sortOrder) - offset + 1;
    }

    public static byte[] padChar(byte[] value, Integer byteSize) {
        byte[] newValue = Arrays.copyOf(value, (int)byteSize);
        if (newValue.length > value.length) {
            Arrays.fill(newValue, value.length, newValue.length, (byte)32);
        }
        return newValue;
    }

    public static boolean equals(StringBuilder b1, StringBuilder b2) {
        if (b1.length() != b2.length()) {
            return false;
        }
        for (int i = 0; i < b1.length(); ++i) {
            if (b1.charAt(i) == b2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static byte[] lpad(byte[] str, int strOffset, int strLength, byte[] fill, int fillOffset, int fillLength, boolean invertFill, int strWithPaddingLen) {
        byte[] paddedStr = new byte[strWithPaddingLen];
        int fillStopIdx = strWithPaddingLen - strLength;
        StringUtil.fill(paddedStr, 0, fillStopIdx, fill, fillOffset, fillOffset + fillLength, invertFill);
        System.arraycopy(str, strOffset, paddedStr, fillStopIdx, strLength);
        return paddedStr;
    }

    public static void fill(byte[] str, int strFromIdx, int strToIdx, byte[] fillArray, int fillFromIdx, int fillToIdx, boolean invertFill) {
        StringUtil.rangeCheck(str.length, strFromIdx, strToIdx);
        StringUtil.rangeCheck(fillArray.length, fillFromIdx, fillToIdx);
        int strIdx = strFromIdx;
        byte[] fill = fillArray;
        int fillLen = fillToIdx - fillFromIdx;
        if (invertFill) {
            fill = SortOrder.invert(fillArray, fillFromIdx, fillLen);
        }
        while (strIdx < strToIdx) {
            int fillIdx = fillFromIdx;
            while (fillIdx < fillToIdx && strIdx < strToIdx) {
                if (strIdx + fillLen < fillToIdx) {
                    System.arraycopy(fill, fillFromIdx, str, strIdx, fillLen);
                    continue;
                }
                str[strIdx++] = fill[fillIdx++];
            }
        }
    }

    private static void rangeCheck(int length, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > length) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static String escapeStringConstant(String pattern) {
        return StringEscapeUtils.escapeSql((String)pattern);
    }

    public static String escapeBackslash(String input) {
        return input.replaceAll("\\\\", "\\\\\\\\");
    }
}

