/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.util.concurrent.CountDownLatch;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TimestampOracleImpl;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestTimestampOracle {
    private static final Logger LOG = LoggerFactory.getLogger(TestTimestampOracle.class);
    @Mock
    private MetricsRegistry metrics;
    @Mock
    private Panicker panicker;
    @Mock
    private TimestampStorage timestampStorage;
    @Mock
    TSOServerConfig config;
    @InjectMocks
    private TimestampOracleImpl timestampOracle;

    @BeforeMethod(alwaysRun=true, timeOut=30000L)
    public void initMocksAndComponents() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test(timeOut=60000L)
    public void testMonotonicTimestampGrowth() throws Exception {
        this.timestampOracle.initialize();
        long last = this.timestampOracle.next();
        int i = 0;
        while ((long)i < 1500000000L) {
            long current = this.timestampOracle.next();
            Assert.assertEquals((long)current, (long)(last + 50L), (String)"Not monotonic growth");
            last = current;
            ++i;
        }
        Assert.assertTrue((this.timestampOracle.getLast() == last ? 1 : 0) != 0);
        LOG.info("Last timestamp: {}", (Object)last);
    }

    @Test(timeOut=10000L)
    public void testTimestampOraclePanicsWhenTheStorageHasProblems() throws Exception {
        this.timestampOracle.initialize();
        final CountDownLatch updateMaxTimestampMethodCalled = new CountDownLatch(1);
        ((TimestampStorage)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                updateMaxTimestampMethodCalled.countDown();
                throw new RuntimeException("Out of memory or something");
            }
        }).when((Object)this.timestampStorage)).updateMaxTimestamp(Matchers.anyLong(), Matchers.anyLong());
        Thread allocThread = new Thread("AllocThread"){

            @Override
            public void run() {
                while (true) {
                    TestTimestampOracle.this.timestampOracle.next();
                }
            }
        };
        allocThread.start();
        updateMaxTimestampMethodCalled.await();
        ((Panicker)Mockito.verify((Object)this.panicker, (VerificationMode)Mockito.atLeastOnce())).panic(Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
    }
}

