/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableRefFactory;
import org.apache.phoenix.schema.SerializedPTableRef;

class SerializedPTableRefFactory
extends PTableRefFactory {
    private static final SerializedPTableRefFactory INSTANCE = new SerializedPTableRefFactory();

    SerializedPTableRefFactory() {
    }

    @Override
    public PTableRef makePTableRef(PTable table, long lastAccessTime, long resolvedTime) {
        byte[] serializedBytes = PTableImpl.toProto(table).toByteArray();
        return new SerializedPTableRef(serializedBytes, lastAccessTime, resolvedTime, table.getEstimatedSize());
    }

    @Override
    public PTableRef makePTableRef(PTableRef tableRef) {
        return new SerializedPTableRef(tableRef);
    }

    public static PTableRefFactory getFactory() {
        return INSTANCE;
    }
}

