/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.state;

import com.google.common.base.Charsets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.twill.api.Command;
import org.apache.twill.internal.state.Message;
import org.apache.twill.internal.state.SimpleMessage;

public final class MessageCodec {
    private static final Type OPTIONS_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)Message.class), new MessageAdapter()).registerTypeAdapter((Type)((Object)Command.class), new CommandAdapter()).create();

    public static Message decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String content = new String(bytes, Charsets.UTF_8);
        return GSON.fromJson(content, Message.class);
    }

    public static byte[] encode(Message message) {
        return GSON.toJson((Object)message, (Type)((Object)Message.class)).getBytes(Charsets.UTF_8);
    }

    private MessageCodec() {
    }

    private static final class CommandAdapter
    implements JsonSerializer<Command>,
    JsonDeserializer<Command> {
        private CommandAdapter() {
        }

        @Override
        public Command deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObj = json.getAsJsonObject();
            return Command.Builder.of(jsonObj.get("command").getAsString()).addOptions((Map)context.deserialize(jsonObj.get("options"), OPTIONS_TYPE)).build();
        }

        @Override
        public JsonElement serialize(Command command, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("command", command.getCommand());
            jsonObj.add("options", context.serialize(command.getOptions(), OPTIONS_TYPE));
            return jsonObj;
        }
    }

    private static final class MessageAdapter
    implements JsonSerializer<Message>,
    JsonDeserializer<Message> {
        private MessageAdapter() {
        }

        @Override
        public Message deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObj = json.getAsJsonObject();
            Message.Type type = Message.Type.valueOf(jsonObj.get("type").getAsString());
            Message.Scope scope = Message.Scope.valueOf(jsonObj.get("scope").getAsString());
            JsonElement name = jsonObj.get("runnableName");
            String runnableName = name == null || name.isJsonNull() ? null : name.getAsString();
            Command command = (Command)context.deserialize(jsonObj.get("command"), (Type)((Object)Command.class));
            return new SimpleMessage(type, scope, runnableName, command);
        }

        @Override
        public JsonElement serialize(Message message, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("type", message.getType().name());
            jsonObj.addProperty("scope", message.getScope().name());
            jsonObj.addProperty("runnableName", message.getRunnableName());
            jsonObj.add("command", context.serialize(message.getCommand(), (Type)((Object)Command.class)));
            return jsonObj;
        }
    }
}

