/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.cache.aggcache.SpillableGroupByCache;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.GroupByCache;
import org.apache.phoenix.coprocessor.HashJoinRegionScanner;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.EncodedColumnQualiferCellsList;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.PositionBasedMultiKeyValueTuple;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SizedUtil;
import org.apache.phoenix.util.TupleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupedAggregateRegionObserver
extends BaseScannerRegionObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupedAggregateRegionObserver.class);
    public static final int MIN_DISTINCT_VALUES = 100;

    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        boolean keyOrdered = false;
        byte[] expressionBytes = scan.getAttribute("_UnorderedGroupByExpressions");
        if (expressionBytes == null) {
            expressionBytes = scan.getAttribute("_OrderedGroupByExpressions");
            keyOrdered = true;
        }
        int offset = 0;
        boolean useNewValueColumnQualifier = EncodedColumnsUtil.useNewValueColumnQualifier(scan);
        if (ScanUtil.isLocalIndex(scan)) {
            Region region = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion();
            offset = region.getRegionInfo().getStartKey().length != 0 ? region.getRegionInfo().getStartKey().length : region.getRegionInfo().getEndKey().length;
            ScanUtil.setRowKeyOffset(scan, offset);
        }
        List<Expression> expressions = this.deserializeGroupByExpressions(expressionBytes, 0);
        TenantCache tenantCache = GlobalCache.getTenantCache((RegionCoprocessorEnvironment)c.getEnvironment(), ScanUtil.getTenantId(scan));
        try (MemoryManager.MemoryChunk em = tenantCache.getMemoryManager().allocate(0L);){
            ServerAggregators aggregators = ServerAggregators.deserialize(scan.getAttribute("_Aggs"), ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration(), em);
            RegionScanner innerScanner = s;
            boolean useProto = false;
            byte[] localIndexBytes = scan.getAttribute("_LocalIndexBuild");
            boolean bl = useProto = localIndexBytes != null;
            if (localIndexBytes == null) {
                localIndexBytes = scan.getAttribute("_LocalIndexBuild");
            }
            List<IndexMaintainer> indexMaintainers = localIndexBytes == null ? null : IndexMaintainer.deserialize(localIndexBytes, useProto);
            TupleProjector tupleProjector = null;
            byte[][] viewConstants = null;
            ColumnReference[] dataColumns = IndexUtil.deserializeDataTableColumnsToJoin(scan);
            TupleProjector p = TupleProjector.deserializeProjectorFromScan(scan);
            HashJoinInfo j = HashJoinInfo.deserializeHashJoinFromScan(scan);
            boolean useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan));
            if (ScanUtil.isLocalIndex(scan) || j == null && p != null) {
                if (dataColumns != null) {
                    tupleProjector = IndexUtil.getTupleProjector(scan, dataColumns);
                    viewConstants = IndexUtil.deserializeViewConstantsFromScan(scan);
                }
                ImmutableBytesPtr tempPtr = new ImmutableBytesPtr();
                innerScanner = this.getWrappedScanner(c, innerScanner, offset, scan, dataColumns, tupleProjector, ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion(), indexMaintainers == null ? null : indexMaintainers.get(0), viewConstants, p, tempPtr, useQualifierAsIndex);
            }
            if (j != null) {
                innerScanner = new HashJoinRegionScanner(innerScanner, scan, p, j, ScanUtil.getTenantId(scan), (RegionCoprocessorEnvironment)c.getEnvironment(), useQualifierAsIndex, useNewValueColumnQualifier);
            }
            long limit = Long.MAX_VALUE;
            byte[] limitBytes = scan.getAttribute("_GroupByLimit");
            if (limitBytes != null) {
                limit = PInteger.INSTANCE.getCodec().decodeInt(limitBytes, 0, SortOrder.getDefault());
            }
            long pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner(scan);
            if (keyOrdered) {
                OrderedGroupByRegionScanner orderedGroupByRegionScanner = new OrderedGroupByRegionScanner(c, scan, innerScanner, expressions, aggregators, limit, pageSizeMs);
                return orderedGroupByRegionScanner;
            }
            UnorderedGroupByRegionScanner unorderedGroupByRegionScanner = new UnorderedGroupByRegionScanner(c, scan, innerScanner, expressions, aggregators, limit, pageSizeMs);
            return unorderedGroupByRegionScanner;
        }
    }

    public static long sizeOfUnorderedGroupByMap(int nRows, int valueSize) {
        return SizedUtil.sizeOfMap(nRows, 48, valueSize);
    }

    public static void serializeIntoScan(Scan scan, String attribName, List<Expression> groupByExpressions) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(Math.max(1, groupByExpressions.size() * 10));
        try {
            if (groupByExpressions.isEmpty()) {
                stream.write(QueryConstants.TRUE);
            } else {
                DataOutputStream output = new DataOutputStream(stream);
                for (Expression expression : groupByExpressions) {
                    WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(expression).ordinal());
                    expression.write(output);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        scan.setAttribute(attribName, stream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Expression> deserializeGroupByExpressions(byte[] expressionBytes, int offset) throws IOException {
        ArrayList<Expression> expressions = new ArrayList<Expression>(3);
        ByteArrayInputStream stream = new ByteArrayInputStream(expressionBytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            try {
                while (true) {
                    int expressionOrdinal = WritableUtils.readVInt((DataInput)input);
                    Expression expression = ExpressionType.values()[expressionOrdinal].newInstance();
                    expression.readFields(input);
                    if (offset != 0) {
                        IndexUtil.setRowKeyExpressionOffset(expression, offset);
                    }
                    expressions.add(expression);
                }
            }
            catch (EOFException e) {
                stream.close();
            }
        }
        catch (Throwable throwable) {
            stream.close();
            throw throwable;
        }
        return expressions;
    }

    @Override
    protected boolean isRegionObserverFor(Scan scan) {
        return scan.getAttribute("_UnorderedGroupByExpressions") != null || scan.getAttribute("_OrderedGroupByExpressions") != null;
    }

    private static class OrderedGroupByRegionScanner
    extends BaseRegionScanner {
        private final Scan scan;
        private final Region region;
        private final Pair<Integer, Integer> minMaxQualifiers;
        private final boolean useQualifierAsIndex;
        private final PTable.QualifierEncodingScheme encodingScheme;
        private final ServerAggregators aggregators;
        private final long limit;
        private Aggregator[] rowAggregators;
        private final List<Expression> expressions;
        private final long pageSizeMs;
        private long rowCount = 0L;
        private ImmutableBytesPtr currentKey = null;

        private OrderedGroupByRegionScanner(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner scanner, List<Expression> expressions, ServerAggregators aggregators, long limit, long pageSizeMs) {
            super(scanner);
            this.scan = scan;
            this.region = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion();
            this.minMaxQualifiers = EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan);
            this.useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(this.minMaxQualifiers);
            this.encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme(scan);
            this.aggregators = aggregators;
            this.rowAggregators = aggregators.getAggregators();
            this.limit = limit;
            this.pageSizeMs = pageSizeMs;
            this.expressions = expressions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean next(List<Cell> results) throws IOException {
            long now;
            boolean atLimit;
            boolean hasMore;
            boolean aggBoundary = false;
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            BaseTuple result = this.useQualifierAsIndex ? new PositionBasedMultiKeyValueTuple() : new MultiKeyValueTuple();
            ImmutableBytesPtr key = null;
            int countOffset = this.rowAggregators.length == 0 ? 1 : 0;
            boolean acquiredLock = false;
            try {
                this.region.startRegionOperation();
                acquiredLock = true;
                RegionScanner regionScanner = this.delegate;
                synchronized (regionScanner) {
                    do {
                        List<Cell> kvs = this.useQualifierAsIndex ? new EncodedColumnQualiferCellsList((Integer)this.minMaxQualifiers.getFirst(), (Integer)this.minMaxQualifiers.getSecond(), this.encodingScheme) : new ArrayList();
                        hasMore = this.delegate.nextRaw((List)kvs);
                        if (!kvs.isEmpty()) {
                            if (ScanUtil.isDummy(kvs)) {
                                ScanUtil.getDummyResult(results);
                                boolean bl = true;
                                return bl;
                            }
                            result.setKeyValues(kvs);
                            key = TupleUtil.getConcatenatedValue(result, this.expressions);
                            boolean bl = aggBoundary = this.currentKey != null && this.currentKey.compareTo(key) != 0;
                            if (!aggBoundary) {
                                this.aggregators.aggregate(this.rowAggregators, result);
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug(LogUtil.addCustomAnnotations("Row passed filters: " + kvs + ", aggregated values: " + Arrays.asList(this.rowAggregators), ScanUtil.getCustomAnnotations(this.scan)));
                                }
                                this.currentKey = key;
                            }
                        }
                        atLimit = this.rowCount + (long)countOffset >= this.limit;
                        now = EnvironmentEdgeManager.currentTimeMillis();
                    } while (hasMore && !aggBoundary && !atLimit && now - startTime < this.pageSizeMs);
                }
            }
            finally {
                if (acquiredLock) {
                    this.region.closeRegionOperation();
                }
            }
            if (hasMore && !aggBoundary && !atLimit && now - startTime >= this.pageSizeMs) {
                ScanUtil.getDummyResult(results);
                return true;
            }
            if (this.currentKey != null) {
                byte[] value = this.aggregators.toBytes(this.rowAggregators);
                KeyValue keyValue = KeyValueUtil.newKeyValue(this.currentKey.get(), this.currentKey.getOffset(), this.currentKey.getLength(), QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length);
                results.add((Cell)keyValue);
                if (aggBoundary) {
                    this.aggregators.reset(this.rowAggregators);
                    this.aggregators.aggregate(this.rowAggregators, result);
                    this.currentKey = key;
                    ++this.rowCount;
                    atLimit |= this.rowCount >= this.limit;
                }
            }
            if (!atLimit) {
                if (hasMore) return true;
                if (aggBoundary) {
                    return true;
                }
            }
            this.currentKey = null;
            return false;
        }
    }

    private static class UnorderedGroupByRegionScanner
    extends BaseRegionScanner {
        private final Region region;
        private final Pair<Integer, Integer> minMaxQualifiers;
        private final boolean useQualifierAsIndex;
        private final PTable.QualifierEncodingScheme encodingScheme;
        private final ServerAggregators aggregators;
        private final long limit;
        private final List<Expression> expressions;
        private final long pageSizeMs;
        private RegionScanner regionScanner = null;
        private final boolean spillableEnabled;
        private final GroupByCache groupByCache;

        private UnorderedGroupByRegionScanner(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner scanner, List<Expression> expressions, ServerAggregators aggregators, long limit, long pageSizeMs) {
            super(scanner);
            this.region = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion();
            this.minMaxQualifiers = EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan);
            this.useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(this.minMaxQualifiers);
            this.encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme(scan);
            this.aggregators = aggregators;
            this.limit = limit;
            this.pageSizeMs = pageSizeMs;
            this.expressions = expressions;
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)c.getEnvironment();
            Configuration conf = env.getConfiguration();
            int estDistVals = conf.getInt("phoenix.groupby.estimatedDistinctValues", 1000);
            byte[] estDistValsBytes = scan.getAttribute("_EstDistinctValues");
            if (estDistValsBytes != null) {
                estDistVals = Math.max(100, (int)((float)Bytes.toInt((byte[])estDistValsBytes) * 1.5f));
            }
            this.spillableEnabled = conf.getBoolean("phoenix.groupby.spillable", QueryServicesOptions.DEFAULT_GROUPBY_SPILLABLE);
            this.groupByCache = GroupByCacheFactory.INSTANCE.newCache(env, ScanUtil.getTenantId(scan), ScanUtil.getCustomAnnotations(scan), aggregators, estDistVals);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(LogUtil.addCustomAnnotations("Grouped aggregation over unordered rows with scan " + scan + ", group by " + expressions + ", aggregators " + aggregators, ScanUtil.getCustomAnnotations(scan)));
                LOGGER.debug(LogUtil.addCustomAnnotations("Spillable groupby enabled: " + this.spillableEnabled, ScanUtil.getCustomAnnotations(scan)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean next(List<Cell> resultsToReturn) throws IOException {
            long now;
            boolean hasMore;
            boolean acquiredLock;
            BaseTuple result;
            long startTime;
            block12: {
                boolean bl;
                startTime = EnvironmentEdgeManager.currentTimeMillis();
                result = this.useQualifierAsIndex ? new PositionBasedMultiKeyValueTuple() : new MultiKeyValueTuple();
                acquiredLock = false;
                try {
                    this.region.startRegionOperation();
                    acquiredLock = true;
                    RegionScanner regionScanner = this.delegate;
                    // MONITORENTER : regionScanner
                    if (this.regionScanner == null) break block12;
                    bl = this.regionScanner.next(resultsToReturn);
                    // MONITOREXIT : regionScanner
                    if (!acquiredLock) return bl;
                }
                catch (Throwable throwable) {
                    if (!acquiredLock) throw throwable;
                    this.region.closeRegionOperation();
                    throw throwable;
                }
                this.region.closeRegionOperation();
                return bl;
            }
            do {
                List<Cell> results = this.useQualifierAsIndex ? new EncodedColumnQualiferCellsList((Integer)this.minMaxQualifiers.getFirst(), (Integer)this.minMaxQualifiers.getSecond(), this.encodingScheme) : new ArrayList();
                hasMore = this.delegate.nextRaw((List)results);
                if (!results.isEmpty()) {
                    if (ScanUtil.isDummy(results)) {
                        ScanUtil.getDummyResult(resultsToReturn);
                        boolean bl = true;
                        // MONITOREXIT : regionScanner
                        if (!acquiredLock) return bl;
                        this.region.closeRegionOperation();
                        return bl;
                    }
                    result.setKeyValues(results);
                    ImmutableBytesPtr key = TupleUtil.getConcatenatedValue(result, this.expressions);
                    Aggregator[] rowAggregators = this.groupByCache.cache(key);
                    this.aggregators.aggregate(rowAggregators, result);
                }
                now = EnvironmentEdgeManager.currentTimeMillis();
            } while (hasMore && this.groupByCache.size() < this.limit && now - startTime < this.pageSizeMs);
            if (hasMore && this.groupByCache.size() < this.limit && now - startTime >= this.pageSizeMs) {
                ScanUtil.getDummyResult(resultsToReturn);
                boolean bl = true;
                // MONITOREXIT : regionScanner
                if (!acquiredLock) return bl;
                this.region.closeRegionOperation();
                return bl;
            }
            this.regionScanner = this.groupByCache.getScanner(this.delegate);
            boolean bl = this.regionScanner.next(resultsToReturn);
            // MONITOREXIT : regionScanner
            if (!acquiredLock) return bl;
            this.region.closeRegionOperation();
            return bl;
        }

        @Override
        public void close() throws IOException {
            if (this.regionScanner != null) {
                this.regionScanner.close();
            } else {
                Closeables.closeQuietly(this.groupByCache);
            }
        }
    }

    private static final class GroupByCacheFactory {
        public static final GroupByCacheFactory INSTANCE = new GroupByCacheFactory();

        private GroupByCacheFactory() {
        }

        GroupByCache newCache(RegionCoprocessorEnvironment env, ImmutableBytesPtr tenantId, byte[] customAnnotations, ServerAggregators aggregators, int estDistVals) {
            Configuration conf = env.getConfiguration();
            boolean spillableEnabled = conf.getBoolean("phoenix.groupby.spillable", QueryServicesOptions.DEFAULT_GROUPBY_SPILLABLE);
            if (spillableEnabled) {
                return new SpillableGroupByCache(env, tenantId, aggregators, estDistVals);
            }
            return new InMemoryGroupByCache(env, tenantId, customAnnotations, aggregators, estDistVals);
        }
    }

    private static final class InMemoryGroupByCache
    implements GroupByCache {
        private final MemoryManager.MemoryChunk chunk;
        private final Map<ImmutableBytesPtr, Aggregator[]> aggregateMap;
        private final ServerAggregators aggregators;
        private final RegionCoprocessorEnvironment env;
        private final byte[] customAnnotations;
        private int estDistVals;

        InMemoryGroupByCache(RegionCoprocessorEnvironment env, ImmutableBytesPtr tenantId, byte[] customAnnotations, ServerAggregators aggregators, int estDistVals) {
            int estValueSize = aggregators.getEstimatedByteSize();
            long estSize = GroupedAggregateRegionObserver.sizeOfUnorderedGroupByMap(estDistVals, estValueSize);
            TenantCache tenantCache = GlobalCache.getTenantCache(env, tenantId);
            this.env = env;
            this.estDistVals = estDistVals;
            this.aggregators = aggregators;
            this.aggregateMap = Maps.newHashMapWithExpectedSize((int)estDistVals);
            this.chunk = tenantCache.getMemoryManager().allocate(estSize);
            this.customAnnotations = customAnnotations;
        }

        @Override
        public void close() throws IOException {
            this.chunk.close();
        }

        @Override
        public Aggregator[] cache(ImmutableBytesPtr cacheKey) {
            ImmutableBytesPtr key = new ImmutableBytesPtr(cacheKey);
            Aggregator[] rowAggregators = this.aggregateMap.get((Object)key);
            if (rowAggregators == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(LogUtil.addCustomAnnotations("Adding new aggregate bucket for row key " + Bytes.toStringBinary((byte[])key.get(), (int)key.getOffset(), (int)key.getLength()), this.customAnnotations));
                }
                rowAggregators = this.aggregators.newAggregators(this.env.getConfiguration());
                this.aggregateMap.put(key, rowAggregators);
                if (this.aggregateMap.size() > this.estDistVals) {
                    this.estDistVals = (int)((float)this.estDistVals * 1.5f);
                    long estSize = GroupedAggregateRegionObserver.sizeOfUnorderedGroupByMap(this.estDistVals, this.aggregators.getEstimatedByteSize());
                    this.chunk.resize(estSize);
                }
            }
            return rowAggregators;
        }

        @Override
        public RegionScanner getScanner(final RegionScanner s) {
            long estSize = GroupedAggregateRegionObserver.sizeOfUnorderedGroupByMap(this.aggregateMap.size(), this.aggregators.getEstimatedByteSize());
            this.chunk.resize(estSize);
            final ArrayList<KeyValue> aggResults = new ArrayList<KeyValue>(this.aggregateMap.size());
            for (Map.Entry<ImmutableBytesPtr, Aggregator[]> entry : this.aggregateMap.entrySet()) {
                ImmutableBytesPtr key = entry.getKey();
                Aggregator[] rowAggregators = entry.getValue();
                byte[] value = this.aggregators.toBytes(rowAggregators);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(LogUtil.addCustomAnnotations("Adding new distinct group: " + Bytes.toStringBinary((byte[])key.get(), (int)key.getOffset(), (int)key.getLength()) + " with aggregators " + Arrays.asList(rowAggregators).toString() + " value = " + Bytes.toStringBinary((byte[])value), this.customAnnotations));
                }
                KeyValue keyValue = KeyValueUtil.newKeyValue(key.get(), key.getOffset(), key.getLength(), QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length);
                aggResults.add(keyValue);
            }
            return new BaseRegionScanner(s){
                private int index;
                {
                    super(delegate);
                    this.index = 0;
                }

                @Override
                public void close() throws IOException {
                    try {
                        s.close();
                    }
                    finally {
                        InMemoryGroupByCache.this.close();
                    }
                }

                @Override
                public boolean next(List<Cell> results) throws IOException {
                    if (this.index >= aggResults.size()) {
                        return false;
                    }
                    results.add((Cell)aggResults.get(this.index));
                    ++this.index;
                    return this.index < aggResults.size();
                }
            };
        }

        @Override
        public long size() {
            return this.aggregateMap.size();
        }
    }
}

