/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import javax.annotation.Nonnull;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.generated.DynamicColumnMetaDataProtos;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.SingleCellConstructorExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnFamilyImpl;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.SizedUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class PTableImpl
implements PTable {
    private static final Integer NO_SALTING = -1;
    private static final int VIEW_MODIFIED_UPDATE_CACHE_FREQUENCY_BIT_SET_POS = 0;
    private static final int VIEW_MODIFIED_USE_STATS_FOR_PARALLELIZATION_BIT_SET_POS = 1;
    private static final int VIEW_MODIFIED_PHOENIX_TTL_BIT_SET_POS = 2;
    private IndexMaintainer indexMaintainer;
    private ImmutableBytesWritable indexMaintainersPtr;
    private final PTableKey key;
    private final PName name;
    private final PName schemaName;
    private final PName tableName;
    private final PName tenantId;
    private final PTableType type;
    private final PIndexState state;
    private final long sequenceNumber;
    private final long timeStamp;
    private final long indexDisableTimestamp;
    private final List<PColumn> pkColumns;
    private final List<PColumn> allColumns;
    private final List<PColumn> excludedColumns;
    private final List<PColumnFamily> families;
    private final Map<byte[], PColumnFamily> familyByBytes;
    private final Map<String, PColumnFamily> familyByString;
    private final ListMultimap<String, PColumn> columnsByName;
    private final Map<KVColumnFamilyQualifier, PColumn> kvColumnsByQualifiers;
    private final PName pkName;
    private final Integer bucketNum;
    private final RowKeySchema rowKeySchema;
    private final List<PTable> indexes;
    private final PName parentName;
    private final PName parentSchemaName;
    private final PName parentTableName;
    private final List<PName> physicalNames;
    private final boolean isImmutableRows;
    private final PName defaultFamilyName;
    private final String viewStatement;
    private final boolean disableWAL;
    private final boolean multiTenant;
    private final boolean storeNulls;
    private final TransactionFactory.Provider transactionProvider;
    private final PTable.ViewType viewType;
    private final PDataType viewIndexIdType;
    private final Long viewIndexId;
    private final int estimatedSize;
    private final PTable.IndexType indexType;
    private final int baseColumnCount;
    private final boolean rowKeyOrderOptimizable;
    private final boolean hasColumnsRequiringUpgrade;
    private final int rowTimestampColPos;
    private final long updateCacheFrequency;
    private final boolean isNamespaceMapped;
    private final String autoPartitionSeqName;
    private final boolean isAppendOnlySchema;
    private final PTable.ImmutableStorageScheme immutableStorageScheme;
    private final PTable.QualifierEncodingScheme qualifierEncodingScheme;
    private final PTable.EncodedCQCounter encodedCQCounter;
    private final Boolean useStatsForParallelization;
    private final long phoenixTTL;
    private final long phoenixTTLHighWaterMark;
    private final BitSet viewModifiedPropSet;
    private final Long lastDDLTimestamp;
    private final boolean isChangeDetectionEnabled;
    private Map<String, String> propertyValues;

    @VisibleForTesting
    PTableImpl() {
        this(new Builder().setIndexes(Collections.emptyList()).setPhysicalNames(Collections.emptyList()).setRowKeySchema(RowKeySchema.EMPTY_SCHEMA));
    }

    private PTableImpl(Builder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.tenantId = builder.tenantId;
        this.type = builder.type;
        this.state = builder.state;
        this.sequenceNumber = builder.sequenceNumber;
        this.timeStamp = builder.timeStamp;
        this.indexDisableTimestamp = builder.indexDisableTimestamp;
        this.pkColumns = builder.pkColumns;
        this.allColumns = builder.allColumns;
        this.excludedColumns = builder.excludedColumns;
        this.families = builder.families;
        this.familyByBytes = builder.familyByBytes;
        this.familyByString = builder.familyByString;
        this.columnsByName = builder.columnsByName;
        this.kvColumnsByQualifiers = builder.kvColumnsByQualifiers;
        this.pkName = builder.pkName;
        this.bucketNum = builder.bucketNum;
        this.rowKeySchema = builder.rowKeySchema;
        this.indexes = builder.indexes;
        this.parentName = builder.parentName;
        this.parentSchemaName = builder.parentSchemaName;
        this.parentTableName = builder.parentTableName;
        this.physicalNames = builder.physicalNames;
        this.isImmutableRows = builder.isImmutableRows;
        this.indexMaintainer = builder.indexMaintainer;
        this.indexMaintainersPtr = builder.indexMaintainersPtr;
        this.defaultFamilyName = builder.defaultFamilyName;
        this.viewStatement = builder.viewStatement;
        this.disableWAL = builder.disableWAL;
        this.multiTenant = builder.multiTenant;
        this.storeNulls = builder.storeNulls;
        this.transactionProvider = builder.transactionProvider;
        this.viewType = builder.viewType;
        this.viewIndexIdType = builder.viewIndexIdType;
        this.viewIndexId = builder.viewIndexId;
        this.estimatedSize = builder.estimatedSize;
        this.indexType = builder.indexType;
        this.baseColumnCount = builder.baseColumnCount;
        this.rowKeyOrderOptimizable = builder.rowKeyOrderOptimizable;
        this.hasColumnsRequiringUpgrade = builder.hasColumnsRequiringUpgrade;
        this.rowTimestampColPos = builder.rowTimestampColPos;
        this.updateCacheFrequency = builder.updateCacheFrequency;
        this.isNamespaceMapped = builder.isNamespaceMapped;
        this.autoPartitionSeqName = builder.autoPartitionSeqName;
        this.isAppendOnlySchema = builder.isAppendOnlySchema;
        this.immutableStorageScheme = builder.immutableStorageScheme;
        this.qualifierEncodingScheme = builder.qualifierEncodingScheme;
        this.encodedCQCounter = builder.encodedCQCounter;
        this.useStatsForParallelization = builder.useStatsForParallelization;
        this.phoenixTTL = builder.phoenixTTL;
        this.phoenixTTLHighWaterMark = builder.phoenixTTLHighWaterMark;
        this.viewModifiedPropSet = builder.viewModifiedPropSet;
        this.propertyValues = builder.propertyValues;
        this.lastDDLTimestamp = builder.lastDDLTimestamp;
        this.isChangeDetectionEnabled = builder.isChangeDetectionEnabled;
    }

    public static List<PColumn> getColumnsToClone(PTable table) {
        return table == null ? Collections.emptyList() : (table.getBucketNum() == null ? table.getColumns() : table.getColumns().subList(1, table.getColumns().size()));
    }

    public static Builder builderWithColumns(PTable table, Collection<PColumn> columns) {
        return PTableImpl.builderFromExisting(table).setColumns(columns);
    }

    private static Builder builderFromExisting(PTable table) {
        return new Builder().setType(table.getType()).setState(table.getIndexState()).setTimeStamp(table.getTimeStamp()).setIndexDisableTimestamp(table.getIndexDisableTimestamp()).setSequenceNumber(table.getSequenceNumber()).setImmutableRows(table.isImmutableRows()).setViewStatement(table.getViewStatement()).setDisableWAL(table.isWALDisabled()).setMultiTenant(table.isMultiTenant()).setStoreNulls(table.getStoreNulls()).setViewType(table.getViewType()).setViewIndexIdType(table.getviewIndexIdType()).setViewIndexId(table.getViewIndexId()).setIndexType(table.getIndexType()).setTransactionProvider(table.getTransactionProvider()).setUpdateCacheFrequency(table.getUpdateCacheFrequency()).setNamespaceMapped(table.isNamespaceMapped()).setAutoPartitionSeqName(table.getAutoPartitionSeqName()).setAppendOnlySchema(table.isAppendOnlySchema()).setImmutableStorageScheme(table.getImmutableStorageScheme() == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : table.getImmutableStorageScheme()).setQualifierEncodingScheme(table.getEncodingScheme() == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : table.getEncodingScheme()).setBaseColumnCount(table.getBaseColumnCount()).setEncodedCQCounter(table.getEncodedCQCounter()).setUseStatsForParallelization(table.useStatsForParallelization()).setExcludedColumns((List<PColumn>)(table.getExcludedColumns() == null ? ImmutableList.of() : ImmutableList.copyOf(table.getExcludedColumns()))).setTenantId(table.getTenantId()).setSchemaName(table.getSchemaName()).setTableName(table.getTableName()).setPkName(table.getPKName()).setDefaultFamilyName(table.getDefaultFamilyName()).setRowKeyOrderOptimizable(table.rowKeyOrderOptimizable()).setBucketNum(table.getBucketNum()).setIndexes(table.getIndexes() == null ? Collections.emptyList() : table.getIndexes()).setParentSchemaName(table.getParentSchemaName()).setParentTableName(table.getParentTableName()).setPhysicalNames((List<PName>)(table.getPhysicalNames() == null ? ImmutableList.of() : ImmutableList.copyOf(table.getPhysicalNames()))).setViewModifiedUseStatsForParallelization(table.hasViewModifiedUseStatsForParallelization()).setViewModifiedUpdateCacheFrequency(table.hasViewModifiedUpdateCacheFrequency()).setViewModifiedPhoenixTTL(table.hasViewModifiedPhoenixTTL()).setPhoenixTTL(table.getPhoenixTTL()).setPhoenixTTLHighWaterMark(table.getPhoenixTTLHighWaterMark()).setLastDDLTimestamp(table.getLastDDLTimestamp()).setIsChangeDetectionEnabled(table.isChangeDetectionEnabled());
    }

    @Override
    public long getUpdateCacheFrequency() {
        return this.updateCacheFrequency;
    }

    @Override
    public boolean isMultiTenant() {
        return this.multiTenant;
    }

    @Override
    public boolean getStoreNulls() {
        return this.storeNulls;
    }

    @Override
    public PTable.ViewType getViewType() {
        return this.viewType;
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    public static void checkTenantId(PName tenantId) {
        Preconditions.checkArgument((tenantId == null || tenantId.getBytes().length > 0 ? 1 : 0) != 0);
    }

    @Override
    public boolean isImmutableRows() {
        return this.isImmutableRows;
    }

    public String toString() {
        return this.name.getString();
    }

    @Override
    public List<PColumn> getPKColumns() {
        return this.pkColumns;
    }

    @Override
    public final PName getName() {
        return this.name;
    }

    @Override
    public final PName getSchemaName() {
        return this.schemaName;
    }

    @Override
    public final PName getTableName() {
        return this.tableName;
    }

    @Override
    public final PTableType getType() {
        return this.type;
    }

    @Override
    public final List<PColumnFamily> getColumnFamilies() {
        return this.families;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int newKey(ImmutableBytesWritable key, byte[][] values) {
        int nValues;
        List<PColumn> columns = this.getPKColumns();
        for (nValues = values.length; nValues > 0 && (values[nValues - 1] == null || values[nValues - 1].length == 0); --nValues) {
        }
        for (PColumn column : columns) {
            if (column.getExpressionStr() == null) continue;
            ++nValues;
        }
        int i = 0;
        TrustedByteArrayOutputStream os = new TrustedByteArrayOutputStream(SchemaUtil.estimateKeyLength(this));
        try {
            PColumn column;
            Integer bucketNum = this.getBucketNum();
            if (bucketNum != null) {
                ++i;
                os.write(QueryConstants.SEPARATOR_BYTE_ARRAY);
            }
            int nColumns = columns.size();
            PDataType type = null;
            SortOrder sortOrder = null;
            boolean wasNull = false;
            while (i < nValues && i < nColumns) {
                byte[] byteValue;
                if (type != null && !type.isFixedWidth()) {
                    os.write(SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable(), wasNull, sortOrder));
                }
                column = columns.get(i);
                sortOrder = column.getSortOrder();
                type = column.getDataType();
                if ((byteValue = values[i++]) == null) {
                    if (column.getExpressionStr() != null) {
                        try {
                            String url = "jdbc:phoenix:none";
                            PhoenixConnection conn = DriverManager.getConnection(url).unwrap(PhoenixConnection.class);
                            StatementContext context = new StatementContext(new PhoenixStatement(conn));
                            ExpressionCompiler compiler = new ExpressionCompiler(context);
                            ParseNode defaultParseNode = new SQLParser(column.getExpressionStr()).parseExpression();
                            Expression defaultExpression = defaultParseNode.accept(compiler);
                            defaultExpression.evaluate(null, key);
                            column.getDataType().coerceBytes(key, null, defaultExpression.getDataType(), defaultExpression.getMaxLength(), defaultExpression.getScale(), defaultExpression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder());
                            byteValue = ByteUtil.copyKeyBytesIfNecessary(key);
                        }
                        catch (SQLException e) {
                            throw new ConstraintViolationException(this.name.getString() + "." + column.getName().getString() + " failed to compile default value expression of " + column.getExpressionStr());
                        }
                    } else {
                        byteValue = ByteUtil.EMPTY_BYTE_ARRAY;
                    }
                }
                boolean bl = wasNull = byteValue.length == 0;
                if (byteValue.length == 0 && !column.isNullable()) {
                    throw new ConstraintViolationException(this.name.getString() + "." + column.getName().getString() + " may not be null");
                }
                Integer maxLength = column.getMaxLength();
                Integer scale = column.getScale();
                key.set(byteValue);
                if (!type.isSizeCompatible(key, null, type, sortOrder, null, null, maxLength, scale)) {
                    throw new DataExceedsCapacityException(column.getDataType(), maxLength, column.getScale(), column.getName().getString());
                }
                key.set(byteValue);
                type.pad(key, maxLength, sortOrder);
                byteValue = ByteUtil.copyKeyBytesIfNecessary(key);
                os.write(byteValue, 0, byteValue.length);
            }
            if (type != null && !type.isFixedWidth() && SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable(), wasNull, sortOrder) == QueryConstants.DESC_SEPARATOR_BYTE) {
                os.write(QueryConstants.DESC_SEPARATOR_BYTE);
            }
            if (i < nColumns && ((column = columns.get(i)).getDataType().isFixedWidth() || !column.isNullable())) {
                throw new ConstraintViolationException(this.name.getString() + "." + column.getName().getString() + " may not be null");
            }
            if (nValues == 0) {
                throw new ConstraintViolationException("Primary key may not be null (" + this.name.getString() + ")");
            }
            byte[] buf = os.getBuffer();
            int size = os.size();
            if (bucketNum != null) {
                buf[0] = SaltingUtil.getSaltingByte(buf, 1, size - 1, bucketNum);
            }
            key.set(buf, 0, size);
            int n = i;
            return n;
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private PRow newRow(KeyValueBuilder builder, long ts, ImmutableBytesWritable key, int i, boolean hasOnDupKey, byte[] ... values) {
        PRowImpl row = new PRowImpl(builder, key, ts, this.getBucketNum(), hasOnDupKey);
        if (i < values.length) {
            for (PColumnFamily family : this.getColumnFamilies()) {
                for (PColumn column : family.getColumns()) {
                    row.setValue(column, values[i++]);
                    if (i != values.length) continue;
                    return row;
                }
            }
        }
        return row;
    }

    @Override
    public PRow newRow(KeyValueBuilder builder, long ts, ImmutableBytesWritable key, boolean hasOnDupKey, byte[] ... values) {
        return this.newRow(builder, ts, key, 0, hasOnDupKey, values);
    }

    @Override
    public PRow newRow(KeyValueBuilder builder, ImmutableBytesWritable key, boolean hasOnDupKey, byte[] ... values) {
        return this.newRow(builder, Long.MAX_VALUE, key, hasOnDupKey, values);
    }

    @Override
    public PColumn getColumnForColumnName(String name) throws ColumnNotFoundException, AmbiguousColumnException {
        List columns = this.columnsByName.get((Object)name);
        int size = columns.size();
        if (size == 0) {
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, name);
        }
        if (size > 1) {
            for (PColumn column : columns) {
                if (column.getFamilyName() != null && !"0".equals(column.getFamilyName().getString())) continue;
                return column;
            }
            throw new AmbiguousColumnException(name);
        }
        return (PColumn)columns.get(0);
    }

    @Override
    public PColumn getColumnForColumnQualifier(byte[] cf, byte[] cq) throws ColumnNotFoundException, AmbiguousColumnException {
        Preconditions.checkNotNull((Object)cq);
        if (!EncodedColumnsUtil.usesEncodedColumnNames(this) || cf == null) {
            String columnName = (String)PVarchar.INSTANCE.toObject(cq);
            return this.getColumnForColumnName(columnName);
        }
        String family = (String)PVarchar.INSTANCE.toObject(cf);
        PColumn col = this.kvColumnsByQualifiers.get(new KVColumnFamilyQualifier(family, cq));
        if (col == null) {
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, "No column found for column qualifier " + this.qualifierEncodingScheme.decode(cq));
        }
        return col;
    }

    @Override
    public PColumnFamily getColumnFamily(String familyName) throws ColumnFamilyNotFoundException {
        PColumnFamily family = this.familyByString.get(familyName);
        if (family == null) {
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnFamilyNotFoundException(schemaNameStr, tableNameStr, familyName);
        }
        return family;
    }

    @Override
    public PColumnFamily getColumnFamily(byte[] familyBytes) throws ColumnFamilyNotFoundException {
        PColumnFamily family = this.familyByBytes.get(familyBytes);
        if (family == null) {
            String familyName = Bytes.toString((byte[])familyBytes);
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnFamilyNotFoundException(schemaNameStr, tableNameStr, familyName);
        }
        return family;
    }

    @Override
    public List<PColumn> getColumns() {
        return this.allColumns;
    }

    @Override
    public List<PColumn> getExcludedColumns() {
        return this.excludedColumns;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getIndexDisableTimestamp() {
        return this.indexDisableTimestamp;
    }

    @Override
    public PColumn getPKColumn(String name) throws ColumnNotFoundException {
        List columns = this.columnsByName.get((Object)name);
        int size = columns.size();
        if (size == 0) {
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, name);
        }
        if (size > 1) {
            do {
                PColumn column;
                if ((column = (PColumn)columns.get(--size)).getFamilyName() != null) continue;
                return column;
            } while (size > 0);
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, name);
        }
        return (PColumn)columns.get(0);
    }

    @Override
    public PName getPKName() {
        return this.pkName;
    }

    @Override
    public RowKeySchema getRowKeySchema() {
        return this.rowKeySchema;
    }

    @Override
    public Integer getBucketNum() {
        return this.bucketNum;
    }

    @Override
    public List<PTable> getIndexes() {
        return this.indexes;
    }

    @Override
    public PIndexState getIndexState() {
        return this.state;
    }

    @Override
    public PName getParentTableName() {
        return this.type != PTableType.VIEW || this.parentName != null ? this.parentTableName : PNameFactory.newName(SchemaUtil.getTableNameFromFullName(this.getPhysicalName().getBytes()));
    }

    @Override
    public PName getParentName() {
        return this.type != PTableType.VIEW || this.parentName != null ? this.parentName : this.getPhysicalName();
    }

    @Override
    public synchronized IndexMaintainer getIndexMaintainer(PTable dataTable, PhoenixConnection connection) {
        if (this.indexMaintainer == null) {
            this.indexMaintainer = IndexMaintainer.create(dataTable, this, connection);
        }
        return this.indexMaintainer;
    }

    @Override
    public synchronized boolean getIndexMaintainers(ImmutableBytesWritable ptr, PhoenixConnection connection) {
        if (this.indexMaintainersPtr == null || this.indexMaintainersPtr.getLength() == 0) {
            this.indexMaintainersPtr = new ImmutableBytesWritable();
            if (this.indexes.isEmpty()) {
                this.indexMaintainersPtr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            } else {
                IndexMaintainer.serialize(this, this.indexMaintainersPtr, connection);
            }
        }
        ptr.set(this.indexMaintainersPtr.get(), this.indexMaintainersPtr.getOffset(), this.indexMaintainersPtr.getLength());
        return this.indexMaintainersPtr.getLength() > 0;
    }

    @Override
    public PName getPhysicalName() {
        if (this.physicalNames.isEmpty()) {
            return SchemaUtil.getPhysicalHBaseTableName(this.schemaName, this.tableName, this.isNamespaceMapped);
        }
        return PNameFactory.newName(this.physicalNames.get(0).getBytes());
    }

    @Override
    public List<PName> getPhysicalNames() {
        return !this.physicalNames.isEmpty() ? this.physicalNames : Lists.newArrayList((Object[])new PName[]{this.getPhysicalName()});
    }

    @Override
    public PName getDefaultFamilyName() {
        return this.defaultFamilyName;
    }

    @Override
    public String getViewStatement() {
        return this.viewStatement;
    }

    @Override
    public boolean isWALDisabled() {
        return this.disableWAL;
    }

    @Override
    public Long getViewIndexId() {
        return this.viewIndexId;
    }

    @Override
    public PDataType getviewIndexIdType() {
        return this.viewIndexIdType;
    }

    @Override
    public PName getTenantId() {
        return this.tenantId;
    }

    @Override
    public PTable.IndexType getIndexType() {
        return this.indexType;
    }

    public static PTable createFromProto(PTableProtos.PTable table) {
        PTable.EncodedCQCounter encodedColumnQualifierCounter;
        if (table == null) {
            return null;
        }
        PName tenantId = null;
        if (table.hasTenantId()) {
            tenantId = PNameFactory.newName(table.getTenantId().toByteArray());
        }
        PName schemaName = PNameFactory.newName(table.getSchemaNameBytes().toByteArray());
        PName tableName = PNameFactory.newName(table.getTableNameBytes().toByteArray());
        PTableType tableType = PTableType.values()[table.getTableType().ordinal()];
        PIndexState indexState = null;
        if (table.hasIndexState()) {
            indexState = PIndexState.fromSerializedValue(table.getIndexState());
        }
        Long viewIndexId = null;
        if (table.hasViewIndexId()) {
            viewIndexId = table.getViewIndexId();
        }
        PDataType viewIndexIdType = table.hasViewIndexIdType() ? PDataType.fromTypeId(table.getViewIndexIdType()) : MetaDataUtil.getLegacyViewIndexIdDataType();
        PTable.IndexType indexType = PTable.IndexType.getDefault();
        if (table.hasIndexType()) {
            indexType = PTable.IndexType.fromSerializedValue(table.getIndexType().toByteArray()[0]);
        }
        long sequenceNumber = table.getSequenceNumber();
        long timeStamp = table.getTimeStamp();
        long indexDisableTimestamp = table.getIndexDisableTimestamp();
        PName pkName = null;
        if (table.hasPkNameBytes()) {
            pkName = PNameFactory.newName(table.getPkNameBytes().toByteArray());
        }
        int bucketNum = table.getBucketNum();
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)table.getColumnsCount());
        for (PTableProtos.PColumn pColumn : table.getColumnsList()) {
            columns.add(PColumnImpl.createFromProto(pColumn));
        }
        ArrayList indexes = Lists.newArrayListWithExpectedSize((int)table.getIndexesCount());
        for (PTableProtos.PTable curPTableProto : table.getIndexesList()) {
            indexes.add(PTableImpl.createFromProto(curPTableProto));
        }
        boolean bl = table.getIsImmutableRows();
        PName parentSchemaName = null;
        PName parentTableName = null;
        if (table.hasParentNameBytes()) {
            parentSchemaName = PNameFactory.newName(SchemaUtil.getSchemaNameFromFullName(table.getParentNameBytes().toByteArray()));
            parentTableName = PNameFactory.newName(SchemaUtil.getTableNameFromFullName(table.getParentNameBytes().toByteArray()));
        }
        PName defaultFamilyName = null;
        if (table.hasDefaultFamilyName()) {
            defaultFamilyName = PNameFactory.newName(table.getDefaultFamilyName().toByteArray());
        }
        boolean disableWAL = table.getDisableWAL();
        boolean multiTenant = table.getMultiTenant();
        boolean storeNulls = table.getStoreNulls();
        TransactionFactory.Provider transactionProvider = null;
        if (table.hasTransactionProvider()) {
            transactionProvider = TransactionFactory.Provider.fromCode(table.getTransactionProvider());
        } else if (table.hasTransactional()) {
            transactionProvider = TransactionFactory.Provider.TEPHRA;
        }
        PTable.ViewType viewType = null;
        String viewStatement = null;
        if (tableType == PTableType.VIEW) {
            viewType = PTable.ViewType.fromSerializedValue(table.getViewType().toByteArray()[0]);
        }
        if (table.hasViewStatement()) {
            viewStatement = (String)PVarchar.INSTANCE.toObject(table.getViewStatement().toByteArray());
        }
        ArrayList physicalNames = Lists.newArrayListWithExpectedSize((int)table.getPhysicalNamesCount());
        for (int i = 0; i < table.getPhysicalNamesCount(); ++i) {
            physicalNames.add(PNameFactory.newName(table.getPhysicalNames(i).toByteArray()));
        }
        int baseColumnCount = -1;
        if (table.hasBaseColumnCount()) {
            baseColumnCount = table.getBaseColumnCount();
        }
        boolean rowKeyOrderOptimizable = false;
        if (table.hasRowKeyOrderOptimizable()) {
            rowKeyOrderOptimizable = table.getRowKeyOrderOptimizable();
        }
        long updateCacheFrequency = 0L;
        if (table.hasUpdateCacheFrequency()) {
            updateCacheFrequency = table.getUpdateCacheFrequency();
        }
        boolean isNamespaceMapped = false;
        if (table.hasIsNamespaceMapped()) {
            isNamespaceMapped = table.getIsNamespaceMapped();
        }
        String autoPartitionSeqName = null;
        if (table.hasAutoParititonSeqName()) {
            autoPartitionSeqName = table.getAutoParititonSeqName();
        }
        boolean isAppendOnlySchema = false;
        if (table.hasIsAppendOnlySchema()) {
            isAppendOnlySchema = table.getIsAppendOnlySchema();
        }
        PTable.ImmutableStorageScheme storageScheme = PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN;
        if (table.hasStorageScheme()) {
            storageScheme = PTable.ImmutableStorageScheme.fromSerializedValue(table.getStorageScheme().toByteArray()[0]);
        }
        PTable.QualifierEncodingScheme qualifierEncodingScheme = PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
        if (table.hasEncodingScheme()) {
            qualifierEncodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue(table.getEncodingScheme().toByteArray()[0]);
        }
        if (!EncodedColumnsUtil.usesEncodedColumnNames(qualifierEncodingScheme) || tableType == PTableType.VIEW) {
            encodedColumnQualifierCounter = PTable.EncodedCQCounter.NULL_COUNTER;
        } else {
            encodedColumnQualifierCounter = new PTable.EncodedCQCounter();
            if (table.getEncodedCQCountersList() != null) {
                for (PTableProtos.EncodedCQCounter cqCounterFromProto : table.getEncodedCQCountersList()) {
                    encodedColumnQualifierCounter.setValue(cqCounterFromProto.getColFamily(), cqCounterFromProto.getCounter());
                }
            }
        }
        Boolean useStatsForParallelization = null;
        if (table.hasUseStatsForParallelization()) {
            useStatsForParallelization = table.getUseStatsForParallelization();
        }
        long phoenixTTL = 0L;
        if (table.hasPhoenixTTL()) {
            phoenixTTL = table.getPhoenixTTL();
        }
        long phoenixTTLHighWaterMark = 0L;
        if (table.hasPhoenixTTLHighWaterMark()) {
            phoenixTTLHighWaterMark = table.getPhoenixTTLHighWaterMark();
        }
        boolean viewModifiedUpdateCacheFrequency = true;
        boolean viewModifiedUseStatsForParallelization = true;
        boolean viewModifiedPhoenixTTL = true;
        if (table.hasViewModifiedUpdateCacheFrequency()) {
            viewModifiedUpdateCacheFrequency = table.getViewModifiedUpdateCacheFrequency();
        }
        if (table.hasViewModifiedUseStatsForParallelization()) {
            viewModifiedUseStatsForParallelization = table.getViewModifiedUseStatsForParallelization();
        }
        if (table.hasViewModifiedPhoenixTTL()) {
            viewModifiedPhoenixTTL = table.getViewModifiedPhoenixTTL();
        }
        Long lastDDLTimestamp = null;
        if (table.hasLastDDLTimestamp()) {
            lastDDLTimestamp = table.getLastDDLTimestamp();
        }
        boolean isChangeDetectionEnabled = false;
        if (table.hasChangeDetectionEnabled()) {
            isChangeDetectionEnabled = table.getChangeDetectionEnabled();
        }
        try {
            return new Builder().setType(tableType).setState(indexState).setTimeStamp(timeStamp).setIndexDisableTimestamp(indexDisableTimestamp).setSequenceNumber(sequenceNumber).setImmutableRows(bl).setViewStatement(viewStatement).setDisableWAL(disableWAL).setMultiTenant(multiTenant).setStoreNulls(storeNulls).setViewType(viewType).setViewIndexIdType(viewIndexIdType).setViewIndexId(viewIndexId).setIndexType(indexType).setTransactionProvider(transactionProvider).setUpdateCacheFrequency(updateCacheFrequency).setNamespaceMapped(isNamespaceMapped).setAutoPartitionSeqName(autoPartitionSeqName).setAppendOnlySchema(isAppendOnlySchema).setImmutableStorageScheme(storageScheme == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : storageScheme).setQualifierEncodingScheme(qualifierEncodingScheme == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : qualifierEncodingScheme).setBaseColumnCount(baseColumnCount).setEncodedCQCounter(encodedColumnQualifierCounter).setUseStatsForParallelization(useStatsForParallelization).setPhoenixTTL(phoenixTTL).setPhoenixTTLHighWaterMark(phoenixTTLHighWaterMark).setExcludedColumns((List<PColumn>)ImmutableList.of()).setTenantId(tenantId).setSchemaName(schemaName).setTableName(tableName).setPkName(pkName).setDefaultFamilyName(defaultFamilyName).setRowKeyOrderOptimizable(rowKeyOrderOptimizable).setBucketNum(bucketNum == NO_SALTING ? null : Integer.valueOf(bucketNum)).setIndexes(indexes == null ? Collections.emptyList() : indexes).setParentSchemaName(parentSchemaName).setParentTableName(parentTableName).setPhysicalNames((List<PName>)(physicalNames == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)physicalNames))).setColumns(columns).setViewModifiedUpdateCacheFrequency(viewModifiedUpdateCacheFrequency).setViewModifiedUseStatsForParallelization(viewModifiedUseStatsForParallelization).setViewModifiedPhoenixTTL(viewModifiedPhoenixTTL).setLastDDLTimestamp(lastDDLTimestamp).setIsChangeDetectionEnabled(isChangeDetectionEnabled).build();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static PTableProtos.PTable toProto(PTable table) {
        PTableProtos.PTable.Builder builder = PTableProtos.PTable.newBuilder();
        if (table.getTenantId() != null) {
            builder.setTenantId(ByteStringer.wrap((byte[])table.getTenantId().getBytes()));
        }
        builder.setSchemaNameBytes(ByteStringer.wrap((byte[])table.getSchemaName().getBytes()));
        builder.setTableNameBytes(ByteStringer.wrap((byte[])table.getTableName().getBytes()));
        builder.setTableType(ProtobufUtil.toPTableTypeProto(table.getType()));
        if (table.getType() == PTableType.INDEX) {
            if (table.getIndexState() != null) {
                builder.setIndexState(table.getIndexState().getSerializedValue());
            }
            if (table.getViewIndexId() != null) {
                builder.setViewIndexId(table.getViewIndexId());
                builder.setViewIndexIdType(table.getviewIndexIdType().getSqlType());
            }
            if (table.getIndexType() != null) {
                builder.setIndexType(ByteStringer.wrap((byte[])new byte[]{table.getIndexType().getSerializedValue()}));
            }
        }
        builder.setSequenceNumber(table.getSequenceNumber());
        builder.setTimeStamp(table.getTimeStamp());
        PName tmp = table.getPKName();
        if (tmp != null) {
            builder.setPkNameBytes(ByteStringer.wrap((byte[])tmp.getBytes()));
        }
        Integer bucketNum = table.getBucketNum();
        int offset = 0;
        if (bucketNum == null) {
            builder.setBucketNum(NO_SALTING);
        } else {
            offset = 1;
            builder.setBucketNum(bucketNum);
        }
        List<PColumn> columns = table.getColumns();
        int columnSize = columns.size();
        for (int i = offset; i < columnSize; ++i) {
            PColumn column = columns.get(i);
            builder.addColumns(PColumnImpl.toProto(column));
        }
        List<PTable> indexes = table.getIndexes();
        for (PTable curIndex : indexes) {
            builder.addIndexes(PTableImpl.toProto(curIndex));
        }
        builder.setIsImmutableRows(table.isImmutableRows());
        if (table.getParentName() != null) {
            builder.setDataTableNameBytes(ByteStringer.wrap((byte[])table.getParentTableName().getBytes()));
        }
        if (table.getParentName() != null) {
            builder.setParentNameBytes(ByteStringer.wrap((byte[])table.getParentName().getBytes()));
        }
        if (table.getDefaultFamilyName() != null) {
            builder.setDefaultFamilyName(ByteStringer.wrap((byte[])table.getDefaultFamilyName().getBytes()));
        }
        builder.setDisableWAL(table.isWALDisabled());
        builder.setMultiTenant(table.isMultiTenant());
        builder.setStoreNulls(table.getStoreNulls());
        if (table.getTransactionProvider() != null) {
            builder.setTransactionProvider(table.getTransactionProvider().getCode());
        }
        if (table.getType() == PTableType.VIEW) {
            builder.setViewType(ByteStringer.wrap((byte[])new byte[]{table.getViewType().getSerializedValue()}));
        }
        if (table.getViewStatement() != null) {
            builder.setViewStatement(ByteStringer.wrap((byte[])PVarchar.INSTANCE.toBytes(table.getViewStatement())));
        }
        for (int i = 0; i < table.getPhysicalNames().size(); ++i) {
            builder.addPhysicalNames(ByteStringer.wrap((byte[])table.getPhysicalNames().get(i).getBytes()));
        }
        builder.setBaseColumnCount(table.getBaseColumnCount());
        builder.setRowKeyOrderOptimizable(table.rowKeyOrderOptimizable());
        builder.setUpdateCacheFrequency(table.getUpdateCacheFrequency());
        builder.setIndexDisableTimestamp(table.getIndexDisableTimestamp());
        builder.setIsNamespaceMapped(table.isNamespaceMapped());
        if (table.getAutoPartitionSeqName() != null) {
            builder.setAutoParititonSeqName(table.getAutoPartitionSeqName());
        }
        builder.setIsAppendOnlySchema(table.isAppendOnlySchema());
        if (table.getImmutableStorageScheme() != null) {
            builder.setStorageScheme(ByteStringer.wrap((byte[])new byte[]{table.getImmutableStorageScheme().getSerializedMetadataValue()}));
        }
        if (table.getEncodedCQCounter() != null) {
            Map<String, Integer> values = table.getEncodedCQCounter().values();
            for (Map.Entry<String, Integer> cqCounter : values.entrySet()) {
                PTableProtos.EncodedCQCounter.Builder cqBuilder = PTableProtos.EncodedCQCounter.newBuilder();
                cqBuilder.setColFamily(cqCounter.getKey());
                cqBuilder.setCounter(cqCounter.getValue());
                builder.addEncodedCQCounters(cqBuilder.build());
            }
        }
        if (table.getEncodingScheme() != null) {
            builder.setEncodingScheme(ByteStringer.wrap((byte[])new byte[]{table.getEncodingScheme().getSerializedMetadataValue()}));
        }
        if (table.useStatsForParallelization() != null) {
            builder.setUseStatsForParallelization(table.useStatsForParallelization());
        }
        builder.setPhoenixTTL(table.getPhoenixTTL());
        builder.setPhoenixTTLHighWaterMark(table.getPhoenixTTLHighWaterMark());
        builder.setViewModifiedUpdateCacheFrequency(table.hasViewModifiedUpdateCacheFrequency());
        builder.setViewModifiedUseStatsForParallelization(table.hasViewModifiedUseStatsForParallelization());
        builder.setViewModifiedPhoenixTTL(table.hasViewModifiedPhoenixTTL());
        if (table.getLastDDLTimestamp() != null) {
            builder.setLastDDLTimestamp(table.getLastDDLTimestamp());
        }
        builder.setChangeDetectionEnabled(table.isChangeDetectionEnabled());
        return builder.build();
    }

    @Override
    public PTableKey getKey() {
        return this.key;
    }

    @Override
    public PName getParentSchemaName() {
        return this.type != PTableType.VIEW || this.parentName != null ? this.parentSchemaName : PNameFactory.newName(SchemaUtil.getSchemaNameFromFullName(this.getPhysicalName().getBytes()));
    }

    @Override
    public TransactionFactory.Provider getTransactionProvider() {
        return this.transactionProvider;
    }

    @Override
    public final boolean isTransactional() {
        return this.transactionProvider != null;
    }

    @Override
    public int getBaseColumnCount() {
        return this.baseColumnCount;
    }

    @Override
    public boolean rowKeyOrderOptimizable() {
        return this.rowKeyOrderOptimizable || !this.hasColumnsRequiringUpgrade;
    }

    @Override
    public int getRowTimestampColPos() {
        return this.rowTimestampColPos;
    }

    @Override
    public boolean isNamespaceMapped() {
        return this.isNamespaceMapped;
    }

    @Override
    public String getAutoPartitionSeqName() {
        return this.autoPartitionSeqName;
    }

    @Override
    public boolean isAppendOnlySchema() {
        return this.isAppendOnlySchema;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PTable)) {
            return false;
        }
        PTable other = (PTable)obj;
        return !(this.key == null ? other.getKey() != null : !this.key.equals(other.getKey()));
    }

    @Override
    public PTable.ImmutableStorageScheme getImmutableStorageScheme() {
        return this.immutableStorageScheme;
    }

    @Override
    public PTable.EncodedCQCounter getEncodedCQCounter() {
        return this.encodedCQCounter;
    }

    @Override
    public PTable.QualifierEncodingScheme getEncodingScheme() {
        return this.qualifierEncodingScheme;
    }

    @Override
    public Boolean useStatsForParallelization() {
        return this.useStatsForParallelization;
    }

    @Override
    public long getPhoenixTTL() {
        return this.phoenixTTL;
    }

    @Override
    public long getPhoenixTTLHighWaterMark() {
        return this.phoenixTTLHighWaterMark;
    }

    @Override
    public boolean hasViewModifiedUpdateCacheFrequency() {
        return this.viewModifiedPropSet.get(0);
    }

    @Override
    public boolean hasViewModifiedUseStatsForParallelization() {
        return this.viewModifiedPropSet.get(1);
    }

    @Override
    public boolean hasViewModifiedPhoenixTTL() {
        return this.viewModifiedPropSet.get(2);
    }

    @Override
    public Long getLastDDLTimestamp() {
        return this.lastDDLTimestamp;
    }

    @Override
    public boolean isChangeDetectionEnabled() {
        return this.isChangeDetectionEnabled;
    }

    @Override
    public Map<String, String> getPropertyValues() {
        return Collections.unmodifiableMap(this.propertyValues);
    }

    @Override
    public Map<String, String> getDefaultPropertyValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("DISABLE_WAL", String.valueOf(false));
        map.put("IMMUTABLE_ROWS", String.valueOf(false));
        map.put("TRANSACTION_PROVIDER", QueryServicesOptions.DEFAULT_TRANSACTION_PROVIDER);
        map.put("IMMUTABLE_STORAGE_SCHEME", QueryServicesOptions.DEFAULT_IMMUTABLE_STORAGE_SCHEME);
        map.put("COLUMN_ENCODED_BYTES", String.valueOf(QueryServicesOptions.DEFAULT_COLUMN_ENCODED_BYTES));
        map.put("UPDATE_CACHE_FREQUENCY", String.valueOf(0L));
        map.put("USE_STATS_FOR_PARALLELIZATION", String.valueOf(true));
        map.put("TRANSACTIONAL", String.valueOf(false));
        map.put("MULTI_TENANT", String.valueOf(false));
        map.put("SALT_BUCKETS", String.valueOf(0));
        map.put("DEFAULT_COLUMN_FAMILY", String.valueOf((Object)TableProperty.DEFAULT_COLUMN_FAMILY));
        return Collections.unmodifiableMap(map);
    }

    private static final class KVColumnFamilyQualifier {
        @Nonnull
        private final String colFamilyName;
        @Nonnull
        private final byte[] colQualifier;

        public KVColumnFamilyQualifier(String colFamilyName, byte[] colQualifier) {
            Preconditions.checkArgument((colFamilyName != null && colQualifier != null ? 1 : 0) != 0, (Object)"None of the arguments, column family name or column qualifier can be null");
            this.colFamilyName = colFamilyName;
            this.colQualifier = colQualifier;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.colFamilyName.hashCode();
            result = 31 * result + Arrays.hashCode(this.colQualifier);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KVColumnFamilyQualifier other = (KVColumnFamilyQualifier)obj;
            if (!this.colFamilyName.equals(other.colFamilyName)) {
                return false;
            }
            return Arrays.equals(this.colQualifier, other.colQualifier);
        }
    }

    private class PRowImpl
    implements PRow {
        private final byte[] key;
        private final ImmutableBytesWritable keyPtr;
        private final KeyValueBuilder kvBuilder;
        private Mutation setValues;
        private Delete unsetValues;
        private Mutation deleteRow;
        private final long ts;
        private final boolean hasOnDupKey;
        private Map<PColumn, byte[]> columnToValueMap;
        private Map<String, List<PColumn>> colFamToDynamicColumnsMapping;

        PRowImpl(KeyValueBuilder kvBuilder, ImmutableBytesWritable key, long ts, Integer bucketNum, boolean hasOnDupKey) {
            this.kvBuilder = kvBuilder;
            this.ts = ts;
            this.hasOnDupKey = hasOnDupKey;
            if (bucketNum != null) {
                this.key = SaltingUtil.getSaltedKey(key, bucketNum);
                this.keyPtr = new ImmutableBytesPtr(this.key);
            } else {
                this.keyPtr = new ImmutableBytesPtr(key);
                this.key = ByteUtil.copyKeyBytesIfNecessary(key);
            }
            this.columnToValueMap = Maps.newHashMapWithExpectedSize((int)1);
            this.colFamToDynamicColumnsMapping = Maps.newHashMapWithExpectedSize((int)1);
            this.newMutations();
        }

        private void newMutations() {
            Increment put = this.hasOnDupKey ? new Increment(this.key) : new Put(this.key);
            Delete delete = new Delete(this.key);
            if (PTableImpl.this.isWALDisabled()) {
                put.setDurability(Durability.SKIP_WAL);
                delete.setDurability(Durability.SKIP_WAL);
            }
            this.setValues = put;
            this.unsetValues = delete;
        }

        @Override
        public List<Mutation> toRowMutations() {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(3);
            if (this.deleteRow != null) {
                mutations.add(this.deleteRow);
            } else {
                if (PTableImpl.this.immutableStorageScheme != null && PTableImpl.this.immutableStorageScheme != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                    Put put = new Put(this.key);
                    if (PTableImpl.this.isWALDisabled()) {
                        put.setDurability(Durability.SKIP_WAL);
                    }
                    for (PColumnFamily family : PTableImpl.this.families) {
                        byte[] columnFamily = family.getName().getBytes();
                        Collection<PColumn> columns = family.getColumns();
                        int maxEncodedColumnQualifier = Integer.MIN_VALUE;
                        for (PColumn pColumn : columns) {
                            int qualifier = PTableImpl.this.qualifierEncodingScheme.decode(pColumn.getColumnQualifierBytes());
                            maxEncodedColumnQualifier = Math.max(maxEncodedColumnQualifier, qualifier);
                        }
                        Expression[] colValues = EncodedColumnsUtil.createColumnExpressionArray(maxEncodedColumnQualifier);
                        for (PColumn column3 : columns) {
                            if (!this.columnToValueMap.containsKey(column3)) continue;
                            int colIndex = PTableImpl.this.qualifierEncodingScheme.decode(column3.getColumnQualifierBytes()) - 11 + 1;
                            colValues[colIndex] = new LiteralExpression(this.columnToValueMap.get(column3));
                        }
                        List<Expression> list = Arrays.asList(colValues);
                        SingleCellConstructorExpression singleCellConstructorExpression = new SingleCellConstructorExpression(PTableImpl.this.immutableStorageScheme, list);
                        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                        singleCellConstructorExpression.evaluate(null, ptr);
                        ImmutableBytesPtr colFamilyPtr = new ImmutableBytesPtr(columnFamily);
                        KeyValueBuilder.addQuietly((Mutation)put, this.kvBuilder.buildPut(this.keyPtr, colFamilyPtr, QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES_PTR, this.ts, ptr));
                    }
                    Map attrsMap = this.setValues.getAttributesMap();
                    this.setValues = put;
                    for (String attrKey : attrsMap.keySet()) {
                        this.setValues.setAttribute(attrKey, (byte[])attrsMap.get(attrKey));
                    }
                }
                Pair<byte[], byte[]> emptyKvInfo = EncodedColumnsUtil.getEmptyKeyValueInfo(PTableImpl.this);
                KeyValueBuilder.addQuietly(this.setValues, this.kvBuilder.buildPut(this.keyPtr, SchemaUtil.getEmptyColumnFamilyPtr(PTableImpl.this), new ImmutableBytesPtr((byte[])emptyKvInfo.getFirst()), this.ts, new ImmutableBytesPtr((byte[])emptyKvInfo.getSecond())));
                mutations.add(this.setValues);
                if (!this.unsetValues.isEmpty()) {
                    mutations.add((Mutation)this.unsetValues);
                }
            }
            return mutations;
        }

        private void removeIfPresent(Mutation m, byte[] family, byte[] qualifier) {
            NavigableMap familyMap = m.getFamilyCellMap();
            List kvs = (List)familyMap.get(family);
            if (kvs != null) {
                Iterator iterator = kvs.iterator();
                while (iterator.hasNext()) {
                    Cell kv = (Cell)iterator.next();
                    if (Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])qualifier, (int)0, (int)qualifier.length) != 0) continue;
                    iterator.remove();
                    break;
                }
            }
        }

        @Override
        public void setValue(PColumn column, byte[] byteValue) {
            boolean isNull;
            this.deleteRow = null;
            byte[] family = column.getFamilyName().getBytes();
            byte[] qualifier = column.getColumnQualifierBytes();
            ImmutableBytesPtr qualifierPtr = new ImmutableBytesPtr(qualifier);
            PDataType type = column.getDataType();
            if (byteValue == null) {
                byteValue = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            if ((isNull = type.isNull(byteValue)) && !column.isNullable()) {
                throw new ConstraintViolationException(PTableImpl.this.name.getString() + "." + column.getName().getString() + " may not be null");
            }
            if (isNull && PTableImpl.this.isImmutableRows() && column.getExpressionStr() == null) {
                this.removeIfPresent(this.setValues, family, qualifier);
                this.removeIfPresent((Mutation)this.unsetValues, family, qualifier);
            } else if (isNull && !PTableImpl.this.getStoreNulls() && !this.hasOnDupKey && column.getExpressionStr() == null) {
                this.removeIfPresent(this.setValues, family, qualifier);
                KeyValueBuilder.deleteQuietly(this.unsetValues, this.kvBuilder, this.kvBuilder.buildDeleteColumns(this.keyPtr, column.getFamilyName().getBytesPtr(), qualifierPtr, this.ts));
            } else {
                ImmutableBytesWritable ptr = new ImmutableBytesWritable(byteValue);
                Integer maxLength = column.getMaxLength();
                Integer scale = column.getScale();
                SortOrder sortOrder = column.getSortOrder();
                if (!type.isSizeCompatible(ptr, null, type, sortOrder, null, null, maxLength, scale)) {
                    throw new DataExceedsCapacityException(column.getDataType(), maxLength, column.getScale(), column.getName().getString());
                }
                ptr.set(byteValue);
                type.pad(ptr, maxLength, sortOrder);
                this.removeIfPresent((Mutation)this.unsetValues, family, qualifier);
                if (PTableImpl.this.immutableStorageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
                    this.columnToValueMap.put(column, ptr.get());
                } else {
                    this.removeIfPresent((Mutation)this.unsetValues, family, qualifier);
                    KeyValueBuilder.addQuietly(this.setValues, this.kvBuilder.buildPut(this.keyPtr, column.getFamilyName().getBytesPtr(), qualifierPtr, this.ts, ptr));
                }
                String fam = Bytes.toString((byte[])family);
                if (column.isDynamic()) {
                    if (!this.colFamToDynamicColumnsMapping.containsKey(fam)) {
                        this.colFamToDynamicColumnsMapping.put(fam, new ArrayList());
                    }
                    this.colFamToDynamicColumnsMapping.get(fam).add(column);
                }
            }
        }

        @Override
        public boolean setAttributesForDynamicColumnsIfReqd() {
            if (this.colFamToDynamicColumnsMapping == null || this.colFamToDynamicColumnsMapping.isEmpty()) {
                return false;
            }
            boolean attrsForDynColsSet = false;
            for (Map.Entry<String, List<PColumn>> colFamToDynColsList : this.colFamToDynamicColumnsMapping.entrySet()) {
                DynamicColumnMetaDataProtos.DynamicColumnMetaData.Builder builder = DynamicColumnMetaDataProtos.DynamicColumnMetaData.newBuilder();
                for (PColumn dynCol : colFamToDynColsList.getValue()) {
                    builder.addDynamicColumns(PColumnImpl.toProto(dynCol));
                }
                if (builder.getDynamicColumnsCount() == 0) continue;
                this.setValues.setAttribute(colFamToDynColsList.getKey(), builder.build().toByteArray());
                attrsForDynColsSet = true;
            }
            return attrsForDynColsSet;
        }

        @Override
        public void setAttributeToProcessDynamicColumnsMetadata() {
            this.setValues.setAttribute("_DynColsMetadataStoredForMutation", PDataType.TRUE_BYTES);
        }

        @Override
        public void delete() {
            this.newMutations();
            Delete delete = new Delete(this.key);
            if (PTableImpl.this.families.isEmpty()) {
                delete.addFamily(SchemaUtil.getEmptyColumnFamily(PTableImpl.this), this.ts);
            } else {
                for (PColumnFamily colFamily : PTableImpl.this.families) {
                    delete.addFamily(colFamily.getName().getBytes(), this.ts);
                }
            }
            this.deleteRow = delete;
            if (PTableImpl.this.isWALDisabled()) {
                this.deleteRow.setDurability(Durability.SKIP_WAL);
            }
        }
    }

    public static class Builder {
        private PTableKey key;
        private PName name;
        private PName schemaName = PName.EMPTY_NAME;
        private PName tableName = PName.EMPTY_NAME;
        private PName tenantId;
        private PTableType type;
        private PIndexState state;
        private long sequenceNumber;
        private long timeStamp;
        private long indexDisableTimestamp;
        private List<PColumn> pkColumns;
        private List<PColumn> allColumns;
        private List<PColumn> excludedColumns;
        private List<PColumnFamily> families;
        private Map<byte[], PColumnFamily> familyByBytes;
        private Map<String, PColumnFamily> familyByString;
        private ListMultimap<String, PColumn> columnsByName;
        private Map<KVColumnFamilyQualifier, PColumn> kvColumnsByQualifiers;
        private PName pkName;
        private Integer bucketNum;
        private RowKeySchema rowKeySchema;
        private List<PTable> indexes;
        private PName parentName;
        private PName parentSchemaName;
        private PName parentTableName;
        private List<PName> physicalNames;
        private boolean isImmutableRows;
        private IndexMaintainer indexMaintainer;
        private ImmutableBytesWritable indexMaintainersPtr;
        private PName defaultFamilyName;
        private String viewStatement;
        private boolean disableWAL;
        private boolean multiTenant;
        private boolean storeNulls;
        private TransactionFactory.Provider transactionProvider;
        private PTable.ViewType viewType;
        private PDataType viewIndexIdType;
        private Long viewIndexId;
        private int estimatedSize;
        private PTable.IndexType indexType;
        private int baseColumnCount;
        private boolean rowKeyOrderOptimizable;
        private boolean hasColumnsRequiringUpgrade;
        private int rowTimestampColPos;
        private long updateCacheFrequency;
        private boolean isNamespaceMapped;
        private String autoPartitionSeqName;
        private boolean isAppendOnlySchema;
        private PTable.ImmutableStorageScheme immutableStorageScheme;
        private PTable.QualifierEncodingScheme qualifierEncodingScheme;
        private PTable.EncodedCQCounter encodedCQCounter;
        private Boolean useStatsForParallelization;
        private long phoenixTTL;
        private long phoenixTTLHighWaterMark;
        private Long lastDDLTimestamp;
        private boolean isChangeDetectionEnabled = false;
        private Map<String, String> propertyValues = new HashMap<String, String>();
        private BitSet viewModifiedPropSet = new BitSet(3);
        private Collection<PColumn> columns;

        public Builder setKey(PTableKey key) {
            this.key = key;
            return this;
        }

        public Builder setName(PName name) {
            this.name = name;
            return this;
        }

        public Builder setSchemaName(PName schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder setTableName(PName tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setTenantId(PName tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder setType(PTableType type) {
            this.type = type;
            return this;
        }

        public Builder setState(PIndexState state2) {
            this.state = state2;
            return this;
        }

        public Builder setSequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public Builder setIndexDisableTimestamp(long indexDisableTimestamp) {
            this.indexDisableTimestamp = indexDisableTimestamp;
            return this;
        }

        public Builder setPkColumns(List<PColumn> pkColumns) {
            this.pkColumns = pkColumns;
            return this;
        }

        public Builder setAllColumns(List<PColumn> allColumns) {
            this.allColumns = allColumns;
            return this;
        }

        public Builder setExcludedColumns(List<PColumn> excludedColumns) {
            this.excludedColumns = excludedColumns;
            return this;
        }

        public Builder setFamilyAttributes(List<PColumnFamily> families) {
            this.familyByBytes = Maps.newHashMapWithExpectedSize((int)families.size());
            this.familyByString = Maps.newHashMapWithExpectedSize((int)families.size());
            for (PColumnFamily family : families) {
                this.familyByBytes.put(family.getName().getBytes(), family);
                this.familyByString.put(family.getName().getString(), family);
            }
            this.families = families;
            return this;
        }

        public Builder setFamilies(List<PColumnFamily> families) {
            this.families = families;
            return this;
        }

        public Builder setFamilyByBytes(Map<byte[], PColumnFamily> familyByBytes) {
            this.familyByBytes = familyByBytes;
            return this;
        }

        public Builder setFamilyByString(Map<String, PColumnFamily> familyByString) {
            this.familyByString = familyByString;
            return this;
        }

        public Builder setColumnsByName(ListMultimap<String, PColumn> columnsByName) {
            this.columnsByName = columnsByName;
            return this;
        }

        public Builder setKvColumnsByQualifiers(Map<KVColumnFamilyQualifier, PColumn> kvColumnsByQualifiers) {
            this.kvColumnsByQualifiers = kvColumnsByQualifiers;
            return this;
        }

        public Builder setPkName(PName pkName) {
            this.pkName = pkName;
            return this;
        }

        public Builder setBucketNum(Integer bucketNum) {
            if (bucketNum != null) {
                this.propertyValues.put("SALT_BUCKETS", String.valueOf(bucketNum));
            }
            this.bucketNum = bucketNum;
            return this;
        }

        public Builder setRowKeySchema(RowKeySchema rowKeySchema) {
            this.rowKeySchema = rowKeySchema;
            return this;
        }

        public Builder setIndexes(List<PTable> indexes) {
            this.indexes = indexes;
            return this;
        }

        public Builder setParentName(PName parentName) {
            this.parentName = parentName;
            return this;
        }

        public Builder setParentSchemaName(PName parentSchemaName) {
            this.parentSchemaName = parentSchemaName;
            return this;
        }

        public Builder setParentTableName(PName parentTableName) {
            this.parentTableName = parentTableName;
            return this;
        }

        public Builder setPhysicalNames(List<PName> physicalNames) {
            this.physicalNames = physicalNames;
            return this;
        }

        public Builder setImmutableRows(boolean immutableRows) {
            this.propertyValues.put("IMMUTABLE_ROWS", String.valueOf(immutableRows));
            this.isImmutableRows = immutableRows;
            return this;
        }

        public Builder setIndexMaintainer(IndexMaintainer indexMaintainer) {
            this.indexMaintainer = indexMaintainer;
            return this;
        }

        public Builder setIndexMaintainersPtr(ImmutableBytesWritable indexMaintainersPtr) {
            this.indexMaintainersPtr = indexMaintainersPtr;
            return this;
        }

        public Builder setDefaultFamilyName(PName defaultFamilyName) {
            if (defaultFamilyName != null) {
                this.propertyValues.put("DEFAULT_COLUMN_FAMILY", defaultFamilyName.getString());
            }
            this.defaultFamilyName = defaultFamilyName;
            return this;
        }

        public Builder setViewStatement(String viewStatement) {
            this.viewStatement = viewStatement;
            return this;
        }

        public Builder setDisableWAL(boolean disableWAL) {
            this.propertyValues.put("DISABLE_WAL", String.valueOf(disableWAL));
            this.disableWAL = disableWAL;
            return this;
        }

        public Builder setMultiTenant(boolean multiTenant) {
            this.propertyValues.put("MULTI_TENANT", String.valueOf(multiTenant));
            this.multiTenant = multiTenant;
            return this;
        }

        public Builder setStoreNulls(boolean storeNulls) {
            this.storeNulls = storeNulls;
            return this;
        }

        public Builder setTransactionProvider(TransactionFactory.Provider transactionProvider) {
            if (transactionProvider != null) {
                this.propertyValues.put("TRANSACTION_PROVIDER", String.valueOf((Object)transactionProvider));
            }
            this.transactionProvider = transactionProvider;
            return this;
        }

        public Builder setViewType(PTable.ViewType viewType) {
            this.viewType = viewType;
            return this;
        }

        public Builder setViewIndexIdType(PDataType viewIndexIdType) {
            this.viewIndexIdType = viewIndexIdType;
            return this;
        }

        public Builder setViewIndexId(Long viewIndexId) {
            this.viewIndexId = viewIndexId;
            return this;
        }

        public Builder setEstimatedSize(int estimatedSize) {
            this.estimatedSize = estimatedSize;
            return this;
        }

        public Builder setIndexType(PTable.IndexType indexType) {
            this.indexType = indexType;
            return this;
        }

        public Builder setBaseColumnCount(int baseColumnCount) {
            this.baseColumnCount = baseColumnCount;
            return this;
        }

        public Builder setRowKeyOrderOptimizable(boolean rowKeyOrderOptimizable) {
            this.rowKeyOrderOptimizable = rowKeyOrderOptimizable;
            return this;
        }

        public Builder setHasColumnsRequiringUpgrade(boolean hasColumnsRequiringUpgrade) {
            this.hasColumnsRequiringUpgrade = hasColumnsRequiringUpgrade;
            return this;
        }

        public Builder setRowTimestampColPos(int rowTimestampColPos) {
            this.rowTimestampColPos = rowTimestampColPos;
            return this;
        }

        public Builder setUpdateCacheFrequency(long updateCacheFrequency) {
            this.propertyValues.put("UPDATE_CACHE_FREQUENCY", String.valueOf(updateCacheFrequency));
            this.updateCacheFrequency = updateCacheFrequency;
            return this;
        }

        public Builder setNamespaceMapped(boolean namespaceMapped) {
            this.isNamespaceMapped = namespaceMapped;
            return this;
        }

        public Builder setAutoPartitionSeqName(String autoPartitionSeqName) {
            this.propertyValues.put("AUTO_PARTITION_SEQ", autoPartitionSeqName);
            this.autoPartitionSeqName = autoPartitionSeqName;
            return this;
        }

        public Builder setAppendOnlySchema(boolean appendOnlySchema) {
            this.propertyValues.put("APPEND_ONLY_SCHEMA", String.valueOf(appendOnlySchema));
            this.isAppendOnlySchema = appendOnlySchema;
            return this;
        }

        public Builder setImmutableStorageScheme(PTable.ImmutableStorageScheme immutableStorageScheme) {
            this.propertyValues.put("IMMUTABLE_STORAGE_SCHEME", immutableStorageScheme.toString());
            this.immutableStorageScheme = immutableStorageScheme;
            return this;
        }

        public Builder setQualifierEncodingScheme(PTable.QualifierEncodingScheme qualifierEncodingScheme) {
            this.propertyValues.put("ENCODING_SCHEME", qualifierEncodingScheme.toString());
            this.qualifierEncodingScheme = qualifierEncodingScheme;
            return this;
        }

        public Builder setEncodedCQCounter(PTable.EncodedCQCounter encodedCQCounter) {
            this.encodedCQCounter = encodedCQCounter;
            return this;
        }

        public Builder setUseStatsForParallelization(Boolean useStatsForParallelization) {
            if (useStatsForParallelization != null) {
                this.propertyValues.put("USE_STATS_FOR_PARALLELIZATION", String.valueOf(useStatsForParallelization));
            }
            this.useStatsForParallelization = useStatsForParallelization;
            return this;
        }

        public Builder setViewModifiedUpdateCacheFrequency(boolean modified) {
            this.viewModifiedPropSet.set(0, modified);
            return this;
        }

        public Builder setViewModifiedUseStatsForParallelization(boolean modified) {
            this.viewModifiedPropSet.set(1, modified);
            return this;
        }

        public Builder setPhoenixTTL(long phoenixTTL) {
            this.phoenixTTL = phoenixTTL;
            return this;
        }

        public Builder setPhoenixTTLHighWaterMark(long phoenixTTLHighWaterMark) {
            this.phoenixTTLHighWaterMark = phoenixTTLHighWaterMark;
            return this;
        }

        public Builder setViewModifiedPhoenixTTL(boolean modified) {
            this.viewModifiedPropSet.set(2, modified);
            return this;
        }

        public Builder setColumns(Collection<PColumn> columns) {
            this.columns = columns;
            return this;
        }

        public Builder setLastDDLTimestamp(Long lastDDLTimestamp) {
            this.lastDDLTimestamp = lastDDLTimestamp;
            return this;
        }

        public Builder setIsChangeDetectionEnabled(Boolean isChangeDetectionEnabled) {
            if (isChangeDetectionEnabled != null) {
                this.isChangeDetectionEnabled = isChangeDetectionEnabled;
            }
            return this;
        }

        private Builder initDerivedAttributes() throws SQLException {
            ArrayList pkColumns;
            Object[] allColumns;
            PTableImpl.checkTenantId(this.tenantId);
            Preconditions.checkNotNull((Object)this.schemaName);
            Preconditions.checkNotNull((Object)this.tableName);
            Preconditions.checkNotNull(this.columns);
            Preconditions.checkNotNull(this.indexes);
            Preconditions.checkNotNull(this.physicalNames);
            PName fullName = PNameFactory.newName(SchemaUtil.getTableName(this.schemaName.getString(), this.tableName.getString()));
            int estimatedSize = 288 + PNameFactory.getEstimatedSize(this.tenantId) + PNameFactory.getEstimatedSize(this.schemaName) + PNameFactory.getEstimatedSize(this.tableName) + PNameFactory.getEstimatedSize(this.pkName) + PNameFactory.getEstimatedSize(this.parentTableName) + PNameFactory.getEstimatedSize(this.defaultFamilyName);
            int numPKColumns = 0;
            if (this.bucketNum != null) {
                allColumns = new PColumn[this.columns.size() + 1];
                allColumns[SaltingUtil.SALTING_COLUMN.getPosition()] = SaltingUtil.SALTING_COLUMN;
                pkColumns = Lists.newArrayListWithExpectedSize((int)(this.columns.size() + 1));
                ++numPKColumns;
            } else {
                allColumns = new PColumn[this.columns.size()];
                pkColumns = Lists.newArrayListWithExpectedSize((int)this.columns.size());
            }
            ArrayList sortedColumns = Lists.newArrayList(this.columns);
            Collections.sort(sortedColumns, new Comparator<PColumn>(){

                @Override
                public int compare(PColumn o1, PColumn o2) {
                    return Integer.valueOf(o1.getPosition()).compareTo(o2.getPosition());
                }
            });
            int position = 0;
            if (this.bucketNum != null) {
                position = 1;
            }
            ArrayListMultimap populateColumnsByName = ArrayListMultimap.create((int)this.columns.size(), (int)1);
            HashMap populateKvColumnsByQualifiers = Maps.newHashMapWithExpectedSize((int)this.columns.size());
            Iterator iterator = sortedColumns.iterator();
            while (iterator.hasNext()) {
                String columnName;
                PColumn column;
                allColumns[position] = column = (PColumn)iterator.next();
                ++position;
                PName familyName = column.getFamilyName();
                if (familyName == null) {
                    ++numPKColumns;
                }
                if (populateColumnsByName.put((Object)(columnName = column.getName().getString()), (Object)column)) {
                    int count = 0;
                    for (PColumn dupColumn : populateColumnsByName.get((Object)columnName)) {
                        if (!Objects.equal((Object)familyName, (Object)dupColumn.getFamilyName()) || ++count <= 1) continue;
                        throw new ColumnAlreadyExistsException(this.schemaName.getString(), fullName.getString(), columnName);
                    }
                }
                byte[] cq = column.getColumnQualifierBytes();
                Object[] cf = column.getFamilyName() != null ? column.getFamilyName().getString() : null;
                if (cf == null || cq == null) continue;
                KVColumnFamilyQualifier info = new KVColumnFamilyQualifier((String)cf, cq);
                if (populateKvColumnsByQualifiers.get(info) != null) {
                    throw new ColumnAlreadyExistsException(this.schemaName.getString(), fullName.getString(), columnName);
                }
                populateKvColumnsByQualifiers.put(info, column);
            }
            estimatedSize = (int)((long)estimatedSize + SizedUtil.sizeOfMap(allColumns.length, 8, SizedUtil.sizeOfArrayList(1)));
            estimatedSize = (int)((long)estimatedSize + (SizedUtil.sizeOfMap(numPKColumns) + SizedUtil.sizeOfMap(allColumns.length)));
            RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(numPKColumns);
            int maxExpectedSize = allColumns.length - numPKColumns;
            LinkedHashMap familyMap = Maps.newLinkedHashMap();
            PColumn rowTimestampCol = null;
            boolean hasColsRequiringUpgrade = false;
            for (PColumn pColumn : allColumns) {
                PName familyName = pColumn.getFamilyName();
                if (familyName == null) {
                    hasColsRequiringUpgrade |= pColumn.getSortOrder() == SortOrder.DESC && (!pColumn.getDataType().isFixedWidth() || pColumn.getDataType() == PChar.INSTANCE || pColumn.getDataType() == PFloat.INSTANCE || pColumn.getDataType() == PDouble.INSTANCE || pColumn.getDataType() == PBinary.INSTANCE) || pColumn.getSortOrder() == SortOrder.ASC && pColumn.getDataType() == PBinary.INSTANCE && pColumn.getMaxLength() != null && pColumn.getMaxLength() > 1;
                    pkColumns.add(pColumn);
                    if (pColumn.isRowTimestamp()) {
                        rowTimestampCol = pColumn;
                    }
                }
                if (familyName == null) {
                    estimatedSize += pColumn.getEstimatedSize();
                    builder.addField(pColumn, pColumn.isNullable(), pColumn.getSortOrder());
                    continue;
                }
                List columnsInFamily = (List)familyMap.get(familyName);
                if (columnsInFamily == null) {
                    columnsInFamily = Lists.newArrayListWithExpectedSize((int)maxExpectedSize);
                    familyMap.put(familyName, columnsInFamily);
                }
                columnsInFamily.add(pColumn);
            }
            int rowTimestampColPos = rowTimestampCol != null ? pkColumns.indexOf(rowTimestampCol) : -1;
            Iterator iterator2 = familyMap.entrySet().iterator();
            Object[] families = new PColumnFamily[familyMap.size()];
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            ImmutableSortedMap.Builder familyByBytes = ImmutableSortedMap.orderedBy((Comparator)Bytes.BYTES_COMPARATOR);
            for (int i = 0; i < families.length; ++i) {
                Map.Entry entry = iterator2.next();
                PColumnFamilyImpl family = new PColumnFamilyImpl((PName)entry.getKey(), (List)entry.getValue());
                families[i] = family;
                builder2.put((Object)family.getName().getString(), (Object)family);
                familyByBytes.put((Object)family.getName().getBytes(), (Object)family);
                estimatedSize += family.getEstimatedSize();
            }
            estimatedSize += SizedUtil.sizeOfArrayList(families.length);
            estimatedSize = (int)((long)estimatedSize + SizedUtil.sizeOfMap(families.length) * 2L);
            for (PTable index : this.indexes) {
                estimatedSize += index.getEstimatedSize();
            }
            estimatedSize += PNameFactory.getEstimatedSize(this.parentName);
            for (PName physicalName : this.physicalNames) {
                estimatedSize += physicalName.getEstimatedSize();
            }
            return this.setName(fullName).setKey(new PTableKey(this.tenantId, fullName.getString())).setParentName(this.parentTableName == null ? null : PNameFactory.newName(SchemaUtil.getTableName(this.parentSchemaName != null ? this.parentSchemaName.getString() : null, this.parentTableName.getString()))).setColumnsByName((ListMultimap<String, PColumn>)populateColumnsByName).setKvColumnsByQualifiers(populateKvColumnsByQualifiers).setAllColumns((List<PColumn>)ImmutableList.copyOf((Object[])allColumns)).setHasColumnsRequiringUpgrade(hasColsRequiringUpgrade | this.hasColumnsRequiringUpgrade).setPkColumns((List<PColumn>)ImmutableList.copyOf((Collection)pkColumns)).setRowTimestampColPos(rowTimestampColPos).setRowKeySchema(builder.rowKeyOrderOptimizable(this.rowKeyOrderOptimizable || !this.hasColumnsRequiringUpgrade).build()).setFamilies((List<PColumnFamily>)ImmutableList.copyOf((Object[])families)).setFamilyByBytes((Map<byte[], PColumnFamily>)familyByBytes.build()).setFamilyByString((Map<String, PColumnFamily>)builder2.build()).setEstimatedSize(estimatedSize + this.rowKeySchema.getEstimatedSize());
        }

        public PTableImpl build() throws SQLException {
            return this.columns == null ? new PTableImpl(this) : new PTableImpl(this.initDerivedAttributes());
        }
    }
}

