/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;

public class ColumnInfo {
    private static final String STR_SEPARATOR = ":";
    private final String columnName;
    private final int sqlType;
    private final Integer precision;
    private final Integer scale;

    public static ColumnInfo create(String columnName, int sqlType, Integer maxLength, Integer scale) {
        if (scale != null) {
            assert (maxLength != null);
            scale = Math.min(maxLength, scale);
            return new ColumnInfo(columnName, sqlType, maxLength, scale);
        }
        if (maxLength != null) {
            return new ColumnInfo(columnName, sqlType, maxLength);
        }
        return new ColumnInfo(columnName, sqlType);
    }

    public ColumnInfo(String columnName, int sqlType) {
        this(columnName, sqlType, null);
    }

    public ColumnInfo(String columnName, int sqlType, Integer maxLength) {
        this(columnName, sqlType, maxLength, null);
    }

    public ColumnInfo(String columnName, int sqlType, Integer precision, Integer scale) {
        Preconditions.checkNotNull((Object)columnName, (Object)"columnName cannot be null");
        Preconditions.checkArgument((!columnName.isEmpty() ? 1 : 0) != 0, (Object)"columnName cannot be empty");
        if (!columnName.startsWith("\"")) {
            columnName = SchemaUtil.getEscapedFullColumnName(columnName);
        }
        this.columnName = columnName;
        this.sqlType = sqlType;
        this.precision = precision;
        this.scale = scale;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public PDataType getPDataType() {
        return PDataType.fromTypeId(this.sqlType);
    }

    public String getDisplayName() {
        String unescapedColumnName = SchemaUtil.getUnEscapedFullColumnName(this.columnName);
        int index = unescapedColumnName.indexOf(".");
        if (index < 0) {
            return unescapedColumnName;
        }
        return unescapedColumnName.substring(index + 1).trim();
    }

    public String toTypeString() {
        return PhoenixRuntime.getSqlTypeName(this.getPDataType(), this.getMaxLength(), this.getScale());
    }

    public String toString() {
        return this.toTypeString() + STR_SEPARATOR + this.columnName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnInfo that = (ColumnInfo)o;
        if (this.sqlType != that.sqlType) {
            return false;
        }
        if (this.precision != that.precision) {
            return false;
        }
        if (this.scale != that.scale) {
            return false;
        }
        return this.columnName.equals(that.columnName);
    }

    public int hashCode() {
        int result = this.columnName.hashCode();
        result = 31 * result + (this.precision << 2) + (this.scale << 1) + this.sqlType;
        return result;
    }

    public static ColumnInfo fromString(String stringRepresentation) {
        ArrayList components = Lists.newArrayList((Object[])stringRepresentation.split(STR_SEPARATOR, 2));
        if (components.size() != 2) {
            throw new IllegalArgumentException("Unparseable string: " + stringRepresentation);
        }
        String[] typeParts = ((String)components.get(0)).split(" ");
        String columnName = (String)components.get(1);
        Integer maxLength = null;
        Integer scale = null;
        if (typeParts[0].contains("(")) {
            Matcher matcher = Pattern.compile("([^\\(]+)\\((\\d+)(?:,(\\d+))?\\)").matcher(typeParts[0]);
            if (!matcher.matches() || matcher.groupCount() > 3) {
                throw new IllegalArgumentException("Unparseable type string: " + typeParts[0]);
            }
            maxLength = Integer.valueOf(matcher.group(2));
            if (matcher.group(3) != null) {
                scale = Integer.valueOf(matcher.group(3));
            }
            typeParts[0] = matcher.group(1);
        }
        PDataType dataType = typeParts.length < 2 ? PDataType.fromSqlTypeName(typeParts[0]) : PDataType.fromSqlTypeName(typeParts[0] + " " + typeParts[1]);
        return ColumnInfo.create(columnName, dataType.getSqlType(), maxLength, scale);
    }

    public Integer getMaxLength() {
        return this.precision;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }
}

