/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpsertExecutor<RECORD, FIELD>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpsertExecutor.class);
    protected final Connection conn;
    protected final List<ColumnInfo> columnInfos;
    protected final List<PDataType> dataTypes;
    protected final List<Function<FIELD, Object>> conversionFunctions;
    protected final PreparedStatement preparedStatement;
    protected final UpsertListener<RECORD> upsertListener;
    protected long upsertCount = 0L;
    protected boolean initFinished = false;

    private static PreparedStatement createStatement(Connection conn, String tableName, List<ColumnInfo> columnInfoList) {
        PreparedStatement preparedStatement;
        try {
            String upsertSql = QueryUtil.constructUpsertStatement(tableName, columnInfoList);
            LOGGER.info("Upserting SQL data with {}", (Object)upsertSql);
            preparedStatement = conn.prepareStatement(upsertSql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return preparedStatement;
    }

    public UpsertExecutor(Connection conn, String tableName, List<ColumnInfo> columnInfoList, UpsertListener<RECORD> upsertListener) {
        this(conn, columnInfoList, UpsertExecutor.createStatement(conn, tableName, columnInfoList), upsertListener);
    }

    @VisibleForTesting
    protected UpsertExecutor(Connection conn, List<ColumnInfo> columnInfoList, PreparedStatement preparedStatement, UpsertListener<RECORD> upsertListener) {
        this.conn = conn;
        this.upsertListener = upsertListener;
        this.columnInfos = columnInfoList;
        this.preparedStatement = preparedStatement;
        this.dataTypes = Lists.newArrayList();
        this.conversionFunctions = Lists.newArrayList();
    }

    protected void finishInit() {
        for (ColumnInfo columnInfo : this.columnInfos) {
            PDataType dataType = PDataType.fromTypeId(columnInfo.getSqlType());
            this.dataTypes.add(dataType);
            this.conversionFunctions.add(this.createConversionFunction(dataType));
        }
        this.initFinished = true;
    }

    public void execute(Iterable<RECORD> records) {
        if (!this.initFinished) {
            this.finishInit();
        }
        for (RECORD record : records) {
            this.execute(record);
        }
    }

    protected abstract void execute(RECORD var1);

    @Override
    public void close() throws IOException {
        try {
            this.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Function<FIELD, Object> createConversionFunction(PDataType var1);

    public static interface UpsertListener<RECORD> {
        public void upsertDone(long var1);

        public void errorOnRecord(RECORD var1, Throwable var2);
    }
}

