/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.net.URL;
import java.security.Principal;
import org.apache.calcite.avatica.org.apache.http.auth.AuthScope;
import org.apache.calcite.avatica.org.apache.http.auth.Credentials;
import org.apache.calcite.avatica.org.apache.http.auth.KerberosCredentials;
import org.apache.calcite.avatica.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.calcite.avatica.org.apache.http.client.methods.HttpPost;
import org.apache.calcite.avatica.org.apache.http.client.methods.HttpUriRequest;
import org.apache.calcite.avatica.org.apache.http.client.protocol.HttpClientContext;
import org.apache.calcite.avatica.org.apache.http.config.Registry;
import org.apache.calcite.avatica.org.apache.http.config.RegistryBuilder;
import org.apache.calcite.avatica.org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.calcite.avatica.org.apache.http.entity.ByteArrayEntity;
import org.apache.calcite.avatica.org.apache.http.entity.ContentType;
import org.apache.calcite.avatica.org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.calcite.avatica.org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.calcite.avatica.org.apache.http.util.EntityUtils;
import org.apache.calcite.avatica.remote.AvaticaCommonsHttpClientImpl;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaCommonsHttpClientSpnegoImpl
extends AvaticaCommonsHttpClientImpl {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaCommonsHttpClientSpnegoImpl.class);
    public static final String CACHED_CONNECTIONS_MAX_KEY = "avatica.http.spnego.max_cached";
    public static final String CACHED_CONNECTIONS_MAX_PER_ROUTE_KEY = "avatica.http.spnego.max_per_route";
    private static final boolean USE_CANONICAL_HOSTNAME = Boolean.parseBoolean(System.getProperty("avatica.http.spnego.use_canonical_hostname", "true"));
    private static final boolean STRIP_PORT_ON_SERVER_LOOKUP = true;

    public AvaticaCommonsHttpClientSpnegoImpl(URL url) {
        this(url, null);
    }

    public AvaticaCommonsHttpClientSpnegoImpl(URL url, GSSCredential credential) {
        super(url);
        this.setGSSCredential(credential);
    }

    @Override
    protected void configureConnectionPool(Registry<ConnectionSocketFactory> registry) {
        String maxCnxnsPerRoute;
        super.configureConnectionPool(registry);
        String maxCnxns = System.getProperty(CACHED_CONNECTIONS_MAX_KEY);
        if (maxCnxns != null) {
            this.pool.setMaxTotal(Integer.parseInt(maxCnxns));
        }
        if ((maxCnxnsPerRoute = System.getProperty(CACHED_CONNECTIONS_MAX_PER_ROUTE_KEY)) != null) {
            this.pool.setDefaultMaxPerRoute(Integer.parseInt(maxCnxnsPerRoute));
        }
    }

    public void setGSSCredential(GSSCredential credential) {
        this.authRegistry = RegistryBuilder.create().register("Negotiate", new SPNegoSchemeFactory(true, USE_CANONICAL_HOSTNAME)).build();
        this.credentialsProvider = new BasicCredentialsProvider();
        if (null != credential) {
            this.credentialsProvider.setCredentials(AuthScope.ANY, new KerberosCredentials(credential));
        } else {
            this.credentialsProvider.setCredentials(AuthScope.ANY, EmptyCredentials.INSTANCE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] send(byte[] request) {
        HttpClientContext context = HttpClientContext.create();
        context.setTargetHost(this.host);
        context.setCredentialsProvider(this.credentialsProvider);
        context.setAuthSchemeRegistry(this.authRegistry);
        context.setAuthCache(this.authCache);
        ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
        HttpPost post = new HttpPost(this.uri);
        post.setEntity(entity);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)post, context);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 == statusCode || 500 == statusCode) {
                byte[] byArray = EntityUtils.toByteArray(response.getEntity());
                return byArray;
            }
            throw new RuntimeException("Failed to execute HTTP Request, got HTTP/" + statusCode);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.debug("Failed to execute HTTP request", e);
            throw new RuntimeException(e);
        }
    }

    private static class EmptyCredentials
    implements Credentials {
        public static final EmptyCredentials INSTANCE = new EmptyCredentials();

        private EmptyCredentials() {
        }

        @Override
        public String getPassword() {
            return null;
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }
    }
}

