/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaCellComparator;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCellComparator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCellComparator.class);
    private CellComparator comparator = CellComparator.getInstance();
    byte[] row1 = Bytes.toBytes((String)"row1");
    byte[] row2 = Bytes.toBytes((String)"row2");
    byte[] row_1_0 = Bytes.toBytes((String)"row10");
    byte[] fam1 = Bytes.toBytes((String)"fam1");
    byte[] fam2 = Bytes.toBytes((String)"fam2");
    byte[] fam_1_2 = Bytes.toBytes((String)"fam12");
    byte[] qual1 = Bytes.toBytes((String)"qual1");
    byte[] qual2 = Bytes.toBytes((String)"qual2");
    byte[] val = Bytes.toBytes((String)"val");

    @Test
    public void testCompareCells() {
        KeyValue kv1 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        KeyValue kv2 = new KeyValue(this.row2, this.fam1, this.qual1, this.val);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, (Cell)kv2) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam2, this.qual1, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        Assert.assertTrue((this.comparator.compareFamilies((Cell)kv1, (Cell)kv2) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 2L, this.val);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, (Cell)kv2) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((this.comparator.compare((Cell)kv1, (Cell)kv2) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        Assert.assertTrue((boolean)CellUtil.equals((Cell)kv1, (Cell)kv2));
    }

    @Test
    public void testCompareCellWithKey() throws Exception {
        KeyValue kv1 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        KeyValue kv2 = new KeyValue(this.row2, this.fam1, this.qual1, this.val);
        Assert.assertTrue((PrivateCellUtil.compare((CellComparator)this.comparator, (Cell)kv1, (byte[])kv2.getKey(), (int)0, (int)kv2.getKey().length) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam2, this.qual1, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        Assert.assertTrue((PrivateCellUtil.compare((CellComparator)this.comparator, (Cell)kv1, (byte[])kv2.getKey(), (int)0, (int)kv2.getKey().length) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 2L, this.val);
        Assert.assertTrue((PrivateCellUtil.compare((CellComparator)this.comparator, (Cell)kv1, (byte[])kv2.getKey(), (int)0, (int)kv2.getKey().length) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((PrivateCellUtil.compare((CellComparator)this.comparator, (Cell)kv1, (byte[])kv2.getKey(), (int)0, (int)kv2.getKey().length) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        Assert.assertTrue((PrivateCellUtil.compare((CellComparator)this.comparator, (Cell)kv1, (byte[])kv2.getKey(), (int)0, (int)kv2.getKey().length) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareByteBufferedCell() {
        byte[] r1 = Bytes.toBytes((String)"row1");
        byte[] r2 = Bytes.toBytes((String)"row2");
        byte[] f1 = Bytes.toBytes((String)"cf1");
        byte[] q1 = Bytes.toBytes((String)"qual1");
        byte[] q2 = Bytes.toBytes((String)"qual2");
        byte[] v = Bytes.toBytes((String)"val1");
        KeyValue kv = new KeyValue(r1, f1, q1, v);
        ByteBuffer buffer = ByteBuffer.wrap(kv.getBuffer());
        ByteBufferKeyValue bbCell1 = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        kv = new KeyValue(r2, f1, q1, v);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        ByteBufferKeyValue bbCell2 = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertEquals((long)0L, (long)CellComparatorImpl.COMPARATOR.compareColumns((Cell)bbCell1, (Cell)bbCell2));
        Assert.assertEquals((long)0L, (long)CellComparatorImpl.COMPARATOR.compareColumns((Cell)bbCell1, (Cell)kv));
        kv = new KeyValue(r2, f1, q2, v);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        ByteBufferKeyValue bbCell3 = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertEquals((long)0L, (long)this.comparator.compareFamilies((Cell)bbCell2, (Cell)bbCell3));
        Assert.assertTrue((this.comparator.compareQualifiers((Cell)bbCell2, (Cell)bbCell3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compareColumns((Cell)bbCell2, (Cell)bbCell3) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.comparator.compareRows((Cell)bbCell2, (Cell)bbCell3));
        Assert.assertTrue((this.comparator.compareRows((Cell)bbCell1, (Cell)bbCell2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetaComparisons() throws Exception {
        long now = System.currentTimeMillis();
        Cell aaa = TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236020145502"), now));
        MetaCellComparator c = MetaCellComparator.META_COMPARATOR;
        Cell bbb = TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,,99999999999999"), now));
        Assert.assertTrue((c.compare(bbb, aaa) < 0 ? 1 : 0) != 0);
        Cell ccc = TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,,1236023996656"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)"regioninfo"), 1236024396271L, (byte[])null));
        Assert.assertTrue((c.compare(ccc, bbb) < 0 ? 1 : 0) != 0);
        Cell x = TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null));
        Cell y = TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)"regioninfo"), 1236034574912L, (byte[])null));
        Assert.assertTrue((c.compare(x, y) < 0 ? 1 : 0) != 0);
    }

    private static Cell createByteBufferKeyValueFromKeyValue(KeyValue kv) {
        ByteBuffer bb = ByteBuffer.wrap(kv.getBuffer());
        return new ByteBufferKeyValue(bb, 0, bb.remaining());
    }

    @Test
    public void testMetaComparisons2() {
        long now = System.currentTimeMillis();
        MetaCellComparator c = MetaCellComparator.META_COMPARATOR;
        Assert.assertTrue((c.compare(TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now)), TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now))) == 0 ? 1 : 0) != 0);
        Cell a = TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now));
        Cell b = TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,2")), now));
        Assert.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compare(TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,2")), now)), TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now))) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compare(TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now)), TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now))) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compare(TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now)), TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,2")), now))) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compare(TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,2")), now)), TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now))) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryKeys() throws Exception {
        TreeSet set = new TreeSet(CellComparatorImpl.COMPARATOR);
        byte[] fam = Bytes.toBytes((String)"col");
        byte[] qf = Bytes.toBytes((String)"umn");
        byte[] nb = new byte[]{};
        Cell[] keys = new Cell[]{TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"aaaaa,\u0000\u0000,2"), fam, qf, 2L, nb)), TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"aaaaa,\u0001,3"), fam, qf, 3L, nb)), TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"aaaaa,,1"), fam, qf, 1L, nb)), TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"aaaaa,\u1000,5"), fam, qf, 5L, nb)), TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"aaaaa,a,4"), fam, qf, 4L, nb)), TestCellComparator.createByteBufferKeyValueFromKeyValue(new KeyValue(Bytes.toBytes((String)"a,a,0"), fam, qf, 0L, nb))};
        Collections.addAll(set, keys);
        boolean assertion = false;
        int count = 0;
        try {
            for (Cell k : set) {
                Assert.assertTrue((String)("count=" + count + ", " + k.toString()), ((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
            }
        }
        catch (AssertionError e) {
            assertion = true;
        }
        Assert.assertTrue((boolean)assertion);
        set = new TreeSet(MetaCellComparator.META_COMPARATOR);
        Collections.addAll(set, keys);
        count = 0;
        for (Cell k : set) {
            Assert.assertTrue((String)("count=" + count + ", " + k.toString()), ((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
        }
    }
}

