/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.avro.Protocol;
import org.apache.avro.TestProtocolGeneric;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.SaslSocketServer;
import org.apache.avro.ipc.SaslSocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSaslDigestMd5
extends TestProtocolGeneric {
    private static final Logger LOG = LoggerFactory.getLogger(TestSaslDigestMd5.class);
    private static final String HOST = "localhost";
    private static final String SERVICE = "avro-test";
    private static final String PRINCIPAL = "avro-test-principal";
    private static final String PASSWORD = "super secret password";
    private static final String REALM = "avro-test-realm";
    private static final String DIGEST_MD5_MECHANISM = "DIGEST-MD5";
    private static final Map<String, String> DIGEST_MD5_PROPS = new HashMap<String, String>();

    @Override
    @Before
    public void testStartServer() throws Exception {
        if (server != null) {
            return;
        }
        server = new SaslSocketServer((Responder)new TestProtocolGeneric.TestResponder(), (SocketAddress)new InetSocketAddress(0), DIGEST_MD5_MECHANISM, SERVICE, HOST, DIGEST_MD5_PROPS, (CallbackHandler)new TestSaslCallbackHandler());
        server.start();
        SaslClient saslClient = Sasl.createSaslClient(new String[]{DIGEST_MD5_MECHANISM}, PRINCIPAL, SERVICE, HOST, DIGEST_MD5_PROPS, new TestSaslCallbackHandler());
        client = new SaslSocketTransceiver((SocketAddress)new InetSocketAddress(server.getPort()), saslClient);
        requestor = new GenericRequestor(PROTOCOL, client);
    }

    @Test(expected=SaslException.class)
    public void testAnonymousClient() throws Exception {
        SaslSocketServer s = new SaslSocketServer((Responder)new TestProtocolGeneric.TestResponder(), (SocketAddress)new InetSocketAddress(0), DIGEST_MD5_MECHANISM, SERVICE, HOST, DIGEST_MD5_PROPS, (CallbackHandler)new TestSaslCallbackHandler());
        s.start();
        SaslSocketTransceiver c = new SaslSocketTransceiver((SocketAddress)new InetSocketAddress(s.getPort()));
        GenericRequestor requestor = new GenericRequestor(PROTOCOL, (Transceiver)c);
        GenericData.Record params = new GenericData.Record(((Protocol.Message)PROTOCOL.getMessages().get("hello")).getRequest());
        params.put("greeting", (Object)"bob");
        Utf8 response = (Utf8)requestor.request("hello", (Object)params);
        Assert.assertEquals((Object)new Utf8("goodbye"), (Object)response);
        s.close();
        c.close();
    }

    @Test(expected=SaslException.class)
    public void testWrongPassword() throws Exception {
        SaslSocketServer s = new SaslSocketServer((Responder)new TestProtocolGeneric.TestResponder(), (SocketAddress)new InetSocketAddress(0), DIGEST_MD5_MECHANISM, SERVICE, HOST, DIGEST_MD5_PROPS, (CallbackHandler)new TestSaslCallbackHandler());
        s.start();
        SaslClient saslClient = Sasl.createSaslClient(new String[]{DIGEST_MD5_MECHANISM}, PRINCIPAL, SERVICE, HOST, DIGEST_MD5_PROPS, new WrongPasswordCallbackHandler());
        SaslSocketTransceiver c = new SaslSocketTransceiver((SocketAddress)new InetSocketAddress(server.getPort()), saslClient);
        GenericRequestor requestor = new GenericRequestor(PROTOCOL, (Transceiver)c);
        GenericData.Record params = new GenericData.Record(((Protocol.Message)PROTOCOL.getMessages().get("hello")).getRequest());
        params.put("greeting", (Object)"bob");
        Utf8 response = (Utf8)requestor.request("hello", (Object)params);
        Assert.assertEquals((Object)new Utf8("goodbye"), (Object)response);
        s.close();
        c.close();
    }

    @Override
    public void testHandshake() throws IOException {
    }

    @Override
    public void testResponseChange() throws IOException {
    }

    static {
        DIGEST_MD5_PROPS.put("javax.security.sasl.qop", "auth-int");
        if (System.getProperty("java.vendor").contains("IBM")) {
            DIGEST_MD5_PROPS.put("com.ibm.security.sasl.digest.realm", REALM);
        } else {
            DIGEST_MD5_PROPS.put("com.sun.security.sasl.digest.realm", REALM);
        }
    }

    private static class WrongPasswordCallbackHandler
    implements CallbackHandler {
        private WrongPasswordCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback c : callbacks) {
                if (c instanceof NameCallback) {
                    ((NameCallback)c).setName(TestSaslDigestMd5.PRINCIPAL);
                    continue;
                }
                if (c instanceof PasswordCallback) {
                    ((PasswordCallback)c).setPassword("wrong".toCharArray());
                    continue;
                }
                if (c instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)c).setAuthorized(true);
                    continue;
                }
                if (c instanceof RealmCallback) {
                    ((RealmCallback)c).setText(TestSaslDigestMd5.REALM);
                    continue;
                }
                throw new UnsupportedCallbackException(c);
            }
        }
    }

    private static class TestSaslCallbackHandler
    implements CallbackHandler {
        private TestSaslCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback c : callbacks) {
                if (c instanceof NameCallback) {
                    ((NameCallback)c).setName(TestSaslDigestMd5.PRINCIPAL);
                    continue;
                }
                if (c instanceof PasswordCallback) {
                    ((PasswordCallback)c).setPassword(TestSaslDigestMd5.PASSWORD.toCharArray());
                    continue;
                }
                if (c instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)c).setAuthorized(true);
                    continue;
                }
                if (c instanceof RealmCallback) {
                    ((RealmCallback)c).setText(TestSaslDigestMd5.REALM);
                    continue;
                }
                throw new UnsupportedCallbackException(c);
            }
        }
    }
}

