/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.FindMax;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.admin.TableOperationsHelper;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.impl.AccumuloServerException;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.TableOperation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.MetadataTable;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.StringUtil;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class TableOperationsImpl
extends TableOperationsHelper {
    private Instance instance;
    private TCredentials credentials;
    private static final Logger log = Logger.getLogger(TableOperations.class);

    public TableOperationsImpl(Instance instance, TCredentials credentials) {
        ArgumentChecker.notNull(instance, credentials);
        this.instance = instance;
        this.credentials = credentials;
    }

    @Override
    public SortedSet<String> list() {
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Fetching list of tables...");
        TreeSet<String> tableNames = new TreeSet<String>(Tables.getNameToIdMap(this.instance).keySet());
        opTimer.stop("Fetched " + tableNames.size() + " table names in %DURATION%");
        return tableNames;
    }

    @Override
    public boolean exists(String tableName) {
        ArgumentChecker.notNull(tableName);
        if (tableName.equals("!METADATA")) {
            return true;
        }
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Checking if table " + tableName + "exists...");
        boolean exists = Tables.getNameToIdMap(this.instance).containsKey(tableName);
        opTimer.stop("Checked existance of " + exists + " in %DURATION%");
        return exists;
    }

    @Override
    public void create(String tableName) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        this.create(tableName, true, TimeType.MILLIS);
    }

    @Override
    public void create(String tableName, boolean limitVersion) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        this.create(tableName, limitVersion, TimeType.MILLIS);
    }

    @Override
    public void create(String tableName, boolean limitVersion, TimeType timeType) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        ArgumentChecker.notNull(tableName, (Object)timeType);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes()), ByteBuffer.wrap(timeType.name().getBytes()));
        Map<String, String> opts = IteratorUtil.generateInitialTableProperties(limitVersion);
        try {
            this.doTableOperation(TableOperation.CREATE, args, opts);
        }
        catch (TableNotFoundException e1) {
            throw new RuntimeException(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long beginTableOperation() throws ThriftSecurityException, TException {
        while (true) {
            MasterClientService.Client client = null;
            try {
                client = MasterClient.getConnectionWithRetry(this.instance);
                long l = client.beginTableOperation(Tracer.traceInfo(), this.credentials);
                return l;
            }
            catch (TTransportException tte) {
                log.debug((Object)"Failed to call beginTableOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            finally {
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTableOperation(long opid, TableOperation op, List<ByteBuffer> args, Map<String, String> opts, boolean autoCleanUp) throws ThriftSecurityException, TException, ThriftTableOperationException {
        while (true) {
            MasterClientService.Client client = null;
            try {
                client = MasterClient.getConnectionWithRetry(this.instance);
                client.executeTableOperation(Tracer.traceInfo(), this.credentials, opid, op, args, opts, autoCleanUp);
            }
            catch (TTransportException tte) {
                log.debug((Object)"Failed to call executeTableOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            finally {
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitForTableOperation(long opid) throws ThriftSecurityException, TException, ThriftTableOperationException {
        while (true) {
            MasterClientService.Client client = null;
            try {
                client = MasterClient.getConnectionWithRetry(this.instance);
                String string = client.waitForTableOperation(Tracer.traceInfo(), this.credentials, opid);
                return string;
            }
            catch (TTransportException tte) {
                log.debug((Object)"Failed to call waitForTableOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            finally {
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTableOperation(long opid) throws ThriftSecurityException, TException {
        while (true) {
            MasterClientService.Client client = null;
            try {
                client = MasterClient.getConnectionWithRetry(this.instance);
                client.finishTableOperation(Tracer.traceInfo(), this.credentials, opid);
            }
            catch (TTransportException tte) {
                log.debug((Object)"Failed to call finishTableOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            finally {
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    private String doTableOperation(TableOperation op, List<ByteBuffer> args, Map<String, String> opts) throws AccumuloSecurityException, TableExistsException, TableNotFoundException, AccumuloException {
        return this.doTableOperation(op, args, opts, true);
    }

    private String doTableOperation(TableOperation op, List<ByteBuffer> args, Map<String, String> opts, boolean wait) throws AccumuloSecurityException, TableExistsException, TableNotFoundException, AccumuloException {
        Long opid = null;
        try {
            opid = this.beginTableOperation();
            this.executeTableOperation(opid, op, args, opts, !wait);
            if (!wait) {
                opid = null;
                String string = null;
                return string;
            }
            String ret = this.waitForTableOperation(opid);
            Tables.clearCache(this.instance);
            String string = ret;
            return string;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case EXISTS: {
                    throw new TableExistsException(e);
                }
                case NOTFOUND: {
                    throw new TableNotFoundException(e);
                }
                case OFFLINE: {
                    throw new TableOfflineException(this.instance, null);
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new AccumuloException(e.getMessage(), e);
        }
        finally {
            if (opid != null) {
                try {
                    this.finishTableOperation(opid);
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void addSplits(String tableName, SortedSet<Text> partitionKeys) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        String tableId = Tables.getTableId(this.instance, tableName);
        ArrayList<Text> splits = new ArrayList<Text>(partitionKeys);
        Collections.sort(splits);
        CountDownLatch latch = new CountDownLatch(splits.size());
        AtomicReference<Object> exception = new AtomicReference<Object>(null);
        ExecutorService executor = Executors.newFixedThreadPool(16, new NamingThreadFactory("addSplits"));
        try {
            executor.submit(new SplitTask(new SplitEnv(tableName, tableId, executor, latch, exception), splits));
            while (!latch.await(100L, TimeUnit.MILLISECONDS)) {
                if (exception.get() == null) continue;
                executor.shutdownNow();
                Exception excep = exception.get();
                if (excep instanceof TableNotFoundException) {
                    throw (TableNotFoundException)excep;
                }
                if (excep instanceof AccumuloException) {
                    throw (AccumuloException)excep;
                }
                if (excep instanceof AccumuloSecurityException) {
                    throw (AccumuloSecurityException)excep;
                }
                if (excep instanceof RuntimeException) {
                    throw (RuntimeException)excep;
                }
                throw new RuntimeException(excep);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSplits(String tableName, SortedSet<Text> partitionKeys, String tableId) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, AccumuloServerException {
        TabletLocator tabLocator = TabletLocator.getInstance(this.instance, new Text(tableId));
        for (Text split : partitionKeys) {
            boolean successful = false;
            int attempt = 0;
            while (!successful) {
                block16: {
                    if (attempt > 0) {
                        UtilWaitThread.sleep(100L);
                    }
                    ++attempt;
                    TabletLocator.TabletLocation tl = tabLocator.locateTablet(split, false, false, this.credentials);
                    if (tl == null) {
                        if (!Tables.exists(this.instance, tableId)) {
                            throw new TableNotFoundException(tableId, tableName, null);
                        }
                        if (Tables.getTableState(this.instance, tableId) != TableState.OFFLINE) continue;
                        throw new TableOfflineException(this.instance, tableId);
                    }
                    try {
                        TabletClientService.Client client = ThriftUtil.getTServerClient(tl.tablet_location, this.instance.getConfiguration());
                        try {
                            OpTimer opTimer = null;
                            if (log.isTraceEnabled()) {
                                opTimer = new OpTimer(log, Level.TRACE).start("Splitting tablet " + tl.tablet_extent + " on " + tl.tablet_location + " at " + split);
                            }
                            client.splitTablet(Tracer.traceInfo(), this.credentials, tl.tablet_extent.toThrift(), TextUtil.getByteBuffer(split));
                            tabLocator.invalidateCache(tl.tablet_extent);
                            if (opTimer == null) break block16;
                            opTimer.stop("Split tablet in %DURATION%");
                        }
                        finally {
                            ThriftUtil.returnClient(client);
                        }
                    }
                    catch (TApplicationException tae) {
                        throw new AccumuloServerException(tl.tablet_location, tae);
                    }
                    catch (TTransportException e) {
                        tabLocator.invalidateCache(tl.tablet_location);
                        continue;
                    }
                    catch (ThriftSecurityException e) {
                        Tables.clearCache(this.instance);
                        if (!Tables.exists(this.instance, tableId)) {
                            throw new TableNotFoundException(tableId, tableName, null);
                        }
                        throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
                    }
                    catch (NotServingTabletException e) {
                        tabLocator.invalidateCache(tl.tablet_extent);
                        continue;
                    }
                    catch (TException e) {
                        tabLocator.invalidateCache(tl.tablet_location);
                        continue;
                    }
                }
                successful = true;
            }
        }
    }

    @Override
    public void merge(String tableName, Text start, Text end) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        ByteBuffer EMPTY = ByteBuffer.allocate(0);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes()), start == null ? EMPTY : TextUtil.getByteBuffer(start), end == null ? EMPTY : TextUtil.getByteBuffer(end));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableOperation(TableOperation.MERGE, args, opts);
        }
        catch (TableExistsException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteRows(String tableName, Text start, Text end) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        ByteBuffer EMPTY = ByteBuffer.allocate(0);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes()), start == null ? EMPTY : TextUtil.getByteBuffer(start), end == null ? EMPTY : TextUtil.getByteBuffer(end));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableOperation(TableOperation.DELETE_RANGE, args, opts);
        }
        catch (TableExistsException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<Text> listSplits(String tableName) throws TableNotFoundException, AccumuloSecurityException {
        ArgumentChecker.notNull(tableName);
        String tableId = Tables.getTableId(this.instance, tableName);
        TreeSet<KeyExtent> tablets = new TreeSet<KeyExtent>();
        TreeMap<KeyExtent, String> locations = new TreeMap<KeyExtent, String>();
        while (true) {
            try {
                tablets.clear();
                locations.clear();
                MetadataTable.getEntries(this.instance, this.credentials, tableId, true, locations, tablets);
            }
            catch (AccumuloSecurityException ase) {
                throw ase;
            }
            catch (Throwable t) {
                if (!Tables.exists(this.instance, tableId)) {
                    throw new TableNotFoundException(tableId, tableName, null);
                }
                if (t instanceof RuntimeException && t.getCause() instanceof AccumuloSecurityException) {
                    throw (AccumuloSecurityException)t.getCause();
                }
                log.info((Object)(t.getMessage() + " ... retrying ..."));
                UtilWaitThread.sleep(3000L);
                continue;
            }
            break;
        }
        ArrayList<Text> endRows = new ArrayList<Text>(tablets.size());
        for (KeyExtent ke : tablets) {
            if (ke.getEndRow() == null) continue;
            endRows.add(ke.getEndRow());
        }
        return endRows;
    }

    @Override
    public Collection<Text> getSplits(String tableName) throws TableNotFoundException {
        try {
            return this.listSplits(tableName);
        }
        catch (AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<Text> listSplits(String tableName, int maxSplits) throws TableNotFoundException, AccumuloSecurityException {
        Collection<Text> endRows = this.listSplits(tableName);
        if (endRows.size() <= maxSplits) {
            return endRows;
        }
        double r = (double)(maxSplits + 1) / (double)endRows.size();
        double pos = 0.0;
        ArrayList<Text> subset = new ArrayList<Text>(maxSplits);
        int j = 0;
        for (int i = 0; i < endRows.size() && j < maxSplits; ++i) {
            pos += r;
            while (pos > 1.0) {
                subset.add((Text)((ArrayList)endRows).get(i));
                ++j;
                pos -= 1.0;
            }
        }
        return subset;
    }

    @Override
    public Collection<Text> getSplits(String tableName, int maxSplits) throws TableNotFoundException {
        try {
            return this.listSplits(tableName, maxSplits);
        }
        catch (AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes()));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableOperation(TableOperation.DELETE, args, opts);
        }
        catch (TableExistsException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clone(String srcTableName, String newTableName, boolean flush2, Map<String, String> propertiesToSet, Set<String> propertiesToExclude) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException {
        ArgumentChecker.notNull(srcTableName, newTableName);
        String srcTableId = Tables.getTableId(this.instance, srcTableName);
        if (flush2) {
            this._flush(srcTableId, null, null, true);
        }
        if (propertiesToExclude == null) {
            propertiesToExclude = Collections.emptySet();
        }
        if (propertiesToSet == null) {
            propertiesToSet = Collections.emptyMap();
        }
        if (!Collections.disjoint(propertiesToExclude, propertiesToSet.keySet())) {
            throw new IllegalArgumentException("propertiesToSet and propertiesToExclude not disjoint");
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(srcTableId.getBytes()), ByteBuffer.wrap(newTableName.getBytes()));
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.putAll(propertiesToSet);
        for (String prop : propertiesToExclude) {
            opts.put(prop, null);
        }
        this.doTableOperation(TableOperation.CLONE, args, opts);
    }

    @Override
    public void rename(String oldTableName, String newTableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException {
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(oldTableName.getBytes()), ByteBuffer.wrap(newTableName.getBytes()));
        HashMap<String, String> opts = new HashMap<String, String>();
        this.doTableOperation(TableOperation.RENAME, args, opts);
    }

    @Override
    @Deprecated
    public void flush(String tableName) throws AccumuloException, AccumuloSecurityException {
        try {
            this.flush(tableName, null, null, false);
        }
        catch (TableNotFoundException e) {
            throw new AccumuloException(e.getMessage(), e);
        }
    }

    @Override
    public void flush(String tableName, Text start, Text end, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        String tableId = Tables.getTableId(this.instance, tableName);
        this._flush(tableId, start, end, wait);
    }

    @Override
    public void compact(String tableName, Text start, Text end, boolean flush2, boolean wait) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        this.compact(tableName, start, end, new ArrayList<IteratorSetting>(), flush2, wait);
    }

    @Override
    public void compact(String tableName, Text start, Text end, List<IteratorSetting> iterators, boolean flush2, boolean wait) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        ArgumentChecker.notNull(tableName);
        ByteBuffer EMPTY = ByteBuffer.allocate(0);
        String tableId = Tables.getTableId(this.instance, tableName);
        if (flush2) {
            this._flush(tableId, start, end, true);
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.getBytes()), start == null ? EMPTY : TextUtil.getByteBuffer(start), end == null ? EMPTY : TextUtil.getByteBuffer(end), ByteBuffer.wrap(IteratorUtil.encodeIteratorSettings(iterators)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableOperation(TableOperation.COMPACT, args, opts, wait);
        }
        catch (TableExistsException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cancelCompaction(String tableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String tableId = Tables.getTableId(this.instance, tableName);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.getBytes()));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableOperation(TableOperation.COMPACT_CANCEL, args, opts, true);
        }
        catch (TableExistsException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _flush(String tableId, Text start, Text end, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try {
            long flushID;
            MasterClientService.Client client;
            while (true) {
                client = null;
                try {
                    client = MasterClient.getConnectionWithRetry(this.instance);
                    flushID = client.initiateFlush(Tracer.traceInfo(), this.credentials, tableId);
                }
                catch (TTransportException tte) {
                    log.debug((Object)"Failed to call initiateFlush, retrying ... ", (Throwable)tte);
                    UtilWaitThread.sleep(100L);
                    continue;
                }
                finally {
                    MasterClient.close(client);
                    continue;
                }
                break;
            }
            while (true) {
                client = null;
                try {
                    client = MasterClient.getConnectionWithRetry(this.instance);
                    client.waitForFlush(Tracer.traceInfo(), this.credentials, tableId, TextUtil.getByteBuffer(start), TextUtil.getByteBuffer(end), flushID, wait ? Long.MAX_VALUE : 1L);
                }
                catch (TTransportException tte) {
                    log.debug((Object)"Failed to call initiateFlush, retrying ... ", (Throwable)tte);
                    UtilWaitThread.sleep(100L);
                    continue;
                }
                finally {
                    MasterClient.close(client);
                    continue;
                }
                break;
            }
        }
        catch (ThriftSecurityException e) {
            if (e.getCode().equals((Object)SecurityErrorCode.TABLE_DOESNT_EXIST)) {
                throw new TableNotFoundException(tableId, null, e.getMessage(), (Throwable)((Object)e));
            }
            log.debug((Object)("flush security exception on table id " + tableId));
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NOTFOUND: {
                    throw new TableNotFoundException(e);
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void setProperty(final String tableName, final String property, final String value) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(tableName, property, value);
        MasterClient.execute(this.instance, new ClientExec<MasterClientService.Client>(){

            @Override
            public void execute(MasterClientService.Client client) throws Exception {
                client.setTableProperty(Tracer.traceInfo(), TableOperationsImpl.this.credentials, tableName, property, value);
            }
        });
    }

    @Override
    public void removeProperty(final String tableName, final String property) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(tableName, property);
        MasterClient.execute(this.instance, new ClientExec<MasterClientService.Client>(){

            @Override
            public void execute(MasterClientService.Client client) throws Exception {
                client.removeTableProperty(Tracer.traceInfo(), TableOperationsImpl.this.credentials, tableName, property);
            }
        });
    }

    @Override
    public Iterable<Map.Entry<String, String>> getProperties(final String tableName) throws AccumuloException, TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        try {
            return ServerClient.executeRaw(this.instance, new ClientExecReturn<Map<String, String>, ClientService.Client>(){

                @Override
                public Map<String, String> execute(ClientService.Client client) throws Exception {
                    return client.getTableConfiguration(Tracer.traceInfo(), TableOperationsImpl.this.credentials, tableName);
                }
            }).entrySet();
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NOTFOUND: {
                    throw new TableNotFoundException(e);
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void setLocalityGroups(String tableName, Map<String, Set<Text>> groups) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        HashSet all = new HashSet();
        for (Map.Entry<String, Set<Text>> entry : groups.entrySet()) {
            if (!Collections.disjoint(all, (Collection)entry.getValue())) {
                throw new IllegalArgumentException("Group " + entry.getKey() + " overlaps with another group");
            }
            all.addAll(entry.getValue());
        }
        for (Map.Entry<String, Set<Text>> entry : groups.entrySet()) {
            Set<Text> colFams = entry.getValue();
            String value = LocalityGroupUtil.encodeColumnFamilies(colFams);
            this.setProperty(tableName, (Object)((Object)Property.TABLE_LOCALITY_GROUP_PREFIX) + entry.getKey(), value);
        }
        this.setProperty(tableName, Property.TABLE_LOCALITY_GROUPS.getKey(), StringUtil.join(groups.keySet(), ","));
        String prefix = Property.TABLE_LOCALITY_GROUP_PREFIX.getKey();
        for (Map.Entry<String, String> entry : this.getProperties(tableName)) {
            String[] parts;
            String group;
            String property = entry.getKey();
            if (!property.startsWith(prefix) || groups.containsKey(group = (parts = property.split("\\."))[parts.length - 1])) continue;
            this.removeProperty(tableName, property);
        }
    }

    @Override
    public Map<String, Set<Text>> getLocalityGroups(String tableName) throws AccumuloException, TableNotFoundException {
        ConfigurationCopy conf = new ConfigurationCopy(this.getProperties(tableName));
        Map<String, Set<ByteSequence>> groups = LocalityGroupUtil.getLocalityGroups(conf);
        HashMap<String, Set<Text>> groups2 = new HashMap<String, Set<Text>>();
        for (Map.Entry<String, Set<ByteSequence>> entry : groups.entrySet()) {
            HashSet<Text> colFams = new HashSet<Text>();
            for (ByteSequence bs : entry.getValue()) {
                colFams.add(new Text(bs.toArray()));
            }
            groups2.put(entry.getKey(), colFams);
        }
        return groups2;
    }

    @Override
    public Set<Range> splitRangeByTablets(String tableName, Range range, int maxSplits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ArgumentChecker.notNull(tableName, range);
        if (maxSplits < 1) {
            throw new IllegalArgumentException("maximum splits must be >= 1");
        }
        if (maxSplits == 1) {
            return Collections.singleton(range);
        }
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        String tableId = Tables.getTableId(this.instance, tableName);
        TabletLocator tl = TabletLocator.getInstance(this.instance, new Text(tableId));
        tl.invalidateCache();
        while (!tl.binRanges(Collections.singletonList(range), binnedRanges, this.credentials).isEmpty()) {
            if (!Tables.exists(this.instance, tableId)) {
                throw new TableDeletedException(tableId);
            }
            if (Tables.getTableState(this.instance, tableId) == TableState.OFFLINE) {
                throw new TableOfflineException(this.instance, tableId);
            }
            log.warn((Object)"Unable to locate bins for specified range. Retrying.");
            UtilWaitThread.sleep(100 + (int)(Math.random() * 100.0));
            binnedRanges.clear();
            tl.invalidateCache();
        }
        LinkedList<Object> unmergedExtents = new LinkedList<Object>();
        ArrayList<Object> mergedExtents = new ArrayList<Object>();
        for (Map map : binnedRanges.values()) {
            unmergedExtents.addAll(map.keySet());
        }
        Collections.sort(unmergedExtents);
        while (unmergedExtents.size() + mergedExtents.size() > maxSplits) {
            if (unmergedExtents.size() >= 2) {
                KeyExtent first = (KeyExtent)unmergedExtents.removeFirst();
                KeyExtent second = (KeyExtent)unmergedExtents.removeFirst();
                first.setEndRow(second.getEndRow());
                mergedExtents.add(first);
                continue;
            }
            mergedExtents.addAll(unmergedExtents);
            unmergedExtents.clear();
            unmergedExtents.addAll(mergedExtents);
            mergedExtents.clear();
        }
        mergedExtents.addAll(unmergedExtents);
        HashSet<Range> ranges = new HashSet<Range>();
        for (KeyExtent keyExtent : mergedExtents) {
            ranges.add(keyExtent.toDataRange().clip(range));
        }
        return ranges;
    }

    @Override
    public void importDirectory(String tableName, String dir, String failureDir, boolean setTime) throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        ArgumentChecker.notNull(tableName, dir, failureDir);
        FileSystem fs = FileUtil.getFileSystem(CachedConfiguration.getInstance(), this.instance.getConfiguration());
        Path dirPath = fs.makeQualified(new Path(dir));
        Path failPath = fs.makeQualified(new Path(failureDir));
        if (!fs.exists(dirPath)) {
            throw new AccumuloException("Bulk import directory " + dir + " does not exist!");
        }
        if (!fs.exists(failPath)) {
            throw new AccumuloException("Bulk import failure directory " + failureDir + " does not exist!");
        }
        FileStatus[] listStatus = fs.listStatus(failPath);
        if (listStatus != null && listStatus.length != 0) {
            if (listStatus.length == 1 && listStatus[0].isDir()) {
                throw new AccumuloException("Bulk import directory " + failPath + " is a file");
            }
            throw new AccumuloException("Bulk import failure directory " + failPath + " is not empty");
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes()), ByteBuffer.wrap(dirPath.toString().getBytes()), ByteBuffer.wrap(failPath.toString().getBytes()), ByteBuffer.wrap((setTime + "").getBytes()));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableOperation(TableOperation.BULK_IMPORT, args, opts);
        }
        catch (TableExistsException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void offline(String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes()));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableOperation(TableOperation.OFFLINE, args, opts);
        }
        catch (TableExistsException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void online(String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes()));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableOperation(TableOperation.ONLINE, args, opts);
        }
        catch (TableExistsException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearLocatorCache(String tableName) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        TabletLocator tabLocator = TabletLocator.getInstance(this.instance, new Text(Tables.getTableId(this.instance, tableName)));
        tabLocator.invalidateCache();
    }

    @Override
    public Map<String, String> tableIdMap() {
        return Tables.getNameToIdMap(this.instance);
    }

    @Override
    public Text getMaxRow(String tableName, Authorizations auths, Text startRow, boolean startInclusive, Text endRow, boolean endInclusive) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(tableName, auths);
        Scanner scanner = this.instance.getConnector(this.credentials.getPrincipal(), CredentialHelper.extractToken(this.credentials)).createScanner(tableName, auths);
        return FindMax.findMax(scanner, startRow, startInclusive, endRow, endInclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getExportedProps(FileSystem fs, Path path) throws IOException {
        HashMap<String, String> props = new HashMap<String, String>();
        ZipInputStream zis = new ZipInputStream((InputStream)fs.open(path));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String line;
                if (!zipEntry.getName().equals("table_config.txt")) continue;
                BufferedReader in = new BufferedReader(new InputStreamReader(zis));
                while ((line = in.readLine()) != null) {
                    String[] sa = line.split("=", 2);
                    props.put(sa[0], sa[1]);
                }
                break;
            }
        }
        finally {
            zis.close();
        }
        return props;
    }

    @Override
    public void importTable(String tableName, String importDir) throws TableExistsException, AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(tableName, importDir);
        try {
            FileSystem fs = FileUtil.getFileSystem(CachedConfiguration.getInstance(), this.instance.getConfiguration());
            Map<String, String> props = TableOperationsImpl.getExportedProps(fs, new Path(importDir, "exportMetadata.zip"));
            for (String propKey : props.keySet()) {
                if (!Property.isClassProperty(propKey) || props.get(propKey).contains("org.apache.accumulo.core")) continue;
                Logger.getLogger(this.getClass()).info((Object)("Imported table sets '" + propKey + "' to '" + props.get(propKey) + "'.  Ensure this class is on Accumulo classpath."));
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(this.getClass()).warn((Object)("Failed to check if imported table references external java classes : " + ioe.getMessage()));
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes()), ByteBuffer.wrap(importDir.getBytes()));
        Map<String, String> opts = Collections.emptyMap();
        try {
            this.doTableOperation(TableOperation.IMPORT, args, opts);
        }
        catch (TableNotFoundException e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void exportTable(String tableName, String exportDir) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(tableName, exportDir);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes()), ByteBuffer.wrap(exportDir.getBytes()));
        Map<String, String> opts = Collections.emptyMap();
        try {
            this.doTableOperation(TableOperation.EXPORT, args, opts);
        }
        catch (TableExistsException e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public boolean testClassLoad(final String tableName, final String className, final String asTypeName) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(tableName, className, asTypeName);
        try {
            return ServerClient.executeRaw(this.instance, new ClientExecReturn<Boolean, ClientService.Client>(){

                @Override
                public Boolean execute(ClientService.Client client) throws Exception {
                    return client.checkTableClass(Tracer.traceInfo(), TableOperationsImpl.this.credentials, tableName, className, asTypeName);
                }
            });
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NOTFOUND: {
                    throw new TableNotFoundException(e);
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void attachIterator(String tableName, IteratorSetting setting, EnumSet<IteratorUtil.IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.testClassLoad(tableName, setting.getIteratorClass(), SortedKeyValueIterator.class.getName());
        super.attachIterator(tableName, setting, scopes);
    }

    @Override
    public int addConstraint(String tableName, String constraintClassName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        this.testClassLoad(tableName, constraintClassName, Constraint.class.getName());
        return super.addConstraint(tableName, constraintClassName);
    }

    private class SplitTask
    implements Runnable {
        private List<Text> splits;
        private SplitEnv env;

        SplitTask(SplitEnv env, List<Text> splits) {
            this.env = env;
            this.splits = splits;
        }

        @Override
        public void run() {
            try {
                if (this.env.exception.get() != null) {
                    return;
                }
                if (this.splits.size() <= 2) {
                    TableOperationsImpl.this.addSplits(this.env.tableName, new TreeSet<Text>(this.splits), this.env.tableId);
                    for (int i = 0; i < this.splits.size(); ++i) {
                        this.env.latch.countDown();
                    }
                    return;
                }
                int mid = this.splits.size() / 2;
                TableOperationsImpl.this.addSplits(this.env.tableName, new TreeSet<Text>(this.splits.subList(mid, mid + 1)), this.env.tableId);
                this.env.latch.countDown();
                this.env.executor.submit(new SplitTask(this.env, this.splits.subList(0, mid)));
                this.env.executor.submit(new SplitTask(this.env, this.splits.subList(mid + 1, this.splits.size())));
            }
            catch (Exception e) {
                this.env.exception.compareAndSet(null, e);
            }
        }
    }

    private static class SplitEnv {
        private String tableName;
        private String tableId;
        private ExecutorService executor;
        private CountDownLatch latch;
        private AtomicReference<Exception> exception;

        SplitEnv(String tableName, String tableId, ExecutorService executor, CountDownLatch latch, AtomicReference<Exception> exception) {
            this.tableName = tableName;
            this.tableId = tableId;
            this.executor = executor;
            this.latch = latch;
            this.exception = exception;
        }
    }
}

