/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import org.apache.accumulo.core.util.ArgumentChecker;

class ThriftTransportKey {
    private final String location;
    private final int port;
    private final long timeout;
    private int hash = -1;

    ThriftTransportKey(String location, int port, long timeout) {
        ArgumentChecker.notNull(location);
        this.location = location;
        this.port = port;
        this.timeout = timeout;
    }

    String getLocation() {
        return this.location;
    }

    int getPort() {
        return this.port;
    }

    long getTimeout() {
        return this.timeout;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ThriftTransportKey)) {
            return false;
        }
        ThriftTransportKey ttk = (ThriftTransportKey)o;
        return this.location.equals(ttk.location) && this.port == ttk.port && this.timeout == ttk.timeout;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = (this.location + Integer.toString(this.port) + Long.toString(this.timeout)).hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return this.location + ":" + Integer.toString(this.port) + " (" + Long.toString(this.timeout) + ")";
    }
}

