/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.net.InetSocketAddress;
import java.util.EnumMap;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;

public class ServerServices
implements Comparable<ServerServices> {
    public static final String SERVICE_SEPARATOR = ";";
    public static final String SEPARATOR_CHAR = "=";
    private EnumMap<Service, String> services = new EnumMap(Service.class);
    private String stringForm = null;

    public ServerServices(String services) {
        String[] addresses;
        for (String address : addresses = services.split(SERVICE_SEPARATOR)) {
            String[] sa = address.split(SEPARATOR_CHAR, 2);
            this.services.put(Service.valueOf(sa[0]), sa[1]);
        }
    }

    public ServerServices(String address, Service service) {
        this(service.name() + SEPARATOR_CHAR + address);
    }

    public String getAddressString(Service service) {
        return this.services.get((Object)service);
    }

    public InetSocketAddress getAddress(Service service) {
        String address = this.getAddressString(service);
        String[] parts = address.split(":", 2);
        if (parts.length == 2) {
            if (parts[1].isEmpty()) {
                return new InetSocketAddress(parts[0], service.getDefaultPort());
            }
            return new InetSocketAddress(parts[0], Integer.parseInt(parts[1]));
        }
        return new InetSocketAddress(address, service.getDefaultPort());
    }

    public String toString() {
        if (this.stringForm == null) {
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            for (Service service : new Service[]{Service.MASTER_CLIENT, Service.TSERV_CLIENT, Service.GC_CLIENT}) {
                if (!this.services.containsKey((Object)service)) continue;
                sb.append(prefix).append(service.name()).append(SEPARATOR_CHAR).append(this.services.get((Object)service));
                prefix = SERVICE_SEPARATOR;
            }
            this.stringForm = sb.toString();
        }
        return this.stringForm;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ServerServices) {
            return this.toString().equals(((ServerServices)o).toString());
        }
        return false;
    }

    @Override
    public int compareTo(ServerServices other) {
        return this.toString().compareTo(other.toString());
    }

    public static enum Service {
        TSERV_CLIENT,
        MASTER_CLIENT,
        GC_CLIENT;


        int getDefaultPort() {
            switch (this) {
                case TSERV_CLIENT: {
                    return AccumuloConfiguration.getDefaultConfiguration().getPort(Property.TSERV_CLIENTPORT);
                }
                case MASTER_CLIENT: {
                    return AccumuloConfiguration.getDefaultConfiguration().getPort(Property.MASTER_CLIENTPORT);
                }
                case GC_CLIENT: {
                    return AccumuloConfiguration.getDefaultConfiguration().getPort(Property.GC_PORT);
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

