/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.IOException;
import org.apache.pig.ErrorHandler;
import org.apache.pig.ErrorHandling;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;

public class StoreFuncDecorator {
    private final StoreFuncInterface storer;
    private final String udfSignature;
    private boolean shouldHandleErrors;
    private ErrorHandler errorHandler;

    public StoreFuncDecorator(StoreFuncInterface storer, String udfSignature) {
        this.storer = storer;
        this.udfSignature = udfSignature;
        this.init();
    }

    private void init() {
        if (UDFContext.getUDFContext().isFrontend()) {
            return;
        }
        if (this.storer instanceof ErrorHandling && this.allowErrors()) {
            this.errorHandler = ((ErrorHandling)((Object)this.storer)).getErrorHandler();
            this.shouldHandleErrors = true;
        }
    }

    private boolean allowErrors() {
        return UDFContext.getUDFContext().getJobConf().getBoolean("pig.error-handling.enabled", false);
    }

    public void putNext(Tuple tuple) throws IOException {
        try {
            this.storer.putNext(tuple);
            if (this.shouldHandleErrors) {
                this.errorHandler.onSuccess(this.udfSignature);
            }
        }
        catch (Exception e) {
            if (this.shouldHandleErrors) {
                this.errorHandler.onError(this.udfSignature, e, tuple);
            }
            throw new IOException(e);
        }
    }

    public StoreFuncInterface getStorer() {
        return this.storer;
    }
}

