/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.udf;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PigProcessor;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.builtin.FindQuantiles;

public class FindQuantilesTez
extends FindQuantiles {
    private static final Log LOG = LogFactory.getLog(FindQuantilesTez.class);
    private static TupleFactory tf = TupleFactory.getInstance();

    public FindQuantilesTez() {
    }

    public FindQuantilesTez(String[] args) {
        super(args);
    }

    @Override
    public Map<String, Object> exec(Tuple in) throws IOException {
        int estimatedNumReducers = -1;
        boolean estimate_sample_quantile = ((Configuration)PigMapReduce.sJobConfInternal.get()).getBoolean("pig.exec.estimate.parallelism", false);
        DataBag mySamples = (DataBag)in.get(1);
        this.samples = BagFactory.getInstance().newDefaultBag();
        Iterator<Tuple> iter = mySamples.iterator();
        long totalInputRows = 0L;
        long sampleSize = 0L;
        while (iter.hasNext()) {
            Tuple t = iter.next();
            if (t.get(t.size() - 1) != null) {
                totalInputRows += ((Long)t.get(t.size() - 1)).longValue();
            }
            if (t.get(t.size() - 2) != null) {
                sampleSize += this.getMemorySize(t);
            }
            if (t.size() <= 2) continue;
            Tuple newTuple = tf.newTuple(t.size() - 2);
            for (int i = 0; i < t.size() - 2; ++i) {
                newTuple.set(i, t.get(i));
            }
            this.samples.add(newTuple);
        }
        if (estimate_sample_quantile) {
            long bytesPerTask = ((Configuration)PigMapReduce.sJobConfInternal.get()).getLong("pig.exec.reducers.bytes.per.reducer", 1000000000L);
            long estimatedInputSize = (long)((double)sampleSize / (double)mySamples.size() * (double)totalInputRows);
            estimatedNumReducers = (int)Math.ceil((double)estimatedInputSize / (double)bytesPerTask);
            if ((estimatedNumReducers = Math.min(estimatedNumReducers, 999)) == 0) {
                estimatedNumReducers = 1;
            }
            LOG.info((Object)("Estimating parallelism: estimatedInputSize is " + estimatedInputSize + ". bytesPerTask is " + bytesPerTask + ". estimatedNumQuantiles is " + estimatedNumReducers + "."));
            this.numQuantiles = estimatedNumReducers;
            LOG.info((Object)("Use estimated parallelism instead:" + estimatedNumReducers));
        }
        Object result = super.exec(in);
        if (estimate_sample_quantile) {
            result.put("pig.exec.estimated.num.parallelism", this.numQuantiles);
        }
        PigProcessor.sampleMap = result;
        return result;
    }

    protected long getMemorySize(Tuple t) {
        int s = t.size();
        try {
            return (Long)t.get(s - 2);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrive the size field from tuple.", e);
        }
    }
}

