/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.spark;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobClient;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.spark.JobMetricsListener;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.NativeSparkOperator;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.ScriptState;
import org.apache.pig.tools.pigstats.spark.SparkCounter;
import org.apache.pig.tools.pigstats.spark.SparkJobStats;
import org.apache.pig.tools.pigstats.spark.SparkScriptState;
import org.apache.pig.tools.pigstats.spark.SparkStatsUtil;
import org.apache.spark.api.java.JavaSparkContext;

public class SparkPigStats
extends PigStats {
    private Map<SparkJobStats, SparkOperator> jobSparkOperatorMap = new HashMap<SparkJobStats, SparkOperator>();
    private static final Log LOG = LogFactory.getLog(SparkPigStats.class);
    private Set<SparkOperator> sparkOperatorsSet = new HashSet<SparkOperator>();
    private SparkScriptState sparkScriptState;
    private Configuration conf;

    public SparkPigStats() {
        this.jobPlan = new PigStats.JobGraph();
        this.sparkScriptState = (SparkScriptState)ScriptState.get();
    }

    public void initialize(PigContext pigContext, SparkOperPlan sparkPlan, Configuration conf) {
        super.start();
        this.pigContext = pigContext;
        this.conf = conf;
        this.sparkScriptState.setScriptInfo(sparkPlan);
    }

    public void addJobStats(POStore poStore, SparkOperator sparkOperator, int jobId, JobMetricsListener jobMetricsListener, JavaSparkContext sparkContext) {
        boolean isSuccess = SparkStatsUtil.isJobSuccess(jobId, sparkContext);
        SparkJobStats jobStats = new SparkJobStats(jobId, this.jobPlan, this.conf);
        jobStats.setSuccessful(isSuccess);
        jobStats.collectStats(jobMetricsListener);
        jobStats.addOutputInfo(poStore, isSuccess, jobMetricsListener);
        this.addInputInfoForSparkOper(sparkOperator, jobStats, isSuccess, jobMetricsListener, this.conf);
        jobStats.initWarningCounters();
        this.jobSparkOperatorMap.put(jobStats, sparkOperator);
        this.jobPlan.add(jobStats);
    }

    public void addFailJobStats(POStore poStore, SparkOperator sparkOperator, String jobId, JobMetricsListener jobMetricsListener, JavaSparkContext sparkContext, Exception e) {
        boolean isSuccess = false;
        SparkJobStats jobStats = new SparkJobStats(jobId, this.jobPlan, this.conf);
        jobStats.setSuccessful(isSuccess);
        jobStats.collectStats(jobMetricsListener);
        jobStats.addOutputInfo(poStore, isSuccess, jobMetricsListener);
        this.addInputInfoForSparkOper(sparkOperator, jobStats, isSuccess, jobMetricsListener, this.conf);
        this.jobSparkOperatorMap.put(jobStats, sparkOperator);
        this.jobPlan.add(jobStats);
        jobStats.setBackendException(e);
    }

    public void addNativeJobStats(NativeSparkOperator sparkOperator, String jobId, boolean isSuccess, Exception e) {
        SparkJobStats jobStats = new SparkJobStats(jobId, this.jobPlan, this.conf);
        jobStats.setSuccessful(isSuccess);
        this.jobSparkOperatorMap.put(jobStats, sparkOperator);
        this.jobPlan.add(jobStats);
        jobStats.setBackendException(e);
    }

    public void finish() {
        super.stop();
        this.display();
    }

    private void display() {
        LOG.info((Object)this.getDisplayString());
        this.handleAggregateWarnings();
    }

    private void handleAggregateWarnings() {
        HashMap<Enum, Long> warningAggMap = new HashMap<Enum, Long>();
        for (SparkJobStats js : this.jobPlan) {
            Map<String, Long> warningCounters;
            Map<String, SparkCounter<Map<String, Long>>> counterMap = js.getWarningCounters();
            if (counterMap == null || (warningCounters = counterMap.get(PigWarning.SPARK_WARN.name()).getValue()) == null) continue;
            for (String warnKey : warningCounters.keySet()) {
                Long val = (Long)warningAggMap.get(warnKey);
                val = val != null ? Long.valueOf(val + warningCounters.get(warnKey)) : warningCounters.get(warnKey);
                warningAggMap.put(PigWarning.valueOf(warnKey), val);
            }
        }
        CompilationMessageCollector.logAggregate(warningAggMap, CompilationMessageCollector.MessageType.Warning, LOG);
    }

    @Override
    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        for (SparkJobStats js : this.jobPlan) {
            if (this.jobSparkOperatorMap.containsKey(js)) {
                SparkOperator sparkOperator = this.jobSparkOperatorMap.get(js);
                js.setAlias(sparkOperator);
            }
            sb.append("Spark Job [" + js.getJobId() + "] Metrics");
            Map<String, Long> stats = js.getStats();
            if (stats == null) {
                sb.append("No statistics found for job " + js.getJobId());
                return sb.toString();
            }
            for (Map.Entry<String, Long> pairs : stats.entrySet()) {
                sb.append("\t" + pairs.getKey() + " : " + pairs.getValue());
            }
            for (InputStats inputStat : js.getInputs()) {
                sb.append("\t" + inputStat.getDisplayString());
            }
        }
        return sb.toString();
    }

    @Override
    public JobClient getJobClient() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public Map<String, List<PigStats>> getAllStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllErrorMessages() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSMMSpillCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getProactiveSpillCountObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getProactiveSpillCountRecords() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberJobs() {
        return this.jobPlan.size();
    }

    private void addInputInfoForSparkOper(SparkOperator sparkOperator, SparkJobStats jobStats, boolean isSuccess, JobMetricsListener jobMetricsListener, Configuration conf) {
        if (this.sparkOperatorsSet.contains(sparkOperator)) {
            return;
        }
        try {
            LinkedList<POLoad> poLoads = PlanHelper.getPhysicalOperators(sparkOperator.physicalPlan, POLoad.class);
            for (POLoad load : poLoads) {
                if (load.isTmpLoad()) continue;
                jobStats.addInputStats(load, isSuccess, poLoads.size() == 1);
            }
        }
        catch (VisitorException ve) {
            LOG.warn((Object)ve);
        }
        this.sparkOperatorsSet.add(sparkOperator);
    }
}

