/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.codehaus.jackson.JsonNode;

public class AvroStorageUtils {
    public static Schema BooleanSchema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
    public static Schema LongSchema = Schema.create((Schema.Type)Schema.Type.LONG);
    public static Schema FloatSchema = Schema.create((Schema.Type)Schema.Type.FLOAT);
    public static Schema DoubleSchema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
    public static Schema IntSchema = Schema.create((Schema.Type)Schema.Type.INT);
    public static Schema StringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
    public static Schema BytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
    public static Schema NullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final String NONAME = "NONAME";
    private static final String PIG_TUPLE_WRAPPER = "PIG_WRAPPER";
    public static PathFilter PATH_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return !path.getName().startsWith("_") && !path.getName().startsWith(".");
        }
    };

    static String getDummyFieldName(int index) {
        return "NONAME_" + index;
    }

    public static Schema.Field createUDField(int index, Schema s) {
        return new Schema.Field(AvroStorageUtils.getDummyFieldName(index), s, null, null);
    }

    public static Schema createUDPartialRecordSchema() {
        return Schema.createRecord((String)NONAME, null, null, (boolean)false);
    }

    public static boolean isUDPartialRecordSchema(Schema s) {
        return s.getName().equals(NONAME);
    }

    public static Schema.Field getUDField(Schema s, int index) {
        return s.getField(AvroStorageUtils.getDummyFieldName(index));
    }

    public static Set<Path> getPaths(String pathString, Configuration conf, boolean failIfNotFound) throws IOException {
        String[] pathStrs;
        HashSet<Path> paths = new HashSet<Path>();
        for (String pathStr : pathStrs = LoadFunc.getPathStrings((String)pathString)) {
            FileSystem fs = FileSystem.get((URI)new Path(pathStr).toUri(), (Configuration)conf);
            FileStatus[] matchedFiles = fs.globStatus(new Path(pathStr), PATH_FILTER);
            if (matchedFiles == null || matchedFiles.length == 0) {
                if (!failIfNotFound) continue;
                throw new IOException("Input Pattern " + pathStr + " matches 0 files");
            }
            for (FileStatus file : matchedFiles) {
                paths.add(file.getPath());
            }
        }
        return paths;
    }

    public static Set<Path> getAllFilesRecursively(Set<Path> basePaths, Configuration conf) throws IOException {
        HashSet<Path> paths = new HashSet<Path>();
        for (Path path : basePaths) {
            FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
            FileStatus f = fs.getFileStatus(path);
            if (f.isDir()) {
                AvroStorageUtils.getAllFilesInternal(f, conf, paths, fs);
                continue;
            }
            paths.add(path);
        }
        return paths;
    }

    private static void getAllFilesInternal(FileStatus file, Configuration conf, Set<Path> paths, FileSystem fs) throws IOException {
        for (FileStatus f : fs.listStatus(file.getPath(), PATH_FILTER)) {
            if (f.isDir()) {
                AvroStorageUtils.getAllFilesInternal(f, conf, paths, fs);
                continue;
            }
            paths.add(f.getPath());
        }
    }

    public static boolean noDir(FileStatus[] ss) {
        for (FileStatus s : ss) {
            if (!s.isDir()) continue;
            return false;
        }
        return true;
    }

    public static Path getLast(Path path, FileSystem fs) throws IOException {
        FileStatus status = fs.getFileStatus(path);
        if (!status.isDir()) {
            return path;
        }
        Object[] statuses = fs.listStatus(path, PATH_FILTER);
        if (statuses.length == 0) {
            return null;
        }
        Arrays.sort(statuses);
        for (int i = statuses.length - 1; i >= 0; --i) {
            if (statuses[i].isDir()) continue;
            return statuses[i].getPath();
        }
        return null;
    }

    private static Schema.Type mergeType(Schema.Type x, Schema.Type y) {
        if (x.equals((Object)y)) {
            return x;
        }
        switch (x) {
            case INT: {
                switch (y) {
                    case LONG: {
                        return Schema.Type.LONG;
                    }
                    case FLOAT: {
                        return Schema.Type.FLOAT;
                    }
                    case DOUBLE: {
                        return Schema.Type.DOUBLE;
                    }
                    case ENUM: 
                    case STRING: {
                        return Schema.Type.STRING;
                    }
                }
            }
            case LONG: {
                switch (y) {
                    case INT: {
                        return Schema.Type.LONG;
                    }
                    case FLOAT: {
                        return Schema.Type.FLOAT;
                    }
                    case DOUBLE: {
                        return Schema.Type.DOUBLE;
                    }
                    case ENUM: 
                    case STRING: {
                        return Schema.Type.STRING;
                    }
                }
            }
            case FLOAT: {
                switch (y) {
                    case LONG: 
                    case INT: {
                        return Schema.Type.FLOAT;
                    }
                    case DOUBLE: {
                        return Schema.Type.DOUBLE;
                    }
                    case ENUM: 
                    case STRING: {
                        return Schema.Type.STRING;
                    }
                }
            }
            case DOUBLE: {
                switch (y) {
                    case LONG: 
                    case FLOAT: 
                    case INT: {
                        return Schema.Type.DOUBLE;
                    }
                    case ENUM: 
                    case STRING: {
                        return Schema.Type.STRING;
                    }
                }
            }
            case ENUM: {
                switch (y) {
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: 
                    case INT: {
                        return Schema.Type.STRING;
                    }
                }
            }
            case STRING: {
                switch (y) {
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case ENUM: 
                    case INT: {
                        return Schema.Type.STRING;
                    }
                }
            }
        }
        return null;
    }

    public static Schema mergeSchema(Schema x, Schema y) throws IOException {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (x.equals((Object)y)) {
            return x;
        }
        Schema.Type xType = x.getType();
        Schema.Type yType = y.getType();
        switch (xType) {
            case RECORD: {
                if (!yType.equals((Object)Schema.Type.RECORD)) {
                    throw new IOException("Cannot merge " + xType + " with " + yType);
                }
                List xFields = x.getFields();
                List yFields = y.getFields();
                LinkedHashMap<String, Schema> fieldName2Schema = new LinkedHashMap<String, Schema>(xFields.size() + yFields.size());
                LinkedHashMap<String, JsonNode> fieldName2Default = new LinkedHashMap<String, JsonNode>(xFields.size() + yFields.size());
                for (Schema.Field xField : xFields) {
                    fieldName2Schema.put(xField.name(), xField.schema());
                    fieldName2Default.put(xField.name(), xField.defaultValue());
                }
                for (Object yField : yFields) {
                    String string = yField.name();
                    Schema currSchema = yField.schema();
                    Schema prevSchema = (Schema)fieldName2Schema.get(string);
                    if (prevSchema == null) {
                        fieldName2Schema.put(string, currSchema);
                        fieldName2Default.put(string, yField.defaultValue());
                        continue;
                    }
                    fieldName2Schema.put(string, AvroStorageUtils.mergeSchema(prevSchema, currSchema));
                    JsonNode xDefaultValue = (JsonNode)fieldName2Default.get(string);
                    JsonNode yDefaultValue = yField.defaultValue();
                    if (xDefaultValue != null) {
                        if (yDefaultValue == null || xDefaultValue.equals((Object)yDefaultValue)) continue;
                        throw new IOException("Cannot merge schema's which have different default values - " + xDefaultValue + " and " + yDefaultValue);
                    }
                    fieldName2Default.put(string, yDefaultValue);
                }
                ArrayList<Schema.Field> mergedFields = new ArrayList<Schema.Field>(fieldName2Schema.size());
                for (Map.Entry entry : fieldName2Schema.entrySet()) {
                    mergedFields.add(new Schema.Field((String)entry.getKey(), (Schema)entry.getValue(), "auto-gen", (JsonNode)fieldName2Default.get(entry.getKey())));
                }
                Schema result = Schema.createRecord((String)"merged", null, (String)"merged schema (generated by AvroStorage)", (boolean)false);
                result.setFields(mergedFields);
                return result;
            }
            case ARRAY: {
                if (!yType.equals((Object)Schema.Type.ARRAY)) {
                    throw new IOException("Cannot merge " + xType + " with " + yType);
                }
                return Schema.createArray((Schema)AvroStorageUtils.mergeSchema(x.getElementType(), y.getElementType()));
            }
            case MAP: {
                if (!yType.equals((Object)Schema.Type.MAP)) {
                    throw new IOException("Cannot merge " + xType + " with " + yType);
                }
                return Schema.createMap((Schema)AvroStorageUtils.mergeSchema(x.getValueType(), y.getValueType()));
            }
            case UNION: {
                if (!yType.equals((Object)Schema.Type.UNION)) {
                    throw new IOException("Cannot merge " + xType + " with " + yType);
                }
                List list = x.getTypes();
                List yTypes = y.getTypes();
                ArrayList<Schema> unionTypes = new ArrayList<Schema>();
                for (Schema xSchema : list) {
                    unionTypes.add(xSchema);
                }
                for (Schema ySchema : yTypes) {
                    if (unionTypes.contains(ySchema)) continue;
                    unionTypes.add(ySchema);
                }
                return Schema.createUnion(unionTypes);
            }
            case FIXED: {
                int ySize;
                if (!yType.equals((Object)Schema.Type.FIXED)) {
                    throw new IOException("Cannot merge " + xType + " with " + yType);
                }
                int xSize = x.getFixedSize();
                if (xSize != (ySize = y.getFixedSize())) {
                    throw new IOException("Cannot merge FIXED types with different sizes: " + xSize + " and " + ySize);
                }
                return Schema.createFixed((String)"merged", null, (String)"merged schema (generated by AvroStorage)", (int)xSize);
            }
        }
        Schema.Type mergedType = AvroStorageUtils.mergeType(xType, yType);
        if (mergedType == null) {
            throw new IOException("Cannot merge " + xType + " with " + yType);
        }
        return Schema.create((Schema.Type)mergedType);
    }

    public static Map<Path, Map<Integer, Integer>> getSchemaToMergedSchemaMap(Schema mergedSchema, Map<Path, Schema> mergedFiles) throws IOException {
        if (!mergedSchema.getType().equals((Object)Schema.Type.RECORD)) {
            throw new IOException("Remapping of non-record schemas is not supported");
        }
        HashMap<Path, Map<Integer, Integer>> result = new HashMap<Path, Map<Integer, Integer>>(mergedFiles.size());
        for (Map.Entry<Path, Schema> entry : mergedFiles.entrySet()) {
            Path path = entry.getKey();
            Schema schema = entry.getValue();
            if (!schema.getType().equals((Object)Schema.Type.RECORD)) {
                throw new IOException("Remapping of non-record schemas is not supported");
            }
            List fields = schema.getFields();
            HashMap<Integer, Integer> oldPos2NewPos = (HashMap<Integer, Integer>)result.get(path);
            if (oldPos2NewPos == null) {
                oldPos2NewPos = new HashMap<Integer, Integer>(fields.size());
                result.put(path, oldPos2NewPos);
            }
            for (Schema.Field field : fields) {
                String fieldName = field.name();
                int oldPos = schema.getField(fieldName).pos();
                int newPos = mergedSchema.getField(fieldName).pos();
                oldPos2NewPos.put(oldPos, newPos);
            }
        }
        return result;
    }

    public static Schema wrapAsUnion(Schema schema, boolean nullable) {
        if (nullable) {
            if (schema.getType().equals((Object)Schema.Type.UNION) && AvroStorageUtils.isAcceptableUnion(schema)) {
                return schema;
            }
            return Schema.createUnion(Arrays.asList(NullSchema, schema));
        }
        return schema;
    }

    public static boolean containsRecursiveRecord(Schema s) {
        HashSet<String> set = new HashSet<String>();
        return AvroStorageUtils.containsRecursiveRecord(s, set);
    }

    protected static boolean containsRecursiveRecord(Schema s, Set<String> definedRecordNames) {
        if (s.getType().equals((Object)Schema.Type.RECORD)) {
            String name = s.getName();
            if (definedRecordNames.contains(name)) {
                return true;
            }
            definedRecordNames.add(s.getName());
            List fields = s.getFields();
            for (Schema.Field field : fields) {
                Schema fs = field.schema();
                if (!AvroStorageUtils.containsRecursiveRecord(fs, definedRecordNames)) continue;
                return true;
            }
            definedRecordNames.remove(s.getName());
            return false;
        }
        if (s.getType().equals((Object)Schema.Type.ARRAY)) {
            Schema fs = s.getElementType();
            return AvroStorageUtils.containsRecursiveRecord(fs, definedRecordNames);
        }
        if (s.getType().equals((Object)Schema.Type.MAP)) {
            Schema vs = s.getValueType();
            return AvroStorageUtils.containsRecursiveRecord(vs, definedRecordNames);
        }
        if (s.getType().equals((Object)Schema.Type.UNION)) {
            List types = s.getTypes();
            for (Schema type : types) {
                if (!AvroStorageUtils.containsRecursiveRecord(type, definedRecordNames)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean containsGenericUnion(Schema s) {
        HashSet<Schema> set = new HashSet<Schema>();
        return AvroStorageUtils.containsGenericUnion(s, set);
    }

    protected static boolean containsGenericUnion(Schema s, Set<Schema> visitedRecords) {
        if (s.getType().equals((Object)Schema.Type.RECORD)) {
            visitedRecords.add(s);
            List fields = s.getFields();
            for (Schema.Field field : fields) {
                Schema fs = field.schema();
                if (visitedRecords.contains(fs) || !AvroStorageUtils.containsGenericUnion(fs, visitedRecords)) continue;
                return true;
            }
            return false;
        }
        if (s.getType().equals((Object)Schema.Type.ARRAY)) {
            Schema fs = s.getElementType();
            if (!visitedRecords.contains(fs)) {
                return AvroStorageUtils.containsGenericUnion(fs, visitedRecords);
            }
            return false;
        }
        if (s.getType().equals((Object)Schema.Type.MAP)) {
            Schema vs = s.getValueType();
            if (!visitedRecords.contains(vs)) {
                return AvroStorageUtils.containsGenericUnion(vs, visitedRecords);
            }
            return false;
        }
        if (s.getType().equals((Object)Schema.Type.UNION)) {
            List types = s.getTypes();
            for (Schema type : types) {
                if (visitedRecords.contains(type) || !AvroStorageUtils.containsGenericUnion(type, visitedRecords)) continue;
                return true;
            }
            return !AvroStorageUtils.isAcceptableUnion(s);
        }
        return false;
    }

    public static boolean isAcceptableUnion(Schema in) {
        if (!in.getType().equals((Object)Schema.Type.UNION)) {
            return false;
        }
        List types = in.getTypes();
        if (types.size() <= 1) {
            return true;
        }
        if (types.size() > 2) {
            return false;
        }
        return ((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) || ((Schema)types.get(1)).getType().equals((Object)Schema.Type.NULL);
    }

    public static ResourceSchema.ResourceFieldSchema wrapAsTuple(ResourceSchema.ResourceFieldSchema subFieldSchema) throws IOException {
        ResourceSchema listSchema = new ResourceSchema();
        listSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{subFieldSchema});
        ResourceSchema.ResourceFieldSchema tupleWrapper = new ResourceSchema.ResourceFieldSchema();
        tupleWrapper.setType((byte)110);
        tupleWrapper.setName(PIG_TUPLE_WRAPPER);
        tupleWrapper.setSchema(listSchema);
        return tupleWrapper;
    }

    public static boolean isTupleWrapper(ResourceSchema.ResourceFieldSchema pigSchema) {
        Boolean status = false;
        if (pigSchema.getType() == 110 && pigSchema.getName() != null && pigSchema.getName().equals(PIG_TUPLE_WRAPPER)) {
            status = true;
        }
        return status;
    }

    public static Schema getAcceptedType(Schema in) {
        if (!AvroStorageUtils.isAcceptableUnion(in)) {
            throw new RuntimeException("Cannot call this function on a unacceptable union");
        }
        List types = in.getTypes();
        switch (types.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Schema)types.get(0);
            }
            case 2: {
                return ((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) ? (Schema)types.get(1) : (Schema)types.get(0);
            }
        }
        return null;
    }

    public static Schema getSchema(Path path, FileSystem fs) throws IOException {
        Path lastFile = AvroStorageUtils.getLast(path, fs);
        if (lastFile == null) {
            return null;
        }
        GenericDatumReader avroReader = new GenericDatumReader();
        FSDataInputStream hdfsInputStream = fs.open(lastFile);
        DataFileStream avroDataStream = new DataFileStream((InputStream)hdfsInputStream, (DatumReader)avroReader);
        Schema ret = avroDataStream.getSchema();
        avroDataStream.close();
        return ret;
    }
}

