/*
 * Decompiled with CFR 0.152.
 */
package sdsu.html;

import sdsu.html.HTML;

public class Image
implements HTML {
    String alignment = null;
    String alternativeText = "";
    String mapURL = null;
    String imageURL = null;
    String borderSize = null;
    String height = null;
    String width = null;
    String verticalGutter = null;
    String horizontalGutter = null;
    String linkURL = null;
    boolean centerImage = false;
    boolean putTextOnNextLine = false;
    boolean isMap = false;

    public Image(String string) {
        this(string, "");
    }

    public Image(String string, String string2) {
        this.imageURL = "\"" + string.trim() + "\"";
        this.alternativeText = "\"" + string2 + "\"";
    }

    public void alignCenter() {
        this.centerImage = true;
    }

    public void alignLeft() {
        this.alignment = "LEFT";
    }

    public void alignRight() {
        this.alignment = "RIGHT";
    }

    public void alignTextBelow() {
        this.putTextOnNextLine = true;
    }

    public void alignTextBottom() {
        this.alignment = "BOTTOM";
    }

    public void alignTextMiddle() {
        this.alignment = "MIDDLE";
    }

    public void alignTextTop() {
        this.alignment = "TOP";
    }

    public static Image blackSDSU() {
        Image image = new Image("http://www.sdsu.edu/graphics/sdsu_logo_9.gif");
        return image;
    }

    public static Image dividerBar(String string) {
        Image image = new Image("http://www.sdsu.edu/graphics/divider_" + string.trim() + ".gif", "----------------------------------------------------------------------");
        image.setWidthPercent(100);
        image.setHeight(6);
        return image;
    }

    public void link(String string) {
        this.linkURL = string;
        if (this.borderSize == null) {
            this.borderSize = "0";
        }
    }

    public static Image redDividerBar() {
        return Image.dividerBar("red");
    }

    public static Image redSDSU() {
        Image image = new Image("http://www.sdsu.edu/graphics/sdsu_logo_3.gif");
        return image;
    }

    public void setBorderSize(int n) {
        this.borderSize = String.valueOf(n);
    }

    public void setHeight(int n) {
        this.height = String.valueOf(n);
    }

    public void setWidth(int n) {
        this.width = String.valueOf(n);
    }

    public void setWidthPercent(int n) {
        this.width = "\"" + String.valueOf(n) + "%\"";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("<IMG ");
        stringBuffer.append("SRC=" + this.imageURL + " ");
        stringBuffer.append("ALT=" + this.alternativeText + " ");
        if (this.alignment != null) {
            stringBuffer.append("ALIGN=" + this.alignment + " ");
        }
        if (this.borderSize != null) {
            stringBuffer.append("BORDER=" + this.borderSize + " ");
        }
        if (this.height != null) {
            stringBuffer.append("HEIGHT=" + this.height + " ");
        }
        if (this.width != null) {
            stringBuffer.append("WIDTH=" + this.width + " ");
        }
        if (this.verticalGutter != null) {
            stringBuffer.append("VSPACE=" + this.verticalGutter + " ");
        }
        if (this.horizontalGutter != null) {
            stringBuffer.append("HSPACE=" + this.horizontalGutter + " ");
        }
        stringBuffer.append(">");
        if (this.putTextOnNextLine) {
            stringBuffer.append("<BR CLEAR=ALL>");
        }
        String string = stringBuffer.toString();
        if (this.linkURL != null) {
            stringBuffer.insert(0, "\n<A HREF=\"" + this.linkURL + "\">\n");
            stringBuffer.append("\n</A>");
        }
        if (this.centerImage) {
            stringBuffer.insert(0, "\n<CENTER>");
            stringBuffer.append("\n</CENTER>");
        }
        return stringBuffer.toString();
    }
}

