/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import sdsu.util.ConversionException;
import sdsu.util.SimpleTokenizer;
import sdsu.util.Stringizable;
import sdsu.util.Stringizer;
import sdsu.util.TokenCharacters;

public class LabeledData
extends Properties
implements Stringizable {
    public static final String NO_VALUE = "";
    private static final char DEFAULT_KEY_SEPARATOR = '=';
    private static final char DEFAULT_PAIR_SEPARATOR = ';';
    private char keyValueSeparatorChar = (char)61;
    private char pairSeparatorChar = (char)59;
    private TokenCharacters parseTable = new TokenCharacters(String.valueOf(String.valueOf(this.keyValueSeparatorChar)) + String.valueOf(this.pairSeparatorChar));

    public LabeledData() {
    }

    public LabeledData(Properties properties) {
        super(properties);
    }

    public void fromCommandLine(String[] stringArray) {
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            if (this.isFlag(string)) {
                if (string.equals("--")) {
                    return;
                }
                if (string.startsWith("--")) {
                    this.processSingleLetterFlag(string);
                } else if (string.indexOf(61) != n) {
                    this.processFlagWithAssigment(string);
                } else if (n2 + 1 == stringArray.length) {
                    ((Hashtable)this).put(string.substring(1), NO_VALUE);
                } else if (this.isFlag(stringArray[n2 + 1])) {
                    ((Hashtable)this).put(string.substring(1), NO_VALUE);
                } else {
                    ((Hashtable)this).put(string.substring(1), stringArray[n2 + 1]);
                }
            }
            ++n2;
        }
    }

    public void fromString(String string) throws ConversionException {
        try {
            this.load(new StringReader(string));
        }
        catch (IOException iOException) {
            throw new ConversionException("Error in converting string to LabeledData: " + iOException.getMessage());
        }
    }

    public String getData(String string) {
        return this.getProperty(string);
    }

    public String getData(String string, String string2) {
        return this.getProperty(string, string2);
    }

    public LabeledData getMetaData() {
        String string;
        LabeledData labeledData = this.parseTable.toLabeledData();
        if (this.keyValueSeparatorChar != '=') {
            string = String.valueOf(this.keyValueSeparatorChar);
            ((Hashtable)labeledData).put("keyValueSeparatorChar", string);
        }
        if (this.pairSeparatorChar != ';') {
            string = String.valueOf(this.pairSeparatorChar);
            ((Hashtable)labeledData).put("pairSeparatorChar", string);
        }
        ((Hashtable)labeledData).put("class", this.getClass().getName());
        return labeledData;
    }

    private boolean isFlag(String string) {
        return string.startsWith("-");
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(new InputStreamReader(inputStream));
    }

    public void load(Reader reader) throws IOException {
        SimpleTokenizer simpleTokenizer = new SimpleTokenizer(reader, this.parseTable);
        while (simpleTokenizer.hasMoreTokens()) {
            String string = simpleTokenizer.nextToken();
            String string2 = simpleTokenizer.separator() == this.pairSeparatorChar ? NO_VALUE : simpleTokenizer.nextToken();
            ((Hashtable)this).put(string, string2);
        }
    }

    private void processFlagWithAssigment(String string) {
        int n = string.indexOf("=");
        ((Hashtable)this).put(string.substring(1, n), string.substring(n + 1));
    }

    private void processSingleLetterFlag(String string) {
        int n = 2;
        while (n < string.length()) {
            ((Hashtable)this).put(string.substring(n, n + 1), NO_VALUE);
            ++n;
        }
    }

    public void save(OutputStream outputStream, String string) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println(this.toString(string));
        printWriter.flush();
    }

    public void setKeyValueSeparatorChar(char c) {
        this.keyValueSeparatorChar = c;
        this.upDateParseTable();
    }

    public void setMetaData(LabeledData labeledData) {
        this.parseTable = new TokenCharacters();
        this.parseTable.fromLabeledData(labeledData);
        if (((Hashtable)labeledData).containsKey("keyValueSeparatorChar")) {
            this.setKeyValueSeparatorChar(labeledData.getData("keyValueSeparatorChar").charAt(0));
        } else {
            this.setKeyValueSeparatorChar('=');
        }
        if (((Hashtable)labeledData).containsKey("pairSeparatorChar")) {
            this.setPairSeparatorChar(labeledData.getData("pairSeparatorChar").charAt(0));
        } else {
            this.setPairSeparatorChar(';');
        }
    }

    public void setPairSeparatorChar(char c) {
        this.pairSeparatorChar = c;
        this.upDateParseTable();
    }

    public void setTokenCharacters(TokenCharacters tokenCharacters) {
        this.parseTable = tokenCharacters;
        this.upDateParseTable();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        Stringizer stringizer = new Stringizer(this.parseTable);
        stringizer.setHeader(string);
        Enumeration enumeration = ((Hashtable)this).keys();
        Enumeration enumeration2 = ((Hashtable)this).elements();
        while (enumeration2.hasMoreElements()) {
            stringizer.appendToken(enumeration.nextElement(), this.keyValueSeparatorChar);
            stringizer.appendToken(enumeration2.nextElement(), this.pairSeparatorChar);
        }
        return stringizer.toString();
    }

    private void upDateParseTable() {
        this.parseTable.setSeparatorChars(String.valueOf(String.valueOf(this.keyValueSeparatorChar)) + String.valueOf(this.pairSeparatorChar));
    }
}

