/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.CollectableLoadFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.IndexableLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.OrderedLoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MergeJoinIndexer;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigRecordReader;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Utils;

public class PigInputFormat
extends InputFormat<Text, Tuple> {
    public static final Log log = LogFactory.getLog(PigInputFormat.class);
    public static final String PIG_INPUTS = "pig.inputs";
    public static final String PIG_INPUT_TARGETS = "pig.inpTargets";
    public static final String PIG_INPUT_SIGNATURES = "pig.inpSignatures";
    public static final String PIG_INPUT_LIMITS = "pig.inpLimits";

    public RecordReader<Text, Tuple> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        RecordReaderFactory factory = new RecordReaderFactory(split, context);
        return factory.createRecordReader();
    }

    static void mergeSplitSpecificConf(LoadFunc loadFunc, PigSplit pigSplit, Configuration originalConf) throws IOException {
        Job job = new Job(originalConf);
        loadFunc.setLocation(PigInputFormat.getLoadLocation(pigSplit.getInputIndex(), originalConf), job);
        ConfigurationUtil.mergeConf(originalConf, job.getConfiguration());
    }

    private static LoadFunc getLoadFunc(int inputIndex, Configuration conf) throws IOException {
        ArrayList inputs = (ArrayList)ObjectSerializer.deserialize(conf.get(PIG_INPUTS));
        FuncSpec loadFuncSpec = ((FileSpec)inputs.get(inputIndex)).getFuncSpec();
        return (LoadFunc)PigContext.instantiateFuncFromSpec(loadFuncSpec);
    }

    private static String getLoadLocation(int inputIndex, Configuration conf) throws IOException {
        ArrayList inputs = (ArrayList)ObjectSerializer.deserialize(conf.get(PIG_INPUTS));
        return ((FileSpec)inputs.get(inputIndex)).getFileName();
    }

    static void passLoadSignature(LoadFunc loadFunc, int inputIndex, Configuration conf) throws IOException {
        ArrayList inpSignatureLists = (ArrayList)ObjectSerializer.deserialize(conf.get(PIG_INPUT_SIGNATURES));
        if (inpSignatureLists.get(inputIndex) != null) {
            loadFunc.setUDFContextSignature((String)inpSignatureLists.get(inputIndex));
            conf.set("pig.loader.signature", (String)inpSignatureLists.get(inputIndex));
        }
        MapRedUtil.setupUDFContext(conf);
    }

    public List<InputSplit> getSplits(JobContext jobcontext) throws IOException, InterruptedException {
        ArrayList inpTargets;
        ArrayList inputs;
        Configuration conf = jobcontext.getConfiguration();
        try {
            inputs = (ArrayList)ObjectSerializer.deserialize(conf.get(PIG_INPUTS));
            inpTargets = (ArrayList)ObjectSerializer.deserialize(conf.get(PIG_INPUT_TARGETS));
            PigContext.setPackageImportList((ArrayList)ObjectSerializer.deserialize(conf.get("udf.import.list")));
            MapRedUtil.setupUDFContext(conf);
        }
        catch (Exception e) {
            int errCode = 2094;
            String msg = "Unable to deserialize object.";
            throw new ExecException(msg, errCode, 4, e);
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (int i = 0; i < inputs.size(); ++i) {
            try {
                FuncSpec loadFuncSpec;
                LoadFunc loadFunc;
                boolean combinable;
                FileSystem fs;
                Path path = new Path(((FileSpec)inputs.get(i)).getFileName());
                boolean isFsPath = true;
                try {
                    fs = path.getFileSystem(conf);
                }
                catch (Exception e) {
                    fs = new Path("/").getFileSystem(conf);
                    isFsPath = false;
                }
                if (!Utils.isLocal(conf)) {
                    fs.setWorkingDirectory(jobcontext.getWorkingDirectory());
                }
                boolean bl = combinable = !((loadFunc = (LoadFunc)PigContext.instantiateFuncFromSpec(loadFuncSpec = ((FileSpec)inputs.get(i)).getFuncSpec())) instanceof MergeJoinIndexer) && !(loadFunc instanceof IndexableLoadFunc) && (!(loadFunc instanceof CollectableLoadFunc) || !(loadFunc instanceof OrderedLoadFunc));
                if (combinable) {
                    combinable = !conf.getBoolean("pig.noSplitCombination", false);
                }
                JobConf confClone = new JobConf(conf);
                Job inputSpecificJob = new Job((Configuration)confClone);
                PigInputFormat.passLoadSignature(loadFunc, i, inputSpecificJob.getConfiguration());
                loadFunc.setLocation(((FileSpec)inputs.get(i)).getFileName(), inputSpecificJob);
                InputFormat inpFormat = loadFunc.getInputFormat();
                List oneInputSplits = inpFormat.getSplits(HadoopShims.createJobContext(inputSpecificJob.getConfiguration(), jobcontext.getJobID()));
                List<InputSplit> oneInputPigSplits = this.getPigSplits(oneInputSplits, i, (ArrayList)inpTargets.get(i), fs.getDefaultBlockSize(isFsPath ? path : fs.getWorkingDirectory()), combinable, (Configuration)confClone);
                splits.addAll(oneInputPigSplits);
                continue;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2118;
                String msg = "Unable to create input splits for: " + ((FileSpec)inputs.get(i)).getFileName();
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    throw new ExecException(e.getMessage(), errCode, 4, e);
                }
                throw new ExecException(msg, errCode, 4, e);
            }
        }
        int n = splits.size();
        int m = inputs.size();
        boolean disableCounter = conf.getBoolean("pig.disable.counter", false);
        if (m > 1 && disableCounter) {
            log.info((Object)"Disable Pig custom input counters");
        }
        for (InputSplit split : splits) {
            ((PigSplit)split).setTotalSplits(n);
            if (m > 1) {
                ((PigSplit)split).setMultiInputs(true);
            }
            ((PigSplit)split).setDisableCounter(disableCounter);
        }
        return splits;
    }

    protected List<InputSplit> getPigSplits(List<InputSplit> oneInputSplits, int inputIndex, ArrayList<OperatorKey> targetOps, long blockSize, boolean combinable, Configuration conf) throws IOException, InterruptedException {
        ArrayList<InputSplit> pigSplits = new ArrayList<InputSplit>();
        if (!combinable) {
            int splitIndex = 0;
            for (InputSplit inputSplit : oneInputSplits) {
                PigSplit pigSplit = new PigSplit(new InputSplit[]{inputSplit}, inputIndex, targetOps, splitIndex++);
                pigSplit.setConf(conf);
                pigSplits.add(pigSplit);
            }
            return pigSplits;
        }
        long maxCombinedSplitSize = conf.getLong("pig.maxCombinedSplitSize", 0L);
        if (maxCombinedSplitSize == 0L) {
            maxCombinedSplitSize = blockSize;
        }
        List<List<InputSplit>> combinedSplits = MapRedUtil.getCombinePigSplits(oneInputSplits, maxCombinedSplitSize, conf);
        for (int i = 0; i < combinedSplits.size(); ++i) {
            pigSplits.add(this.createPigSplit(combinedSplits.get(i), inputIndex, targetOps, i, conf));
        }
        return pigSplits;
    }

    private InputSplit createPigSplit(List<InputSplit> combinedSplits, int inputIndex, ArrayList<OperatorKey> targetOps, int splitIndex, Configuration conf) {
        PigSplit pigSplit = new PigSplit(combinedSplits.toArray(new InputSplit[0]), inputIndex, targetOps, splitIndex);
        pigSplit.setConf(conf);
        return pigSplit;
    }

    protected static class RecordReaderFactory {
        protected InputFormat inputFormat;
        protected PigSplit pigSplit;
        protected LoadFunc loadFunc;
        protected TaskAttemptContext context;
        protected long limit;

        public RecordReaderFactory(InputSplit split, TaskAttemptContext context) throws IOException {
            PigSplit pigSplit = (PigSplit)split;
            int n = pigSplit.getTotalSplits();
            context.getConfiguration().setInt("pig.mapsplits.count", n);
            Configuration conf = context.getConfiguration();
            PigContext.setPackageImportList((ArrayList)ObjectSerializer.deserialize(conf.get("udf.import.list")));
            MapRedUtil.setupUDFContext(conf);
            LoadFunc loadFunc = PigInputFormat.getLoadFunc(pigSplit.getInputIndex(), conf);
            PigInputFormat.passLoadSignature(loadFunc, pigSplit.getInputIndex(), conf);
            PigInputFormat.mergeSplitSpecificConf(loadFunc, pigSplit, conf);
            InputFormat inputFormat = loadFunc.getInputFormat();
            ArrayList inpLimitLists = (ArrayList)ObjectSerializer.deserialize(conf.get(PigInputFormat.PIG_INPUT_LIMITS));
            this.inputFormat = inputFormat;
            this.pigSplit = pigSplit;
            this.loadFunc = loadFunc;
            this.context = context;
            this.limit = (Long)inpLimitLists.get(pigSplit.getInputIndex());
        }

        public RecordReader<Text, Tuple> createRecordReader() throws IOException, InterruptedException {
            return new PigRecordReader(this.inputFormat, this.pigSplit, this.loadFunc, this.context, this.limit);
        }
    }
}

