/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.util.Iterator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.data.Tuple;

abstract class OutputConsumerIterator
implements Iterator<Tuple> {
    private final Iterator<Tuple> input;
    private Result result = null;
    private boolean returned = true;
    private boolean done = false;

    OutputConsumerIterator(Iterator<Tuple> input) {
        this.input = input;
    }

    protected abstract void attach(Tuple var1);

    protected abstract Result getNextResult() throws ExecException;

    protected abstract void endOfInput();

    private void readNext() {
        try {
            while (true) {
                if (this.result != null && !this.returned) {
                    return;
                }
                if (this.result == null) {
                    if (!this.input.hasNext()) {
                        this.done = true;
                        return;
                    }
                    Tuple v1 = this.input.next();
                    this.attach(v1);
                }
                if (!this.input.hasNext()) {
                    this.endOfInput();
                }
                this.result = this.getNextResult();
                this.returned = false;
                switch (this.result.returnStatus) {
                    case 0: {
                        this.returned = false;
                        break;
                    }
                    case 1: {
                        this.returned = true;
                        break;
                    }
                    case 3: {
                        boolean bl = this.done = !this.input.hasNext();
                        if (this.done) break;
                        this.result = null;
                        break;
                    }
                    case 2: {
                        throw new RuntimeException("Error while processing " + this.result);
                    }
                }
            }
        }
        catch (ExecException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        this.readNext();
        return !this.done;
    }

    @Override
    public Tuple next() {
        this.readNext();
        if (this.done) {
            throw new RuntimeException("Past the end. Call hasNext() before calling next()");
        }
        if (this.result == null || this.result.returnStatus != 0) {
            throw new RuntimeException("Unexpected response code from operator: " + this.result);
        }
        this.returned = true;
        return (Tuple)this.result.result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

