/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreResources;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.LogicalToPhysicalTranslatorException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserComparisonFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCross;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PONative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORank;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.data.DataType;
import org.apache.pig.data.SchemaTupleClassGenerator;
import org.apache.pig.data.SchemaTupleFrontend;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.GFCross;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.CompilerUtils;
import org.apache.pig.impl.util.LinkedMultiMap;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.ReverseDependencyOrderWalkerWOSeenChk;
import org.apache.pig.newplan.SubtreeDependencyOrderWalker;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.expression.ExpToPhyTranslationVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.relational.MapSideMergeValidator;
import org.apache.pig.parser.SourceLocation;

public class LogToPhyTranslationVisitor
extends LogicalRelationalNodesVisitor {
    private static final Log LOG = LogFactory.getLog(LogToPhyTranslationVisitor.class);
    protected Map<Operator, PhysicalOperator> logToPhyMap;
    protected Deque<PhysicalPlan> currentPlans;
    protected PhysicalPlan currentPlan;
    protected NodeIdGenerator nodeGen = NodeIdGenerator.getGenerator();
    protected PigContext pc;

    public LogToPhyTranslationVisitor(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
        this.currentPlan = new PhysicalPlan();
        this.logToPhyMap = new HashMap<Operator, PhysicalOperator>();
        this.currentPlans = new LinkedList<PhysicalPlan>();
    }

    public void setPigContext(PigContext pc) {
        this.pc = pc;
    }

    public Map<Operator, PhysicalOperator> getLogToPhyMap() {
        return this.logToPhyMap;
    }

    public PhysicalPlan getPhysicalPlan() {
        return this.currentPlan;
    }

    @Override
    public void visit(LOLoad loLoad) throws FrontendException {
        String scope = "scope";
        POLoad load = new POLoad(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loLoad.getLoadFunc());
        load.addOriginalLocation(loLoad.getAlias(), loLoad.getLocation());
        load.setLFile(loLoad.getFileSpec());
        load.setPc(this.pc);
        load.setResultType((byte)120);
        load.setSignature(loLoad.getSignature());
        load.setLimit(loLoad.getLimit());
        load.setIsTmpLoad(loLoad.isTmpLoad());
        load.setCacheFiles(loLoad.getLoadFunc().getCacheFiles());
        load.setShipFiles(loLoad.getLoadFunc().getShipFiles());
        this.currentPlan.add(load);
        this.logToPhyMap.put(loLoad, load);
        List<Operator> op = loLoad.getPlan().getPredecessors(loLoad);
        if (op != null) {
            PhysicalOperator from = this.logToPhyMap.get(op.get(0));
            try {
                this.currentPlan.connect(from, load);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    @Override
    public void visit(LONative loNative) throws FrontendException {
        String scope = "scope";
        PONative poNative = new PONative(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        poNative.addOriginalLocation(loNative.getAlias(), loNative.getLocation());
        poNative.setNativeMRjar(loNative.getNativeMRJar());
        poNative.setParams(loNative.getParams());
        poNative.setResultType((byte)120);
        this.logToPhyMap.put(loNative, poNative);
        this.currentPlan.add(poNative);
        List<Operator> op = loNative.getPlan().getPredecessors(loNative);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Native.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poNative);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(LOFilter filter) throws FrontendException {
        String scope = "scope";
        POFilter poFilter = new POFilter(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), filter.getRequestedParallelism());
        poFilter.addOriginalLocation(filter.getAlias(), filter.getLocation());
        poFilter.setResultType((byte)120);
        this.currentPlan.add(poFilter);
        this.logToPhyMap.put(filter, poFilter);
        this.currentPlans.push(this.currentPlan);
        this.currentPlan = new PhysicalPlan();
        ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(filter.getFilterPlan());
        this.pushWalker(childWalker);
        this.currentWalker.walk(new ExpToPhyTranslationVisitor(this.currentWalker.getPlan(), childWalker, filter, this.currentPlan, this.logToPhyMap));
        this.popWalker();
        poFilter.setPlan(this.currentPlan);
        this.currentPlan = this.currentPlans.pop();
        List<Operator> op = filter.getPlan().getPredecessors(filter);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Filter.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poFilter);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.translateSoftLinks(filter);
    }

    @Override
    public void visit(LOSort sort) throws FrontendException {
        POSort poSort;
        String scope = "scope";
        List<LogicalExpressionPlan> logPlans = sort.getSortColPlans();
        ArrayList<PhysicalPlan> sortPlans = new ArrayList<PhysicalPlan>(logPlans.size());
        this.currentPlans.push(this.currentPlan);
        for (LogicalExpressionPlan plan : logPlans) {
            this.currentPlan = new PhysicalPlan();
            ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(plan);
            this.pushWalker(childWalker);
            ((PlanWalker)childWalker).walk(new ExpToPhyTranslationVisitor(this.currentWalker.getPlan(), childWalker, sort, this.currentPlan, this.logToPhyMap));
            sortPlans.add(this.currentPlan);
            this.popWalker();
        }
        this.currentPlan = this.currentPlans.pop();
        if (sort.getUserFunc() == null) {
            poSort = new POSort(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), sort.getRequestedParallelism(), null, sortPlans, sort.getAscendingCols(), null);
        } else {
            POUserComparisonFunc comparator = new POUserComparisonFunc(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), sort.getRequestedParallelism(), null, sort.getUserFunc());
            poSort = new POSort(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), sort.getRequestedParallelism(), null, sortPlans, sort.getAscendingCols(), comparator);
        }
        poSort.addOriginalLocation(sort.getAlias(), sort.getLocation());
        poSort.setLimit(sort.getLimit());
        this.logToPhyMap.put(sort, poSort);
        this.currentPlan.add(poSort);
        List<Operator> op = sort.getPlan().getPredecessors(sort);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Sort.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poSort);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        poSort.setResultType((byte)120);
    }

    @Override
    public void visit(LORank loRank) throws FrontendException {
        block11: {
            String scope = "scope";
            Random randomGenerator = new Random();
            Long operationID = Math.abs(randomGenerator.nextLong());
            try {
                if (!loRank.isRowNumber()) {
                    boolean[] flags = new boolean[]{false};
                    MultiMap<Integer, LogicalExpressionPlan> expressionPlans = new MultiMap<Integer, LogicalExpressionPlan>();
                    for (int i = 0; i < loRank.getRankColPlans().size(); ++i) {
                        expressionPlans.put(Integer.valueOf(i), loRank.getRankColPlans());
                    }
                    POPackage poPackage = this.compileToLR_GR_PackTrio(loRank, null, flags, expressionPlans);
                    poPackage.getPkgr().setPackageType(Packager.PackageType.GROUP);
                    this.translateSoftLinks(loRank);
                    List<Boolean> flattenLst = Arrays.asList(true, false);
                    PhysicalPlan fep1 = new PhysicalPlan();
                    POProject feproj1 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1);
                    feproj1.addOriginalLocation(loRank.getAlias(), loRank.getLocation());
                    feproj1.setColumn(0);
                    feproj1.setResultType(poPackage.getPkgr().getKeyType());
                    feproj1.setStar(false);
                    feproj1.setOverloaded(false);
                    fep1.add(feproj1);
                    PhysicalPlan fep2 = new PhysicalPlan();
                    POProject feproj2 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1);
                    feproj2.addOriginalLocation(loRank.getAlias(), loRank.getLocation());
                    feproj2.setColumn(1);
                    feproj2.setResultType((byte)120);
                    feproj2.setStar(false);
                    feproj2.setOverloaded(false);
                    fep2.add(feproj2);
                    List<PhysicalPlan> fePlans = Arrays.asList(fep1, fep2);
                    POForEach poForEach = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1, fePlans, flattenLst);
                    List<LogicalExpressionPlan> rankPlans = loRank.getRankColPlans();
                    byte[] newTypes = new byte[rankPlans.size()];
                    for (int i = 0; i < rankPlans.size(); ++i) {
                        LogicalExpressionPlan loep = rankPlans.get(i);
                        Iterator<Operator> inpOpers = loep.getOperators();
                        while (inpOpers.hasNext()) {
                            Operator oper = inpOpers.next();
                            newTypes[i] = ((ProjectExpression)oper).getType();
                        }
                    }
                    ArrayList<PhysicalPlan> newPhysicalPlan = new ArrayList<PhysicalPlan>();
                    ArrayList<Boolean> newOrderPlan = new ArrayList<Boolean>();
                    for (int i = 0; i < loRank.getRankColPlans().size(); ++i) {
                        PhysicalPlan fep3 = new PhysicalPlan();
                        POProject feproj3 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1);
                        feproj3.addOriginalLocation(loRank.getAlias(), loRank.getLocation());
                        feproj3.setColumn(i);
                        feproj3.setResultType(newTypes[i]);
                        feproj3.setStar(false);
                        feproj3.setOverloaded(false);
                        fep3.add(feproj3);
                        newPhysicalPlan.add(fep3);
                        newOrderPlan.add(loRank.getAscendingCol().get(i));
                    }
                    POSort poSort = new POSort(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1, null, newPhysicalPlan, newOrderPlan, null);
                    poSort.addOriginalLocation(loRank.getAlias(), loRank.getLocation());
                    POCounter poCounter = new POCounter(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1, null, newPhysicalPlan, newOrderPlan);
                    poCounter.addOriginalLocation(loRank.getAlias(), loRank.getLocation());
                    poCounter.setResultType((byte)110);
                    poCounter.setIsRowNumber(loRank.isRowNumber());
                    poCounter.setIsDenseRank(loRank.isDenseRank());
                    poCounter.setOperationID(String.valueOf(operationID));
                    PORank poRank = new PORank(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1, null, newPhysicalPlan, newOrderPlan);
                    poRank.addOriginalLocation(loRank.getAlias(), loRank.getLocation());
                    poRank.setResultType((byte)110);
                    poRank.setOperationID(String.valueOf(operationID));
                    List<Boolean> flattenLst2 = Arrays.asList(false, true);
                    PhysicalPlan fep12 = new PhysicalPlan();
                    POProject feproj12 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1);
                    feproj12.addOriginalLocation(loRank.getAlias(), loRank.getLocation());
                    feproj12.setColumn(0);
                    feproj12.setResultType((byte)15);
                    feproj12.setStar(false);
                    feproj12.setOverloaded(false);
                    fep12.add(feproj12);
                    PhysicalPlan fep22 = new PhysicalPlan();
                    POProject feproj22 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1);
                    feproj22.addOriginalLocation(loRank.getAlias(), loRank.getLocation());
                    feproj22.setColumn(loRank.getRankColPlans().size() + 1);
                    feproj22.setResultType((byte)120);
                    feproj22.setStar(false);
                    feproj22.setOverloaded(false);
                    fep22.add(feproj22);
                    List<PhysicalPlan> fePlans2 = Arrays.asList(fep12, fep22);
                    POForEach poForEach2 = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1, fePlans2, flattenLst2);
                    this.currentPlan.add(poForEach);
                    this.currentPlan.add(poSort);
                    this.currentPlan.add(poCounter);
                    this.currentPlan.add(poRank);
                    this.currentPlan.add(poForEach2);
                    try {
                        this.currentPlan.connect(poPackage, poForEach);
                        this.currentPlan.connect(poForEach, poSort);
                        this.currentPlan.connect(poSort, poCounter);
                        this.currentPlan.connect(poCounter, poRank);
                        this.currentPlan.connect(poRank, poForEach2);
                    }
                    catch (PlanException e) {
                        throw new LogicalToPhysicalTranslatorException(e.getMessage(), e.getErrorCode(), e.getErrorSource(), (Throwable)e);
                    }
                    this.logToPhyMap.put(loRank, poForEach2);
                    break block11;
                }
                List<LogicalExpressionPlan> logPlans = loRank.getRankColPlans();
                ArrayList<PhysicalPlan> rankPlans = new ArrayList<PhysicalPlan>(logPlans.size());
                this.currentPlans.push(this.currentPlan);
                for (LogicalExpressionPlan plan : logPlans) {
                    this.currentPlan = new PhysicalPlan();
                    ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(plan);
                    this.pushWalker(childWalker);
                    ((PlanWalker)childWalker).walk(new ExpToPhyTranslationVisitor(this.currentWalker.getPlan(), childWalker, loRank, this.currentPlan, this.logToPhyMap));
                    rankPlans.add(this.currentPlan);
                    this.popWalker();
                }
                this.currentPlan = this.currentPlans.pop();
                POCounter poCounter = new POCounter(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1, null, rankPlans, loRank.getAscendingCol());
                poCounter.addOriginalLocation(loRank.getAlias(), loRank.getLocation());
                poCounter.setResultType((byte)110);
                poCounter.setIsRowNumber(loRank.isRowNumber());
                poCounter.setIsDenseRank(loRank.isDenseRank());
                poCounter.setOperationID(String.valueOf(operationID));
                PORank poRank = new PORank(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1, null, rankPlans, loRank.getAscendingCol());
                poRank.addOriginalLocation(loRank.getAlias(), loRank.getLocation());
                poRank.setResultType((byte)110);
                poRank.setOperationID(String.valueOf(operationID));
                this.currentPlan.add(poCounter);
                this.currentPlan.add(poRank);
                List<Operator> op = loRank.getPlan().getPredecessors(loRank);
                if (op == null) {
                    int errCode = 2051;
                    String msg = "Did not find a predecessor for Rank.";
                    throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
                }
                PhysicalOperator from = this.logToPhyMap.get(op.get(0));
                this.currentPlan.connect(from, poCounter);
                this.currentPlan.connect(poCounter, poRank);
                this.logToPhyMap.put(loRank, poRank);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    @Override
    public void visit(LOCross cross) throws FrontendException {
        String scope = "scope";
        List<Operator> inputs = cross.getPlan().getPredecessors(cross);
        if (cross.isNested()) {
            POCross physOp = new POCross(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism());
            physOp.addOriginalLocation(physOp.getAlias(), physOp.getOriginalLocations());
            this.currentPlan.add(physOp);
            physOp.setResultType((byte)120);
            this.logToPhyMap.put(cross, physOp);
            for (Operator op : cross.getPlan().getPredecessors(cross)) {
                PhysicalOperator from = this.logToPhyMap.get(op);
                try {
                    this.currentPlan.connect(from, physOp);
                }
                catch (PlanException e) {
                    int errCode = 2015;
                    String msg = "Invalid physical operators in the physical plan";
                    throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
                }
            }
        } else {
            POGlobalRearrange poGlobal = new POGlobalRearrange(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism());
            poGlobal.addOriginalLocation(cross.getAlias(), cross.getLocation());
            POPackage poPackage = new POPackage(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism());
            poGlobal.addOriginalLocation(cross.getAlias(), cross.getLocation());
            poGlobal.setCross(true);
            this.currentPlan.add(poGlobal);
            this.currentPlan.add(poPackage);
            int count = 0;
            try {
                this.currentPlan.connect(poGlobal, poPackage);
                List<Boolean> flattenLst = Arrays.asList(true, true);
                for (Operator op : inputs) {
                    PhysicalPlan fep1 = new PhysicalPlan();
                    ConstantExpression ce1 = new ConstantExpression(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism());
                    ce1.setValue(inputs.size());
                    ce1.setResultType((byte)10);
                    fep1.add(ce1);
                    ConstantExpression ce2 = new ConstantExpression(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism());
                    ce2.setValue(count);
                    ce2.setResultType((byte)10);
                    fep1.add(ce2);
                    POUserFunc gfc = new POUserFunc(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism(), Arrays.asList(ce1, ce2), new FuncSpec(GFCross.class.getName() + "('" + poGlobal.getOperatorKey().toString() + "')"));
                    gfc.addOriginalLocation(cross.getAlias(), cross.getLocation());
                    gfc.setResultType((byte)120);
                    fep1.addAsLeaf(gfc);
                    gfc.setInputs(Arrays.asList(ce1, ce2));
                    PhysicalPlan fep2 = new PhysicalPlan();
                    POProject feproj = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism());
                    feproj.addOriginalLocation(cross.getAlias(), cross.getLocation());
                    feproj.setResultType((byte)110);
                    feproj.setStar(true);
                    feproj.setOverloaded(false);
                    fep2.add(feproj);
                    List<PhysicalPlan> fePlans = Arrays.asList(fep1, fep2);
                    POForEach fe = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism(), fePlans, flattenLst);
                    fe.setMapSideOnly(true);
                    fe.addOriginalLocation(cross.getAlias(), cross.getLocation());
                    this.currentPlan.add(fe);
                    this.currentPlan.connect(this.logToPhyMap.get(op), fe);
                    POLocalRearrange physOp = new POLocalRearrange(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism());
                    physOp.addOriginalLocation(cross.getAlias(), cross.getLocation());
                    ArrayList<PhysicalPlan> lrPlans = new ArrayList<PhysicalPlan>();
                    for (int i = 0; i < inputs.size(); ++i) {
                        PhysicalPlan lrp1 = new PhysicalPlan();
                        POProject lrproj1 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism(), i);
                        lrproj1.addOriginalLocation(cross.getAlias(), cross.getLocation());
                        lrproj1.setOverloaded(false);
                        lrproj1.setResultType((byte)10);
                        lrp1.add(lrproj1);
                        lrPlans.add(lrp1);
                    }
                    physOp.setCross(true);
                    physOp.setIndex(count++);
                    physOp.setKeyType((byte)110);
                    physOp.setPlans(lrPlans);
                    physOp.setResultType((byte)110);
                    this.currentPlan.add(physOp);
                    this.currentPlan.connect(fe, physOp);
                    this.currentPlan.connect(physOp, poGlobal);
                }
            }
            catch (PlanException e1) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e1);
            }
            catch (ExecException e) {
                int errCode = 2058;
                String msg = "Unable to set index on newly create POLocalRearrange.";
                throw new VisitorException(msg, errCode, 4, (Throwable)e);
            }
            poPackage.getPkgr().setKeyType((byte)110);
            poPackage.setResultType((byte)110);
            poPackage.setNumInps(count);
            boolean[] inner = new boolean[count];
            for (int i = 0; i < count; ++i) {
                inner[i] = true;
            }
            poPackage.getPkgr().setInner(inner);
            ArrayList<PhysicalPlan> fePlans = new ArrayList<PhysicalPlan>();
            ArrayList<Boolean> flattenLst = new ArrayList<Boolean>();
            for (int i = 1; i <= count; ++i) {
                PhysicalPlan fep1 = new PhysicalPlan();
                POProject feproj1 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism(), i);
                feproj1.addOriginalLocation(cross.getAlias(), cross.getLocation());
                feproj1.setResultType((byte)120);
                feproj1.setOverloaded(false);
                fep1.add(feproj1);
                fePlans.add(fep1);
                flattenLst.add(true);
            }
            POForEach fe = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelism(), fePlans, flattenLst);
            fe.addOriginalLocation(cross.getAlias(), cross.getLocation());
            this.currentPlan.add(fe);
            try {
                this.currentPlan.connect(poPackage, fe);
            }
            catch (PlanException e1) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e1);
            }
            this.logToPhyMap.put(cross, fe);
        }
    }

    @Override
    public void visit(LOStream stream) throws FrontendException {
        String scope = "scope";
        POStream poStream = new POStream(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), stream.getExecutableManager(), stream.getStreamingCommand(), this.pc.getProperties());
        poStream.addOriginalLocation(stream.getAlias(), stream.getLocation());
        this.currentPlan.add(poStream);
        this.logToPhyMap.put(stream, poStream);
        List<Operator> op = stream.getPlan().getPredecessors(stream);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Stream.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poStream);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(LOInnerLoad load) throws FrontendException {
        String scope = "scope";
        POProject exprOp = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        LogicalSchema s = load.getSchema();
        if (load.sourceIsBag()) {
            exprOp.setResultType((byte)120);
            exprOp.setOverloaded(true);
        } else if (s != null) {
            exprOp.setResultType(s.getField((int)0).type);
        } else {
            exprOp.setResultType((byte)50);
        }
        ProjectExpression proj = load.getProjection();
        if (proj.isProjectStar()) {
            exprOp.setStar(proj.isProjectStar());
        } else if (proj.isRangeProject()) {
            if (proj.getEndCol() != -1) {
                throw new AssertionError((Object)"project range that is not a project-to-end seen in translation to physical plan!");
            }
            exprOp.setProjectToEnd(proj.getStartCol());
        } else {
            exprOp.setColumn(load.getColNum());
        }
        this.logToPhyMap.put(load, exprOp);
        this.currentPlan.add(exprOp);
    }

    @Override
    public void visit(LOForEach foreach) throws FrontendException {
        String scope = "scope";
        ArrayList<PhysicalPlan> innerPlans = new ArrayList<PhysicalPlan>();
        LogicalPlan inner = foreach.getInnerPlan();
        LOGenerate gen = (LOGenerate)inner.getSinks().get(0);
        List<LogicalExpressionPlan> exps = gen.getOutputPlans();
        List<Operator> preds = inner.getPredecessors(gen);
        this.currentPlans.push(this.currentPlan);
        for (int i = 0; i < exps.size(); ++i) {
            this.currentPlan = new PhysicalPlan();
            PlanWalker childWalker = new ReverseDependencyOrderWalkerWOSeenChk(exps.get(i));
            this.pushWalker(childWalker);
            childWalker.walk(new ExpToPhyTranslationVisitor(exps.get(i), childWalker, gen, this.currentPlan, this.logToPhyMap));
            this.popWalker();
            Object leaves = exps.get(i).getSinks();
            Iterator iterator = leaves.iterator();
            while (iterator.hasNext()) {
                Operator l = (Operator)iterator.next();
                PhysicalOperator op = this.logToPhyMap.get(l);
                if (!(l instanceof ProjectExpression)) continue;
                int input = ((ProjectExpression)l).getInputNum();
                Operator pred = preds.get(input);
                childWalker = new SubtreeDependencyOrderWalker(inner, pred);
                this.pushWalker(childWalker);
                childWalker.walk(this);
                this.popWalker();
                PhysicalOperator leaf = this.logToPhyMap.get(pred);
                if (pred instanceof LOInnerLoad) {
                    this.currentPlan.remove(leaf);
                    this.logToPhyMap.remove(pred);
                    POProject leafProj = (POProject)leaf;
                    try {
                        if (leafProj.isStar()) {
                            ((POProject)op).setStar(true);
                            continue;
                        }
                        if (leafProj.isProjectToEnd()) {
                            ((POProject)op).setProjectToEnd(leafProj.getStartCol());
                            continue;
                        }
                        ((POProject)op).setColumn(leafProj.getColumn());
                        continue;
                    }
                    catch (ExecException e) {
                        throw new FrontendException((Operator)foreach, "Cannot get column from " + leaf, 2230, (Throwable)e);
                    }
                }
                this.currentPlan.connect(leaf, op);
            }
            innerPlans.add(this.currentPlan);
        }
        this.currentPlan = this.currentPlans.pop();
        boolean[] flatten = gen.getFlattenFlags();
        ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
        for (boolean fl : flatten) {
            flattenList.add(fl);
        }
        LogicalSchema logSchema = foreach.getSchema();
        Schema schema = null;
        if (logSchema != null) {
            try {
                schema = Schema.getPigSchema(new ResourceSchema(logSchema));
            }
            catch (FrontendException e) {
                throw new RuntimeException("LogicalSchema in foreach unable to be converted to Schema: " + logSchema, e);
            }
        }
        if (schema != null) {
            SchemaTupleFrontend.registerToGenerateIfPossible(schema, false, SchemaTupleClassGenerator.GenContext.FOREACH);
        }
        POForEach poFE = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), foreach.getRequestedParallelism(), innerPlans, flattenList, schema);
        poFE.addOriginalLocation(foreach.getAlias(), foreach.getLocation());
        poFE.setResultType((byte)120);
        this.logToPhyMap.put(foreach, poFE);
        this.currentPlan.add(poFE);
        List<Operator> op = foreach.getPlan().getPredecessors(foreach);
        if (op == null) {
            return;
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poFE);
        }
        catch (Exception e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.translateSoftLinks(foreach);
    }

    private List<PhysicalPlan> translateExpressionPlans(LogicalRelationalOperator loj, List<LogicalExpressionPlan> plans) throws FrontendException {
        ArrayList<PhysicalPlan> exprPlans = new ArrayList<PhysicalPlan>();
        if (plans == null || plans.size() == 0) {
            return exprPlans;
        }
        this.currentPlans.push(this.currentPlan);
        for (LogicalExpressionPlan lp : plans) {
            this.currentPlan = new PhysicalPlan();
            ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(lp);
            this.pushWalker(childWalker);
            this.currentWalker.walk(new ExpToPhyTranslationVisitor(this.currentWalker.getPlan(), childWalker, loj, this.currentPlan, this.logToPhyMap));
            exprPlans.add(this.currentPlan);
            this.popWalker();
        }
        this.currentPlan = this.currentPlans.pop();
        return exprPlans;
    }

    @Override
    public void visit(LOStore loStore) throws FrontendException {
        String scope = "scope";
        POStore store = new POStore(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        store.addOriginalLocation(loStore.getAlias(), loStore.getLocation());
        store.setSFile(loStore.getOutputSpec());
        store.setInputSpec(loStore.getInputSpec());
        store.setSignature(loStore.getSignature());
        store.setSortInfo(loStore.getSortInfo());
        store.setIsTmpStore(loStore.isTmpStore());
        store.setStoreFunc(loStore.getStoreFunc());
        store.setSchema(Util.translateSchema(loStore.getSchema()));
        if (loStore.getStoreFunc() instanceof StoreResources) {
            store.setCacheFiles(((StoreResources)((Object)loStore.getStoreFunc())).getCacheFiles());
            store.setShipFiles(((StoreResources)((Object)loStore.getStoreFunc())).getShipFiles());
        }
        this.currentPlan.add(store);
        List<Operator> op = loStore.getPlan().getPredecessors(loStore);
        PhysicalOperator from = null;
        if (op != null) {
            from = this.logToPhyMap.get(op.get(0));
        }
        try {
            this.currentPlan.connect(from, store);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.logToPhyMap.put(loStore, store);
    }

    @Override
    public void visit(LOCogroup cg) throws FrontendException {
        switch (cg.getGroupType()) {
            case COLLECTED: {
                this.translateCollectedCogroup(cg);
                break;
            }
            case REGULAR: {
                POPackage poPackage = this.compileToLR_GR_PackTrio(cg, cg.getCustomPartitioner(), cg.getInner(), cg.getExpressionPlans());
                poPackage.getPkgr().setPackageType(Packager.PackageType.GROUP);
                this.logToPhyMap.put(cg, poPackage);
                break;
            }
            case MERGE: {
                this.translateMergeCogroup(cg);
                break;
            }
            default: {
                throw new LogicalToPhysicalTranslatorException("Unknown CoGroup Modifier", 4);
            }
        }
        this.translateSoftLinks(cg);
    }

    private void translateCollectedCogroup(LOCogroup cg) throws FrontendException {
        LogicalRelationalOperator pred = (LogicalRelationalOperator)this.plan.getPredecessors(cg).get(0);
        List<LogicalExpressionPlan> exprPlans = cg.getExpressionPlans().get(0);
        POCollectedGroup physOp = new POCollectedGroup(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        physOp.addOriginalLocation(cg.getAlias(), cg.getLocation());
        List<PhysicalPlan> pExprPlans = this.translateExpressionPlans(cg, exprPlans);
        try {
            physOp.setPlans(pExprPlans);
        }
        catch (PlanException pe) {
            int errCode = 2071;
            String msg = "Problem with setting up map group's plans.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)pe);
        }
        Byte type = null;
        if (exprPlans.size() > 1) {
            type = 110;
            physOp.setKeyType(type);
        } else {
            type = ((PhysicalOperator)pExprPlans.get(0).getLeaves().get(0)).getResultType();
            physOp.setKeyType(type);
        }
        physOp.setResultType((byte)110);
        this.currentPlan.add(physOp);
        try {
            this.currentPlan.connect(this.logToPhyMap.get(pred), physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.logToPhyMap.put(cg, physOp);
    }

    private POMergeCogroup compileToMergeCogrp(LogicalRelationalOperator relationalOp, MultiMap<Integer, LogicalExpressionPlan> innerPlans) throws FrontendException {
        List<Operator> inputs = relationalOp.getPlan().getPredecessors(relationalOp);
        POLocalRearrange[] innerLRs = new POLocalRearrange[inputs.size()];
        int count = 0;
        ArrayList<PhysicalOperator> inpPOs = new ArrayList<PhysicalOperator>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            Operator op = inputs.get(i);
            PhysicalOperator physOp = this.logToPhyMap.get(op);
            inpPOs.add(physOp);
            List<LogicalExpressionPlan> plans = innerPlans.get(i);
            POLocalRearrange poInnerLR = new POLocalRearrange(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
            poInnerLR.addOriginalLocation(relationalOp.getAlias(), relationalOp.getLocation());
            List<PhysicalPlan> exprPlans = this.translateExpressionPlans(relationalOp, plans);
            try {
                poInnerLR.setPlans(exprPlans);
            }
            catch (PlanException pe) {
                int errCode = 2071;
                String msg = "Problem with setting up local rearrange's plans.";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)pe);
            }
            innerLRs[count] = poInnerLR;
            try {
                poInnerLR.setIndex(count++);
            }
            catch (ExecException e1) {
                int errCode = 2058;
                String msg = "Unable to set index on newly create POLocalRearrange.";
                throw new VisitorException(msg, errCode, 4, (Throwable)e1);
            }
            poInnerLR.setKeyType(plans.size() > 1 ? (byte)110 : ((PhysicalOperator)exprPlans.get(0).getLeaves().get(0)).getResultType());
            poInnerLR.setResultType((byte)110);
        }
        POMergeCogroup poCogrp = new POMergeCogroup(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")), inpPOs, innerLRs, relationalOp.getRequestedParallelism());
        return poCogrp;
    }

    private void translateMergeCogroup(LOCogroup cg) throws FrontendException {
        if (!this.validateMergeCogrp(cg.getInner())) {
            throw new LogicalToPhysicalTranslatorException("Inner is not supported for any relation on Merge Cogroup.");
        }
        List<Operator> inputs = cg.getPlan().getPredecessors(cg);
        MapSideMergeValidator validator = new MapSideMergeValidator();
        validator.validateMapSideMerge(inputs, cg.getPlan());
        POMergeCogroup poCogrp = this.compileToMergeCogrp(cg, cg.getExpressionPlans());
        poCogrp.setResultType((byte)110);
        poCogrp.addOriginalLocation(cg.getAlias(), cg.getLocation());
        this.currentPlan.add(poCogrp);
        for (Operator op : inputs) {
            try {
                this.currentPlan.connect(this.logToPhyMap.get(op), poCogrp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
        this.logToPhyMap.put(cg, poCogrp);
    }

    private boolean validateMergeCogrp(boolean[] innerFlags) {
        for (boolean flag : innerFlags) {
            if (!flag) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(LOJoin loj) throws FrontendException {
        String msg;
        String scope = "scope";
        List<Operator> inputs = loj.getPlan().getPredecessors(loj);
        LinkedMultiMap<PhysicalOperator, PhysicalPlan> joinPlans = new LinkedMultiMap<PhysicalOperator, PhysicalPlan>();
        ArrayList<List<PhysicalPlan>> ppLists = new ArrayList<List<PhysicalPlan>>();
        ArrayList<PhysicalOperator> inp = new ArrayList<PhysicalOperator>();
        ArrayList<List<Byte>> keyTypes = new ArrayList<List<Byte>>();
        boolean[] innerFlags = loj.getInnerFlags();
        String alias = loj.getAlias();
        SourceLocation location = loj.getLocation();
        int parallel = loj.getRequestedParallelism();
        for (int i = 0; i < inputs.size(); ++i) {
            Operator op = inputs.get(i);
            PhysicalOperator physOp = this.logToPhyMap.get(op);
            inp.add(physOp);
            List plans = (List)loj.getJoinPlan(i);
            List<PhysicalPlan> exprPlans = this.translateExpressionPlans(loj, plans);
            ppLists.add(exprPlans);
            joinPlans.put(physOp, exprPlans);
            ArrayList<Byte> tupleKeyMemberTypes = new ArrayList<Byte>();
            for (PhysicalPlan exprPlan : exprPlans) {
                tupleKeyMemberTypes.add(((PhysicalOperator)exprPlan.getLeaves().get(0)).getResultType());
            }
            keyTypes.add(tupleKeyMemberTypes);
        }
        if (loj.getJoinType() == LOJoin.JOINTYPE.SKEWED) {
            String msg2;
            POSkewedJoin skj;
            try {
                skj = new POSkewedJoin(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, inp, innerFlags);
                skj.addOriginalLocation(alias, location);
                skj.setJoinPlans(joinPlans);
            }
            catch (Exception e) {
                int errCode = 2015;
                String msg3 = "Skewed Join creation failed";
                throw new LogicalToPhysicalTranslatorException(msg3, errCode, 4, (Throwable)e);
            }
            skj.setResultType((byte)110);
            for (int i = 0; i < inputs.size(); ++i) {
                Operator op = inputs.get(i);
                if (!innerFlags[i]) {
                    try {
                        LogicalSchema s = ((LogicalRelationalOperator)op).getSchema();
                        if (s == null) {
                            throw new FrontendException(loj, "Cannot determine skewed join schema", 2247);
                        }
                        skj.addSchema(Util.translateSchema(s));
                        continue;
                    }
                    catch (FrontendException e) {
                        int errCode = 2015;
                        msg2 = "Couldn't set the schema for outer join";
                        throw new LogicalToPhysicalTranslatorException(msg2, errCode, 4, (Throwable)e);
                    }
                }
                skj.addSchema(null);
            }
            this.currentPlan.add(skj);
            for (Operator op : inputs) {
                try {
                    this.currentPlan.connect(this.logToPhyMap.get(op), skj);
                }
                catch (PlanException e) {
                    int errCode = 2015;
                    msg2 = "Invalid physical operators in the physical plan";
                    throw new LogicalToPhysicalTranslatorException(msg2, errCode, 4, (Throwable)e);
                }
            }
            this.logToPhyMap.put(loj, skj);
        } else if (loj.getJoinType() == LOJoin.JOINTYPE.REPLICATED) {
            POFRJoin pfrj;
            Schema[] inputSchemas = new Schema[inputs.size()];
            Schema[] keySchemas = new Schema[inputs.size()];
            block24: for (int i = 0; i < inputs.size(); ++i) {
                LogicalSchema logicalSchema = ((LogicalRelationalOperator)inputs.get(i)).getSchema();
                if (logicalSchema == null) continue;
                Schema toGen = Schema.getPigSchema(new ResourceSchema(logicalSchema));
                SchemaTupleFrontend.registerToGenerateIfPossible(toGen, false, SchemaTupleClassGenerator.GenContext.FR_JOIN);
                inputSchemas[i] = toGen;
                Schema keyToGen = new Schema();
                for (Byte byt : (List)keyTypes.get(i)) {
                    if (byt == null || DataType.isComplex(byt)) continue block24;
                    keyToGen.add(new Schema.FieldSchema(null, byt));
                }
                SchemaTupleFrontend.registerToGenerateIfPossible(keyToGen, false, SchemaTupleClassGenerator.GenContext.FR_JOIN);
                keySchemas[i] = keyToGen;
            }
            int fragment = 0;
            try {
                boolean isLeftOuter = false;
                isLeftOuter = !innerFlags[1];
                Tuple nullTuple = null;
                if (isLeftOuter) {
                    try {
                        LogicalSchema inputSchema = ((LogicalRelationalOperator)inputs.get(1)).getSchema();
                        if (inputSchema == null) {
                            int errCode = 1109;
                            String msg4 = "Input (" + ((LogicalRelationalOperator)inputs.get(1)).getAlias() + ") on which outer join is desired should have a valid schema";
                            throw new LogicalToPhysicalTranslatorException(msg4, errCode, 2);
                        }
                        nullTuple = TupleFactory.getInstance().newTuple(inputSchema.size());
                        for (int j = 0; j < inputSchema.size(); ++j) {
                            nullTuple.set(j, null);
                        }
                    }
                    catch (FrontendException e) {
                        int errCode = 2104;
                        String msg5 = "Error while determining the schema of input";
                        throw new LogicalToPhysicalTranslatorException(msg5, errCode, 4, (Throwable)e);
                    }
                }
                pfrj = new POFRJoin(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, inp, ppLists, keyTypes, null, fragment, isLeftOuter, nullTuple, inputSchemas, keySchemas);
                pfrj.addOriginalLocation(alias, location);
            }
            catch (ExecException e1) {
                int errCode = 2058;
                msg = "Unable to set index on newly create POLocalRearrange.";
                throw new VisitorException(msg, errCode, 4, (Throwable)e1);
            }
            pfrj.setResultType((byte)110);
            this.currentPlan.add(pfrj);
            for (Operator op : inputs) {
                try {
                    this.currentPlan.connect(this.logToPhyMap.get(op), pfrj);
                }
                catch (PlanException e) {
                    int errCode = 2015;
                    String msg6 = "Invalid physical operators in the physical plan";
                    throw new LogicalToPhysicalTranslatorException(msg6, errCode, 4, (Throwable)e);
                }
            }
            this.logToPhyMap.put(loj, pfrj);
        } else {
            if ((loj.getJoinType() == LOJoin.JOINTYPE.MERGE || loj.getJoinType() == LOJoin.JOINTYPE.MERGESPARSE) && new MapSideMergeValidator().validateMapSideMerge(inputs, loj.getPlan())) {
                PhysicalOperator smj;
                boolean usePOMergeJoin;
                boolean bl = usePOMergeJoin = inputs.size() == 2 && innerFlags[0] && innerFlags[1];
                if (usePOMergeJoin) {
                    Object logicalSchema = ((LogicalRelationalOperator)inputs.get(0)).getSchema();
                    Schema leftSchema = null;
                    if (logicalSchema != null) {
                        leftSchema = Schema.getPigSchema(new ResourceSchema((LogicalSchema)logicalSchema));
                    }
                    logicalSchema = ((LogicalRelationalOperator)inputs.get(1)).getSchema();
                    Schema rightSchema = null;
                    if (logicalSchema != null) {
                        rightSchema = Schema.getPigSchema(new ResourceSchema((LogicalSchema)logicalSchema));
                    }
                    logicalSchema = loj.getSchema();
                    Schema mergedSchema = null;
                    if (logicalSchema != null) {
                        mergedSchema = Schema.getPigSchema(new ResourceSchema((LogicalSchema)logicalSchema));
                    }
                    if (leftSchema != null) {
                        SchemaTupleFrontend.registerToGenerateIfPossible(leftSchema, false, SchemaTupleClassGenerator.GenContext.MERGE_JOIN);
                    }
                    if (rightSchema != null) {
                        SchemaTupleFrontend.registerToGenerateIfPossible(rightSchema, false, SchemaTupleClassGenerator.GenContext.MERGE_JOIN);
                    }
                    if (mergedSchema != null) {
                        SchemaTupleFrontend.registerToGenerateIfPossible(mergedSchema, false, SchemaTupleClassGenerator.GenContext.MERGE_JOIN);
                    }
                    try {
                        smj = new POMergeJoin(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, inp, joinPlans, keyTypes, loj.getJoinType(), leftSchema, rightSchema, mergedSchema);
                    }
                    catch (PlanException e) {
                        int errCode = 2042;
                        String msg7 = "Merge Join creation failed";
                        throw new LogicalToPhysicalTranslatorException(msg7, errCode, 4, (Throwable)e);
                    }
                    this.logToPhyMap.put(loj, smj);
                } else {
                    smj = this.compileToMergeCogrp(loj, loj.getExpressionPlans());
                }
                smj.setResultType((byte)110);
                this.currentPlan.add(smj);
                smj.addOriginalLocation(alias, location);
                for (Operator op : inputs) {
                    try {
                        this.currentPlan.connect(this.logToPhyMap.get(op), smj);
                    }
                    catch (PlanException e) {
                        int errCode = 2015;
                        msg = "Invalid physical operators in the physical plan";
                        throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
                    }
                }
                if (!usePOMergeJoin) {
                    POForEach fe = this.compileFE4Flattening(innerFlags, scope, parallel, alias, location, inputs);
                    this.currentPlan.add(fe);
                    try {
                        this.currentPlan.connect(smj, fe);
                    }
                    catch (PlanException e) {
                        throw new LogicalToPhysicalTranslatorException(e.getMessage(), e.getErrorCode(), e.getErrorSource(), (Throwable)e);
                    }
                    this.logToPhyMap.put(loj, fe);
                }
                return;
            }
            if (loj.getJoinType() == LOJoin.JOINTYPE.HASH || loj.getJoinType() == LOJoin.JOINTYPE.BLOOM) {
                POPackage poPackage = this.compileToLR_GR_PackTrio(loj, loj.getCustomPartitioner(), innerFlags, loj.getExpressionPlans());
                POForEach fe = this.compileFE4Flattening(innerFlags, scope, parallel, alias, location, inputs);
                this.currentPlan.add(fe);
                try {
                    this.currentPlan.connect(poPackage, fe);
                }
                catch (PlanException e) {
                    throw new LogicalToPhysicalTranslatorException(e.getDetailedMessage(), e.getErrorCode(), e.getErrorSource(), (Throwable)e);
                }
                this.logToPhyMap.put(loj, fe);
                if (loj.getJoinType() == LOJoin.JOINTYPE.BLOOM) {
                    if (innerFlags.length == 2 && !innerFlags[0] && !innerFlags[1]) {
                        throw new LogicalToPhysicalTranslatorException("Error at " + loj.getLocation() + " with alias " + loj.getAlias() + ". Bloom join cannot be used with a FULL OUTER join.", 1109, 2);
                    }
                    poPackage.getPkgr().setPackageType(Packager.PackageType.BLOOMJOIN);
                } else {
                    poPackage.getPkgr().setPackageType(Packager.PackageType.JOIN);
                }
            }
        }
        this.translateSoftLinks(loj);
    }

    private POPackage compileToLR_GR_PackTrio(LogicalRelationalOperator relationalOp, String customPartitioner, boolean[] innerFlags, MultiMap<Integer, LogicalExpressionPlan> innerPlans) throws FrontendException {
        POGlobalRearrange poGlobal = new POGlobalRearrange(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")), relationalOp.getRequestedParallelism());
        poGlobal.addOriginalLocation(relationalOp.getAlias(), relationalOp.getLocation());
        poGlobal.setCustomPartitioner(customPartitioner);
        POPackage poPackage = new POPackage(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")), relationalOp.getRequestedParallelism());
        poPackage.addOriginalLocation(relationalOp.getAlias(), relationalOp.getLocation());
        this.currentPlan.add(poGlobal);
        this.currentPlan.add(poPackage);
        try {
            this.currentPlan.connect(poGlobal, poPackage);
        }
        catch (PlanException e1) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e1);
        }
        int count = 0;
        Byte type = null;
        List<Operator> inputs = relationalOp.getPlan().getPredecessors(relationalOp);
        for (int i = 0; i < inputs.size(); ++i) {
            Operator op = inputs.get(i);
            List<LogicalExpressionPlan> plans = innerPlans.get(i);
            POLocalRearrange physOp = new POLocalRearrange(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")), relationalOp.getRequestedParallelism());
            physOp.addOriginalLocation(relationalOp.getAlias(), relationalOp.getLocation());
            List<PhysicalPlan> exprPlans = this.translateExpressionPlans(relationalOp, plans);
            try {
                physOp.setPlans(exprPlans);
            }
            catch (PlanException pe) {
                int errCode = 2071;
                String msg = "Problem with setting up local rearrange's plans.";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)pe);
            }
            try {
                physOp.setIndex(count++);
            }
            catch (ExecException e1) {
                int errCode = 2058;
                String msg = "Unable to set index on newly create POLocalRearrange.";
                throw new VisitorException(msg, errCode, 4, (Throwable)e1);
            }
            if (plans.size() > 1) {
                type = 110;
                physOp.setKeyType(type);
            } else {
                type = ((PhysicalOperator)exprPlans.get(0).getLeaves().get(0)).getResultType();
                physOp.setKeyType(type);
            }
            physOp.setResultType((byte)110);
            this.currentPlan.add(physOp);
            try {
                this.currentPlan.connect(this.logToPhyMap.get(op), physOp);
                this.currentPlan.connect(physOp, poGlobal);
                continue;
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
        poPackage.getPkgr().setKeyType(type);
        poPackage.setResultType((byte)110);
        poPackage.setNumInps(count);
        poPackage.getPkgr().setInner(innerFlags);
        return poPackage;
    }

    private POForEach compileFE4Flattening(boolean[] innerFlags, String scope, int parallel, String alias, SourceLocation location, List<Operator> inputs) throws FrontendException {
        POForEach fe;
        ArrayList<PhysicalPlan> fePlans = new ArrayList<PhysicalPlan>();
        ArrayList<Boolean> flattenLst = new ArrayList<Boolean>();
        try {
            for (int i = 0; i < inputs.size(); ++i) {
                PhysicalPlan fep1 = new PhysicalPlan();
                POProject feproj1 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, i + 1);
                feproj1.addOriginalLocation(alias, location);
                feproj1.setResultType((byte)120);
                feproj1.setOverloaded(false);
                fep1.add(feproj1);
                fePlans.add(fep1);
                if (!innerFlags[i]) {
                    Operator joinInput = inputs.get(i);
                    LogToPhyTranslationVisitor.updateWithEmptyBagCheck(fep1, joinInput);
                }
                flattenLst.add(true);
            }
            fe = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, fePlans, flattenLst);
            fe.addOriginalLocation(alias, location);
        }
        catch (PlanException e1) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e1);
        }
        return fe;
    }

    @Override
    public void visit(LOUnion loUnion) throws FrontendException {
        String scope = "scope";
        POUnion physOp = new POUnion(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loUnion.getRequestedParallelism());
        physOp.addOriginalLocation(loUnion.getAlias(), loUnion.getLocation());
        this.currentPlan.add(physOp);
        physOp.setResultType((byte)120);
        this.logToPhyMap.put(loUnion, physOp);
        List<Operator> ops = loUnion.getPlan().getPredecessors(loUnion);
        for (Operator l : ops) {
            PhysicalOperator from = this.logToPhyMap.get(l);
            try {
                this.currentPlan.connect(from, physOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    @Override
    public void visit(LODistinct loDistinct) throws FrontendException {
        String scope = "scope";
        PODistinct physOp = new PODistinct(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loDistinct.getRequestedParallelism());
        physOp.setCustomPartitioner(loDistinct.getCustomPartitioner());
        physOp.addOriginalLocation(loDistinct.getAlias(), loDistinct.getLocation());
        this.currentPlan.add(physOp);
        physOp.setResultType((byte)120);
        this.logToPhyMap.put(loDistinct, physOp);
        Operator op = loDistinct.getPlan().getPredecessors(loDistinct).get(0);
        PhysicalOperator from = this.logToPhyMap.get(op);
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(LOLimit loLimit) throws FrontendException {
        String scope = "scope";
        POLimit poLimit = new POLimit(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loLimit.getRequestedParallelism());
        poLimit.setLimit(loLimit.getLimit());
        poLimit.addOriginalLocation(loLimit.getAlias(), loLimit.getLocation());
        poLimit.setResultType((byte)120);
        this.currentPlan.add(poLimit);
        this.logToPhyMap.put(loLimit, poLimit);
        if (loLimit.getLimitPlan() != null) {
            this.currentPlans.push(this.currentPlan);
            this.currentPlan = new PhysicalPlan();
            ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(loLimit.getLimitPlan());
            this.pushWalker(childWalker);
            this.currentWalker.walk(new ExpToPhyTranslationVisitor(this.currentWalker.getPlan(), childWalker, loLimit, this.currentPlan, this.logToPhyMap));
            poLimit.setLimitPlan(this.currentPlan);
            this.popWalker();
            this.currentPlan = this.currentPlans.pop();
        }
        Operator op = loLimit.getPlan().getPredecessors(loLimit).get(0);
        PhysicalOperator from = this.logToPhyMap.get(op);
        try {
            this.currentPlan.connect(from, poLimit);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.translateSoftLinks(loLimit);
    }

    @Override
    public void visit(LOSplit loSplit) throws FrontendException {
        FileSpec splStrFile;
        String scope = "scope";
        POSplit physOp = new POSplit(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loSplit.getRequestedParallelism());
        physOp.addOriginalLocation(loSplit.getAlias(), loSplit.getLocation());
        try {
            splStrFile = new FileSpec(FileLocalizer.getTemporaryPath(this.pc).toString(), new FuncSpec(Utils.getTmpFileCompressorName(this.pc)));
        }
        catch (IOException e1) {
            byte errSrc = this.pc.getErrorSource();
            int errCode = 0;
            switch (errSrc) {
                case 4: {
                    errCode = 2016;
                    break;
                }
                case 16: {
                    errCode = 6002;
                    break;
                }
                case 8: {
                    errCode = 4003;
                }
            }
            String msg = "Unable to obtain a temporary path.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, errSrc, (Throwable)e1);
        }
        physOp.setSplitStore(splStrFile);
        this.logToPhyMap.put(loSplit, physOp);
        this.currentPlan.add(physOp);
        List<Operator> op = loSplit.getPlan().getPredecessors(loSplit);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Split.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(LOSplitOutput loSplitOutput) throws FrontendException {
        String scope = "scope";
        POFilter poFilter = new POFilter(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loSplitOutput.getRequestedParallelism());
        poFilter.addOriginalLocation(loSplitOutput.getAlias(), loSplitOutput.getLocation());
        poFilter.setResultType((byte)120);
        this.currentPlan.add(poFilter);
        this.logToPhyMap.put(loSplitOutput, poFilter);
        this.currentPlans.push(this.currentPlan);
        this.currentPlan = new PhysicalPlan();
        ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(loSplitOutput.getFilterPlan());
        this.pushWalker(childWalker);
        this.currentWalker.walk(new ExpToPhyTranslationVisitor(this.currentWalker.getPlan(), childWalker, loSplitOutput, this.currentPlan, this.logToPhyMap));
        this.popWalker();
        poFilter.setPlan(this.currentPlan);
        this.currentPlan = this.currentPlans.pop();
        List<Operator> op = loSplitOutput.getPlan().getPredecessors(loSplitOutput);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Filter.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poFilter);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.translateSoftLinks(loSplitOutput);
    }

    public static void updateWithEmptyBagCheck(PhysicalPlan fePlan, Operator joinInput) throws FrontendException {
        LogicalSchema inputSchema = null;
        try {
            inputSchema = ((LogicalRelationalOperator)joinInput).getSchema();
            if (inputSchema == null) {
                int errCode = 1109;
                String msg = "Input (" + ((LogicalRelationalOperator)joinInput).getAlias() + ") on which outer join is desired should have a valid schema";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 2);
            }
        }
        catch (FrontendException e) {
            int errCode = 2104;
            String msg = "Error while determining the schema of input";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        CompilerUtils.addEmptyBagOuterJoin(fePlan, Util.translateSchema(inputSchema), false, null);
    }

    private void translateSoftLinks(Operator op) throws FrontendException {
        List<Operator> preds = op.getPlan().getSoftLinkPredecessors(op);
        if (preds == null) {
            return;
        }
        for (Operator pred : preds) {
            PhysicalOperator from = this.logToPhyMap.get(pred);
            this.currentPlan.createSoftLink(from, (org.apache.pig.impl.plan.Operator)this.logToPhyMap.get(op));
        }
    }
}

