/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class ForEachUserSchemaVisitor
extends LogicalRelationalNodesVisitor {
    public ForEachUserSchemaVisitor(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    private static LogicalSchema replaceNullByteArraySchema(LogicalSchema originalSchema, LogicalSchema userSchema) throws FrontendException {
        if (originalSchema == null && userSchema == null) {
            return null;
        }
        if (originalSchema == null) {
            return userSchema.deepCopy();
        }
        if (userSchema == null) {
            return originalSchema.deepCopy();
        }
        LogicalSchema replacedSchema = new LogicalSchema();
        for (int i = 0; i < originalSchema.size(); ++i) {
            LogicalSchema.LogicalFieldSchema replacedFS = ForEachUserSchemaVisitor.replaceNullByteArrayFieldSchema(originalSchema.getField(i), userSchema.getField(i));
            replacedSchema.addField(replacedFS);
        }
        return replacedSchema;
    }

    private static LogicalSchema.LogicalFieldSchema replaceNullByteArrayFieldSchema(LogicalSchema.LogicalFieldSchema originalFS, LogicalSchema.LogicalFieldSchema userFS) throws FrontendException {
        if (originalFS == null && userFS == null) {
            return null;
        }
        if (originalFS == null) {
            return userFS.deepCopy();
        }
        if (userFS == null) {
            return originalFS.deepCopy();
        }
        if (originalFS.type == 1 || originalFS.type == 50) {
            return userFS.deepCopy();
        }
        if (userFS.type == 1 || userFS.type == 50) {
            return new LogicalSchema.LogicalFieldSchema(userFS.alias, originalFS.schema, originalFS.type);
        }
        if (!DataType.isSchemaType(originalFS.type)) {
            return userFS.deepCopy();
        }
        LogicalSchema replacedSchema = ForEachUserSchemaVisitor.replaceNullByteArraySchema(originalFS.schema, userFS.schema);
        return new LogicalSchema.LogicalFieldSchema(userFS.alias, replacedSchema, userFS.type);
    }

    private static boolean hasOnlyNullOrByteArraySchema(LogicalSchema.LogicalFieldSchema fs) {
        if (DataType.isSchemaType(fs.type)) {
            if (fs.schema != null) {
                for (LogicalSchema.LogicalFieldSchema sub_fs : fs.schema.getFields()) {
                    if (ForEachUserSchemaVisitor.hasOnlyNullOrByteArraySchema(sub_fs)) continue;
                    return false;
                }
            }
        } else if (fs.type != 1 && fs.type != 50) {
            return false;
        }
        return true;
    }

    @Override
    public void visit(LOForEach foreach) throws FrontendException {
        LOGenerate generate = (LOGenerate)foreach.getInnerPlan().getSinks().get(0);
        List<LogicalSchema> mExpSchemas = generate.getExpSchemas();
        List<LogicalSchema> mUserDefinedSchemas = generate.getUserDefinedSchema();
        if (foreach.getSchema() == null) {
            return;
        }
        if (mUserDefinedSchemas == null) {
            return;
        }
        boolean hasUserDefinedSchema = false;
        for (LogicalSchema mUserDefinedSchema : mUserDefinedSchemas) {
            if (mUserDefinedSchema == null) continue;
            hasUserDefinedSchema = true;
            break;
        }
        if (!hasUserDefinedSchema) {
            return;
        }
        if (mExpSchemas.size() != mUserDefinedSchemas.size()) {
            throw new FrontendException("Size mismatch: Get " + mExpSchemas.size() + " mExpSchemas, but " + mUserDefinedSchemas.size() + " mUserDefinedSchemas", 0, generate.getLocation());
        }
        LogicalPlan innerPlan = new LogicalPlan();
        LOForEach casterForEach = new LOForEach(this.plan);
        casterForEach.setInnerPlan(innerPlan);
        casterForEach.setAlias(foreach.getAlias());
        ArrayList<LogicalExpressionPlan> exps = new ArrayList<LogicalExpressionPlan>();
        LOGenerate gen = new LOGenerate(innerPlan, exps, null);
        innerPlan.add(gen);
        int index = 0;
        boolean needCast = false;
        for (int i = 0; i < mExpSchemas.size(); ++i) {
            LogicalSchema mExpSchema = mExpSchemas.get(i);
            LogicalSchema mUserDefinedSchema = mUserDefinedSchemas.get(i);
            if (mExpSchema == null) {
                for (LogicalSchema.LogicalFieldSchema fs : mUserDefinedSchema.getFields()) {
                    if (ForEachUserSchemaVisitor.hasOnlyNullOrByteArraySchema(fs)) {
                        this.addToExps(casterForEach, innerPlan, gen, exps, index, false, null);
                    } else {
                        this.addToExps(casterForEach, innerPlan, gen, exps, index, true, fs);
                        needCast = true;
                    }
                    ++index;
                }
                continue;
            }
            if (mUserDefinedSchema == null) {
                for (int j = 0; j < mExpSchema.size(); ++j) {
                    this.addToExps(casterForEach, innerPlan, gen, exps, index, false, null);
                    ++index;
                }
                continue;
            }
            if (mExpSchema.size() != mUserDefinedSchema.size()) {
                throw new FrontendException("Size mismatch: Cannot cast " + mExpSchema.size() + " fields to " + mUserDefinedSchema.size(), 0, foreach.getLocation());
            }
            LogicalSchema replacedSchema = ForEachUserSchemaVisitor.replaceNullByteArraySchema(mExpSchema, mUserDefinedSchema);
            for (int j = 0; j < mExpSchema.size(); ++j) {
                LogicalSchema.LogicalFieldSchema mExpFieldSchema = mExpSchema.getField(j);
                LogicalSchema.LogicalFieldSchema mUserDefinedFieldSchema = replacedSchema.getField(j);
                if (ForEachUserSchemaVisitor.hasOnlyNullOrByteArraySchema(mUserDefinedFieldSchema) || LogicalSchema.LogicalFieldSchema.typeMatch(mExpFieldSchema, mUserDefinedFieldSchema)) {
                    this.addToExps(casterForEach, innerPlan, gen, exps, index, false, null);
                } else {
                    this.addToExps(casterForEach, innerPlan, gen, exps, index, true, mUserDefinedFieldSchema);
                    needCast = true;
                }
                ++index;
            }
        }
        gen.setFlattenFlags(new boolean[index]);
        if (needCast) {
            List<Operator> successorOps = this.plan.getSuccessors(foreach);
            if (successorOps != null && successorOps.size() > 0) {
                Operator next = this.plan.getSuccessors(foreach).get(0);
                this.plan.insertBetween(foreach, casterForEach, next);
            } else {
                this.plan.add(casterForEach);
                this.plan.connect(foreach, casterForEach);
            }
            for (LogicalSchema mUserDefinedSchema : mUserDefinedSchemas) {
                this.resetTypeToNull(mUserDefinedSchema);
            }
            foreach.resetSchema();
            generate.resetSchema();
        }
    }

    private void resetTypeToNull(LogicalSchema s1) {
        if (s1 != null) {
            for (LogicalSchema.LogicalFieldSchema fs : s1.getFields()) {
                if (DataType.isSchemaType(fs.type)) {
                    this.resetTypeToNull(fs.schema);
                    continue;
                }
                fs.type = 1;
            }
        }
    }

    private void addToExps(LOForEach casterForEach, LogicalPlan innerPlan, LOGenerate gen, List<LogicalExpressionPlan> exps, int index, boolean needCaster, LogicalSchema.LogicalFieldSchema fs) {
        LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, casterForEach, index);
        innerPlan.add(innerLoad);
        innerPlan.connect(innerLoad, gen);
        LogicalExpressionPlan exp = new LogicalExpressionPlan();
        ProjectExpression prj = new ProjectExpression(exp, index, 0, gen);
        exp.add(prj);
        if (needCaster) {
            CastExpression cast = new CastExpression(exp, prj, new LogicalSchema.LogicalFieldSchema(fs));
            exp.add(cast);
        }
        exps.add(exp);
    }
}

