/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.task.ErrorReporter;
import org.apache.tez.runtime.task.TaskReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTaskRunner
implements TezUmbilical,
ErrorReporter {
    private static final Logger LOG = LoggerFactory.getLogger(TezTaskRunner.class);
    private final Configuration tezConf;
    private final LogicalIOProcessorRuntimeTask task;
    private final UserGroupInformation ugi;
    private final TaskReporter taskReporter;
    private final ListeningExecutorService executor;
    private volatile ListenableFuture<Void> taskFuture;
    private volatile Thread waitingThread;
    private volatile Throwable firstException;
    private final AtomicBoolean fatalErrorSent = new AtomicBoolean(false);
    private final AtomicBoolean taskRunning;
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);

    TezTaskRunner(Configuration tezConf, UserGroupInformation ugi, String[] localDirs, TaskSpec taskSpec, int appAttemptNumber, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> serviceProviderEnvMap, Multimap<String, String> startedInputsMap, TaskReporter taskReporter, ListeningExecutorService executor, ObjectRegistry objectRegistry, String pid, ExecutionContext executionContext, long memAvailable) throws IOException {
        this.tezConf = tezConf;
        this.ugi = ugi;
        this.taskReporter = taskReporter;
        this.executor = executor;
        this.task = new LogicalIOProcessorRuntimeTask(taskSpec, appAttemptNumber, tezConf, localDirs, this, serviceConsumerMetadata, serviceProviderEnvMap, startedInputsMap, objectRegistry, pid, executionContext, memAvailable);
        this.taskRunning = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() throws InterruptedException, IOException, TezException {
        this.waitingThread = Thread.currentThread();
        this.taskRunning.set(true);
        this.taskReporter.registerTask(this.task, this);
        TaskRunnerCallable callable = new TaskRunnerCallable();
        Throwable failureCause = null;
        this.taskFuture = this.executor.submit((Callable)((Object)callable));
        try {
            this.taskFuture.get();
            failureCause = this.firstException;
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for task to complete. Interrupting task");
            this.taskFuture.cancel(true);
            if (this.shutdownRequested.get()) {
                LOG.info("Shutdown requested... returning");
                boolean bl = false;
                return bl;
            }
            failureCause = this.firstException != null ? this.firstException : e;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FSError) {
                failureCause = cause;
            } else {
                if (cause instanceof Error) {
                    LOG.error("Exception of type Error.", cause);
                    this.sendFailure(cause, "Fatal Error cause TezChild exit.");
                    throw new TezException("Fatal Error cause TezChild exit.", cause);
                }
                failureCause = cause;
            }
        }
        finally {
            this.taskReporter.unregisterTask(this.task.getTaskAttemptID());
            Thread.interrupted();
        }
        if (failureCause != null) {
            if (failureCause instanceof FSError) {
                LOG.info("Encountered an FSError while executing task: " + this.task.getTaskAttemptID(), failureCause);
                throw (FSError)failureCause;
            }
            if (failureCause instanceof Error) {
                LOG.error("Exception of type Error.", failureCause);
                this.sendFailure(failureCause, "Fatal error cause TezChild exit.");
                throw new TezException("Fatal error cause TezChild exit.", failureCause);
            }
            if (failureCause instanceof IOException) {
                throw (IOException)failureCause;
            }
            if (failureCause instanceof TezException) {
                throw (TezException)failureCause;
            }
            if (failureCause instanceof InterruptedException) {
                throw (InterruptedException)failureCause;
            }
            throw new TezException(failureCause);
        }
        if (this.shutdownRequested.get()) {
            LOG.info("Shutdown requested... returning");
            return false;
        }
        return true;
    }

    private void sendFailure(Throwable t, String message) throws IOException, TezException {
        if (!this.fatalErrorSent.getAndSet(true)) {
            this.task.setFatalError(t, message);
            this.task.setFrameworkCounters();
            try {
                this.taskReporter.taskFailed(this.task.getTaskAttemptID(), t, message, null);
            }
            catch (IOException e) {
                LOG.warn("Heartbeat failure caused by communication failure", (Throwable)e);
                throw e;
            }
            catch (TezException e) {
                LOG.warn("Heartbeat failure reported by AM", (Throwable)e);
                throw e;
            }
        } else {
            LOG.warn("Ignoring fatal error since another error has already been reported", t);
        }
    }

    @Override
    public void addEvents(Collection<TezEvent> events) {
        if (this.taskRunning.get()) {
            this.taskReporter.addEvents(this.task.getTaskAttemptID(), events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void signalFatalError(TezTaskAttemptID taskAttemptID, Throwable t, String message, EventMetaData sourceInfo) {
        if (!this.fatalErrorSent.getAndSet(true)) {
            this.maybeRegisterFirstException(t);
            try {
                this.taskReporter.taskFailed(taskAttemptID, t, this.getTaskDiagnosticsString(t, message), sourceInfo);
            }
            catch (IOException e) {
                LOG.warn("Heartbeat failure caused by communication failure", (Throwable)e);
            }
            catch (TezException e) {
                LOG.warn("Heartbeat failure reported by AM", (Throwable)e);
            }
            finally {
                this.waitingThread.interrupt();
            }
        }
    }

    @Override
    public boolean canCommit(TezTaskAttemptID taskAttemptID) {
        if (this.taskRunning.get()) {
            try {
                return this.taskReporter.canCommit(taskAttemptID);
            }
            catch (IOException e) {
                LOG.warn("Communication failure while trying to commit", (Throwable)e);
                this.maybeRegisterFirstException(e);
                this.waitingThread.interrupt();
                return false;
            }
        }
        return false;
    }

    @Override
    public synchronized void reportError(Throwable t) {
        if (this.taskRunning.get()) {
            LOG.error("TaskReporter reported error", t);
            this.maybeRegisterFirstException(t);
            this.waitingThread.interrupt();
        } else {
            LOG.info("Ignoring Communication failure since task with id=" + this.task.getTaskAttemptID() + " is already complete");
        }
    }

    @Override
    public void shutdownRequested() {
        this.shutdownRequested.set(true);
        this.waitingThread.interrupt();
    }

    private String getTaskDiagnosticsString(Throwable t, String message) {
        String diagnostics = t != null && message != null ? "exceptionThrown=" + ExceptionUtils.getStackTrace((Throwable)t) + ", errorMessage=" + message : (t == null && message == null ? "Unknown error" : (t != null ? "exceptionThrown=" + ExceptionUtils.getStackTrace((Throwable)t) : " errorMessage=" + message));
        return diagnostics;
    }

    private synchronized void maybeRegisterFirstException(Throwable t) {
        if (this.firstException == null) {
            this.firstException = t;
        }
    }

    private class TaskRunnerCallable
    extends CallableWithNdc<Void> {
        private TaskRunnerCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void callInternal() throws Exception {
            try {
                Void void_ = (Void)TezTaskRunner.this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try {
                            LOG.info("Initializing task, taskAttemptId=" + TezTaskRunner.this.task.getTaskAttemptID());
                            TezTaskRunner.this.task.initialize();
                            if (!Thread.currentThread().isInterrupted() && TezTaskRunner.this.firstException == null) {
                                LOG.info("Running task, taskAttemptId=" + TezTaskRunner.this.task.getTaskAttemptID());
                                TezTaskRunner.this.task.run();
                                LOG.info("Closing task, taskAttemptId=" + TezTaskRunner.this.task.getTaskAttemptID());
                                TezTaskRunner.this.task.close();
                                TezTaskRunner.this.task.setFrameworkCounters();
                            }
                            LOG.info("Task completed, taskAttemptId=" + TezTaskRunner.this.task.getTaskAttemptID() + ", fatalErrorOccurred=" + (TezTaskRunner.this.firstException != null));
                            if (TezTaskRunner.this.firstException == null) {
                                try {
                                    TezTaskRunner.this.taskReporter.taskSucceeded(TezTaskRunner.this.task.getTaskAttemptID());
                                }
                                catch (IOException e) {
                                    LOG.warn("Heartbeat failure caused by communication failure", (Throwable)e);
                                    TezTaskRunner.this.maybeRegisterFirstException(e);
                                }
                                catch (TezException e) {
                                    LOG.warn("Heartbeat failure reported by AM", (Throwable)e);
                                    TezTaskRunner.this.maybeRegisterFirstException(e);
                                }
                            }
                            Void e = null;
                            return e;
                        }
                        catch (Throwable cause) {
                            block20: {
                                if (cause instanceof FSError) {
                                    block19: {
                                        TezTaskRunner.this.maybeRegisterFirstException(cause);
                                        LOG.info("Encountered an FSError while executing task: " + TezTaskRunner.this.task.getTaskAttemptID(), cause);
                                        try {
                                            TezTaskRunner.this.sendFailure(cause, "FS Error in Child JVM");
                                        }
                                        catch (Exception ignored) {
                                            LOG.info("Ignoring the following exception since a previous exception is already registered", (Object)ignored.getClass().getName());
                                            if (!LOG.isTraceEnabled()) break block19;
                                            LOG.trace("Ignored exception is", (Throwable)ignored);
                                        }
                                    }
                                    throw (FSError)cause;
                                }
                                if (cause instanceof Error) {
                                    LOG.error("Exception of type Error.", cause);
                                    TezTaskRunner.this.sendFailure(cause, "Fatal Error cause TezChild exit.");
                                    throw new TezException("Fatal Error cause TezChild exit.", cause);
                                }
                                if (cause instanceof UndeclaredThrowableException) {
                                    cause = ((UndeclaredThrowableException)cause).getCause();
                                }
                                TezTaskRunner.this.maybeRegisterFirstException(cause);
                                LOG.info("Encounted an error while executing task: " + TezTaskRunner.this.task.getTaskAttemptID(), cause);
                                try {
                                    TezTaskRunner.this.sendFailure(cause, "Failure while running task");
                                }
                                catch (Exception ignored) {
                                    LOG.info("Ignoring the following exception since a previous exception is already registered", (Object)ignored.getClass().getName());
                                    if (!LOG.isTraceEnabled()) break block20;
                                    LOG.trace("Ignored exception is", (Throwable)ignored);
                                }
                            }
                            if (cause instanceof IOException) {
                                throw (IOException)cause;
                            }
                            if (cause instanceof TezException) {
                                throw (TezException)cause;
                            }
                            throw new TezException(cause);
                        }
                        finally {
                            TezTaskRunner.this.task.cleanup();
                        }
                    }
                });
                return void_;
            }
            finally {
                TezTaskRunner.this.taskRunning.set(false);
            }
        }
    }
}

