/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.logging;

import java.io.File;
import java.io.InputStream;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.util.IntParam$;
import org.apache.spark.util.logging.FileAppender;
import org.apache.spark.util.logging.RollingFileAppender;
import org.apache.spark.util.logging.RollingFileAppender$;
import org.apache.spark.util.logging.SizeBasedRollingPolicy;
import org.apache.spark.util.logging.SizeBasedRollingPolicy$;
import org.apache.spark.util.logging.TimeBasedRollingPolicy;
import org.apache.spark.util.logging.TimeBasedRollingPolicy$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

public final class FileAppender$
implements Logging {
    public static final FileAppender$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new FileAppender$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public FileAppender apply(InputStream inputStream, File file, SparkConf conf) {
        FileAppender fileAppender;
        String rollingStrategy = conf.get(RollingFileAppender$.MODULE$.STRATEGY_PROPERTY(), RollingFileAppender$.MODULE$.STRATEGY_DEFAULT());
        String rollingSizeBytes = conf.get(RollingFileAppender$.MODULE$.SIZE_PROPERTY(), RollingFileAppender$.MODULE$.STRATEGY_DEFAULT());
        String rollingInterval = conf.get(RollingFileAppender$.MODULE$.INTERVAL_PROPERTY(), RollingFileAppender$.MODULE$.INTERVAL_DEFAULT());
        String string = rollingStrategy;
        if ("".equals(string)) {
            fileAppender = new FileAppender(inputStream, file, this.$lessinit$greater$default$3());
        } else if ("time".equals(string)) {
            fileAppender = this.createTimeBasedAppender$1(inputStream, file, conf, rollingInterval);
        } else if ("size".equals(string)) {
            fileAppender = this.createSizeBasedAppender$1(inputStream, file, conf, rollingSizeBytes);
        } else {
            this.logWarning((Function0<String>)new Serializable(rollingStrategy){
                public static final long serialVersionUID = 0L;
                private final String rollingStrategy$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal strategy [", "] for rolling executor logs, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rollingStrategy$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rolling logs not enabled"})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    this.rollingStrategy$1 = rollingStrategy$1;
                }
            });
            fileAppender = new FileAppender(inputStream, file, this.$lessinit$greater$default$3());
        }
        return fileAppender;
    }

    public int $lessinit$greater$default$3() {
        return 8192;
    }

    private final FileAppender createTimeBasedAppender$1(InputStream inputStream$1, File file$1, SparkConf conf$1, String rollingInterval$1) {
        Some some;
        String string = rollingInterval$1;
        if ("daily".equals(string)) {
            this.logInfo((Function0<String>)new Serializable(file$1){
                public static final long serialVersionUID = 0L;
                private final File file$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling executor logs enabled for ", " with daily rolling"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                }
                {
                    this.file$1 = file$1;
                }
            });
            some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)86400000L), (Object)"--yyyy-MM-dd"));
        } else if ("hourly".equals(string)) {
            this.logInfo((Function0<String>)new Serializable(file$1){
                public static final long serialVersionUID = 0L;
                private final File file$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling executor logs enabled for ", " with hourly rolling"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                }
                {
                    this.file$1 = file$1;
                }
            });
            some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3600000L), (Object)"--yyyy-MM-dd--HH"));
        } else if ("minutely".equals(string)) {
            this.logInfo((Function0<String>)new Serializable(file$1){
                public static final long serialVersionUID = 0L;
                private final File file$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling executor logs enabled for ", " with rolling every minute"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                }
                {
                    this.file$1 = file$1;
                }
            });
            some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)60000L), (Object)"--yyyy-MM-dd--HH-mm"));
        } else {
            Option<Object> option = IntParam$.MODULE$.unapply(string);
            if (option.isEmpty()) {
                this.logWarning((Function0<String>)new Serializable(rollingInterval$1){
                    public static final long serialVersionUID = 0L;
                    private final String rollingInterval$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal interval for rolling executor logs [", "], "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rollingInterval$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rolling logs not enabled"})).s((Seq)Nil$.MODULE$)).toString();
                    }
                    {
                        this.rollingInterval$1 = rollingInterval$1;
                    }
                });
                some = None$.MODULE$;
            } else {
                int seconds = BoxesRunTime.unboxToInt((Object)option.get());
                this.logInfo((Function0<String>)new Serializable(file$1, seconds){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;
                    private final int seconds$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling executor logs enabled for ", " with rolling ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1, BoxesRunTime.boxToInteger((int)this.seconds$1)}));
                    }
                    {
                        this.file$1 = file$1;
                        this.seconds$1 = seconds$1;
                    }
                });
                some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)((long)seconds * 1000L)), (Object)"--yyyy-MM-dd--HH-mm-ss"));
            }
        }
        Some validatedParams = some;
        return (FileAppender)validatedParams.map((Function1)new Serializable(inputStream$1, file$1, conf$1){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$1;
            private final File file$1;
            private final SparkConf conf$1;

            public final RollingFileAppender apply(Tuple2<Object, String> x0$1) {
                Tuple2<Object, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    long interval = tuple2._1$mcJ$sp();
                    String pattern = (String)tuple2._2();
                    RollingFileAppender rollingFileAppender = new RollingFileAppender(this.inputStream$1, this.file$1, new TimeBasedRollingPolicy(interval, pattern, TimeBasedRollingPolicy$.MODULE$.$lessinit$greater$default$3()), this.conf$1, RollingFileAppender$.MODULE$.$lessinit$greater$default$5());
                    return rollingFileAppender;
                }
                throw new MatchError(tuple2);
            }
            {
                this.inputStream$1 = inputStream$1;
                this.file$1 = file$1;
                this.conf$1 = conf$1;
            }
        }).getOrElse((Function0)new Serializable(inputStream$1, file$1){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$1;
            private final File file$1;

            public final FileAppender apply() {
                return new FileAppender(this.inputStream$1, this.file$1, FileAppender$.MODULE$.$lessinit$greater$default$3());
            }
            {
                this.inputStream$1 = inputStream$1;
                this.file$1 = file$1;
            }
        });
    }

    private final FileAppender createSizeBasedAppender$1(InputStream inputStream$1, File file$1, SparkConf conf$1, String rollingSizeBytes$1) {
        FileAppender fileAppender;
        String string = rollingSizeBytes$1;
        Option<Object> option = IntParam$.MODULE$.unapply(string);
        if (option.isEmpty()) {
            this.logWarning((Function0<String>)new Serializable(rollingSizeBytes$1){
                public static final long serialVersionUID = 0L;
                private final String rollingSizeBytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal size [", "] for rolling executor logs, rolling logs not enabled"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rollingSizeBytes$1}));
                }
                {
                    this.rollingSizeBytes$1 = rollingSizeBytes$1;
                }
            });
            fileAppender = new FileAppender(inputStream$1, file$1, this.$lessinit$greater$default$3());
        } else {
            int bytes = BoxesRunTime.unboxToInt((Object)option.get());
            this.logInfo((Function0<String>)new Serializable(file$1, bytes){
                public static final long serialVersionUID = 0L;
                private final File file$1;
                private final int bytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling executor logs enabled for ", " with rolling every ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1, BoxesRunTime.boxToInteger((int)this.bytes$1)}));
                }
                {
                    this.file$1 = file$1;
                    this.bytes$1 = bytes$1;
                }
            });
            fileAppender = new RollingFileAppender(inputStream$1, file$1, new SizeBasedRollingPolicy(bytes, SizeBasedRollingPolicy$.MODULE$.$lessinit$greater$default$2()), conf$1, RollingFileAppender$.MODULE$.$lessinit$greater$default$5());
        }
        return fileAppender;
    }

    private FileAppender$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

