/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataTimeOfStrikeCountReset is the corresponding interface of BACnetConstructedDataTimeOfStrikeCountReset
type BACnetConstructedDataTimeOfStrikeCountReset interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetTimeOfStrikeCountReset returns TimeOfStrikeCountReset (property field)
	GetTimeOfStrikeCountReset() BACnetDateTime
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateTime
	// IsBACnetConstructedDataTimeOfStrikeCountReset is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataTimeOfStrikeCountReset()
	// CreateBuilder creates a BACnetConstructedDataTimeOfStrikeCountResetBuilder
	CreateBACnetConstructedDataTimeOfStrikeCountResetBuilder() BACnetConstructedDataTimeOfStrikeCountResetBuilder
}

// _BACnetConstructedDataTimeOfStrikeCountReset is the data-structure of this message
type _BACnetConstructedDataTimeOfStrikeCountReset struct {
	BACnetConstructedDataContract
	TimeOfStrikeCountReset BACnetDateTime
}

var _ BACnetConstructedDataTimeOfStrikeCountReset = (*_BACnetConstructedDataTimeOfStrikeCountReset)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataTimeOfStrikeCountReset)(nil)

// NewBACnetConstructedDataTimeOfStrikeCountReset factory function for _BACnetConstructedDataTimeOfStrikeCountReset
func NewBACnetConstructedDataTimeOfStrikeCountReset(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, timeOfStrikeCountReset BACnetDateTime, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataTimeOfStrikeCountReset {
	if timeOfStrikeCountReset == nil {
		panic("timeOfStrikeCountReset of type BACnetDateTime for BACnetConstructedDataTimeOfStrikeCountReset must not be nil")
	}
	_result := &_BACnetConstructedDataTimeOfStrikeCountReset{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		TimeOfStrikeCountReset:        timeOfStrikeCountReset,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataTimeOfStrikeCountResetBuilder is a builder for BACnetConstructedDataTimeOfStrikeCountReset
type BACnetConstructedDataTimeOfStrikeCountResetBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(timeOfStrikeCountReset BACnetDateTime) BACnetConstructedDataTimeOfStrikeCountResetBuilder
	// WithTimeOfStrikeCountReset adds TimeOfStrikeCountReset (property field)
	WithTimeOfStrikeCountReset(BACnetDateTime) BACnetConstructedDataTimeOfStrikeCountResetBuilder
	// WithTimeOfStrikeCountResetBuilder adds TimeOfStrikeCountReset (property field) which is build by the builder
	WithTimeOfStrikeCountResetBuilder(func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataTimeOfStrikeCountResetBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataTimeOfStrikeCountReset or returns an error if something is wrong
	Build() (BACnetConstructedDataTimeOfStrikeCountReset, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataTimeOfStrikeCountReset
}

// NewBACnetConstructedDataTimeOfStrikeCountResetBuilder() creates a BACnetConstructedDataTimeOfStrikeCountResetBuilder
func NewBACnetConstructedDataTimeOfStrikeCountResetBuilder() BACnetConstructedDataTimeOfStrikeCountResetBuilder {
	return &_BACnetConstructedDataTimeOfStrikeCountResetBuilder{_BACnetConstructedDataTimeOfStrikeCountReset: new(_BACnetConstructedDataTimeOfStrikeCountReset)}
}

type _BACnetConstructedDataTimeOfStrikeCountResetBuilder struct {
	*_BACnetConstructedDataTimeOfStrikeCountReset

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataTimeOfStrikeCountResetBuilder) = (*_BACnetConstructedDataTimeOfStrikeCountResetBuilder)(nil)

func (b *_BACnetConstructedDataTimeOfStrikeCountResetBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataTimeOfStrikeCountReset
}

func (b *_BACnetConstructedDataTimeOfStrikeCountResetBuilder) WithMandatoryFields(timeOfStrikeCountReset BACnetDateTime) BACnetConstructedDataTimeOfStrikeCountResetBuilder {
	return b.WithTimeOfStrikeCountReset(timeOfStrikeCountReset)
}

func (b *_BACnetConstructedDataTimeOfStrikeCountResetBuilder) WithTimeOfStrikeCountReset(timeOfStrikeCountReset BACnetDateTime) BACnetConstructedDataTimeOfStrikeCountResetBuilder {
	b.TimeOfStrikeCountReset = timeOfStrikeCountReset
	return b
}

func (b *_BACnetConstructedDataTimeOfStrikeCountResetBuilder) WithTimeOfStrikeCountResetBuilder(builderSupplier func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataTimeOfStrikeCountResetBuilder {
	builder := builderSupplier(b.TimeOfStrikeCountReset.CreateBACnetDateTimeBuilder())
	var err error
	b.TimeOfStrikeCountReset, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDateTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataTimeOfStrikeCountResetBuilder) Build() (BACnetConstructedDataTimeOfStrikeCountReset, error) {
	if b.TimeOfStrikeCountReset == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'timeOfStrikeCountReset' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataTimeOfStrikeCountReset.deepCopy(), nil
}

func (b *_BACnetConstructedDataTimeOfStrikeCountResetBuilder) MustBuild() BACnetConstructedDataTimeOfStrikeCountReset {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataTimeOfStrikeCountResetBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataTimeOfStrikeCountResetBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataTimeOfStrikeCountResetBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataTimeOfStrikeCountResetBuilder().(*_BACnetConstructedDataTimeOfStrikeCountResetBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataTimeOfStrikeCountResetBuilder creates a BACnetConstructedDataTimeOfStrikeCountResetBuilder
func (b *_BACnetConstructedDataTimeOfStrikeCountReset) CreateBACnetConstructedDataTimeOfStrikeCountResetBuilder() BACnetConstructedDataTimeOfStrikeCountResetBuilder {
	if b == nil {
		return NewBACnetConstructedDataTimeOfStrikeCountResetBuilder()
	}
	return &_BACnetConstructedDataTimeOfStrikeCountResetBuilder{_BACnetConstructedDataTimeOfStrikeCountReset: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_TIME_OF_STRIKE_COUNT_RESET
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) GetTimeOfStrikeCountReset() BACnetDateTime {
	return m.TimeOfStrikeCountReset
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) GetActualValue() BACnetDateTime {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDateTime(m.GetTimeOfStrikeCountReset())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataTimeOfStrikeCountReset(structType any) BACnetConstructedDataTimeOfStrikeCountReset {
	if casted, ok := structType.(BACnetConstructedDataTimeOfStrikeCountReset); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataTimeOfStrikeCountReset); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) GetTypeName() string {
	return "BACnetConstructedDataTimeOfStrikeCountReset"
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (timeOfStrikeCountReset)
	lengthInBits += m.TimeOfStrikeCountReset.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataTimeOfStrikeCountReset BACnetConstructedDataTimeOfStrikeCountReset, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataTimeOfStrikeCountReset"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataTimeOfStrikeCountReset")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	timeOfStrikeCountReset, err := ReadSimpleField[BACnetDateTime](ctx, "timeOfStrikeCountReset", ReadComplex[BACnetDateTime](BACnetDateTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeOfStrikeCountReset' field"))
	}
	m.TimeOfStrikeCountReset = timeOfStrikeCountReset

	actualValue, err := ReadVirtualField[BACnetDateTime](ctx, "actualValue", (*BACnetDateTime)(nil), timeOfStrikeCountReset)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataTimeOfStrikeCountReset"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataTimeOfStrikeCountReset")
	}

	return m, nil
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataTimeOfStrikeCountReset"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataTimeOfStrikeCountReset")
		}

		if err := WriteSimpleField[BACnetDateTime](ctx, "timeOfStrikeCountReset", m.GetTimeOfStrikeCountReset(), WriteComplex[BACnetDateTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'timeOfStrikeCountReset' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataTimeOfStrikeCountReset"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataTimeOfStrikeCountReset")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) IsBACnetConstructedDataTimeOfStrikeCountReset() {
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) deepCopy() *_BACnetConstructedDataTimeOfStrikeCountReset {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataTimeOfStrikeCountResetCopy := &_BACnetConstructedDataTimeOfStrikeCountReset{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDateTime](m.TimeOfStrikeCountReset),
	}
	_BACnetConstructedDataTimeOfStrikeCountResetCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataTimeOfStrikeCountResetCopy
}

func (m *_BACnetConstructedDataTimeOfStrikeCountReset) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
