/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NodeTypeDescription extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 575;
  }

  // Properties.
  protected final ExpandedNodeId typeDefinitionNode;
  protected final boolean includeSubTypes;
  protected final List<QueryDataDescription> dataToReturn;

  public NodeTypeDescription(
      ExpandedNodeId typeDefinitionNode,
      boolean includeSubTypes,
      List<QueryDataDescription> dataToReturn) {
    super();
    this.typeDefinitionNode = typeDefinitionNode;
    this.includeSubTypes = includeSubTypes;
    this.dataToReturn = dataToReturn;
  }

  public ExpandedNodeId getTypeDefinitionNode() {
    return typeDefinitionNode;
  }

  public boolean getIncludeSubTypes() {
    return includeSubTypes;
  }

  public List<QueryDataDescription> getDataToReturn() {
    return dataToReturn;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NodeTypeDescription");

    // Simple Field (typeDefinitionNode)
    writeSimpleField("typeDefinitionNode", typeDefinitionNode, writeComplex(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (includeSubTypes)
    writeSimpleField("includeSubTypes", includeSubTypes, writeBoolean(writeBuffer));

    // Implicit Field (noOfDataToReturn) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDataToReturn =
        (int) ((((getDataToReturn()) == (null)) ? -(1) : COUNT(getDataToReturn())));
    writeImplicitField("noOfDataToReturn", noOfDataToReturn, writeSignedInt(writeBuffer, 32));

    // Array Field (dataToReturn)
    writeComplexTypeArrayField("dataToReturn", dataToReturn, writeBuffer);

    writeBuffer.popContext("NodeTypeDescription");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NodeTypeDescription _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (typeDefinitionNode)
    lengthInBits += typeDefinitionNode.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (includeSubTypes)
    lengthInBits += 1;

    // Implicit Field (noOfDataToReturn)
    lengthInBits += 32;

    // Array field
    if (dataToReturn != null) {
      int i = 0;
      for (QueryDataDescription element : dataToReturn) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= dataToReturn.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("NodeTypeDescription");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExpandedNodeId typeDefinitionNode =
        readSimpleField(
            "typeDefinitionNode",
            readComplex(() -> ExpandedNodeId.staticParse(readBuffer), readBuffer));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean includeSubTypes = readSimpleField("includeSubTypes", readBoolean(readBuffer));

    int noOfDataToReturn = readImplicitField("noOfDataToReturn", readSignedInt(readBuffer, 32));

    List<QueryDataDescription> dataToReturn =
        readCountArrayField(
            "dataToReturn",
            readComplex(
                () ->
                    (QueryDataDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (572)),
                readBuffer),
            noOfDataToReturn);

    readBuffer.closeContext("NodeTypeDescription");
    // Create the instance
    return new NodeTypeDescriptionBuilderImpl(typeDefinitionNode, includeSubTypes, dataToReturn);
  }

  public static class NodeTypeDescriptionBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExpandedNodeId typeDefinitionNode;
    private final boolean includeSubTypes;
    private final List<QueryDataDescription> dataToReturn;

    public NodeTypeDescriptionBuilderImpl(
        ExpandedNodeId typeDefinitionNode,
        boolean includeSubTypes,
        List<QueryDataDescription> dataToReturn) {
      this.typeDefinitionNode = typeDefinitionNode;
      this.includeSubTypes = includeSubTypes;
      this.dataToReturn = dataToReturn;
    }

    public NodeTypeDescription build() {
      NodeTypeDescription nodeTypeDescription =
          new NodeTypeDescription(typeDefinitionNode, includeSubTypes, dataToReturn);
      return nodeTypeDescription;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NodeTypeDescription)) {
      return false;
    }
    NodeTypeDescription that = (NodeTypeDescription) o;
    return (getTypeDefinitionNode() == that.getTypeDefinitionNode())
        && (getIncludeSubTypes() == that.getIncludeSubTypes())
        && (getDataToReturn() == that.getDataToReturn())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getTypeDefinitionNode(), getIncludeSubTypes(), getDataToReturn());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
