/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CurrentTime
extends Expression {
    private final Function function;
    private final Integer precision;

    public CurrentTime(Function function) {
        this(Optional.empty(), function, null);
    }

    public CurrentTime(NodeLocation location, Function function) {
        this(Optional.of(location), function, null);
    }

    public CurrentTime(Function function, Integer precision) {
        this(Optional.empty(), function, precision);
    }

    public CurrentTime(NodeLocation location, Function function, Integer precision) {
        this(Optional.of(location), function, precision);
    }

    private CurrentTime(Optional<NodeLocation> location, Function function, Integer precision) {
        super(location);
        Objects.requireNonNull(function, "function is null");
        this.function = function;
        this.precision = precision;
    }

    public Function getFunction() {
        return this.function;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCurrentTime(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentTime that = (CurrentTime)o;
        return this.function == that.function && Objects.equals(this.precision, that.precision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.function, this.precision});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!CurrentTime.sameClass(this, other)) {
            return false;
        }
        CurrentTime otherNode = (CurrentTime)other;
        return this.function == otherNode.function && Objects.equals(this.precision, otherNode.precision);
    }

    public static enum Function {
        TIME("current_time"),
        DATE("current_date"),
        TIMESTAMP("current_timestamp"),
        LOCALTIME("localtime"),
        LOCALTIMESTAMP("localtimestamp");

        private final String name;

        private Function(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

