/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.connector.CatalogName;
import io.trino.metadata.IndexHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorResolvedIndex;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;

public final class ResolvedIndex {
    private final IndexHandle indexHandle;
    private final TupleDomain<ColumnHandle> undeterminedTupleDomain;

    public ResolvedIndex(CatalogName catalogName, ConnectorTransactionHandle transactionHandle, ConnectorResolvedIndex index) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(index, "index is null");
        this.indexHandle = new IndexHandle(catalogName, transactionHandle, index.getIndexHandle());
        this.undeterminedTupleDomain = index.getUnresolvedTupleDomain();
    }

    public IndexHandle getIndexHandle() {
        return this.indexHandle;
    }

    public TupleDomain<ColumnHandle> getUnresolvedTupleDomain() {
        return this.undeterminedTupleDomain;
    }
}

