/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.KeyValuePairs;
import io.trino.operator.aggregation.state.KeyValuePairStateSerializer;
import io.trino.operator.aggregation.state.KeyValuePairsState;
import io.trino.operator.aggregation.state.KeyValuePairsStateFactory;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MapAggregationFunction
extends SqlAggregationFunction {
    public static final String NAME = "map_agg";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(MapAggregationFunction.class, "input", Type.class, BlockTypeOperators.BlockPositionEqual.class, BlockTypeOperators.BlockPositionHashCode.class, Type.class, KeyValuePairsState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(MapAggregationFunction.class, "combine", KeyValuePairsState.class, KeyValuePairsState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(MapAggregationFunction.class, "output", KeyValuePairsState.class, BlockBuilder.class);
    private final BlockTypeOperators blockTypeOperators;

    public MapAggregationFunction(BlockTypeOperators blockTypeOperators) {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("K", new TypeSignatureParameter[0]), (Object)new TypeSignature("V", new TypeSignatureParameter[0])), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false, (Object)true)), false, true, "Aggregates all the rows (key/value pairs) into a single map", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(true, TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))));
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        MapType outputType = (MapType)boundSignature.getReturnType();
        Type keyType = outputType.getKeyType();
        BlockTypeOperators.BlockPositionEqual keyEqual = this.blockTypeOperators.getEqualOperator(keyType);
        BlockTypeOperators.BlockPositionHashCode keyHashCode = this.blockTypeOperators.getHashCodeOperator(keyType);
        Type valueType = outputType.getValueType();
        KeyValuePairStateSerializer stateSerializer = new KeyValuePairStateSerializer(outputType, keyEqual, keyHashCode);
        return new AggregationMetadata(MethodHandles.insertArguments(INPUT_FUNCTION, 0, keyType, keyEqual, keyHashCode, valueType), Optional.empty(), Optional.of(COMBINE_FUNCTION), OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<KeyValuePairsState>(KeyValuePairsState.class, stateSerializer, new KeyValuePairsStateFactory(keyType, valueType))));
    }

    public static void input(Type keyType, BlockTypeOperators.BlockPositionEqual keyEqual, BlockTypeOperators.BlockPositionHashCode keyHashCode, Type valueType, KeyValuePairsState state, Block key, Block value, int position) {
        KeyValuePairs pairs = state.get();
        if (pairs == null) {
            pairs = new KeyValuePairs(keyType, keyEqual, keyHashCode, valueType);
            state.set(pairs);
        }
        long startSize = pairs.estimatedInMemorySize();
        pairs.add(key, value, position, position);
        state.addMemoryUsage(pairs.estimatedInMemorySize() - startSize);
    }

    public static void combine(KeyValuePairsState state, KeyValuePairsState otherState) {
        if (state.get() != null && otherState.get() != null) {
            Block keys = otherState.get().getKeys();
            Block values = otherState.get().getValues();
            KeyValuePairs pairs = state.get();
            long startSize = pairs.estimatedInMemorySize();
            for (int i = 0; i < keys.getPositionCount(); ++i) {
                pairs.add(keys, values, i, i);
            }
            state.addMemoryUsage(pairs.estimatedInMemorySize() - startSize);
        } else if (state.get() == null) {
            state.set(otherState.get());
        }
    }

    public static void output(KeyValuePairsState state, BlockBuilder out) {
        KeyValuePairs pairs = state.get();
        if (pairs == null) {
            out.appendNull();
        } else {
            pairs.serialize(out);
        }
    }
}

