/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.NullableDoubleState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.RealType;

@AggregationFunction(value="sum")
public final class RealSumAggregation {
    private RealSumAggregation() {
    }

    @InputFunction
    public static void sum(@AggregationState NullableDoubleState state, @SqlType(value="real") long value) {
        state.setNull(false);
        state.setValue(state.getValue() + (double)Float.intBitsToFloat((int)value));
    }

    @CombineFunction
    public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        if (state.isNull()) {
            if (otherState.isNull()) {
                return;
            }
            state.set(otherState);
            return;
        }
        if (!otherState.isNull()) {
            state.setValue(state.getValue() + otherState.getValue());
        }
    }

    @OutputFunction(value="real")
    public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)state.getValue()));
        }
    }
}

