/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.listagg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.listagg.ListaggAggregationState;
import io.trino.operator.aggregation.listagg.ListaggAggregationStateFactory;
import io.trino.operator.aggregation.listagg.ListaggAggregationStateSerializer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class ListaggAggregationFunction
extends SqlAggregationFunction {
    public static final ListaggAggregationFunction LISTAGG = new ListaggAggregationFunction();
    public static final String NAME = "listagg";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(ListaggAggregationFunction.class, "input", Type.class, ListaggAggregationState.class, Block.class, Slice.class, Boolean.TYPE, Slice.class, Boolean.TYPE, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(ListaggAggregationFunction.class, "combine", Type.class, ListaggAggregationState.class, ListaggAggregationState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(ListaggAggregationFunction.class, "output", Type.class, ListaggAggregationState.class, BlockBuilder.class);
    private static final int MAX_OUTPUT_LENGTH = 0x100000;
    private static final int MAX_OVERFLOW_FILLER_LENGTH = 65536;

    private ListaggAggregationFunction() {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), VarcharType.VARCHAR.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"v")}), (Object)new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"d")}), (Object)BooleanType.BOOLEAN.getTypeSignature(), (Object)new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"f")}), (Object)BooleanType.BOOLEAN.getTypeSignature()), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)true, (Object)false, (Object)false, (Object)false, (Object)false)), false, true, "concatenates the input values with the specified separator", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(true, VarcharType.VARCHAR.getTypeSignature(), BooleanType.BOOLEAN.getTypeSignature(), VarcharType.VARCHAR.getTypeSignature(), BooleanType.BOOLEAN.getTypeSignature(), TypeSignature.arrayType((TypeSignature)VarcharType.VARCHAR.getTypeSignature())));
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        VarcharType type = VarcharType.VARCHAR;
        ListaggAggregationStateSerializer stateSerializer = new ListaggAggregationStateSerializer((Type)type);
        ListaggAggregationStateFactory stateFactory = new ListaggAggregationStateFactory((Type)type);
        MethodHandle inputFunction = AggregationFunctionAdapter.normalizeInputMethod(INPUT_FUNCTION.bindTo(type), boundSignature, AggregationFunctionAdapter.AggregationParameterKind.STATE, AggregationFunctionAdapter.AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL, AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, AggregationFunctionAdapter.AggregationParameterKind.BLOCK_INDEX);
        MethodHandle combineFunction = COMBINE_FUNCTION.bindTo(type);
        MethodHandle outputFunction = OUTPUT_FUNCTION.bindTo(type);
        return new AggregationMetadata(inputFunction, Optional.empty(), Optional.of(combineFunction), outputFunction, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<ListaggAggregationState>(ListaggAggregationState.class, stateSerializer, stateFactory)));
    }

    public static void input(Type type, ListaggAggregationState state, Block value, Slice separator, boolean overflowError, Slice overflowFiller, boolean showOverflowEntryCount, int position) {
        if (state.isEmpty()) {
            if (overflowFiller.length() > 65536) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Overflow filler length %d exceeds maximum length %d", overflowFiller.length(), 65536));
            }
            state.setSeparator(separator);
            state.setOverflowError(overflowError);
            state.setOverflowFiller(overflowFiller);
            state.setShowOverflowEntryCount(showOverflowEntryCount);
        }
        if (!value.isNull(position)) {
            state.add(value, position);
        }
    }

    public static void combine(Type type, ListaggAggregationState state, ListaggAggregationState otherState) {
        Slice previousSeparator = state.getSeparator();
        if (previousSeparator == null) {
            state.setSeparator(otherState.getSeparator());
            state.setOverflowError(otherState.isOverflowError());
            state.setOverflowFiller(otherState.getOverflowFiller());
            state.setShowOverflowEntryCount(otherState.showOverflowEntryCount());
        }
        state.merge(otherState);
    }

    public static void output(Type type, ListaggAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
        } else {
            ListaggAggregationFunction.outputState(state, out, 0x100000);
        }
    }

    @VisibleForTesting
    protected static void outputState(ListaggAggregationState state, BlockBuilder out, int maxOutputLength) {
        Slice separator = state.getSeparator();
        int separatorLength = separator.length();
        OutputContext context = new OutputContext();
        state.forEach((block, position) -> {
            int entryLength = block.getSliceLength(position);
            int spaceRequired = entryLength + (context.emittedEntryCount > 0 ? separatorLength : 0);
            if (context.outputLength + (long)spaceRequired > (long)maxOutputLength) {
                context.overflow = true;
                return false;
            }
            if (context.emittedEntryCount > 0) {
                out.writeBytes(separator, 0, separatorLength);
                context.outputLength += (long)separatorLength;
            }
            block.writeBytesTo(position, 0, entryLength, out);
            context.outputLength += (long)entryLength;
            ++context.emittedEntryCount;
            return true;
        });
        if (context.overflow) {
            if (state.isOverflowError()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT, String.format("Concatenated string has the length in bytes larger than the maximum output length %d", maxOutputLength));
            }
            if (context.emittedEntryCount > 0) {
                out.writeBytes(separator, 0, separatorLength);
            }
            out.writeBytes(state.getOverflowFiller(), 0, state.getOverflowFiller().length());
            if (state.showOverflowEntryCount()) {
                out.writeBytes(Slices.utf8Slice((String)"("), 0, 1);
                Slice count = Slices.utf8Slice((String)Integer.toString(state.getEntryCount() - context.emittedEntryCount));
                out.writeBytes(count, 0, count.length());
                out.writeBytes(Slices.utf8Slice((String)")"), 0, 1);
            }
        }
        out.closeEntry();
    }

    private static class OutputContext {
        long outputLength;
        int emittedEntryCount;
        boolean overflow;

        private OutputContext() {
        }
    }
}

