/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.operator.scalar.StringFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.DateTimes;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.function.Function;
import java.util.regex.Matcher;

@ScalarOperator(value=OperatorType.CAST)
public final class VarcharToTimestampWithTimeZoneCast {
    private VarcharToTimestampWithTimeZoneCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long castToShort(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="varchar(x)") Slice value) {
        try {
            return VarcharToTimestampWithTimeZoneCast.toShort((int)precision, StringFunctions.trim(value).toStringUtf8(), timezone -> {
                if (timezone == null) {
                    return session.getTimeZoneKey().getZoneId();
                }
                return ZoneId.of(timezone);
            });
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone castToLong(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="varchar(x)") Slice value) {
        try {
            return VarcharToTimestampWithTimeZoneCast.toLong((int)precision, StringFunctions.trim(value).toStringUtf8(), timezone -> {
                if (timezone == null) {
                    return session.getTimeZoneKey().getZoneId();
                }
                return ZoneId.of(timezone);
            });
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    private static long toShort(int precision, String value, Function<String, ZoneId> zoneId) {
        Preconditions.checkArgument((precision <= 3 ? 1 : 0) != 0, (Object)"precision must be less than max short timestamp precision");
        Matcher matcher = DateTimes.DATETIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid timestamp: " + value);
        }
        String year = matcher.group("year");
        String month = matcher.group("month");
        String day = matcher.group("day");
        String hour = matcher.group("hour");
        String minute = matcher.group("minute");
        String second = matcher.group("second");
        String fraction = matcher.group("fraction");
        String timezone = matcher.group("timezone");
        ZoneId zone = zoneId.apply(timezone);
        long epochSecond = ZonedDateTime.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), hour == null ? 0 : Integer.parseInt(hour), minute == null ? 0 : Integer.parseInt(minute), second == null ? 0 : Integer.parseInt(second), 0, zone).toEpochSecond();
        int actualPrecision = 0;
        long fractionValue = 0L;
        if (fraction != null) {
            actualPrecision = fraction.length();
            fractionValue = Long.parseLong(fraction);
        }
        if (actualPrecision > precision) {
            fractionValue = DateTimes.round(fractionValue, actualPrecision - precision);
        }
        long millisOfSecond = DateTimes.rescale(fractionValue, actualPrecision, 3);
        return DateTimeEncoding.packDateTimeWithZone((long)(epochSecond * 1000L + millisOfSecond), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)zone.getId()));
    }

    private static LongTimestampWithTimeZone toLong(int precision, String value, Function<String, ZoneId> zoneId) {
        Preconditions.checkArgument((precision > 3 && precision <= 12 ? 1 : 0) != 0, (Object)"precision out of range");
        Matcher matcher = DateTimes.DATETIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid timestamp: " + value);
        }
        String year = matcher.group("year");
        String month = matcher.group("month");
        String day = matcher.group("day");
        String hour = matcher.group("hour");
        String minute = matcher.group("minute");
        String second = matcher.group("second");
        String fraction = matcher.group("fraction");
        String timezone = matcher.group("timezone");
        ZoneId zone = zoneId.apply(timezone);
        long epochSecond = ZonedDateTime.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), hour == null ? 0 : Integer.parseInt(hour), minute == null ? 0 : Integer.parseInt(minute), second == null ? 0 : Integer.parseInt(second), 0, zone).toEpochSecond();
        int actualPrecision = 0;
        long fractionValue = 0L;
        if (fraction != null) {
            actualPrecision = fraction.length();
            fractionValue = Long.parseLong(fraction);
        }
        if (actualPrecision > precision) {
            fractionValue = DateTimes.round(fractionValue, actualPrecision - precision);
        }
        long fractionInPicos = DateTimes.rescale(fractionValue, actualPrecision, 12);
        return DateTimes.longTimestampWithTimeZone(epochSecond, fractionInPicos, zone);
    }
}

