/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.SqlFormatter;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Statement;
import javax.annotation.Nullable;

public final class SqlFormatterUtil {
    private SqlFormatterUtil() {
    }

    public static String getFormattedSql(Statement statement, SqlParser sqlParser) {
        Statement parsed;
        String sql = SqlFormatter.formatSql((Node)statement);
        try {
            ParsingOptions parsingOptions = new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.REJECT);
            parsed = sqlParser.createStatement(sql, parsingOptions);
        }
        catch (ParsingException e) {
            throw SqlFormatterUtil.formattingFailure(e, "Formatted query does not parse", statement, sql);
        }
        if (!statement.equals((Object)parsed)) {
            throw SqlFormatterUtil.formattingFailure(null, "Query does not round-trip", statement, sql);
        }
        return sql;
    }

    private static TrinoException formattingFailure(@Nullable Throwable cause, String message, Statement statement, String sql) {
        TrinoException exception = new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, message, cause);
        exception.addSuppressed((Throwable)new RuntimeException("Statement: " + statement));
        exception.addSuppressed((Throwable)new RuntimeException(String.format("Formatted: [%s]", sql)));
        return exception;
    }
}

