/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.RunLengthEncodedBlock;

public class RunLengthBlockEncoding
implements BlockEncoding {
    public static final String NAME = "RLE";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block;
        sliceOutput.writeInt(rleBlock.getPositionCount());
        blockEncodingSerde.writeBlock(sliceOutput, rleBlock.getValue());
    }

    @Override
    public RunLengthEncodedBlock readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        Block value = blockEncodingSerde.readBlock(sliceInput);
        return new RunLengthEncodedBlock(value, positionCount);
    }
}

