/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.block.SingleMapBlock;
import io.trino.spi.type.MapType;
import java.util.Optional;

public class SingleMapBlockEncoding
implements BlockEncoding {
    public static final String NAME = "MAP_ELEMENT";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        SingleMapBlock singleMapBlock = (SingleMapBlock)block;
        blockEncodingSerde.writeType(sliceOutput, singleMapBlock.getMapType());
        int offset = singleMapBlock.getOffset();
        int positionCount = singleMapBlock.getPositionCount();
        blockEncodingSerde.writeBlock(sliceOutput, singleMapBlock.getRawKeyBlock().getRegion(offset / 2, positionCount / 2));
        blockEncodingSerde.writeBlock(sliceOutput, singleMapBlock.getRawValueBlock().getRegion(offset / 2, positionCount / 2));
        Optional<int[]> hashTable = singleMapBlock.tryGetHashTable();
        if (hashTable.isPresent()) {
            int hashTableLength = positionCount / 2 * 2;
            sliceOutput.appendInt(hashTableLength);
            sliceOutput.writeBytes(Slices.wrappedIntArray((int[])hashTable.get(), (int)(offset / 2 * 2), (int)hashTableLength));
        } else {
            sliceOutput.appendInt(-1);
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        MapType mapType = (MapType)blockEncodingSerde.readType(sliceInput);
        Block keyBlock = blockEncodingSerde.readBlock(sliceInput);
        Block valueBlock = blockEncodingSerde.readBlock(sliceInput);
        int hashTableLength = sliceInput.readInt();
        int[] hashTable = null;
        if (hashTableLength >= 0) {
            hashTable = new int[hashTableLength];
            sliceInput.readBytes(Slices.wrappedIntArray((int[])hashTable));
        }
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("Deserialized SingleMapBlock violates invariants: key %d, value %d", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        if (hashTable != null && keyBlock.getPositionCount() * 2 != hashTable.length) {
            throw new IllegalArgumentException(String.format("Deserialized SingleMapBlock violates invariants: expected hashtable size %d, actual hashtable size %d", keyBlock.getPositionCount() * 2, hashTable.length));
        }
        MapBlock mapBlock = MapBlock.createMapBlockInternal(mapType, 0, 1, Optional.empty(), new int[]{0, keyBlock.getPositionCount()}, keyBlock, valueBlock, new MapHashTables(mapType, Optional.ofNullable(hashTable)));
        return new SingleMapBlock(0, keyBlock.getPositionCount() * 2, mapBlock);
    }
}

