/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.trino.spi.type.Timestamps;
import java.util.Objects;

public final class SqlTimeWithTimeZone {
    private final int precision;
    private final long picos;
    private final int offsetMinutes;

    public static SqlTimeWithTimeZone newInstance(int precision, long picoseconds, int offsetMinutes) {
        if (precision < 0 || precision > 12) {
            throw new IllegalArgumentException("Invalid precision: " + precision);
        }
        if (Timestamps.rescale(Timestamps.rescale(picoseconds, 12, precision), precision, 12) != picoseconds) {
            throw new IllegalArgumentException(String.format("picoseconds contains data beyond specified precision (%s): %s", precision, picoseconds));
        }
        if (picoseconds < 0L || picoseconds >= 86400000000000000L) {
            throw new IllegalArgumentException("picoseconds is out of range: " + picoseconds);
        }
        if (offsetMinutes < -840 || offsetMinutes > 840) {
            throw new IllegalArgumentException("offsetMinutes is out of range: " + offsetMinutes);
        }
        return new SqlTimeWithTimeZone(precision, picoseconds, offsetMinutes);
    }

    private SqlTimeWithTimeZone(int precision, long picos, int offsetMinutes) {
        this.precision = precision;
        this.picos = picos;
        this.offsetMinutes = offsetMinutes;
    }

    public long getPicos() {
        return this.picos;
    }

    public int getOffsetMinutes() {
        return this.offsetMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTimeWithTimeZone other = (SqlTimeWithTimeZone)o;
        return this.precision == other.precision && this.picos == other.picos && this.offsetMinutes == other.offsetMinutes;
    }

    public int hashCode() {
        return Objects.hash(this.precision, this.picos, this.offsetMinutes);
    }

    @JsonValue
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%02d:%02d:%02d", this.picos / 3600000000000000L, this.picos / 60000000000000L % 60L, this.picos / 1000000000000L % 60L));
        if (this.precision > 0) {
            long scaledFraction = this.picos % 1000000000000L / Timestamps.POWERS_OF_TEN[12 - this.precision];
            builder.append(".");
            builder.append(String.format("%0" + this.precision + "d", scaledFraction));
        }
        builder.append(String.format("%s%02d:%02d", Character.valueOf(this.offsetMinutes >= 0 ? (char)'+' : '-'), Math.abs(this.offsetMinutes / 60), Math.abs(this.offsetMinutes % 60)));
        return builder.toString();
    }
}

